/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.common.propertyeditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;

public class PasswordInplaceEditor
extends JPasswordField
implements InplaceEditor,
InplaceEditor.Factory {
    private String password;
    protected PropertyEditor editor = null;
    protected PropertyEnv env = null;
    private boolean added = false;
    KeyStroke[] strokes = new KeyStroke[]{KeyStroke.getKeyStroke(36, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40), KeyStroke.getKeyStroke(35, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40), KeyStroke.getKeyStroke(38, 0, false), KeyStroke.getKeyStroke(40, 0, false)};
    private PropertyModel pm = null;

    public void removeNotify() {
        super.removeNotify();
    }

    public void clear() {
        this.editor = null;
        this.setEditable(true);
        this.setEnabled(true);
        this.setText("");
        this.pm = null;
        this.env = null;
    }

    public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        this.setActionCommand("success");
        this.env = propertyEnv;
        if (this.editor == propertyEditor) {
            return;
        }
        this.editor = propertyEditor;
        boolean bl = true;
        this.setEnabled(bl);
        this.setEditable(bl);
        this.reset();
        this.added = false;
    }

    public void addNotify() {
        super.addNotify();
        this.added = true;
    }

    public JComponent getComponent() {
        return this;
    }

    public Object getValue() {
        return this.getText();
    }

    public void reset() {
        String string;
        String string2 = this.editor.getAsText();
        if (this.getClass() == PasswordInplaceEditor.class && this.env != null && this.env.getFeatureDescriptor() != null && (string = (String)this.env.getFeatureDescriptor().getValue("initialEditValue")) != null) {
            string2 = string;
        }
        if (string2 == null) {
            string2 = "";
        }
        this.setText(string2);
        this.setSelectionStart(0);
        this.setSelectionEnd(string2.length());
    }

    public KeyStroke[] getKeyStrokes() {
        return this.strokes;
    }

    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    private void handleInitialInputEvent(InputEvent inputEvent) {
        String string = this.getText();
        if (string.length() > 0) {
            this.setSelectionStart(0);
            this.setSelectionEnd(this.getText().length());
        }
    }

    public void setValue(Object object) {
        this.setText(object != null ? object.toString() : "");
    }

    public boolean supportsTextEntry() {
        return true;
    }

    public PropertyModel getPropertyModel() {
        return this.pm;
    }

    public void setPropertyModel(PropertyModel propertyModel) {
        this.pm = propertyModel;
    }

    public boolean isKnownComponent(Component component) {
        return false;
    }

    private Graphics getScratchGraphics(Component component) {
        Graphics graphics = null;
        BufferedImage bufferedImage = null;
        if (graphics == null) {
            if (bufferedImage == null) {
                bufferedImage = new BufferedImage(1, 1, 2);
            }
            graphics = bufferedImage.getGraphics();
        }
        return graphics;
    }

    private int getMinimumPropPanelWidth() {
        int n = 50;
        int n2 = Math.round((float)n * this.getFontSizeFactor());
        return n2;
    }

    private float getFontSizeFactor() {
        Font font = UIManager.getFont("controlFont");
        if (font == null) {
            JLabel jLabel = new JLabel();
            font = jLabel.getFont();
        }
        int n = 12;
        float f = n / font.getSize();
        return f;
    }

    private int getMinimumPropPanelHeight() {
        int n = 18;
        int n2 = Math.round((float)n * this.getFontSizeFactor());
        return n2;
    }

    public Dimension getPreferredSize() {
        Graphics graphics = this.getScratchGraphics(this);
        String string = "***";
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        Dimension dimension = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
        dimension.width = Math.max(dimension.width, this.getMinimumPropPanelWidth());
        dimension.height = Math.max(dimension.height, this.getMinimumPropPanelHeight());
        if (this.getBorder() != null) {
            Insets insets = this.getBorder().getBorderInsets(this);
            dimension.width += insets.right + insets.left;
            dimension.height += insets.top + insets.bottom;
        }
        return dimension;
    }

    private int getTextMargin() {
        if ("apple.laf.AquaLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName())) {
            return 0;
        }
        Object object = UIManager.get("netbeans.ps.textMargin");
        int n = object instanceof Integer ? (Integer)object : 2;
        return n;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (this.added) {
            this.handleInitialInputEvent(mouseEvent);
        }
        this.added = false;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        if (this.editor != null && !this.hasFocus() && this.editor.isPaintable()) {
            Insets insets = this.getInsets();
            Color color = graphics.getColor();
            try {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            finally {
                graphics.setColor(color);
            }
            insets.left += this.getTextMargin();
            this.editor.paintValue(graphics, new Rectangle(insets.left, insets.top, this.getWidth() - (insets.right + insets.left), this.getHeight() - (insets.top + insets.bottom)));
        } else {
            super.paintComponent(graphics);
        }
    }

    public InplaceEditor getInplaceEditor() {
        return new PasswordInplaceEditor();
    }
}

