/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.common.propertyeditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FileEditor2
extends PropertyEditorSupport
implements ExPropertyEditor,
PropertyChangeListener {
    private PropertyEnv env;
    static final String PROPERTY_SHOW_DIRECTORIES = "directories";
    static final String PROPERTY_SHOW_FILES = "files";
    static final String PROPERTY_FILTER = "filter";
    static final String PROPERTY_CURRENT_DIR = "currentDir";
    static final String PROPERTY_BASE_DIR = "baseDir";
    private int mode = 2;
    private boolean directories = true;
    private boolean files = true;
    private javax.swing.filechooser.FileFilter fileFilter;
    private File currentDirectory;
    private File baseDirectory;
    static File lastCurrentDir;
    private JFileChooser chooser;
    private FeatureDescriptor fd;
    private boolean enableFC = true;
    private boolean inherited = true;
    JCheckBox jButton1 = null;
    JPanel jPanel1 = null;

    public Object getObject() {
        return this.env.getFeatureDescriptor().getValue("object");
    }

    public Method getMethod() {
        return (Method)this.env.getFeatureDescriptor().getValue("method");
    }

    public String getParam() {
        return (String)this.env.getFeatureDescriptor().getValue("param");
    }

    public String getContext() {
        return (String)this.env.getFeatureDescriptor().getValue("context");
    }

    public File getInherit() {
        Method method = this.getMethod();
        Object object = this.getObject();
        String string = this.getParam();
        Object object2 = null;
        try {
            Object object3 = method.invoke(object, string);
            object2 = object3 instanceof String ? (object3.equals("") ? null : new File((String)object3)) : (File)object3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveDisableComponent(JComponent jComponent, boolean bl) {
        JComponent jComponent2 = jComponent;
        synchronized (jComponent2) {
            jComponent.setEnabled(bl);
            for (int i = 0; i < jComponent.getComponentCount(); ++i) {
                Component component = jComponent.getComponent(i);
                if (!(component instanceof JComponent)) continue;
                this.recursiveDisableComponent((JComponent)component, bl);
            }
        }
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        Object object;
        Object object2;
        Object object3;
        this.env = propertyEnv;
        this.directories = true;
        this.files = true;
        this.fileFilter = null;
        Object object4 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_SHOW_DIRECTORIES);
        if (object4 instanceof Boolean) {
            this.directories = (Boolean)object4;
        }
        if ((object3 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_SHOW_FILES)) instanceof Boolean) {
            this.files = (Boolean)object3;
        }
        if ((object2 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_FILTER)) instanceof FilenameFilter) {
            this.fileFilter = new DelegatingFilenameFilter((FilenameFilter)object2);
        } else if (object2 instanceof javax.swing.filechooser.FileFilter) {
            this.fileFilter = (javax.swing.filechooser.FileFilter)object2;
        } else if (object2 instanceof FileFilter) {
            this.fileFilter = new DelegatingFileFilter((FileFilter)object2);
        }
        Object object5 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_CURRENT_DIR);
        if (object5 instanceof File) {
            this.currentDirectory = (File)object5;
            if (!this.currentDirectory.isDirectory()) {
                ErrorManager.getDefault().log(16, "java.io.File will not accept currentDir=" + this.baseDirectory);
                this.currentDirectory = null;
            }
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_BASE_DIR)) instanceof File) {
            this.baseDirectory = (File)object;
            if (!this.baseDirectory.isDirectory() || !this.baseDirectory.isAbsolute()) {
                ErrorManager.getDefault().log(16, "java.io.File will not accept baseDir=" + this.baseDirectory);
                this.baseDirectory = null;
            }
        }
        this.mode = this.files ? (this.directories ? 2 : 0) : (this.directories ? 1 : 2);
    }

    public String getAsText() {
        File file = (File)this.getValue();
        if (file == null) {
            return "";
        }
        String string = file.getPath();
        if (string.equals("")) {
            string = ".";
        }
        return string;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null");
        }
        if (string.equals("")) {
            this.setValue(null);
            return;
        }
        if (string.equals(".")) {
            string = "";
        }
        this.setValue(new File(string));
    }

    public Component getCustomEditor() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            File file = (File)this.getValue();
            if (file != null && !file.isAbsolute() && this.baseDirectory != null) {
                file = new File(this.baseDirectory, file.getPath());
            }
            if (this.currentDirectory != null) {
                this.chooser.setCurrentDirectory(this.currentDirectory);
            } else if (file != null && file.getParentFile() != null) {
                this.chooser.setCurrentDirectory(file.getParentFile());
                this.chooser.setSelectedFile(file);
            } else if (lastCurrentDir != null) {
                this.chooser.setCurrentDirectory(lastCurrentDir);
            }
            this.chooser.setFileSelectionMode(this.mode);
            if (this.fileFilter != null) {
                this.chooser.setFileFilter(this.fileFilter);
            }
            switch (this.mode) {
                case 2: {
                    this.chooser.setDialogTitle(FileEditor2.getString("CTL_DialogTitleFilesAndDirs"));
                    break;
                }
                case 0: {
                    this.chooser.setDialogTitle(FileEditor2.getString("CTL_DialogTitleFiles"));
                    break;
                }
                case 1: {
                    this.chooser.setDialogTitle(FileEditor2.getString("CTL_DialogTitleDirs"));
                }
            }
            this.chooser.setControlButtonsAreShown(false);
            this.chooser.addPropertyChangeListener("SelectedFileChangedProperty", this);
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new FlowLayout(2));
            this.jPanel1.setPreferredSize(new Dimension(10, 45));
            ResourceBundle resourceBundle = NbBundle.getBundle((Class)FileEditor2.class);
            this.jButton1 = new JCheckBox("");
            this.jButton1.setToolTipText("");
            this.jButton1.setText(resourceBundle.getString("CTL_Default"));
            this.jButton1.setMaximumSize(new Dimension(180, 27));
            this.jButton1.setPreferredSize(new Dimension(180, 27));
            this.jButton1.setLocation((int)(this.jButton1.getLocation().getX() - 14.0), (int)this.jButton1.getLocation().getY());
            this.jButton1.setMargin(new Insets(2, 11, 2, 11));
            this.jButton1.setFocusPainted(false);
            if (this.getContext() == null) {
                if (this.getInherit() == null) {
                    this.jButton1.setSelected(true);
                    this.recursiveDisableComponent(this.chooser, false);
                    this.inherited = true;
                } else {
                    this.jButton1.setSelected(false);
                    this.recursiveDisableComponent(this.chooser, true);
                    this.inherited = false;
                }
            } else {
                this.jButton1.setVisible(false);
                this.inherited = false;
            }
            this.jPanel1.add(this.jButton1);
            this.chooser.setAccessory(this.jButton1);
            this.jButton1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FileEditor2.this.jButton1ActionPerformed(actionEvent);
                }
            });
            String string = (String)this.env.getFeatureDescriptor().getValue("helpID");
            HelpCtx.setHelpIDString((JComponent)this.chooser, (String)string);
        }
        return this.chooser;
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        try {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (jCheckBox.isSelected()) {
                this.setValue(null);
                File file = (File)this.getValue();
                if (file != null) {
                    if (file != null && !file.getPath().equals(".") && !file.getPath().equals("")) {
                        this.chooser.setSelectedFile(file);
                    } else if (file != null && (file.getPath().equals(".") || file.getPath().equals(""))) {
                        this.chooser.setSelectedFile(file);
                    }
                    this.setValue(null);
                }
                this.recursiveDisableComponent(this.chooser, false);
                this.jPanel1.setEnabled(true);
                this.jButton1.setEnabled(true);
                this.inherited = true;
            } else {
                this.recursiveDisableComponent(this.chooser, true);
                if (this.chooser.getSelectedFile() == null) {
                    if (this.files) {
                        if (this.getValue() == null || this.getValue().equals("")) {
                            this.setValue(null);
                            this.setAsText("");
                        } else {
                            File file = new File(((File)this.getValue()).getAbsolutePath());
                            this.setValue(null);
                            this.setValue(file);
                        }
                    } else {
                        this.setValue(this.chooser.getCurrentDirectory());
                    }
                } else {
                    String string = this.chooser.getSelectedFile().getAbsolutePath();
                    this.setAsText("");
                    this.setAsText(string);
                }
                this.inherited = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getJavaInitializationString() {
        File file = (File)this.getValue();
        if (file == null) {
            return "null";
        }
        if (this.baseDirectory != null && !file.isAbsolute()) {
            return "new java.io.File(" + FileEditor2.stringify(this.baseDirectory.getPath()) + ", " + FileEditor2.stringify(file.getPath()) + ")";
        }
        return "new java.io.File(" + FileEditor2.stringify(file.getAbsolutePath()) + ")";
    }

    static String stringify(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2 + 2);
        stringBuffer.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private HelpCtx getHelpCtx() {
        return new HelpCtx(FileEditor2.class);
    }

    private static String getString(String string) {
        return NbBundle.getBundle((Class)FileEditor2.class).getString(string);
    }

    static String getChildRelativePath(File file, File file2) {
        if (file2.equals(file)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(file2.getPath().length());
        stringBuffer.append(file2.getName());
        for (File file3 = file2.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
            if (file3.equals(file)) {
                return stringBuffer.toString();
            }
            stringBuffer.insert(0, File.separatorChar);
            stringBuffer.insert(0, file3.getName());
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (!this.files && file.isFile()) {
            return;
        }
        if (!this.directories && file.isDirectory()) {
            return;
        }
        if (this.baseDirectory != null && (string = FileEditor2.getChildRelativePath(this.baseDirectory, file)) != null) {
            file = new File(string);
        }
        if (!this.inherited) {
            this.setValue(new File(file.getAbsolutePath()));
            lastCurrentDir = jFileChooser.getCurrentDirectory();
        }
    }

    public static JFileChooser createHackedFileChooser() {
        Serializable serializable;
        Object object;
        final JFileChooser jFileChooser = new JFileChooser();
        InputMap inputMap = jFileChooser.getInputMap(1);
        if (inputMap != null && (object = inputMap.get((KeyStroke)(serializable = KeyStroke.getKeyStroke(10, 0)))) == null) {
            inputMap.put((KeyStroke)serializable, "approveSelection");
        }
        if ((serializable = jFileChooser.getActionMap()) != null && (object = ((ActionMap)serializable).getParent()) != null) {
            final Action action = ((ActionMap)object).get("approveSelection");
            ((ActionMap)object).put("approveSelection", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file = jFileChooser.getSelectedFile();
                    if (file != null && file.isDirectory()) {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        jFileChooser.setCurrentDirectory(file);
                    } else if (action != null) {
                        action.actionPerformed(actionEvent);
                    }
                }
            });
        }
        return jFileChooser;
    }

    static class DelegatingFilenameFilter
    extends javax.swing.filechooser.FileFilter {
        private FilenameFilter filter;

        public DelegatingFilenameFilter(FilenameFilter filenameFilter) {
            this.filter = filenameFilter;
        }

        public boolean accept(File file) {
            return this.filter.accept(file.getParentFile(), file.getName());
        }

        public String getDescription() {
            return null;
        }
    }

    static class DelegatingFileFilter
    extends javax.swing.filechooser.FileFilter {
        private FileFilter filter;

        public DelegatingFileFilter(FileFilter fileFilter) {
            this.filter = fileFilter;
        }

        public boolean accept(File file) {
            return this.filter.accept(file);
        }

        public String getDescription() {
            return null;
        }
    }
}

