/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class NbProcessDescriptor
implements Serializable {
    private static final long serialVersionUID = -4535211234565221486L;
    private static ErrorManager execLog;
    private String processName;
    private String arguments;
    private String info;

    public NbProcessDescriptor(String processName, String arguments) {
        this(processName, arguments, null);
    }

    public NbProcessDescriptor(String processName, String arguments, String info) {
        this.processName = processName;
        this.arguments = arguments;
        this.info = info;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getInfo() {
        return this.info;
    }

    public Process exec(Format format, String[] envp, File cwd) throws IOException {
        return this.exec(format, envp, false, cwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process exec(Format format, String[] envp, boolean appendEnv, File cwd) throws IOException {
        String stringArgs = format == null ? this.arguments : format.format(this.arguments);
        String[] args = NbProcessDescriptor.parseArguments(stringArgs);
        String[] call = null;
        envp = NbProcessDescriptor.substituteEnv(format, envp);
        if (Utilities.getOperatingSystem() == 8192 && this.isJavaCmd(args)) {
            call = this.constructVMSCmdLine(format, args);
        } else {
            call = new String[args.length + 1];
            call[0] = format == null ? this.processName : format.format(this.processName);
            System.arraycopy(args, 0, call, 1, args.length);
        }
        NbProcessDescriptor.logArgs(call);
        if (envp != null && appendEnv) {
            int i;
            HashMap<String, Object> e = new HashMap<String, Object>(100);
            Iterator<Map.Entry<Object, Object>> it = System.getProperties().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String prop = (String)entry.getKey();
                if (!prop.startsWith("Env-")) continue;
                String evar = prop.substring(4);
                e.put(evar, entry.getValue());
            }
            for (i = 0; i < envp.length; ++i) {
                String nameval = envp[i];
                int idx = nameval.indexOf(61);
                if (idx == -1) {
                    throw new IOException("No equal sign in name=value: " + nameval);
                }
                e.put(nameval.substring(0, idx), nameval.substring(idx + 1));
            }
            envp = new String[e.size()];
            i = 0;
            it = e.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                envp[i++] = (String)entry.getKey() + '=' + (String)entry.getValue();
            }
        }
        int os = Utilities.getOperatingSystem();
        Thread currentThread = null;
        int currentPriority = 0;
        try {
            Process process;
            if (os == 4) {
                currentThread = Thread.currentThread();
                currentPriority = currentThread.getPriority();
                currentThread.setPriority(5);
            }
            if (cwd == null) {
                if (envp == null) {
                    process = Runtime.getRuntime().exec(call);
                    return process;
                }
                process = Runtime.getRuntime().exec(call, envp);
                return process;
            }
            process = Runtime.getRuntime().exec(call, envp, cwd);
            return process;
        }
        finally {
            if (os == 4) {
                currentThread.setPriority(currentPriority);
            }
        }
    }

    private static void logArgs(String[] args) {
        try {
            ResourceBundle rb = NbBundle.getBundle((String)"org.openide.execution.Bundle");
            String exc = rb.getString("CTL_Exec");
            String fmt = rb.getString("FMT_ExecParams");
            MessageFormat msgformat = new MessageFormat(fmt);
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            printer.println(exc);
            for (int i = 0; i < args.length; ++i) {
                printer.println(msgformat.format(new Object[]{new Integer(i), args[i]}));
            }
            printer.close();
            NbProcessDescriptor.getExecLog().log(1, writer.toString());
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public Process exec(Format format, String[] envp) throws IOException {
        return this.exec(format, envp, null);
    }

    public Process exec(Format format) throws IOException {
        return this.exec(format, null);
    }

    public Process exec() throws IOException {
        return this.exec(null, null);
    }

    public int hashCode() {
        return this.processName.hashCode() + this.arguments.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NbProcessDescriptor)) {
            return false;
        }
        NbProcessDescriptor him = (NbProcessDescriptor)o;
        return this.processName.equals(him.processName) && this.arguments.equals(him.arguments);
    }

    private static String[] parseArguments(String sargs) {
        return Utilities.parseParameters((String)sargs);
    }

    private static ErrorManager getExecLog() {
        if (execLog == null) {
            execLog = ErrorManager.getDefault().getInstance("IDE-Exec");
        }
        return execLog;
    }

    private boolean isJavaCmd(String[] args) {
        return args.length > 0 && (this.processName.endsWith("{/}java") || this.processName.endsWith("{/}javac"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] constructVMSCmdLine(Format format, String[] args) throws IOException {
        PrintWriter pWriter = null;
        File switchFile = null;
        String atFileName = null;
        String javacCmd = "{/}javac";
        try {
            switchFile = File.createTempFile("compilerparams", "pms");
            switchFile.deleteOnExit();
            pWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(switchFile)));
            for (int i = 0; i < args.length; ++i) {
                if (args[i].charAt(0) == '@' && this.processName.endsWith("{/}javac")) {
                    atFileName = args[i];
                    continue;
                }
                pWriter.println(args[i]);
            }
        }
        finally {
            if (pWriter != null) {
                pWriter.close();
            }
        }
        String[] call = atFileName != null ? new String[4] : new String[3];
        call[0] = format == null ? this.processName : format.format(this.processName);
        call[1] = "-V";
        call[2] = switchFile.getAbsolutePath();
        if (call.length > 3) {
            call[3] = atFileName;
        }
        return call;
    }

    private static String[] substituteEnv(Format format, String[] envp) {
        if (envp == null || envp.length == 0 || format == null) {
            return envp;
        }
        String[] ret = new String[envp.length];
        StringBuffer adder = new StringBuffer();
        for (int i = 0; i < envp.length; ++i) {
            int idx;
            ret[i] = envp[i];
            if (ret[i] == null || (idx = ret[i].indexOf(61)) < 0) continue;
            String val = ret[i].substring(idx + 1);
            String key = ret[i].substring(0, idx);
            adder.append(key).append('=').append(format.format(val));
            ret[i] = adder.toString();
            adder.setLength(0);
        }
        return ret;
    }
}

