/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerType;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class ExternalCompilerType
extends CompilerType {
    private static final long serialVersionUID = -4934327582488427081L;
    public static final String PROP_EXTERNAL_COMPILER = "externalCompiler";
    public static final String PROP_ERROR_EXPRESSION = "errorExpression";
    private static final NbProcessDescriptor DEFAULT_DESCRIPTOR = new NbProcessDescriptor("{jdk.home}{/}bin{/}javac", "-classpath {filesystems}{:}{classpath}{:}{library}{:}{bootclasspath} {files}", NbBundle.getBundle((Class)ExternalCompilerGroup.class).getString("MSG_ExternalCompilerHint"));
    private NbProcessDescriptor nbDescriptor = DEFAULT_DESCRIPTOR;
    private ExternalCompiler.ErrorExpression err = ExternalCompiler.JAVAC;

    public NbProcessDescriptor getExternalCompiler() {
        return this.nbDescriptor;
    }

    public void setExternalCompiler(NbProcessDescriptor nbProcessDescriptor) {
        NbProcessDescriptor nbProcessDescriptor2 = this.nbDescriptor;
        this.nbDescriptor = nbProcessDescriptor;
        this.firePropertyChange(PROP_EXTERNAL_COMPILER, nbProcessDescriptor2, nbProcessDescriptor);
    }

    public void setErrorExpression(ExternalCompiler.ErrorExpression errorExpression) {
        ExternalCompiler.ErrorExpression errorExpression2 = this.err;
        this.err = errorExpression;
        this.firePropertyChange(PROP_ERROR_EXPRESSION, errorExpression2, errorExpression);
    }

    public ExternalCompiler.ErrorExpression getErrorExpression() {
        return this.err;
    }

    public void prepareJob(CompilerJob compilerJob, Class clazz, DataObject dataObject) {
        if (clazz != ExternalCompiler.COMPILE && clazz != ExternalCompiler.BUILD) {
            return;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        new ExternalCompiler(compilerJob, fileObject, (Object)clazz, this.nbDescriptor, this.err);
    }
}

