/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.openide.LifecycleManager;
import org.openide.awt.StatusDisplayer;
import org.openide.compiler.CompilerSysProcess;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.io.FoldingIOException;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

final class CompilerExecutor
extends ProcessExecutor {
    static final long serialVersionUID = -2611259508166125914L;
    private List files = new LinkedList();
    private ExternalCompilerGroup eCompiler;
    private NbProcessDescriptor nbDescriptor;
    private ExternalCompiler.ErrorExpression errorExpression;
    private Object compilerType;

    CompilerExecutor(ExternalCompilerGroup externalCompilerGroup, NbProcessDescriptor nbProcessDescriptor, ExternalCompiler.ErrorExpression errorExpression, Object object) {
        this.eCompiler = externalCompilerGroup;
        this.nbDescriptor = nbProcessDescriptor;
        this.errorExpression = errorExpression;
        this.compilerType = object;
    }

    public void addFile(String string) {
        this.files.add(string);
    }

    private static InputOutput getCompilerIO() {
        String string = NbBundle.getBundle((String)"org.openide.compiler.Bundle").getString("CTL_CompileTab");
        return IOProvider.getDefault().getIO(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute(DataObject dataObject) throws IOException {
        CERunnable cERunnable;
        CERunnable cERunnable2 = cERunnable = new CERunnable(this.eCompiler, this.errorExpression, this.nbDescriptor, this.files, this.compilerType);
        synchronized (cERunnable2) {
            ExecutorTask executorTask = ExecutionEngine.getDefault().execute(NbBundle.getBundle((Class)CompilerExecutor.class).getString("CTL_CompilationTask"), cERunnable, CompilerExecutor.getCompilerIO());
            try {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                cERunnable.wait();
                Throwable throwable = cERunnable.getException();
                if (throwable != null) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new FoldingIOException(throwable);
                }
                CompilerSysProcess compilerSysProcess = cERunnable.getCompilerSysProcess();
                compilerSysProcess.setExecutorTask(executorTask);
                return compilerSysProcess;
            }
            catch (InterruptedException interruptedException) {
                return new CompilerSysProcess.InterruptedProcess();
            }
        }
    }

    ExternalCompiler.ErrorExpression getErrorExpression() {
        return this.errorExpression;
    }

    NbProcessDescriptor getDescriptor() {
        return this.nbDescriptor;
    }

    static class CERunnable
    implements Runnable {
        private ExternalCompilerGroup eeg;
        private ExternalCompiler.ErrorExpression errorExpression;
        private NbProcessDescriptor nbDescriptor;
        private Throwable t;
        private CompilerSysProcess csp;
        private List files;
        private Object compilerType;

        CERunnable(ExternalCompilerGroup externalCompilerGroup, ExternalCompiler.ErrorExpression errorExpression, NbProcessDescriptor nbProcessDescriptor, List list, Object object) {
            this.eeg = externalCompilerGroup;
            this.errorExpression = errorExpression;
            this.nbDescriptor = nbProcessDescriptor;
            this.files = list;
            this.compilerType = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                LifecycleManager.getDefault().saveAll();
                String string = this.eeg.getStatusLineText();
                StatusDisplayer.getDefault().setStatusText(string);
                this.csp = new CompilerSysProcess(this, this.eeg, this.eeg.createProcess(this.nbDescriptor, this.files.toArray(new String[0]), this.compilerType), this.errorExpression);
            }
            catch (Exception exception) {
                this.t = exception;
            }
            finally {
                CERunnable cERunnable = this;
                synchronized (cERunnable) {
                    this.notifyAll();
                }
            }
        }

        public Throwable getException() {
            return this.t;
        }

        public CompilerSysProcess getCompilerSysProcess() {
            return this.csp;
        }
    }
}

