/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerGroup;
import org.openide.compiler.CompilerGroupException;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerTask;
import org.openide.compiler.DependencyException;
import org.openide.util.Lookup;

public abstract class CompilationEngine {
    protected abstract CompilerTask start(CompilerJob var1);

    protected static List createComputationLevels(CompilerJob compilerJob) throws DependencyException {
        return compilerJob.computationLevels();
    }

    protected static Collection createCompilerGroups(Collection collection) throws CompilerGroupException {
        HashMap<Object, CompilerGroup> hashMap = new HashMap<Object, CompilerGroup>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Compiler compiler = (Compiler)iterator.next();
            if (compiler.isUpToDate()) continue;
            Object object = compiler.compilerGroupKey();
            CompilerGroup compilerGroup = (CompilerGroup)hashMap.get(object);
            if (compilerGroup == null) {
                Class clazz = compiler.compilerGroupClass();
                try {
                    compilerGroup = (CompilerGroup)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new CompilerGroupException(clazz, exception);
                }
                hashMap.put(object, compilerGroup);
            }
            compilerGroup.add(compiler);
        }
        return hashMap.values();
    }

    public static CompilationEngine getDefault() {
        return (CompilationEngine)Lookup.getDefault().lookup(CompilationEngine.class);
    }
}

