/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.pascalsupport.pascal.datasys;

import com.hp.openvms.netbeans.baseclasses.actions.MyPropertiesAction;
import com.hp.openvms.netbeans.baseclasses.dataloaders.AlphaVMSDataLoader;
import com.hp.openvms.netbeans.pascalsupport.PascalConstants;
import com.hp.openvms.netbeans.pascalsupport.pascal.datasys.PascalDataObject;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.openide.actions.BuildAction;
import org.openide.actions.CompileAction;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.EditAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.SaveAsTemplateAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class PascalDataLoader
extends AlphaVMSDataLoader {
    private static final int EXTERNALIZED_VERSION = 1;
    public static final String PROP_PASCAL_EXTENSIONS = "pascalExtensions";
    public static final String PROP_PERFECT_RECOGNITION = "perfectRecognition";
    public static final String REQUIRED_MIME = "text/x-hp+openvms+pas";
    private static ResourceBundle bundle;

    public PascalDataLoader() {
        super("com.hp.openvms.netbeans.pascalsupport.pascal.datasys.PascalDataObject");
    }

    public PascalDataLoader(String string) {
        super(string);
    }

    public PascalDataLoader(Class clazz) {
        super(clazz);
    }

    protected String actionsContext() {
        return "Loaders/text/x-hp+openvms+pas/Actions";
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)PascalDataLoader.class, (String)"LBL_loaderName");
    }

    public static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)PascalDataLoader.class);
        }
        return bundle.getString(string);
    }

    protected SystemAction[] defaultActions() {
        return new SystemAction[]{SystemAction.get((Class)OpenAction.class), SystemAction.get((Class)EditAction.class), SystemAction.get((Class)FileSystemAction.class), null, SystemAction.get((Class)CompileAction.class), SystemAction.get((Class)BuildAction.class), null, SystemAction.get((Class)CutAction.class), SystemAction.get((Class)CopyAction.class), SystemAction.get((Class)PasteAction.class), null, SystemAction.get((Class)DeleteAction.class), SystemAction.get((Class)RenameAction.class), null, SystemAction.get((Class)SaveAsTemplateAction.class), null, SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)MyPropertiesAction.class)};
    }

    public ExtensionList getPascalExtensions() {
        ExtensionList extensionList = (ExtensionList)this.getProperty(PROP_PASCAL_EXTENSIONS);
        if (extensionList == null) {
            extensionList = new ExtensionList();
            for (int i = 0; i < PascalConstants.PASCAL_EXTENSIONS.length; ++i) {
                extensionList.addExtension(PascalConstants.PASCAL_EXTENSIONS[i]);
            }
            this.putProperty(PROP_PASCAL_EXTENSIONS, extensionList, false);
        }
        return extensionList;
    }

    public void setPascalExtensions(ExtensionList extensionList) {
        this.putProperty(PROP_PASCAL_EXTENSIONS, extensionList, true);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(1);
        objectOutput.writeObject(this.getProperty(PROP_PASCAL_EXTENSIONS));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        if (objectInput.available() > 0) {
            int n = objectInput.readInt();
            this.putProperty(PROP_PASCAL_EXTENSIONS, objectInput.readObject(), false);
        }
    }

    private FileObject findBrotherCaseInsensitive(FileObject fileObject, String string) {
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 == null) {
            return null;
        }
        FileObject[] fileObjectArray = fileObject2.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (fileObjectArray[i].getExt() == null) continue;
            StringBuffer stringBuffer = new StringBuffer(fileObject.getName().length() + 1 + (string == null ? 0 : string.length()));
            stringBuffer.append(fileObject.getName()).append(".").append(string);
            if (!fileObjectArray[i].getNameExt().equalsIgnoreCase(stringBuffer.toString())) continue;
            return fileObjectArray[i];
        }
        return null;
    }

    private FileObject findBrother(Enumeration enumeration, FileObject fileObject) {
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            FileObject fileObject2 = this.findBrotherCaseInsensitive(fileObject, string);
            if (fileObject2 == null) continue;
            return fileObject2;
        }
        return null;
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        if (this.getPascalExtensions().isRegistered(fileObject)) {
            return fileObject;
        }
        return null;
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        String string = fileObject.getExt();
        if (this.getPascalExtensions().isRegistered(string)) {
            return new PascalDataObject(fileObject, this);
        }
        return null;
    }
}

