/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.pascalsupport.pascal;

import com.hp.openvms.netbeans.pascalsupport.pascal.datasys.PascalCompilerSupport;
import com.hp.openvms.netbeans.pascalsupport.pascal.datasys.PascalDataObject;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;

class SurrogateNode
extends AbstractNode {
    private Node realNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public SurrogateNode(Children children, Node node) {
        super(children);
        this.realNode = node;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Remote Compiler Settings");
        set.setDisplayName("Remote Compiler Settings");
        set.setShortDescription("Settings for remote operations on a remote host");
        DataObject dataObject = (DataObject)this.realNode.getCookie(DataObject.class);
        if (dataObject instanceof PascalDataObject) {
            ((PascalCompilerSupport)dataObject.getCookie(PascalCompilerSupport.class)).addProperties(set);
            ((PascalCompilerSupport)dataObject.getCookie(PascalCompilerSupport.class)).addMakefileProperty(set);
            ((PascalCompilerSupport)dataObject.getCookie(PascalCompilerSupport.class)).addBuildOptionProperty(set);
        }
        set.put((Node.Property)this.createRemoteFilePathProperty());
        try {
            if (dataObject.getPrimaryFile().getFileSystem() instanceof FTPFileSystem) {
                set.put((Node.Property)this.createFileResidenceProperty());
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        sheet.put(set);
        return sheet;
    }

    private PropertySupport createRemoteFilePathProperty() {
        class RemoteFilePathPropertySupport
        extends PropertySupport.ReadOnly {
            public RemoteFilePathPropertySupport() {
                super("Remote File Path", class$java$lang$String == null ? (class$java$lang$String = SurrogateNode.class$("java.lang.String")) : class$java$lang$String, "Remote File Path", "Remote File Path");
            }

            public Object getValue() {
                DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                FileObject fileObject = dataObject.getPrimaryFile();
                Object object = dataObject.getPrimaryFile().getAttribute("REMOTE_FILEPATH");
                if (object != null) {
                    return object;
                }
                String string = fileObject.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (Utilities.isWindows()) {
                        string = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        string = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return string;
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    dataObject.getPrimaryFile().setAttribute("REMOTE_FILEPATH", object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                FileObject fileObject = dataObject.getPrimaryFile();
                String string = fileObject.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (Utilities.isWindows()) {
                        string = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        string = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    }
                    this.setValue(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new RemoteFilePathPropertySupport();
    }

    private PropertySupport createFileResidenceProperty() {
        class FileResidenceProperty
        extends PropertySupport.ReadOnly {
            public FileResidenceProperty() {
                super("File Residence", class$java$lang$String == null ? (class$java$lang$String = SurrogateNode.class$("java.lang.String")) : class$java$lang$String, "File Residence", "Determine if the file should reside in local disk, server or both");
            }

            public Object getValue() {
                DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                FileObject fileObject = dataObject.getPrimaryFile();
                Object object = fileObject.getAttribute("file_residence_mode");
                if (object != null) {
                    Integer n = (Integer)object;
                    String string = "Make Client and Server";
                    switch (n) {
                        case 1: {
                            string = "Client Only";
                            break;
                        }
                        case 0: {
                            string = "Server Only";
                            break;
                        }
                        case 2: {
                            string = "Client and Server";
                        }
                    }
                    return string;
                }
                return "Client and Server";
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    dataObject.getPrimaryFile().setAttribute("file_residence_mode", object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new FileResidenceProperty();
    }

    private PropertySupport createUseXtermProperty() {
        class UseXtermPropertySupport
        extends PropertySupport.ReadWrite {
            public UseXtermPropertySupport() {
                super("Use Xterm for Compile", class$java$lang$Boolean == null ? (class$java$lang$Boolean = SurrogateNode.class$("java.lang.Boolean")) : class$java$lang$Boolean, "Use Xterm for Compile", "Use the X terminal window to display the output");
            }

            public Object getValue() {
                DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                FileObject fileObject = dataObject.getPrimaryFile();
                Object object = dataObject.getPrimaryFile().getAttribute("useXtermCompile");
                if (object != null) {
                    return object;
                }
                try {
                    AbstractNetworkFileSystem abstractNetworkFileSystem = (AbstractNetworkFileSystem)dataObject.getPrimaryFile().getFileSystem();
                    return new Boolean(abstractNetworkFileSystem.getUseXtermCompile());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return new Boolean(DistributedSettings.getDefault().getUseXtermCompile());
                }
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    dataObject.getPrimaryFile().setAttribute("useXtermCompile", object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new UseXtermPropertySupport();
    }

    private PropertySupport createRemoteArgumentsProperty() {
        class RemoteArgumentsPropertySupport
        extends PropertySupport.ReadWrite {
            public RemoteArgumentsPropertySupport() {
                super("Remote Arguments", class$java$lang$String == null ? (class$java$lang$String = SurrogateNode.class$("java.lang.String")) : class$java$lang$String, "Remote Arguments", "Remote Arguments");
            }

            public Object getValue() {
                DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                FileObject fileObject = dataObject.getPrimaryFile();
                Object object = dataObject.getPrimaryFile().getAttribute("REMOTE_ARGUMENT");
                if (object != null) {
                    return object;
                }
                return "";
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    dataObject.getPrimaryFile().setAttribute("REMOTE_ARGUMENT", object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new RemoteArgumentsPropertySupport();
    }
}

