/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.pascalsupport.pascal;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompiler;
import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompilerType;
import com.hp.openvms.netbeans.baseclasses.dataloaders.AlphaVMSDataLoader;
import com.hp.openvms.netbeans.pascalsupport.pascal.PascalCompilerGroup;
import com.hp.openvms.netbeans.pascalsupport.pascal.PascalCompilerType;
import com.hp.openvms.netbeans.pascalsupport.pascal.datasys.PascalCompilerSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.compiler.ExternalCompiler;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class PascalCompiler
extends AlphaVMSCompiler {
    private PascalCompilerType compilerSvcType;
    private static final String COMPILER_NAME = "HP PASCAL compiler";
    private boolean isRemote = false;

    public PascalCompiler(Class clazz, FileObject fileObject, NbProcessDescriptor nbProcessDescriptor, ExternalCompiler.ErrorExpression errorExpression, PascalCompilerType pascalCompilerType) {
        super(clazz.equals(BUILD) || clazz.equals(AlphaVMSCompilerType.REMOTE_BUILD), fileObject, nbProcessDescriptor, errorExpression);
        if (clazz.equals(AlphaVMSCompilerType.REMOTE_COMPILE) || clazz.equals(AlphaVMSCompilerType.REMOTE_BUILD)) {
            this.isRemote = true;
        }
        this.compilerSvcType = pascalCompilerType;
    }

    public Class compilerGroupClass() {
        return PascalCompilerGroup.class;
    }

    public Object compilerGroupKey() {
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(0, super.compilerGroupKey());
        arrayList.add(1, PascalCompiler.class);
        arrayList.add(2, (Object)this.compilerSvcType);
        return arrayList;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof PascalCompiler)) {
            return false;
        }
        PascalCompiler pascalCompiler = (PascalCompiler)((Object)object);
        return pascalCompiler.compilerSvcType == this.compilerSvcType && this.getBuilding() == pascalCompiler.getBuilding();
    }

    public int hashCode() {
        return 0x4D2 ^ this.getFileObject().getPackageNameExt('/', '.').hashCode();
    }

    public String getCompilerName() {
        return COMPILER_NAME;
    }

    public PascalCompilerType getCompilerSvcType() {
        return this.compilerSvcType;
    }

    public final FileObject getFileObject0() {
        return this.getFileObject();
    }

    public boolean isUpToDate() {
        try {
            boolean bl = super.isUpToDate();
            if (!bl) {
                return false;
            }
            DataObject dataObject = DataObject.find((FileObject)this.getFileObject());
            RemoteFSFile remoteFSFile = null;
            PascalCompilerSupport pascalCompilerSupport = (PascalCompilerSupport)dataObject.getCookie(CompilerCookie.class);
            NbProcessDescriptor nbProcessDescriptor = pascalCompilerSupport.getExternalCompiler();
            remoteFSFile = pascalCompilerSupport.getBuildDirectory();
            FileObject fileObject = dataObject.getPrimaryFile();
            FileObject fileObject2 = fileObject.getParent();
            AlphaVMSDataLoader alphaVMSDataLoader = (AlphaVMSDataLoader)DataLoader.getLoader((Class)AlphaVMSDataLoader.class);
            Enumeration enumeration = alphaVMSDataLoader.getObjExtensions().extensions();
            File file = null;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = fileObject.getName().toUpperCase() + "." + string.toUpperCase();
                file = new File(remoteFSFile.getAbsolutePath() + File.separatorChar + string2);
                if (file.exists()) break;
                file = null;
            }
            if (file != null && file.length() > 0L && file.lastModified() > fileObject.lastModified().getTime()) {
                return true;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public boolean isRemote() {
        return this.isRemote;
    }
}

