/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.BreakpointImpl;
import com.hp.openvms.netbeans.debugsupport.breakpoints.BreakpointsReader;
import com.hp.openvms.netbeans.debugsupport.breakpoints.FunctionBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.FunctionBreakpointImpl;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpointImpl;
import com.hp.openvms.netbeans.debugsupport.breakpoints.PersistenceManager;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.distributed.rmi.protocol.debug.DebugInfo;
import org.netbeans.modules.distributed.rmi.protocol.debug.LookupLinePacket;
import org.netbeans.spi.debugger.ContextProvider;

public class BreakpointsEngineListener
extends LazyActionsManagerListener
implements PropertyChangeListener,
DebuggerManagerListener {
    private RemoteDebugger debugger;
    private Session session;
    private BreakpointsReader breakpointsReader;
    private HashMap breakpointToImpl = new HashMap();

    public BreakpointsEngineListener(ContextProvider contextProvider) {
        this.debugger = (RemoteDebugger)contextProvider.lookupFirst(null, RemoteDebugger.class);
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
        this.debugger.addPropertyChangeListener("state", this);
        this.breakpointsReader = PersistenceManager.findBreakpointsReader();
    }

    protected void destroy() {
        this.debugger.removePropertyChangeListener("state", this);
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.removeBreakpointImpls();
        this.unvalidateBreakpoints();
    }

    public String[] getProperties() {
        return new String[]{"asd"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getOldValue() == "state_starting" && propertyChangeEvent.getNewValue() == "state_loading") {
            this.createBreakpointImpls();
            DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        }
    }

    public void actionPerformed(Object object) {
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.createBreakpointImpl(breakpoint, false);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.removeBreakpointImpl(breakpoint, true);
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
        System.err.println("BEL.engineAdded: ");
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
        System.err.println("BEL.engineRemoved: ");
    }

    private void createBreakpointImpls() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        int n = breakpointArray.length;
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n > 0) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                if (!(breakpointArray[n3] instanceof RemoteBreakpoint)) continue;
                this.createBreakpointImpl(breakpointArray[n3], true);
                ++n2;
                arrayList.add(new Integer(n3));
            }
            DebugInfo[] debugInfoArray = this.debugger.breakpointInsertFlushCache();
            for (n3 = 0; n3 < n2; ++n3) {
                LookupLinePacket lookupLinePacket;
                if (debugInfoArray[n3] == null || debugInfoArray[n3].getLookupLinePackets() == null || (lookupLinePacket = (LookupLinePacket)debugInfoArray[n3].getLookupLinePackets().get(0)) == null) continue;
                ((LineBreakpoint)breakpointArray[(Integer)arrayList.get(n3)]).setLookupLinePacket(lookupLinePacket);
            }
        } else {
            this.debugger.setRunning();
        }
    }

    private void removeBreakpointImpls() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        int n = breakpointArray.length;
        for (int i = 0; i < n; ++i) {
            if (!(breakpointArray[i] instanceof RemoteBreakpoint)) continue;
            this.removeBreakpointImpl(breakpointArray[i], false);
        }
    }

    private void unvalidateBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        int n = breakpointArray.length;
        for (int i = 0; i < n; ++i) {
            if (!(breakpointArray[i] instanceof RemoteBreakpoint)) continue;
            ((RemoteBreakpoint)breakpointArray[i]).setState(0);
        }
    }

    public void fixBreakpointImpls() {
        Iterator iterator = this.breakpointToImpl.values().iterator();
        while (iterator.hasNext()) {
            ((BreakpointImpl)iterator.next()).fixed();
        }
    }

    private void createBreakpointImpl(Breakpoint breakpoint, boolean bl) {
        if (this.breakpointToImpl.containsKey(breakpoint)) {
            return;
        }
        if (breakpoint instanceof LineBreakpoint) {
            this.breakpointToImpl.put(breakpoint, new LineBreakpointImpl((LineBreakpoint)breakpoint, this.breakpointsReader, this.debugger, this.session, bl));
        } else if (breakpoint instanceof FunctionBreakpoint) {
            this.breakpointToImpl.put(breakpoint, new FunctionBreakpointImpl((FunctionBreakpoint)breakpoint, this.breakpointsReader, this.debugger, this.session));
        }
    }

    private void removeBreakpointImpl(Breakpoint breakpoint, boolean bl) {
        BreakpointImpl breakpointImpl = (BreakpointImpl)this.breakpointToImpl.get(breakpoint);
        if (breakpointImpl != null) {
            if (bl && ((LineBreakpoint)breakpoint).getLookupLinePacket() != null) {
                this.debugger.breakpointRemove(((LineBreakpoint)breakpoint).getLookupLinePacket());
            }
            breakpointImpl.remove();
            this.breakpointToImpl.remove(breakpoint);
        }
    }
}

