/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.dclsupport.dcl.datasys;

import com.hp.openvms.netbeans.dclsupport.dcl.BaseCompilerType;
import com.hp.openvms.netbeans.dclsupport.dcl.DCLCompilerType;
import com.hp.openvms.netbeans.dclsupport.dcl.MMSCompilerType;
import com.hp.openvms.netbeans.dclsupport.dcl.SHCompilerType;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.MMSDataObject;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.SHDataObject;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.propertyeditors.BoolEditor;
import org.netbeans.modules.distributed.common.propertyeditors.StringEditor2;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.propertyeditor.FileEditor;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.compiler.CompilerSupport;
import org.openide.compiler.ExternalCompiler;
import org.openide.cookies.CompilerCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class DCLBuildSupport
extends CompilerSupport {
    public static final String PROP_FILE_PARAMS = "cpqDclCompileParams";
    public static final String PROP_BUILD_DIR = "cpqDclBuildDirectory";
    public static final String PROP_EXTERNAL_COMPILER = "cqpDclExternalCompiler";
    public static final String PROP_OUTPUT_SWITCH = "cqpDclOutputSwitch";
    public static final String PROP_PARAMETERS_PROMPT = "cqpDclPromptForParams";
    public static final String PROP_RESET = "cpqDclReset";
    public static final String PROP_TARGET = "cpqDclTarget";
    public static final int DCL_TYPE = 0;
    public static final int MMS_TYPE = 1;
    public static final int SH_TYPE = 2;
    protected static final ResourceBundle bundle = NbBundle.getBundle((Class)DCLBuildSupport.class);
    protected MultiDataObject.Entry entry;
    int sType = 0;
    String sRemoteProperty;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;

    public DCLBuildSupport(MultiDataObject.Entry entry, Class clazz) {
        super(entry, clazz);
        this.entry = entry;
        if (entry.getDataObject() instanceof MMSDataObject) {
            this.sType = 1;
            this.sRemoteProperty = "Prompt for Qualifiers and Additional Targets";
        } else if (entry.getDataObject() instanceof SHDataObject) {
            this.sType = 2;
            this.sRemoteProperty = "Prompt for Arguments";
        } else {
            this.sRemoteProperty = "Prompt for Parameters";
        }
    }

    public FileObject getFileObject() {
        return this.entry.getFile();
    }

    private BaseCompilerType getProjCompilerType() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.getFileObject());
        if (project != null) {
            RemoteProjectSettings remoteProjectSettings = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
            if (remoteProjectSettings != null) {
                remoteProjectSettings.refreshAll();
            }
            if (this.sType == 0) {
                if (remoteProjectSettings == null) {
                    return new DCLCompilerType(this.getFileObject());
                }
                return (DCLCompilerType)((Object)remoteProjectSettings.getCompilerSettings("dcl"));
            }
            if (this.sType == 2) {
                if (remoteProjectSettings == null) {
                    return new SHCompilerType(this.getFileObject());
                }
                return (SHCompilerType)((Object)remoteProjectSettings.getCompilerSettings("sh"));
            }
            if (remoteProjectSettings == null) {
                return new MMSCompilerType(this.getFileObject());
            }
            return (MMSCompilerType)((Object)remoteProjectSettings.getCompilerSettings("mms"));
        }
        return null;
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createBuildProperty());
        set.put((Node.Property)this.createExternalCompilerProperty());
        if (this.sType == 1) {
            set.put((Node.Property)this.createTargetProperty());
        }
        set.put((Node.Property)this.createOutputSwitchProperty());
        set.put((Node.Property)this.createXDisplayDeviceNumber());
        set.put((Node.Property)this.createPromptForParameter());
    }

    protected String getString(String string) {
        return bundle.getString(string);
    }

    public ExternalCompiler.ErrorExpression errorExpression() {
        return this.getProjCompilerType().getErrorExpression();
    }

    private String getFlaggedNameOutputSwitch(String string, String string2) {
        return string;
    }

    public void setBuildDirectory(RemoteFSFile remoteFSFile) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_DIR, (Object)remoteFSFile);
    }

    public RemoteFSFile getBuildDirectory() {
        this.getTargets();
        Object object = this.entry.getFile().getAttribute(PROP_BUILD_DIR);
        if (object == null) {
            return this.getProjCompilerType().getBuildDirectory();
        }
        if (object != null && !(object instanceof RemoteFSFile)) {
            try {
                this.entry.getFile().setAttribute(PROP_BUILD_DIR, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getBuildDirectory();
        }
        return (RemoteFSFile)object;
    }

    public void setOutputSwitch(Boolean bl) throws IOException {
        this.entry.getFile().setAttribute(PROP_OUTPUT_SWITCH, (Object)bl);
    }

    public void setPromptForParameter(Boolean bl) throws IOException {
        this.entry.getFile().setAttribute("Prompt for Parameters", (Object)bl);
    }

    public Boolean getOutputSwitch() {
        Boolean bl = (Boolean)this.entry.getFile().getAttribute(PROP_OUTPUT_SWITCH);
        if (bl == null) {
            return this.getProjCompilerType().outputSwitch();
        }
        return bl;
    }

    public Boolean getPromptForParameter() {
        Boolean bl = (Boolean)this.entry.getFile().getAttribute(PROP_PARAMETERS_PROMPT);
        if (bl == null) {
            return Boolean.FALSE;
        }
        return bl;
    }

    private String getCurrentFileDir() {
        try {
            String string = FileUtil.toFile((FileObject)this.entry.getDataObject().getPrimaryFile().getFileSystem().getRoot()).getAbsolutePath();
            String string2 = this.entry.getDataObject().getPrimaryFile().getParent().getPackageName('/');
            Object var3_4 = null;
            return string + '/' + string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getTarget() {
        String string = (String)this.entry.getFile().getAttribute(PROP_TARGET);
        if (string != null) {
            return string;
        }
        String[] stringArray = this.getTargets();
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return "";
    }

    public void setTarget(String string) throws IOException {
        this.entry.getFile().setAttribute(PROP_TARGET, (Object)string);
    }

    public String[] getTargets() {
        InputStream inputStream = null;
        try {
            inputStream = this.entry.getDataObject().getPrimaryFile().getInputStream();
            TargetParser targetParser = new TargetParser();
            String[] stringArray = targetParser.parse(inputStream);
            inputStream.close();
            return stringArray;
        }
        catch (Exception exception) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new String[0];
        }
    }

    public String getExternalCompiler() {
        String string = (String)this.entry.getFile().getAttribute(PROP_EXTERNAL_COMPILER);
        if (string == null) {
            return this.getProjCompilerType().getExternalCompilerString();
        }
        return string;
    }

    private void setExternalCompiler(String string) throws IOException {
        this.entry.getFile().setAttribute(PROP_EXTERNAL_COMPILER, (Object)string);
    }

    protected void setDefaultFunction(PropertySupport propertySupport, String string, String string2) {
        try {
            propertySupport.setValue("method", (Object)FileObject.class.getMethod("getAttribute", String.class));
            propertySupport.setValue("param", (Object)string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        propertySupport.setValue("object", (Object)this.entry.getFile());
        propertySupport.setValue("helpID", (Object)string2);
    }

    private String getFlaggedName(String string, String string2) {
        return string;
    }

    private void flagProperty(String string, String string2) {
    }

    private PropertySupport createXDisplayDeviceNumber() {
        class XDisplayDeviceNumberPropertySupport
        extends PropertySupport.ReadWrite {
            public XDisplayDeviceNumberPropertySupport() {
                super("X Display Device Number", class$java$lang$Integer == null ? (class$java$lang$Integer = DCLBuildSupport.class$("java.lang.Integer")) : class$java$lang$Integer, "X Display Device Number", "Defines the screen associated with the display device");
            }

            public Object getValue() {
                FileSystem fileSystem = null;
                try {
                    fileSystem = DCLBuildSupport.this.entry.getFile().getFileSystem();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
                if (fileSystem instanceof AbstractNetworkFileSystem) {
                    Integer n = (Integer)DCLBuildSupport.this.entry.getFile().getAttribute("xDisplayDeviceNumber");
                    if (n != null) {
                        return n;
                    }
                    return new Integer(((AbstractNetworkFileSystem)fileSystem).getXDisplayDeviceNumber());
                }
                return new Integer(DistributedSettings.getDefault().getXDisplayDeviceNumber());
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    DCLBuildSupport.this.entry.getFile().setAttribute("xDisplayDeviceNumber", object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new XDisplayDeviceNumberPropertySupport();
    }

    private PropertySupport createBuildProperty() {
        class PropertySupportBuildDirectory
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildDirectory() {
                super(DCLBuildSupport.PROP_BUILD_DIR, class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile == null ? (class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile = DCLBuildSupport.class$("org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile")) : class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile, DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_buildDirectory"), DCLBuildSupport.PROP_BUILD_DIR), bundle.getString("HINT_buildDirectory"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.FALSE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", DCLBuildSupport.this.entry.getFile().getNameExt());
                try {
                    if (DCLBuildSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", DCLBuildSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (DCLBuildSupport.this.getProjCompilerType().getBuildDirectory() != null) {
                    this.setValue("projvalue", DCLBuildSupport.this.getProjCompilerType().getBuildDirectory());
                }
                DCLBuildSupport.this.setDefaultFunction((PropertySupport)this, DCLBuildSupport.PROP_BUILD_DIR, "com.hp.openvms.netbeans.dclsupport.settings.DCLFileExecuteSettings");
            }

            public Object getValue() {
                return DCLBuildSupport.this.getBuildDirectory();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof RemoteFSFile || object == null) {
                    try {
                        DCLBuildSupport.this.setBuildDirectory((RemoteFSFile)object);
                        DCLBuildSupport.this.flagProperty(DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_buildDirectory"), DCLBuildSupport.PROP_BUILD_DIR), DCLBuildSupport.PROP_BUILD_DIR);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    DCLBuildSupport.this.setBuildDirectory(null);
                    DCLBuildSupport.this.setBuildDirectory(DCLBuildSupport.this.getBuildDirectory());
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new PropertySupportBuildDirectory();
    }

    private PropertySupport createExternalCompilerProperty() {
        class ExternalCompilerPropertySupport
        extends PropertySupport.ReadWrite {
            public ExternalCompilerPropertySupport() {
                super(DCLBuildSupport.PROP_EXTERNAL_COMPILER, class$java$lang$String == null ? (class$java$lang$String = DCLBuildSupport.class$("java.lang.String")) : class$java$lang$String, DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_EXTERNAL_COMPILER"), DCLBuildSupport.PROP_EXTERNAL_COMPILER), bundle.getString("HINT_EXTERNAL_COMPILER"));
                DCLBuildSupport.this.setDefaultFunction((PropertySupport)this, DCLBuildSupport.PROP_EXTERNAL_COMPILER, "com.hp.openvms.netbeans.dclsupport.settings.DCLFileExecuteSettings");
            }

            public Object getValue() {
                return DCLBuildSupport.this.getExternalCompiler();
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    DCLBuildSupport.this.setExternalCompiler((String)object);
                    DCLBuildSupport.this.flagProperty(DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_EXTERNAL_COMPILER"), DCLBuildSupport.PROP_EXTERNAL_COMPILER), DCLBuildSupport.PROP_EXTERNAL_COMPILER);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    DCLBuildSupport.this.setExternalCompiler(null);
                    DCLBuildSupport.this.setExternalCompiler(DCLBuildSupport.this.getExternalCompiler());
                    DCLBuildSupport.this.flagProperty(DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_EXTERNAL_COMPILER"), DCLBuildSupport.PROP_EXTERNAL_COMPILER), DCLBuildSupport.PROP_EXTERNAL_COMPILER);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new ExternalCompilerPropertySupport();
    }

    private PropertySupport createTargetProperty() {
        class PropertySupportTarget
        extends PropertySupport.ReadWrite {
            public PropertySupportTarget() {
                super(DCLBuildSupport.PROP_TARGET, class$java$lang$String == null ? (class$java$lang$String = DCLBuildSupport.class$("java.lang.String")) : class$java$lang$String, DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_target"), DCLBuildSupport.PROP_TARGET), bundle.getString("HINT_target"));
            }

            public Object getValue() {
                return DCLBuildSupport.this.getTarget();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof String || object == null) {
                    try {
                        DCLBuildSupport.this.setTarget((String)object);
                        DCLBuildSupport.this.flagProperty(DCLBuildSupport.this.getFlaggedName(bundle.getString("PROP_target"), DCLBuildSupport.PROP_TARGET), DCLBuildSupport.PROP_TARGET);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public PropertyEditor getPropertyEditor() {
                return new TagEditor();
            }
        }
        return new PropertySupportTarget();
    }

    private PropertySupport createOutputSwitchProperty() {
        class OutputSwitchPropertySupport
        extends PropertySupport.ReadWrite {
            public OutputSwitchPropertySupport() {
                super(DCLBuildSupport.PROP_OUTPUT_SWITCH, class$java$lang$Object == null ? (class$java$lang$Object = DCLBuildSupport.class$("java.lang.Object")) : class$java$lang$Object, DCLBuildSupport.this.getFlaggedNameOutputSwitch(bundle.getString("PROP_OUTPUT_SWITCH"), DCLBuildSupport.PROP_OUTPUT_SWITCH), bundle.getString("HINT_OUTPUT_SWITCH"));
                DCLBuildSupport.this.setDefaultFunction((PropertySupport)this, DCLBuildSupport.PROP_OUTPUT_SWITCH, "com.hp.openvms.netbeans.hpsupport.settings.DCLFileExecuteSettings");
                if (DCLBuildSupport.this.getProjCompilerType().outputSwitch() != null) {
                    this.setValue("projValue", DCLBuildSupport.this.getProjCompilerType().outputSwitch());
                }
            }

            public Object getValue() {
                FileSystem fileSystem = null;
                try {
                    fileSystem = DCLBuildSupport.this.entry.getFile().getFileSystem();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
                if (fileSystem instanceof AbstractNetworkFileSystem) {
                    Boolean bl = (Boolean)DCLBuildSupport.this.entry.getFile().getAttribute("useXtermExecution");
                    if (bl != null) {
                        return bl;
                    }
                    return new Boolean(((AbstractNetworkFileSystem)fileSystem).getUseXtermExecution());
                }
                return DCLBuildSupport.this.getOutputSwitch();
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    FileSystem fileSystem = null;
                    try {
                        fileSystem = DCLBuildSupport.this.entry.getFile().getFileSystem();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                    if (fileSystem instanceof AbstractNetworkFileSystem) {
                        DCLBuildSupport.this.entry.getFile().setAttribute("useXtermExecution", object);
                    } else {
                        DCLBuildSupport.this.setOutputSwitch((Boolean)object);
                    }
                    DCLBuildSupport.this.flagProperty(DCLBuildSupport.this.getFlaggedNameOutputSwitch(bundle.getString("PROP_OUTPUT_SWITCH"), DCLBuildSupport.PROP_OUTPUT_SWITCH), DCLBuildSupport.PROP_OUTPUT_SWITCH);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new OutputSwitchPropertySupport();
    }

    private PropertySupport createPromptForParameter() {
        class PromptForParameterSupport
        extends PropertySupport.ReadWrite {
            public PromptForParameterSupport() {
                super(DCLBuildSupport.this.sRemoteProperty, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DCLBuildSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean, DCLBuildSupport.this.sRemoteProperty, DCLBuildSupport.this.sRemoteProperty);
            }

            public Object getValue() {
                FileSystem fileSystem = null;
                try {
                    fileSystem = DCLBuildSupport.this.entry.getFile().getFileSystem();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
                if (fileSystem instanceof AbstractNetworkFileSystem) {
                    Boolean bl = (Boolean)DCLBuildSupport.this.entry.getFile().getAttribute("Prompt for Parameters");
                    if (bl != null) {
                        return bl;
                    }
                    return Boolean.FALSE;
                }
                return Boolean.FALSE;
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    FileSystem fileSystem = null;
                    try {
                        fileSystem = DCLBuildSupport.this.entry.getFile().getFileSystem();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                    if (fileSystem instanceof AbstractNetworkFileSystem) {
                        DCLBuildSupport.this.entry.getFile().setAttribute("Prompt for Parameters", object);
                    } else {
                        DCLBuildSupport.this.setPromptForParameter((Boolean)object);
                    }
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new PromptForParameterSupport();
    }

    public static class RemoteCompile
    extends DCLBuildSupport
    implements CompilerCookie.Compile {
        public RemoteCompile(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = DCLBuildSupport.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        }
    }

    public static class Compile
    extends DCLBuildSupport
    implements CompilerCookie.Compile {
        public Compile(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = DCLBuildSupport.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        }
    }

    private class TagEditor
    extends PropertyEditorSupport {
        private TagEditor() {
        }

        public String getAsText() {
            return (String)this.getValue();
        }

        public void setAsText(String string) throws IllegalArgumentException {
            this.setValue(string);
        }

        public String[] getTags() {
            return DCLBuildSupport.this.getTargets();
        }
    }

    class TargetParser {
        TargetParser() {
        }

        public String[] parse(InputStream inputStream) throws IOException {
            Vector<String> vector = new Vector<String>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                Pattern pattern;
                Matcher matcher;
                StringBuffer stringBuffer2 = new StringBuffer(string);
                for (int i = stringBuffer2.length() - 1; i >= 0 && (stringBuffer2.charAt(i) == ' ' || stringBuffer2.charAt(i) == '\t'); --i) {
                    stringBuffer2.deleteCharAt(i);
                }
                if (stringBuffer2.length() > 0 && (stringBuffer2.charAt(stringBuffer2.length() - 1) == '-' || stringBuffer2.charAt(stringBuffer2.length() - 1) == '\\')) {
                    stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
                    stringBuffer.append(stringBuffer2);
                    continue;
                }
                stringBuffer.append(stringBuffer2);
                String string2 = stringBuffer.toString().trim().toLowerCase();
                if (!string2.startsWith("#") && !string2.startsWith("!") && (matcher = (pattern = Pattern.compile("(.+)\\s(depends_on|:)\\s(.*)")).matcher(string2)).matches()) {
                    vector.add(matcher.group(1));
                }
                if (stringBuffer.length() <= 0) continue;
                stringBuffer.delete(0, stringBuffer.length());
            }
            return vector.toArray(new String[0]);
        }
    }
}

