/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.prop;

import com.hp.openvms.netbeans.cppsupport.prop.PropertyDialogManager;
import com.hp.openvms.netbeans.cppsupport.prop.PropertySheet;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openide.awt.ToolbarButton;
import org.openide.awt.ToolbarToggleButton;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class PropertySheetToolbar
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private PropertySheet mySheet;
    private ToolbarToggleButton bNoSort;
    private ToolbarToggleButton bAlphaSort;
    private ToolbarToggleButton bTypeSort;
    private ToolbarToggleButton bDisplayWritableOnly;
    private ToolbarButton customizer;
    private ToolbarButton help;
    private boolean ignorePropertyChange = false;

    public PropertySheetToolbar(PropertySheet propertySheet) {
        this.mySheet = propertySheet;
        this.mySheet.addPropertyChangeListener(this);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.bNoSort = new ToolbarToggleButton((Icon)new ImageIcon(Utilities.loadImage((String)"org/openide/resources/propertysheet/unsorted.gif")));
        this.add((Component)this.bNoSort);
        this.bNoSort.getAccessibleContext().setAccessibleName(PropertySheetToolbar.getString("ACS_CTL_NoSort"));
        this.bNoSort.setToolTipText(PropertySheetToolbar.getString("CTL_NoSort"));
        this.bNoSort.setSelected(true);
        this.bNoSort.addActionListener((ActionListener)this);
        this.bAlphaSort = new ToolbarToggleButton((Icon)new ImageIcon(Utilities.loadImage((String)"org/openide/resources/propertysheet/sortedByNames.gif")));
        this.add((Component)this.bAlphaSort);
        this.bAlphaSort.getAccessibleContext().setAccessibleName(PropertySheetToolbar.getString("ACS_CTL_AlphaSort"));
        this.bAlphaSort.setToolTipText(PropertySheetToolbar.getString("CTL_AlphaSort"));
        this.bAlphaSort.addActionListener((ActionListener)this);
        this.bTypeSort = new ToolbarToggleButton((Icon)new ImageIcon(Utilities.loadImage((String)"org/openide/resources/propertysheet/sortedByTypes.gif")));
        this.add((Component)this.bTypeSort);
        this.bTypeSort.getAccessibleContext().setAccessibleName(PropertySheetToolbar.getString("ACS_CTL_TypeSort"));
        this.bTypeSort.setToolTipText(PropertySheetToolbar.getString("CTL_TypeSort"));
        this.bTypeSort.addActionListener((ActionListener)this);
        this.setSortingMode(this.mySheet.getSortingMode());
        JToolBar.Separator separator = new JToolBar.Separator();
        this.add(separator);
        separator.updateUI();
        this.bDisplayWritableOnly = new ToolbarToggleButton((Icon)new ImageIcon(Utilities.loadImage((String)"org/openide/resources/propertysheet/showWritableOnly.gif")), this.mySheet.getDisplayWritableOnly());
        this.bDisplayWritableOnly.getAccessibleContext().setAccessibleName(PropertySheetToolbar.getString("ACS_CTL_VisibleWritableOnly"));
        this.bDisplayWritableOnly.setToolTipText(PropertySheetToolbar.getString("CTL_VisibleWritableOnly"));
        this.bDisplayWritableOnly.addActionListener((ActionListener)this);
        this.add((Component)this.bDisplayWritableOnly);
        separator = new JToolBar.Separator();
        this.add(separator);
        separator.updateUI();
        this.customizer = new ToolbarButton((Icon)new ImageIcon(Utilities.loadImage((String)"org/openide/resources/propertysheet/customize.gif")));
        this.add((Component)this.customizer);
        this.customizer.getAccessibleContext().setAccessibleName(PropertySheetToolbar.getString("ACS_CTL_Customize"));
        this.customizer.setToolTipText(PropertySheetToolbar.getString("CTL_Customize"));
        this.customizer.setEnabled(false);
        this.customizer.addActionListener((ActionListener)this);
        separator = new JToolBar.Separator();
        this.add(separator);
        separator.updateUI();
        this.help = new ToolbarButton((Icon)new ImageIcon(Utilities.loadImage((String)"org/openide/resources/propertysheet/propertySheetHelp.gif")));
        this.add((Component)this.help);
        this.help.getAccessibleContext().setAccessibleName(PropertySheetToolbar.getString("ACS_CTL_Help"));
        this.help.setToolTipText(PropertySheetToolbar.getString("CTL_Help"));
        this.help.setEnabled(false);
        this.help.addActionListener((ActionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bNoSort) {
            this.setSortingMode(0);
        } else if (object == this.bAlphaSort) {
            this.setSortingMode(1);
        } else if (object == this.bTypeSort) {
            this.setSortingMode(2);
        } else if (object == this.customizer) {
            this.mySheet.invokeCustomization();
        } else if (object == this.help) {
            this.mySheet.invokeHelp();
        } else if (object == this.bDisplayWritableOnly) {
            this.ignorePropertyChange = true;
            try {
                this.mySheet.setDisplayWritableOnly(this.bDisplayWritableOnly.isSelected());
            }
            finally {
                this.ignorePropertyChange = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSortingMode(int n) {
        this.ignorePropertyChange = true;
        try {
            this.mySheet.setSortingMode(n);
            this.ignorePropertyChange = false;
            this.bNoSort.setSelected(n == 0);
        }
        catch (PropertyVetoException propertyVetoException) {
            try {
                PropertyDialogManager.notify(propertyVetoException);
                this.ignorePropertyChange = false;
                this.bNoSort.setSelected(n == 0);
            }
            catch (Throwable throwable) {
                this.ignorePropertyChange = false;
                this.bNoSort.setSelected(n == 0);
                this.bAlphaSort.setSelected(n == 1);
                this.bTypeSort.setSelected(n == 2);
                throw throwable;
            }
            this.bAlphaSort.setSelected(n == 1);
            this.bTypeSort.setSelected(n == 2);
        }
        this.bAlphaSort.setSelected(n == 1);
        this.bTypeSort.setSelected(n == 2);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.ignorePropertyChange) {
            return;
        }
        if (propertyChangeEvent.getPropertyName() == null) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("sortingMode")) {
            this.setSortingMode((Integer)propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("displayWritableOnly")) {
            this.bDisplayWritableOnly.setSelected(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("hasCustomizer")) {
            this.customizer.setEnabled(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("pageHelpID")) {
            this.help.setEnabled(this.mySheet.getPageHelpID() != null);
        }
    }

    private static void toBufferedImage(ImageIcon imageIcon) {
        BufferedImage bufferedImage = PropertySheetToolbar.createImage();
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.drawImage(imageIcon.getImage(), 0, 0, null);
        graphics.dispose();
        imageIcon.setImage(bufferedImage);
    }

    private static BufferedImage createImage() {
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(16, 16), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage;
    }

    private static String getString(String string) {
        return NbBundle.getBundle((Class)PropertySheetToolbar.class).getString(string);
    }
}

