/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.beans.editors;

import com.hp.openvms.netbeans.beans.editors.AlphaVMSListQualifier;
import com.hp.openvms.netbeans.beans.editors.AlphaVMSListQualifierEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.distributed.common.propertyeditors.FileEditor2;
import org.netbeans.modules.distributed.common.propertyeditors.StringCustomEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class AlphaVMSListQualifierCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    private static File lastDirFolder = null;
    private static File lastJarFolder = null;
    private AlphaVMSListQualifierEditor editor;
    private DefaultListModel listModel = new DefaultListModel();
    private boolean isCancel = true;
    private JButton addDirButton;
    private JCheckBox defaultButton;
    private JButton downButton;
    private JPanel innerPanel;
    private JLabel pathLabel;
    private JList pathList;
    private JScrollPane pathScrollPane;
    private JButton removeButton;
    private JButton upButton;

    public AlphaVMSListQualifierCustomEditor() {
        this.initComponents();
        this.pathList.setModel(this.listModel);
        this.pathScrollPane.setViewportView(this.pathList);
        this.pathLabel.setDisplayedMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_Classpath.Border_Mnemonic").charAt(0));
        this.addDirButton.setMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_AddDirectory_Mnemonic").charAt(0));
        this.upButton.setMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_MoveUp_Mnemonic").charAt(0));
        this.downButton.setMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_MoveDown_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_Remove_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_Default_Mnemonic").charAt(0));
        this.defaultButton.setMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_Default").charAt(0));
        this.pathList.getAccessibleContext().setAccessibleDescription(AlphaVMSListQualifierCustomEditor.getString("ACSD_PathList"));
        this.addDirButton.getAccessibleContext().setAccessibleDescription(AlphaVMSListQualifierCustomEditor.getString("ACSD_AddDirectory"));
        this.upButton.getAccessibleContext().setAccessibleDescription(AlphaVMSListQualifierCustomEditor.getString("ACSD_MoveUp"));
        this.downButton.getAccessibleContext().setAccessibleDescription(AlphaVMSListQualifierCustomEditor.getString("ACSD_MoveDown"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(AlphaVMSListQualifierCustomEditor.getString("ACSD_Remove"));
        this.getAccessibleContext().setAccessibleDescription(AlphaVMSListQualifierCustomEditor.getString("ACSD_AlphaVMSListQualifierCustomEditor"));
    }

    AlphaVMSListQualifierCustomEditor(AlphaVMSListQualifierEditor alphaVMSListQualifierEditor) {
        this();
        this.editor = alphaVMSListQualifierEditor;
        Object object = alphaVMSListQualifierEditor.getValue();
        if (object instanceof AlphaVMSListQualifier) {
            this.setAlphaVMSListQualifier(((AlphaVMSListQualifier)object).getPlainList());
        }
        if (this.editor.getContext() == null) {
            if (this.editor.getInherit() == null) {
                this.defaultButton.setSelected(true);
                this.disableButtons();
            } else {
                this.defaultButton.setSelected(false);
                this.addDirButton.setEnabled(true);
                this.enableButtons();
            }
        } else {
            this.defaultButton.setVisible(false);
        }
        HelpCtx.setHelpIDString((JComponent)this, (String)this.editor.getHelpID());
    }

    private void disableButtons() {
        this.removeButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.addDirButton.setEnabled(false);
    }

    private void initComponents() {
        this.innerPanel = new JPanel();
        this.addDirButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.removeButton = new JButton();
        this.pathScrollPane = new JScrollPane();
        this.pathList = new JList();
        this.pathLabel = new JLabel();
        this.defaultButton = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.innerPanel.setLayout(new GridBagLayout());
        this.innerPanel.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.addDirButton.setText(NbBundle.getBundle((Class)AlphaVMSListQualifierCustomEditor.class).getString("CTL_AddDirectory"));
        this.addDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaVMSListQualifierCustomEditor.this.addDirButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.addDirButton, gridBagConstraints);
        this.upButton.setText(NbBundle.getBundle((Class)AlphaVMSListQualifierCustomEditor.class).getString("CTL_MoveUp"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaVMSListQualifierCustomEditor.this.upButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setText(NbBundle.getBundle((Class)AlphaVMSListQualifierCustomEditor.class).getString("CTL_MoveDown"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaVMSListQualifierCustomEditor.this.downButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.innerPanel.add((Component)this.downButton, gridBagConstraints);
        this.removeButton.setText(NbBundle.getBundle((Class)AlphaVMSListQualifierCustomEditor.class).getString("CTL_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaVMSListQualifierCustomEditor.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.innerPanel.add((Component)this.removeButton, gridBagConstraints);
        this.pathList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AlphaVMSListQualifierCustomEditor.this.pathListValueChanged(listSelectionEvent);
            }
        });
        this.pathList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AlphaVMSListQualifierCustomEditor.this.pathListMouseClicked(mouseEvent);
            }
        });
        this.pathScrollPane.setViewportView(this.pathList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.innerPanel.add((Component)this.pathScrollPane, gridBagConstraints);
        this.pathLabel.setLabelFor(this.pathList);
        this.pathLabel.setText(NbBundle.getBundle((Class)AlphaVMSListQualifierCustomEditor.class).getString("CTL_Classpath.Border_Title"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.innerPanel.add((Component)this.pathLabel, gridBagConstraints);
        this.defaultButton.setToolTipText("");
        this.defaultButton.setText(ResourceBundle.getBundle("com/hp/openvms/netbeans/beans/editors/Bundle").getString("CTL_Default"));
        this.defaultButton.setPreferredSize(new Dimension(180, 25));
        this.defaultButton.setMaximumSize(new Dimension(180, 25));
        this.defaultButton.setFocusPainted(false);
        this.defaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaVMSListQualifierCustomEditor.this.defaultButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        this.innerPanel.add((Component)this.defaultButton, gridBagConstraints);
        this.add((Component)this.innerPanel, "Center");
    }

    private void defaultButtonActionPerformed(ActionEvent actionEvent) {
        try {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (jCheckBox.isSelected()) {
                this.editor.setValue(null);
                this.listModel.removeAllElements();
                AlphaVMSListQualifier alphaVMSListQualifier = (AlphaVMSListQualifier)this.editor.getValue();
                this.setAlphaVMSListQualifier(alphaVMSListQualifier.getPlainList());
                this.disableButtons();
            } else {
                this.enableButtons();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void pathListMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        this.triggerEdit(this.pathList.getSelectedIndex());
    }

    private void pathListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n;
        int n2 = this.pathList.getSelectedIndex();
        Object[] objectArray = this.pathList.getSelectedValues();
        for (n = 0; n < objectArray.length; ++n) {
            this.listModel.removeElement(objectArray[n]);
            this.fireValueChanged();
        }
        n = this.listModel.getSize();
        if (n2 >= 0 && n > 0) {
            if (n == n2) {
                this.pathList.setSelectedIndex(n2 - 1);
            } else if (n > n2) {
                this.pathList.setSelectedIndex(n2);
            } else {
                this.pathList.setSelectedIndex(0);
            }
        }
        this.enableButtons();
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.pathList.getSelectedIndex();
        this.swap(n);
        this.pathList.setSelectedIndex(n + 1);
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.pathList.getSelectedIndex();
        this.swap(n - 1);
        this.pathList.setSelectedIndex(n - 1);
    }

    private void addDirButtonActionPerformed(ActionEvent actionEvent) {
        StringCustomEditor stringCustomEditor = new StringCustomEditor("", true);
        this.isCancel = false;
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)stringCustomEditor, "Include Directory", true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(DialogDescriptor.CANCEL_OPTION)) {
                    AlphaVMSListQualifierCustomEditor.this.isCancel = true;
                }
                if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION)) {
                    AlphaVMSListQualifierCustomEditor.this.isCancel = false;
                }
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        if (stringCustomEditor.getPropertyValue().length() > 0 && !this.isCancel) {
            this.listModel.addElement(stringCustomEditor.getPropertyValue());
            this.fireValueChanged();
        }
    }

    private void fireValueChanged() {
        if (this.editor != null) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    private void triggerEdit(int n) {
        if (n < 0) {
            return;
        }
        String string = (String)this.listModel.elementAt(n);
        File file = new File(string);
        if (file.isDirectory()) {
            File file2;
            JFileChooser jFileChooser = FileEditor2.createHackedFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle(AlphaVMSListQualifierCustomEditor.getString("CTL_Edit_Local_Dialog_Title"));
            if (file.getParentFile() != null) {
                jFileChooser.setCurrentDirectory(file.getParentFile());
                jFileChooser.setSelectedFile(file);
            }
            if (jFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), AlphaVMSListQualifierCustomEditor.getString("CTL_Approve_Button_Title")) == 0 && (file2 = jFileChooser.getSelectedFile()) != null && file2.isDirectory()) {
                lastDirFolder = jFileChooser.getCurrentDirectory();
                try {
                    file2 = file2.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.listModel.set(n, file2.getAbsolutePath());
                this.fireValueChanged();
            }
        } else if (file.isFile()) {
            File file3;
            JFileChooser jFileChooser = FileEditor2.createHackedFileChooser();
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
                }

                public String getDescription() {
                    return AlphaVMSListQualifierCustomEditor.getString("CTL_JarArchivesMask");
                }
            });
            jFileChooser.setCurrentDirectory(file.getParentFile());
            jFileChooser.setSelectedFile(file);
            jFileChooser.setDialogTitle(AlphaVMSListQualifierCustomEditor.getString("CTL_Edit_Jar_Dialog_Title"));
            if (jFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), AlphaVMSListQualifierCustomEditor.getString("CTL_Approve_Button_Title")) == 0 && (file3 = jFileChooser.getSelectedFile()) != null && file3.isFile()) {
                lastJarFolder = jFileChooser.getCurrentDirectory();
                this.listModel.set(n, file3.getAbsolutePath());
                this.fireValueChanged();
            }
        }
    }

    private void swap(int n) {
        if (n < 0 || n >= this.listModel.size() - 1) {
            return;
        }
        Object e = this.listModel.elementAt(n);
        this.listModel.removeElement(e);
        this.listModel.add(n + 1, e);
        this.fireValueChanged();
    }

    private void enableButtons() {
        this.addDirButton.setEnabled(true);
        this.removeButton.setEnabled(this.pathList.getSelectedIndices().length > 0);
        if (this.pathList.getSelectedIndices().length == 1) {
            this.downButton.setEnabled(this.pathList.getSelectedIndices()[0] < this.pathList.getModel().getSize() - 1);
            this.upButton.setEnabled(this.pathList.getSelectedIndices()[0] > 0);
        } else {
            this.downButton.setEnabled(false);
            this.upButton.setEnabled(false);
        }
    }

    private void setAlphaVMSListQualifier(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("(")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith(")")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            this.listModel.addElement(string2.trim());
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (this.defaultButton.isSelected()) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        String[] stringArray = this.listModel.elements();
        while (stringArray.hasMoreElements()) {
            arrayList.add(stringArray.nextElement());
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        return new AlphaVMSListQualifier(stringArray);
    }

    private static final String getString(String string) {
        return NbBundle.getBundle((Class)AlphaVMSListQualifierCustomEditor.class).getString(string);
    }
}

