/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPClient;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPFileName;

public class FTPFile
extends File {
    private boolean canRead;
    private boolean canWrite;
    private boolean isDir;
    private boolean isHidden;
    private boolean isExist;
    private String absName;
    private String name;
    private String parent;
    private long lastModified;
    private long size;
    private FTPClient ftpClient;

    public FTPFile(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, String string2, String string3, long l, long l2, FTPClient fTPClient) {
        super(string);
        this.ftpClient = fTPClient;
        this.canWrite = bl2;
        this.canRead = bl;
        this.isDir = bl3;
        this.isHidden = bl4;
        this.absName = string;
        this.name = string2;
        this.lastModified = l;
        this.size = l2;
        this.parent = string3;
        this.isExist = true;
    }

    public FTPFile(String string, String string2, FTPClient fTPClient) {
        super(string, string2);
        this.ftpClient = fTPClient;
        this.parent = string;
        this.name = string2;
        RemoteFileAttributes remoteFileAttributes = null;
        string = FileUtility.openVMSPathToUnixPath((String)string, (boolean)true);
        string2 = FileUtility.openVMSPathToUnixPath((String)string2, (boolean)true);
        try {
            if (string2.indexOf(string) == 0 && string2.length() > string.length() && (string2 = string2.substring(string.length(), string2.length())).startsWith("/")) {
                string2 = string2.substring(1, string2.length());
            }
            FTPFileName fTPFileName = new FTPFileName(string, "", true);
            FTPFileName fTPFileName2 = new FTPFileName(string, string2);
            remoteFileAttributes = fTPClient.listFile(fTPFileName.getFullName(), fTPFileName2);
        }
        catch (IOException iOException) {
            return;
        }
        if (remoteFileAttributes != null && remoteFileAttributes.getName() != null) {
            this.canWrite = true;
            this.canRead = true;
            this.isDir = remoteFileAttributes.isDirectory();
            this.isHidden = false;
            this.absName = remoteFileAttributes.getName().getFullName();
            this.lastModified = remoteFileAttributes.getDate().getTime();
            this.size = remoteFileAttributes.getSize();
            this.isExist = true;
        } else {
            this.absName = string + "/" + string2;
            this.isDir = true;
        }
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public int compareTo(File file) {
        return this.absName.compareTo(file.getAbsolutePath());
    }

    public int compareTo(Object object) {
        return this.absName.compareTo(object.toString());
    }

    public boolean createNewFile() {
        return false;
    }

    public static File createTempFile(String string, String string2) {
        return null;
    }

    public static File createTempFile(String string, String string2, File file) {
        return null;
    }

    public boolean delete() {
        FTPFileName fTPFileName = new FTPFileName(this.parent, this.name, this.isDirectory());
        try {
            this.ftpClient.delete(fTPFileName);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void deleteOnExit() {
    }

    public boolean equals(Object object) {
        if (this.toString() == null || object == null || object.toString() == null) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public boolean exists() {
        return this.isExist;
    }

    public File getAbsoluteFile() {
        return this;
    }

    public String getAbsolutePath() {
        if (this.absName == null) {
            return this.parent;
        }
        return this.absName;
    }

    public File getCanonicalFile() {
        return this.getAbsoluteFile();
    }

    public String getCanonicalPath() {
        return this.getAbsolutePath();
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public File getParentFile() {
        if (this.parent.equalsIgnoreCase(this.ftpClient.getRoot().getFullName())) {
            return new FTPFile(true, true, true, false, this.parent, this.parent, "", 0L, 0L, this.ftpClient);
        }
        if (this.parent != null && this.parent.length() > 0) {
            String string = this.parent.substring(this.parent.lastIndexOf(47) + 1, this.parent.length());
            String string2 = this.parent.substring(0, this.parent.lastIndexOf(47));
            if (string2.equals("")) {
                return new FTPFile(true, true, true, false, this.parent, this.parent, "", 0L, 0L, this.ftpClient);
            }
            return new FTPFile(string2, string, this.ftpClient);
        }
        return null;
    }

    public String getPath() {
        return FileUtility.unixPathToOpenVMSPath((String)this.getAbsolutePath(), (boolean)this.isDirectory());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isAbsolute() {
        return false;
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public long length() {
        return this.size;
    }

    public String[] list() {
        RemoteFileAttributes[] remoteFileAttributesArray = null;
        try {
            remoteFileAttributesArray = this.ftpClient.list(new FTPFileName(this.parent, this.name, this.isDirectory()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] stringArray = new String[remoteFileAttributesArray == null ? 0 : remoteFileAttributesArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = remoteFileAttributesArray[i].getName().getFullName();
        }
        return stringArray;
    }

    public String[] list(FilenameFilter filenameFilter) {
        return null;
    }

    public File[] listFiles() {
        RemoteFileAttributes[] remoteFileAttributesArray = null;
        try {
            remoteFileAttributesArray = this.ftpClient.list(new FTPFileName(this.parent, this.name, this.isDirectory()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File[] fileArray = new FTPFile[remoteFileAttributesArray == null ? 0 : remoteFileAttributesArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new FTPFile(true, true, remoteFileAttributesArray[i].isDirectory(), false, remoteFileAttributesArray[i].getName().getFullName(), remoteFileAttributesArray[i].getName().getName(), this.absName, remoteFileAttributesArray[i].getDate().getTime(), remoteFileAttributesArray[i].getSize(), this.ftpClient);
        }
        return fileArray;
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        return null;
    }

    public static File[] listRoots() {
        return null;
    }

    public boolean mkdir() {
        try {
            this.ftpClient.mkdir(new FTPFileName(this.parent, this.name, this.isDirectory()));
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean mkdirs() {
        try {
            this.ftpClient.mkdir(new FTPFileName(this.parent, this.name, this.isDirectory()));
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean renameTo(File file) {
        try {
            if (this.isDirectory()) {
                this.ftpClient.rmdir(new FTPFileName(this.parent, this.name, this.isDirectory()));
                this.ftpClient.mkdir(new FTPFileName(this.parent, file.getName(), this.isDirectory()));
            } else {
                this.ftpClient.rename(new FTPFileName(this.parent, this.name, this.isDirectory()), file.getName());
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean setLastModified(long l) {
        return false;
    }

    public boolean setReadOnly() {
        return false;
    }

    public String toString() {
        return this.absName;
    }

    public URI toURI() {
        return null;
    }

    public URL toURL() {
        return null;
    }

    public FTPClient getFTPClient() {
        return this.ftpClient;
    }
}

