/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.ftpfs.DisconnectCallBack;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPDialogs;
import org.netbeans.modules.distributed.remotefs.ftpfs.LogInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteClient;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileName;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPException;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPFileAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPFileName;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPLogInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPResponse;

public class FTPClient
implements RemoteClient {
    private static final FTPFileAttributes[] EMPTY_LIST = new FTPFileAttributes[0];
    private BufferedReader in;
    private BufferedOutputStream out;
    private PrintWriter log = null;
    private File logfile = null;
    private RandomAccessFile rafile = null;
    private Socket socket;
    private ServerSocket serversocket;
    private FTPResponse response;
    private String host;
    private int port;
    private String user;
    private char[] password;
    private String serversystem = null;
    private boolean connected = false;
    private boolean passiveMode = false;
    private boolean sshForward = false;
    private String rwd;
    private DisconnectCallBack dc;
    public static final int DEFAULT_PORT = 21;
    private static final int BUFFER = 1024;
    private int TIMEOUT = 300000;
    private static FTPFileName remoteRootName;
    private static final String VMS_DIR = "dir;";
    private Object lock;
    private boolean isMultiNet;
    private static List failedAttempts;

    public FTPClient(FTPLogInfo fTPLogInfo, String string, DisconnectCallBack disconnectCallBack) {
        this.host = fTPLogInfo.getHost();
        this.port = fTPLogInfo.getPort();
        this.user = fTPLogInfo.getUser();
        this.password = fTPLogInfo.getPassword();
        this.rwd = string;
        this.dc = disconnectCallBack;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToFailedAttempts(String string, String string2) {
        List list = failedAttempts;
        synchronized (list) {
            failedAttempts.add(string.toLowerCase() + string2.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromFailedAttempts(String string, String string2) {
        List list = failedAttempts;
        synchronized (list) {
            failedAttempts.remove(string.toLowerCase() + string2.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsInFailedAttempts(String string, String string2) {
        List list = failedAttempts;
        synchronized (list) {
            return failedAttempts.contains(string.toLowerCase() + string2.toLowerCase());
        }
    }

    public void setSocketTimeout(int n) {
        this.TIMEOUT = n;
    }

    public int compare(LogInfo logInfo) {
        return -1;
    }

    private void writeLog(StringBuffer stringBuffer) {
        if (this.log != null) {
            this.log.println(new Date().toString() + " " + stringBuffer.toString());
            this.log.flush();
        }
    }

    private void writeLog(String string) {
        if (this.log != null) {
            this.log.println(new Date().toString() + " " + string);
            this.log.flush();
        }
    }

    public void setLog(PrintWriter printWriter) {
        this.log = printWriter;
    }

    public void setLog(OutputStream outputStream) {
        this.log = new PrintWriter(new OutputStreamWriter(outputStream));
        this.log.println("\n---------------------------------------------------------------------------\nFTP Log Session: " + new Date().toString() + "\n---------------------------------------------------------------------------");
    }

    public void setLog(File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        this.logfile = file;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public void setPassiveMode(boolean bl) {
        this.passiveMode = bl;
    }

    public boolean isSSHForward() {
        return this.sshForward;
    }

    public void setSSHForward(boolean bl) {
        this.sshForward = bl;
    }

    protected FTPResponse getResponse() {
        return this.response;
    }

    protected void setResponse() throws IOException {
        this.response = new FTPResponse(this.in);
        this.response.writeLog(this.log);
    }

    protected void setResponse(BufferedReader bufferedReader) throws IOException {
        this.response = new FTPResponse(bufferedReader);
        this.response.writeLog(this.log);
    }

    protected boolean isUnixType() {
        if (this.serversystem != null) {
            return this.serversystem.toUpperCase().startsWith("UNIX TYPE: L8");
        }
        return false;
    }

    protected boolean isVMSType() {
        if (this.serversystem != null) {
            return this.serversystem.toUpperCase().startsWith("VMS");
        }
        return false;
    }

    protected boolean isMultiNet() {
        return this.isMultiNet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFileName getRoot() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isVMSType() && this.isConnected()) {
                try {
                    this.pwd();
                    FTPResponse fTPResponse = this.getResponse();
                    if (fTPResponse.isPositiveCompletion()) {
                        String string = fTPResponse.getResponse();
                        string = string.substring(string.indexOf(34) + 1, string.lastIndexOf(34));
                        String string2 = FileUtility.openVMSPathToUnixPath((String)string, (boolean)true);
                        remoteRootName = new FTPFileName("", string2, true);
                        return remoteRootName;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return FTPFileName.getRoot();
        }
    }

    private void keepConnectionAlive() {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block7: {
                    try {
                        while (true) {
                            Object object = FTPClient.this.lock;
                            synchronized (object) {
                                if (!FTPClient.this.connected) {
                                    break block7;
                                }
                                FTPClient.this.processSimpleCommand("NOOP", false);
                            }
                            Thread.currentThread();
                            Thread.sleep(60000L);
                        }
                    }
                    catch (Exception exception) {}
                    {
                    }
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (FTPClient.containsInFailedAttempts(this.host, this.user)) {
                return;
            }
            if (this.log == null && this.logfile != null) {
                this.rafile = new RandomAccessFile(this.logfile, "rw");
                this.rafile.seek(this.rafile.length());
                this.setLog(new FileOutputStream(this.rafile.getFD()));
            }
            try {
                this.socket = new Socket(this.isSSHForward() ? "localhost" : this.host, this.port);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
            this.socket.setSoTimeout(this.TIMEOUT);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.setResponse();
            while (this.getResponse().isPositivePreliminary()) {
                this.setResponse();
            }
            if (!this.getResponse().isPositiveCompletion()) {
                throw new FTPException(this.getResponse());
            }
            try {
                this.login();
                this.password = null;
            }
            catch (FTPException fTPException) {
                if (fTPException.getResponse().getCode() == 530) {
                    FTPClient.addToFailedAttempts(this.host, this.user);
                }
                throw fTPException;
            }
            this.binary();
            this.cwd(this.rwd);
            this.keepConnectionAlive();
        }
    }

    private void reconnect() throws IOException {
        this.close();
        this.connect();
    }

    private StringBuffer toLowerCase(StringBuffer stringBuffer) {
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c < 'A' || c > 'Z') continue;
            stringBuffer.setCharAt(i, Character.toLowerCase(c));
        }
        return stringBuffer;
    }

    protected void sendCommand(StringBuffer stringBuffer) throws IOException {
        for (int i = 0; i < stringBuffer.length(); ++i) {
            this.out.write(stringBuffer.charAt(i));
        }
        this.out.write(10);
        this.out.flush();
        this.toLowerCase(stringBuffer);
        if (stringBuffer.substring(0, 4).startsWith("pass")) {
            this.writeLog("PASS *****");
        } else {
            this.writeLog(stringBuffer);
        }
        this.setResponse();
    }

    protected void processSimpleCommand(StringBuffer stringBuffer, boolean bl) throws IOException {
        this.processSimpleCommand(stringBuffer, 2, bl);
    }

    protected void processSimpleCommand(String string, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string);
        this.processSimpleCommand(stringBuffer, 2, bl);
    }

    protected void processSimpleCommand(String string, int n, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string);
        this.processSimpleCommand(stringBuffer, n, bl);
    }

    protected boolean startsWith(StringBuffer stringBuffer, String string) {
        return stringBuffer.substring(0, string.length() - 1).equals(string);
    }

    protected void processSimpleCommand(StringBuffer stringBuffer, int n, boolean bl) throws IOException {
        try {
            this.sendCommand(stringBuffer);
            if (this.getResponse().getFirstDigit() != n) {
                throw new FTPException(this.getResponse());
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            if (bl) {
                try {
                    this.reconnect();
                    this.processSimpleCommand(stringBuffer, n, false);
                }
                catch (IOException iOException) {
                    this.close();
                    FTPDialogs.ftpConnectionError(socketTimeoutException.getMessage(), this.host);
                    if (this.dc != null) {
                        this.dc.disconnected();
                    }
                    throw new IOException(socketTimeoutException.getMessage());
                }
            }
            throw new IOException(socketTimeoutException.getMessage());
        }
        catch (IOException iOException) {
            if (bl && this.connLostException(iOException)) {
                try {
                    this.reconnect();
                    this.processSimpleCommand(stringBuffer, n, false);
                }
                catch (IOException iOException2) {
                    this.close();
                    FTPDialogs.ftpConnectionError(iOException.getMessage(), this.host);
                    if (this.dc != null) {
                        this.dc.disconnected();
                    }
                    throw iOException;
                }
            }
            if (this.DirNotFoundException(iOException)) {
                if (this.startsWith(stringBuffer, "RMD") || this.startsWith(stringBuffer, "DELE")) {
                    return;
                }
                throw iOException;
            }
            throw iOException;
        }
    }

    private boolean connLostException(IOException iOException) {
        boolean bl;
        boolean bl2 = bl = iOException instanceof SocketException || iOException instanceof FTPException && ((FTPException)iOException).getResponse().getCode() == 421;
        if (bl) {
            this.connected = false;
        }
        return bl;
    }

    private boolean DirNotFoundException(IOException iOException) {
        boolean bl = iOException instanceof FTPException && ((FTPException)iOException).getResponse().getCode() == 550;
        return bl;
    }

    private boolean DirAlreadyExistException(IOException iOException) {
        boolean bl = iOException instanceof FTPException && ((FTPException)iOException).getResponse().getCode() == 550;
        return bl;
    }

    protected void clearStringBuffer(StringBuffer stringBuffer) {
        for (int i = 0; i < stringBuffer.length(); ++i) {
            stringBuffer.setCharAt(i, '\u0000');
        }
    }

    protected void login() throws IOException {
        StringBuffer stringBuffer = new StringBuffer("USER ");
        stringBuffer.append(this.user);
        this.sendCommand(stringBuffer);
        if (this.getResponse().isPositiveCompletion()) {
            return;
        }
        if (!this.getResponse().isPositiveIntermediate()) {
            throw new FTPException(this.getResponse());
        }
        StringBuffer stringBuffer2 = new StringBuffer("PASS ");
        stringBuffer2.append(this.password);
        this.processSimpleCommand(stringBuffer2, false);
        this.clearStringBuffer(stringBuffer2);
        this.connected = true;
        stringBuffer.setLength(0);
        stringBuffer.append("SYST");
        this.processSimpleCommand(stringBuffer, false);
        if (this.getResponse().getResponse().length() >= 5) {
            this.serversystem = this.getResponse().getResponse().substring(4);
            this.isMultiNet = this.serversystem.startsWith("VMS MultiNet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.lock;
        synchronized (object) {
            return this.connected;
        }
    }

    protected Socket openData(String string) throws IOException {
        this.writeLog(string);
        if (this.isPassiveMode()) {
            return this.openDataPassive(string);
        }
        return this.openDataActive(string);
    }

    private String getIPAddress(String string) {
        try {
            return InetAddress.getByName(Utils.getIntendedHostAddress()).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    protected Socket openDataActive(String string) throws IOException {
        this.serversocket = new ServerSocket(0);
        int n = this.serversocket.getLocalPort();
        String string2 = this.getIPAddress(Utils.getIntendedHostAddress()).replace('.', ',') + "," + n / 256 + "," + n % 256;
        this.processSimpleCommand("PORT " + string2, true);
        this.processSimpleCommand(string, 1, true);
        Socket socket = this.serversocket.accept();
        return socket;
    }

    protected Socket openDataPassive(String string) throws IOException {
        this.processSimpleCommand("PASV", true);
        String string2 = this.getResponse().getResponse();
        String string3 = "";
        int n = 0;
        boolean bl = false;
        if (this.getResponse().getCode() == 227) {
            String string4;
            StringTokenizer stringTokenizer;
            int n2 = string2.indexOf(40);
            int n3 = string2.indexOf(41);
            if (n2 > 3 && n3 > 3 && n2 < n3 && (stringTokenizer = new StringTokenizer(string4 = string2.substring(n2 + 1, n3), ",")).countTokens() == 6) {
                for (int i = 0; i < 4; ++i) {
                    string3 = string3 + stringTokenizer.nextToken() + (i < 3 ? "." : "");
                }
                try {
                    n = Integer.parseInt(stringTokenizer.nextToken()) * 256 + Integer.parseInt(stringTokenizer.nextToken());
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
            }
        }
        if (!bl) {
            throw new IOException("Can't recognize PASV command response. Use active mode.\n" + this.response);
        }
        Socket socket = new Socket(string3, n);
        socket.setSoTimeout(this.TIMEOUT);
        this.processSimpleCommand(string, 1, true);
        return socket;
    }

    protected void closeData(Socket socket) throws IOException {
        while (this.getResponse().isPositivePreliminary()) {
            this.setResponse();
        }
        if (!this.getResponse().isPositiveCompletion()) {
            throw new FTPException(this.getResponse());
        }
        socket.close();
        if (this.serversocket != null) {
            this.serversocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(RemoteFileName remoteFileName, File file, boolean bl) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n = 0;
            while (n++ < 2) {
                try {
                    int n2;
                    if (bl) {
                        this.ascii();
                    } else {
                        this.binary();
                    }
                    Socket socket = this.isMultiNet() && ((FTPFileName)remoteFileName).getFullName().startsWith("/") ? this.openData("RETR " + FileUtility.unixPathToOpenVMSPath((String)((FTPFileName)remoteFileName).getFullName(), (boolean)false)) : this.openData("RETR " + ((FTPFileName)remoteFileName).getFullName());
                    InputStream inputStream = socket.getInputStream();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    byte[] byArray = new byte[1024];
                    while ((n2 = inputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                    }
                    inputStream.close();
                    ((OutputStream)fileOutputStream).close();
                    this.closeData(socket);
                    break;
                }
                catch (IOException iOException) {
                    if (n < 2 && this.connLostException(iOException)) {
                        this.reconnect();
                        continue;
                    }
                    throw iOException;
                }
            }
        }
    }

    public void get(RemoteFileName remoteFileName, File file) throws IOException {
        this.get(remoteFileName, file, false);
    }

    public void put(File file, RemoteFileName remoteFileName) throws IOException {
        this.put(file, remoteFileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(File file, RemoteFileName remoteFileName, boolean bl) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n = 0;
            while (n++ < 2) {
                try {
                    int n2;
                    if (bl) {
                        this.ascii();
                    } else {
                        this.binary();
                    }
                    Socket socket = this.isMultiNet() && ((FTPFileName)remoteFileName).getFullName().startsWith("/") ? this.openData("STOR " + FileUtility.unixPathToOpenVMSPath((String)((FTPFileName)remoteFileName).getFullName(), (boolean)false)) : this.openData("STOR " + ((FTPFileName)remoteFileName).getFullName());
                    FileInputStream fileInputStream = new FileInputStream(file);
                    OutputStream outputStream = socket.getOutputStream();
                    byte[] byArray = new byte[1024];
                    while ((n2 = ((InputStream)fileInputStream).read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n2);
                    }
                    outputStream.close();
                    ((InputStream)fileInputStream).close();
                    this.closeData(socket);
                    break;
                }
                catch (IOException iOException) {
                    if (n < 2 && this.connLostException(iOException)) {
                        this.reconnect();
                        continue;
                    }
                    throw iOException;
                }
            }
        }
    }

    private FTPFileAttributes[] parseList(StringTokenizer stringTokenizer, String string, boolean bl) {
        if (this.isVMSType()) {
            if (this.isMultiNet()) {
                return this.parseListVMSMultiNet(stringTokenizer, string, bl);
            }
            return this.parseListVMS(stringTokenizer, string, bl);
        }
        return this.parseListUnix(stringTokenizer, string);
    }

    private FTPFileAttributes[] parseListVMS(StringTokenizer stringTokenizer, String string, boolean bl) {
        Object var5_4 = null;
        HashSet<FTPFileAttributes> hashSet = null;
        FTPFileAttributes fTPFileAttributes = null;
        String string2 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        String string3 = null;
        String string4 = null;
        int n2 = 0;
        int n3 = stringTokenizer.countTokens();
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (bl5) {
                string5 = string2 + " " + string5;
                bl5 = false;
                string2 = "";
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string5);
            int n4 = 0;
            fTPFileAttributes = new FTPFileAttributes();
            if (stringTokenizer2.countTokens() == 1) {
                string2 = string5;
                bl5 = true;
                continue;
            }
            while (stringTokenizer2.hasMoreTokens()) {
                String string6 = stringTokenizer2.nextToken();
                switch (n4) {
                    case 0: {
                        if (n == 0 && string6.equals("Directory")) {
                            bl2 = true;
                            break;
                        }
                        if (string6.equals("Total")) {
                            bl2 = true;
                            break;
                        }
                        int n5 = string6.lastIndexOf(".");
                        if (string6.regionMatches(true, n5 + 1, VMS_DIR, 0, 4)) {
                            fTPFileAttributes.setIsDirectory(true);
                        } else {
                            fTPFileAttributes.setIsDirectory(false);
                        }
                        int n6 = fTPFileAttributes.isDirectory() ? 46 : 59;
                        String string7 = string6.substring(0, string6.lastIndexOf(n6));
                        if (!fTPFileAttributes.isDirectory() && string7.indexOf(46) < 0) {
                            string7 = string7 + '.';
                        }
                        String string8 = FileUtility.openVMSPathToWinPath((String)string7, (boolean)fTPFileAttributes.isDirectory(), (String)"", (String)"");
                        fTPFileAttributes.setName(new FTPFileName(string, string8.substring(1), fTPFileAttributes.isDirectory()));
                        break;
                    }
                    case 1: {
                        if (string6.indexOf(47) >= 0) {
                            try {
                                fTPFileAttributes.setSize(Integer.parseInt(string6.substring(0, string6.indexOf(47))));
                            }
                            catch (NumberFormatException numberFormatException) {
                                bl2 = true;
                            }
                            break;
                        }
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        try {
                            n2 = Integer.parseInt(string6.substring(0, string6.indexOf(45)));
                            string3 = string6.substring(string6.indexOf(45) + 1, string6.lastIndexOf(45));
                            string4 = string6.substring(string6.lastIndexOf(45) + 1, string6.length());
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl3 = true;
                        }
                        break;
                    }
                    case 3: {
                        if (fTPFileAttributes.setDate(string3, n2, string4, string6)) break;
                        bl3 = true;
                        break;
                    }
                }
                if (bl2 || bl3) break;
                ++n4;
            }
            if (bl2 || bl3) {
                if (bl3) {
                    bl4 = true;
                }
                bl2 = false;
                bl3 = false;
                continue;
            }
            if (bl) {
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                if (hashSet.contains(fTPFileAttributes)) continue;
                hashSet.add(fTPFileAttributes);
                ++n;
                continue;
            }
            hashSet = new HashSet();
            hashSet.add(fTPFileAttributes);
            break;
        }
        if (hashSet == null) {
            hashSet = new HashSet<FTPFileAttributes>();
        }
        return hashSet.toArray(new FTPFileAttributes[0]);
    }

    private FTPFileAttributes[] parseListVMSMultiNet(StringTokenizer stringTokenizer, String string, boolean bl) {
        Object var5_4 = null;
        HashSet<FTPFileAttributes> hashSet = null;
        FTPFileAttributes fTPFileAttributes = null;
        String string2 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        String string3 = null;
        String string4 = null;
        int n2 = 0;
        int n3 = stringTokenizer.countTokens();
        boolean bl6 = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (bl5) {
                string5 = string2 + " " + string5;
                bl5 = false;
                string2 = "";
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string5);
            int n4 = 0;
            fTPFileAttributes = new FTPFileAttributes();
            if (stringTokenizer2.countTokens() == 1) {
                if (!bl6) {
                    string2 = string5;
                    bl5 = true;
                    continue;
                }
                bl6 = false;
                continue;
            }
            while (stringTokenizer2.hasMoreTokens()) {
                String string6 = stringTokenizer2.nextToken();
                switch (n4) {
                    case 0: {
                        if (n == 0 && string6.equals("150 List started")) {
                            bl2 = true;
                            break;
                        }
                        if (string6.equals("Total")) {
                            bl2 = true;
                            break;
                        }
                        int n5 = string6.lastIndexOf(".");
                        if (string6.regionMatches(true, n5 + 1, VMS_DIR, 0, 4)) {
                            fTPFileAttributes.setIsDirectory(true);
                        } else {
                            fTPFileAttributes.setIsDirectory(false);
                        }
                        int n6 = fTPFileAttributes.isDirectory() ? 46 : 59;
                        String string7 = string6.substring(0, string6.lastIndexOf(n6));
                        if (!fTPFileAttributes.isDirectory() && string7.indexOf(46) < 0) {
                            string7 = string7 + '.';
                        }
                        String string8 = FileUtility.openVMSPathToWinPath((String)string7, (boolean)fTPFileAttributes.isDirectory(), (String)"", (String)"");
                        fTPFileAttributes.setName(new FTPFileName(string, string8.substring(1), fTPFileAttributes.isDirectory()));
                        break;
                    }
                    case 1: {
                        try {
                            fTPFileAttributes.setSize(Integer.parseInt(string6));
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl2 = true;
                        }
                        break;
                    }
                    case 2: {
                        try {
                            n2 = Integer.parseInt(string6.substring(0, string6.indexOf(45)));
                            string3 = string6.substring(string6.indexOf(45) + 1, string6.lastIndexOf(45));
                            string4 = string6.substring(string6.lastIndexOf(45) + 1, string6.length());
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl3 = true;
                        }
                        break;
                    }
                    case 3: {
                        if (fTPFileAttributes.setDate(string3, n2, string4, string6)) break;
                        bl3 = true;
                        break;
                    }
                }
                if (bl2 || bl3) break;
                ++n4;
            }
            if (bl2 || bl3) {
                if (bl3) {
                    bl4 = true;
                }
                bl2 = false;
                bl3 = false;
                continue;
            }
            if (bl) {
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                if (hashSet.contains(fTPFileAttributes)) continue;
                hashSet.add(fTPFileAttributes);
                ++n;
                continue;
            }
            hashSet = new HashSet();
            hashSet.add(fTPFileAttributes);
            break;
        }
        if (hashSet == null) {
            hashSet = new HashSet<FTPFileAttributes>();
        }
        return hashSet.toArray(new FTPFileAttributes[0]);
    }

    private FTPFileAttributes[] parseListUnix(StringTokenizer stringTokenizer, String string) {
        FTPFileAttributes[] fTPFileAttributesArray = null;
        FTPFileAttributes fTPFileAttributes = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        String string2 = null;
        int n2 = 0;
        int n3 = stringTokenizer.countTokens();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3);
            int n4 = 0;
            fTPFileAttributes = new FTPFileAttributes();
            while (stringTokenizer2.hasMoreTokens()) {
                String string4 = stringTokenizer2.nextToken();
                switch (n4) {
                    case 0: {
                        if (n == 0 && string4.equals("total")) {
                            bl = true;
                            break;
                        }
                        if (string4.startsWith("d")) {
                            fTPFileAttributes.setIsDirectory(true);
                        } else if (string4.startsWith("-")) {
                            fTPFileAttributes.setIsDirectory(false);
                        } else {
                            bl = true;
                        }
                        fTPFileAttributes.setRights(string4.substring(1));
                        break;
                    }
                    case 1: {
                        try {
                            fTPFileAttributes.setLinks(Integer.parseInt(string4));
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl2 = true;
                        }
                        break;
                    }
                    case 2: {
                        fTPFileAttributes.setUser(string4);
                        break;
                    }
                    case 3: {
                        fTPFileAttributes.setGroup(string4);
                        break;
                    }
                    case 4: {
                        try {
                            fTPFileAttributes.setSize(Integer.parseInt(string4));
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl2 = true;
                        }
                        break;
                    }
                    case 5: {
                        string2 = string4;
                        break;
                    }
                    case 6: {
                        try {
                            n2 = Integer.parseInt(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl2 = true;
                        }
                        if (n2 >= 1 && n2 <= 31) break;
                        bl2 = true;
                        break;
                    }
                    case 7: {
                        if (fTPFileAttributes.setDate(string2, n2, string4)) break;
                        bl2 = true;
                        break;
                    }
                    case 8: {
                        fTPFileAttributes.setName(new FTPFileName(string, string4));
                        if (!string4.equals(".") && !string4.equals("..") || n > 2) break;
                        bl = true;
                    }
                }
                if (bl || bl2) break;
                ++n4;
            }
            if (bl || bl2) {
                if (bl2) {
                    bl3 = true;
                }
                bl = false;
                bl2 = false;
                continue;
            }
            if (fTPFileAttributesArray == null) {
                fTPFileAttributesArray = new FTPFileAttributes[stringTokenizer.countTokens() + 1];
            }
            fTPFileAttributesArray[n] = fTPFileAttributes;
            ++n;
        }
        if (fTPFileAttributesArray == null) {
            fTPFileAttributesArray = EMPTY_LIST;
        }
        return fTPFileAttributesArray;
    }

    public void addParser(ListParser listParser) {
        throw new Error("Not implemented yet");
    }

    public void addParser(String string, ListParser listParser) {
        throw new Error("Not implemented yet");
    }

    public boolean removeParser(ListParser listParser) {
        return false;
    }

    public void removeAllParsers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFileAttributes listFile(String string, RemoteFileName remoteFileName) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            Object object3;
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            if (!this.isConnected()) {
                return null;
            }
            while (n++ < 2) {
                try {
                    int n2;
                    if (!this.isVMSType()) {
                        object3 = this.openData(remoteFileName == null ? "LIST" : "LIST " + remoteFileName.getFullName());
                    } else if (this.isMultiNet() && remoteFileName != null && remoteFileName.getFullName().startsWith("/")) {
                        object2 = remoteFileName.getFullName();
                        object2 = remoteFileName.isDirectory() ? FileUtility.unixPathToOpenVMSPath((String)((String)object2 + ".dir"), (boolean)false) : FileUtility.unixPathToOpenVMSPath((String)object2, (boolean)false);
                        object3 = this.openData(remoteFileName == null ? "LIST" : "LIST " + (String)object2);
                    } else {
                        object3 = this.openData(remoteFileName == null ? "LIST" : "LIST " + remoteFileName.getFullName());
                    }
                    object2 = new InputStreamReader(((Socket)object3).getInputStream());
                    char[] cArray = new char[1024];
                    while ((n2 = ((Reader)object2).read(cArray)) != -1) {
                        stringBuffer.append(cArray, 0, n2);
                    }
                    ((InputStreamReader)object2).close();
                    this.closeData((Socket)object3);
                    break;
                }
                catch (IOException iOException) {
                    if (n < 2 && this.connLostException(iOException)) {
                        this.reconnect();
                        continue;
                    }
                    throw iOException;
                }
            }
            if ((object2 = this.parseList((StringTokenizer)(object3 = new StringTokenizer(stringBuffer.toString(), "\r\n")), string, false)) == null || ((FTPFileAttributes[])object2).length == 0) {
                return new RemoteFileAttributes();
            }
            return object2[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFileAttributes[] list(RemoteFileName remoteFileName) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            if (!this.isConnected()) {
                return new RemoteFileAttributes[0];
            }
            if (n++ < 2) {
                try {
                    int n2;
                    object2 = !this.isVMSType() ? this.openData(remoteFileName == null ? "LIST" : "LIST " + ((FTPFileName)remoteFileName).getFullName()) : (this.isMultiNet() && ((FTPFileName)remoteFileName).getFullName().startsWith("/") ? (remoteFileName.isDirectory() ? this.openData(remoteFileName == null ? "LIST" : "LIST " + FileUtility.unixPathToOpenVMSPath((String)((FTPFileName)remoteFileName).getFullName(), (boolean)true) + "*.*;0") : this.openData(remoteFileName == null ? "LIST" : "LIST " + FileUtility.unixPathToOpenVMSPath((String)((FTPFileName)remoteFileName).getFullName(), (boolean)false) + ";0")) : (remoteFileName.isDirectory() ? this.openData(remoteFileName == null ? "LIST" : "LIST " + ((FTPFileName)remoteFileName).getFullName() + "/*.*;0") : this.openData(remoteFileName == null ? "LIST" : "LIST " + ((FTPFileName)remoteFileName).getFullName() + ";0")));
                    InputStreamReader inputStreamReader = new InputStreamReader(((Socket)object2).getInputStream());
                    char[] cArray = new char[1024];
                    while ((n2 = inputStreamReader.read(cArray)) != -1) {
                        stringBuffer.append(cArray, 0, n2);
                    }
                    inputStreamReader.close();
                    this.closeData((Socket)object2);
                }
                catch (IOException iOException) {
                    if (n < 2 && this.connLostException(iOException)) {
                        try {
                            this.reconnect();
                        }
                        catch (IOException iOException2) {
                            return null;
                        }
                    }
                    if (n < 2 && this.DirNotFoundException(iOException)) {
                        return null;
                    }
                    throw iOException;
                }
            }
            object2 = new StringTokenizer(stringBuffer.toString(), "\r\n");
            return this.parseList((StringTokenizer)object2, ((FTPFileName)remoteFileName).getFullName(), remoteFileName.isDirectory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(RemoteFileName remoteFileName, String string) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            FTPFileName fTPFileName = new FTPFileName(((FTPFileName)remoteFileName).getDirectory(), string, remoteFileName.isDirectory());
            int n = 0;
            while (n++ < 2) {
                try {
                    if (this.isMultiNet() && ((FTPFileName)remoteFileName).getFullName().startsWith("/")) {
                        this.processSimpleCommand("RNFR " + FileUtility.unixPathToOpenVMSPath((String)remoteFileName.getFullName(), (boolean)remoteFileName.isDirectory()), 3, true);
                        this.processSimpleCommand("RNTO " + FileUtility.unixPathToOpenVMSPath((String)fTPFileName.getFullName(), (boolean)remoteFileName.isDirectory()), 2, true);
                        break;
                    }
                    this.processSimpleCommand("RNFR " + remoteFileName.getFullName(), 3, true);
                    this.processSimpleCommand("RNTO " + fTPFileName.getFullName(), 2, true);
                    break;
                }
                catch (IOException iOException) {
                    if (n < 2 && this.connLostException(iOException)) {
                        this.reconnect();
                        continue;
                    }
                    throw iOException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RemoteFileName remoteFileName) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isVMSType()) {
                if (this.isMultiNet() && ((FTPFileName)remoteFileName).getFullName().startsWith("/")) {
                    this.processSimpleCommand("DELE " + FileUtility.unixPathToOpenVMSPath((String)((FTPFileName)remoteFileName).getFullName(), (boolean)false) + ";*", true);
                } else {
                    this.processSimpleCommand("DELE " + ((FTPFileName)remoteFileName).getFullName() + ";*", true);
                }
            } else {
                this.processSimpleCommand("DELE " + ((FTPFileName)remoteFileName).getFullName(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkdir(RemoteFileName remoteFileName) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isMultiNet() && ((FTPFileName)remoteFileName).getFullName().startsWith("/")) {
                    this.processSimpleCommand("MKD " + FileUtility.unixPathToOpenVMSPath((String)((FTPFileName)remoteFileName).getFullName(), (boolean)true), true);
                } else {
                    this.processSimpleCommand("MKD " + remoteFileName.getFullName(), true);
                }
            }
            catch (IOException iOException) {
                if (this.DirAlreadyExistException(iOException)) {
                    return;
                }
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rmdir(RemoteFileName remoteFileName) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isMultiNet() && ((FTPFileName)remoteFileName).getFullName().startsWith("/")) {
                this.processSimpleCommand("RMD " + FileUtility.unixPathToOpenVMSPath((String)((FTPFileName)remoteFileName).getFullName(), (boolean)true), true);
            } else {
                this.processSimpleCommand("RMD " + ((FTPFileName)remoteFileName).getFullName(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pwd() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.processSimpleCommand("PWD", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cwd(String string) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (string == null) {
                return;
            }
            this.rwd = new String(string);
            if (this.isMultiNet() && string.startsWith("/")) {
                string = FileUtility.unixPathToOpenVMSPath((String)string, (boolean)true);
            }
            this.processSimpleCommand("CWD " + string, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void system() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.processSimpleCommand("SYST", true);
        }
    }

    private void ascii() throws IOException {
        this.processSimpleCommand("TYPE A", true);
    }

    private void binary() throws IOException {
        this.processSimpleCommand("TYPE I", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.sendCommand(new StringBuffer("QUIT"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.connected = false;
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
                if (this.log != null) {
                    this.log.close();
                    this.log = null;
                }
                if (this.rafile != null) {
                    this.rafile.close();
                    this.rafile = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        failedAttempts = new ArrayList();
    }

    public static interface ListParser {
        public RemoteFileAttributes parseList(StringTokenizer var1);
    }

    public static interface Reconnect {
        public boolean notifyReconnect(String var1);
    }
}

