/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFile;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.Sync;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class SyncTablePanel
extends JDialog {
    private JTable jTable1;
    private JScrollPane scrollPane;
    private JButton jButton1;
    private JButton jButton2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private MyJPopupMenu popupMenu;
    private String password;
    private static SyncTablePanel syncTable;
    private static Object[] longValues;
    private static int preferedTableWidth;
    private static final Object synchronizedObject;

    public SyncTablePanel() {
        this.myInitComponents();
    }

    public SyncTableModel getTableModel() {
        return (SyncTableModel)this.jTable1.getModel();
    }

    public JTable getTable() {
        return this.jTable1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void update(RemoteFile remoteFile) {
        SyncTableModel syncTableModel = syncTable.getTableModel();
        Object object = synchronizedObject;
        synchronized (object) {
            ArrayList arrayList = syncTableModel.getFiles();
            Map map = syncTableModel.getMap();
            Object[] objectArray = (Object[])map.get(remoteFile) != null ? (Object[])map.get(remoteFile) : new Object[7];
            RemoteFileSystem remoteFileSystem = remoteFile.getRemoteFS();
            if (remoteFile.getClientStatus() == Sync.SyncState.UpToDate && remoteFile.getServerStatus() == Sync.SyncState.UpToDate && (Object[])map.get(remoteFile) == null) {
                return;
            }
            objectArray[0] = remoteFile;
            objectArray[1] = remoteFile.getCacheFile().getAbsolutePath();
            SyncTablePanel.longValues[0] = ((String)objectArray[1]).length() > ((String)longValues[0]).length() ? objectArray[1] : longValues[0];
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("REMOTE_ROOT", remoteFileSystem.getRootFile());
            hashMap.put("LCOAL_ROOT", remoteFileSystem.getLocalRoot());
            objectArray[2] = FileUtility.winPathToOpenVMSPath((String)((String)objectArray[1]), (boolean)false, hashMap);
            SyncTablePanel.longValues[1] = ((String)objectArray[2]).length() > ((String)longValues[1]).length() ? objectArray[2] : longValues[1];
            objectArray[3] = remoteFile.getStatusString();
            SyncTablePanel.longValues[2] = ((String)objectArray[3]).length() > ((String)longValues[2]).length() ? objectArray[3] : longValues[2];
            objectArray[4] = new Boolean(false);
            objectArray[5] = new Boolean(false);
            objectArray[6] = new Boolean(true);
            if (!map.containsKey(remoteFile)) {
                map.put(remoteFile, objectArray);
                arrayList.add(objectArray);
            }
            syncTableModel.fireTableDataChanged();
            SyncTablePanel.initColumnSizes(syncTable.getTable());
        }
    }

    public static synchronized void bringupTable(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = synchronizedObject;
                synchronized (object) {
                    SyncTableModel syncTableModel;
                    ArrayList arrayList;
                    if (syncTable == null) {
                        syncTable = new SyncTablePanel();
                        syncTable.setModal(bl);
                    }
                    if ((arrayList = (syncTableModel = syncTable.getTableModel()).getFiles()) == null || arrayList.size() == 0) {
                        return;
                    }
                    syncTable.pack();
                    syncTable.show();
                }
            }
        });
    }

    public static synchronized void showSyncFiles(final RemoteFile remoteFile, final boolean bl, final boolean bl2) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = synchronizedObject;
                synchronized (object) {
                    if (syncTable == null) {
                        syncTable = new SyncTablePanel();
                        if (remoteFile.getClientStatus() == Sync.SyncState.UpToDate && remoteFile.getServerStatus() == Sync.SyncState.UpToDate) {
                            syncTable = null;
                            return;
                        }
                        syncTable;
                        SyncTablePanel.update(remoteFile);
                        if (!bl2) {
                            syncTable.setModal(bl);
                            syncTable.pack();
                            syncTable.show();
                        }
                    } else {
                        syncTable;
                        SyncTablePanel.update(remoteFile);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeTable() {
        SyncTableModel syncTableModel = (SyncTableModel)this.jTable1.getModel();
        ArrayList arrayList = null;
        SyncTableModel syncTableModel2 = syncTableModel;
        synchronized (syncTableModel2) {
            arrayList = syncTableModel.getFiles();
            Map map = syncTableModel.getMap();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                if (((RemoteFile)objectArray[0]).getClientStatus() != Sync.SyncState.UpToDate || ((RemoteFile)objectArray[0]).getServerStatus() != Sync.SyncState.UpToDate) continue;
                iterator.remove();
                map.remove(objectArray[0]);
            }
        }
        if (arrayList.size() == 0) {
            syncTable = null;
            this.exitForm(null);
            return;
        }
        syncTableModel.fireTableDataChanged();
    }

    private int getSelectedColumnHeaderIdx(MouseEvent mouseEvent) {
        JTable jTable = ((JTableHeader)mouseEvent.getSource()).getTable();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        if (n == -1) {
            return -1;
        }
        return n;
    }

    private static void initColumnSizes(JTable jTable) {
        SyncTableModel syncTableModel = (SyncTableModel)jTable.getModel();
        TableColumn tableColumn = null;
        Component component = null;
        int n = 0;
        int n2 = 0;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        int n3 = jTable.getColumnModel().getColumnMargin();
        for (int i = 0; i < 6; ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            component = tableCellRenderer.getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            n = component.getPreferredSize().width;
            component = jTable.getDefaultRenderer(syncTableModel.getColumnClass(i)).getTableCellRendererComponent(jTable, longValues[i], false, false, 0, i);
            n2 = component.getPreferredSize().width;
            if (i > 2) {
                preferedTableWidth += Math.max(n, n2);
                continue;
            }
            if (i == 2) {
                tableColumn.setPreferredWidth(Math.max(n, n2));
                continue;
            }
            tableColumn.setPreferredWidth(Math.min(250, n2));
        }
        jTable.setPreferredScrollableViewportSize(new Dimension(preferedTableWidth += 600, (int)jTable.getPreferredScrollableViewportSize().getHeight()));
        preferedTableWidth = 0;
    }

    private void myInitComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.popupMenu = new MyJPopupMenu();
        this.getContentPane().setLayout(new GridBagLayout());
        this.jTable1 = new JTable(){

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                if (n >= this.getRowCount()) {
                    return null;
                }
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setToolTipText(null);
                    if (n2 < 2 && n < this.getModel().getRowCount()) {
                        jComponent.setToolTipText((String)this.getValueAt(n, n2));
                    }
                }
                return component;
            }
        };
        this.setTitle("FTP Filesystem - Conflict Resolution");
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.jTable1);
        this.jPanel2.setLayout(new FlowLayout(2));
        this.jButton1.setText("Synchronize");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SyncTablePanel.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.jButton1.setEnabled(false);
        this.jPanel2.add(this.jButton1);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SyncTablePanel.this.jButton2ActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.jButton2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.scrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        JMenuItem jMenuItem = new JMenuItem("Select All");
        this.jTable1.setModel(new SyncTableModel());
        this.jTable1.setColumnSelectionAllowed(true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SyncTablePanel.this.jTable1.getSelectedColumn();
                if (n < 0) {
                    n = SyncTablePanel.this.popupMenu.getColumnIndex();
                }
                for (int i = 0; i < SyncTablePanel.this.jTable1.getRowCount(); ++i) {
                    SyncTablePanel.this.jTable1.getModel().setValueAt(Boolean.TRUE, i, n);
                }
            }
        });
        this.popupMenu.add(jMenuItem);
        PopupListener popupListener = new PopupListener();
        this.jTable1.addMouseListener(popupListener);
        JTableHeader jTableHeader = this.jTable1.getTableHeader();
        jTableHeader.addMouseListener(new ColumnHeaderListener());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                syncTable = null;
            }
        });
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        SyncTableModel syncTableModel = (SyncTableModel)this.jTable1.getModel();
        final ArrayList arrayList = syncTableModel.getFiles();
        final HashMap hashMap = new HashMap();
        this.jButton1.setEnabled(false);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = synchronizedObject;
                synchronized (object) {
                    Object object2;
                    RemoteFileSystem remoteFileSystem;
                    Object object3;
                    InputOutput inputOutput = IOProvider.getDefault().getIO("FTP Filesystem - Conflict Resolution", false);
                    try {
                        inputOutput.select();
                        inputOutput.getOut().reset();
                        inputOutput.setFocusTaken(true);
                        inputOutput.setErrVisible(false);
                        inputOutput.setErrSeparated(false);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    StatusDisplayer.getDefault().setStatusText("Resolving Conflicts");
                    for (int i = 0; i < arrayList.size(); ++i) {
                        try {
                            object3 = (RemoteFile)((Object[])arrayList.get(i))[0];
                            remoteFileSystem = ((RemoteFile)object3).getRemoteFS();
                            if (((RemoteFile)object3).getClientStatus() == Sync.SyncState.UpToDate && ((RemoteFile)object3).getServerStatus() == Sync.SyncState.UpToDate) continue;
                            if (((Object[])arrayList.get(i))[4].equals(Boolean.TRUE)) {
                                ((RemoteFile)object3).copyToClient();
                                inputOutput.getOut().println("Copying " + ((RemoteFile)object3).getName().getFullName() + " to client");
                            } else {
                                if (!((Object[])arrayList.get(i))[5].equals(Boolean.TRUE)) continue;
                                ((RemoteFile)object3).copyToServer();
                                inputOutput.getOut().println("Copying " + ((RemoteFile)object3).getCacheFile().getAbsolutePath() + " to server");
                            }
                            ((Object[])arrayList.get((int)i))[3] = ((RemoteFile)object3).getStatusString();
                            object2 = ((RemoteFile)object3).getCacheFile().getParent().equalsIgnoreCase(remoteFileSystem.getLocalRoot()) ? "" : ((RemoteFile)object3).getCacheFile().getParentFile().getAbsolutePath().substring(remoteFileSystem.getLocalRoot().length() + 1);
                            object2 = ((String)object2).replace(File.separatorChar, '/');
                            if (((String)object2).lastIndexOf(47) > 0) {
                                object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(47));
                            }
                            hashMap.put(object2, remoteFileSystem);
                            continue;
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)fileStateInvalidException.getMessage(), 0));
                            continue;
                        }
                        catch (IOException iOException) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)iOException.getMessage(), 0));
                        }
                    }
                    inputOutput.getOut().println("Done");
                    Iterator iterator = hashMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        object3 = (String)iterator.next();
                        remoteFileSystem = (FileSystem)hashMap.get(object3);
                        object2 = remoteFileSystem.findResource((String)object3);
                        if (object2 == null) continue;
                        object2.refresh();
                    }
                    SyncTablePanel.this.purgeTable();
                    StatusDisplayer.getDefault().setStatusText("Resolving Conflicts: Done");
                    Utils.closeActiveEditorFile();
                }
            }
        });
    }

    private void jButton2ActionPerformed(ActionEvent actionEvent) {
        syncTable = null;
        this.exitForm(null);
    }

    private void initComponents() {
        this.setTitle("FTP Filesystem - Conflict Resolution");
    }

    private void exitForm(WindowEvent windowEvent) {
        this.dispose();
    }

    public static void main(String[] stringArray) {
    }

    static {
        longValues = new Object[]{"", "", "", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
        synchronizedObject = new Object();
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SyncTablePanel.this.jTable1.getSelectedColumn() > 2) {
                this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (SyncTablePanel.this.jTable1.getSelectedColumn() > 2) {
                this.showPopup(mouseEvent);
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                SyncTablePanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class MyJPopupMenu
    extends JPopupMenu {
        private int index;

        MyJPopupMenu() {
        }

        public void setColumnIndex(int n) {
            this.index = n;
        }

        public int getColumnIndex() {
            return this.index;
        }
    }

    class ColumnHeaderListener
    extends MouseAdapter {
        ColumnHeaderListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SyncTablePanel.this.getSelectedColumnHeaderIdx(mouseEvent) > 2) {
                this.showPopup(mouseEvent);
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            SyncTablePanel.this.popupMenu.setColumnIndex(SyncTablePanel.this.getSelectedColumnHeaderIdx(mouseEvent));
            SyncTablePanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class SyncTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Local File", "Remote File", "Status", "Server->Client", "Client->Server", "No Action"};
        private ArrayList data = new ArrayList();
        private HashMap map = new HashMap();
        private HashSet actionList = new HashSet();

        public ArrayList getFiles() {
            return this.data;
        }

        public Map getMap() {
            return this.map;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return ((Object[])this.data.get(n))[n2 + 1];
        }

        public Class getColumnClass(int n) {
            return longValues[n].getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 > 2;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 > 2 && object.equals(Boolean.TRUE)) {
                Boolean bl = Boolean.FALSE;
                if (n2 == 3) {
                    ((Object[])this.data.get((int)n))[n2 + 2] = bl;
                    ((Object[])this.data.get((int)n))[n2 + 3] = bl;
                    SyncTablePanel.this.jButton1.setEnabled(true);
                    this.fireTableCellUpdated(n, n2 + 2);
                    this.fireTableCellUpdated(n, n2 + 3);
                    this.actionList.add(new Integer(n));
                } else if (n2 == 4) {
                    ((Object[])this.data.get((int)n))[n2] = bl;
                    ((Object[])this.data.get((int)n))[n2 + 2] = bl;
                    this.fireTableCellUpdated(n, n2 - 1);
                    this.fireTableCellUpdated(n, n2 + 2);
                    SyncTablePanel.this.jButton1.setEnabled(true);
                    this.actionList.add(new Integer(n));
                } else if (n2 == 5) {
                    ((Object[])this.data.get((int)n))[n2] = bl;
                    ((Object[])this.data.get((int)n))[n2 - 1] = bl;
                    this.fireTableCellUpdated(n, n2 - 2);
                    this.fireTableCellUpdated(n, n2 - 1);
                    this.actionList.remove(new Integer(n));
                    if (this.actionList.size() == 0) {
                        SyncTablePanel.this.jButton1.setEnabled(false);
                    }
                }
                ((Object[])this.data.get((int)n))[n2 + 1] = object;
                this.fireTableCellUpdated(n, n2 + 1);
            } else if (n2 == 2) {
                ((Object[])this.data.get((int)n))[n2 + 1] = object;
                this.fireTableCellUpdated(n, n2 + 1);
            }
        }
    }
}

