/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.cookies.RemoteCompileCookie;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.LifecycleManager;
import org.openide.actions.AbstractCompileAction;
import org.openide.awt.StatusDisplayer;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.cookies.CompilerCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class RemoteCompileAction
extends NodeAction {
    public String getName() {
        return "Remote Compile";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Class[] cookieClasses() {
        return new Class[]{CompilerCookie.class};
    }

    protected final Class cookie() {
        return DataObject.class;
    }

    protected String iconResource() {
        return "org/netbeans/modules/distributed/resources/remcompile.gif";
    }

    private static void refreshFS() {
        Set set = OpenProjectList.getFsSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileSystem fileSystem = (FileSystem)iterator.next();
            fileSystem.refresh(false);
        }
    }

    private static void refreshRemoteProjectSettings(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        RemoteProjectSettings remoteProjectSettings = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
        if (remoteProjectSettings != null) {
            remoteProjectSettings.refreshAll();
        }
    }

    protected void performAction(Node[] nodeArray) {
        final Node[] nodeArray2 = nodeArray;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RemoteCompileAction.refreshFS();
                RemoteCompileAction.this.compile3GL(nodeArray2);
                RemoteCompileAction.refreshFS();
            }
        });
    }

    static String findName(Node[] nodeArray) {
        String string = "";
        if (nodeArray.length > 0) {
            Node node = nodeArray[0];
            Node.Cookie cookie = null;
            do {
                if ((cookie = node.getCookie(class$org$openide$loaders$DataObject == null ? RemoteCompileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) == null) continue;
                DataObject dataObject = (DataObject)cookie;
                string = dataObject.isValid() ? dataObject.getNodeDelegate().getDisplayName() : "";
                break;
            } while ((node = node.getParentNode()) != null);
        }
        return NbBundle.getMessage((Class)Compiler.class, (String)"FMT_Compile", (Object)new Integer(nodeArray.length), (Object)string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray;
        Object object = actionEvent == null ? null : actionEvent.getSource();
        Node[] nodeArray2 = null;
        if (object instanceof Node) {
            nodeArray = (Node[])object;
            nodeArray2 = new Node[]{nodeArray};
        } else {
            nodeArray2 = object instanceof Node[] ? (Node[])object : super.getActivatedNodes();
        }
        nodeArray = nodeArray2;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RemoteCompileAction.refreshFS();
                RemoteCompileAction.this.compile3GL(nodeArray);
                RemoteCompileAction.refreshFS();
            }
        });
    }

    public static CompilerJob createJob(Enumeration enumeration, Compiler.Depth depth) {
        CompilerJob compilerJob = new CompilerJob(depth);
        AbstractCompileAction.prepareJobFor((CompilerJob)compilerJob, (Enumeration)enumeration, (Class)RemoteCompileCookie.class, (Compiler.Depth)depth);
        return compilerJob;
    }

    private void compile3GL(Node[] nodeArray) {
        if (DistributedSettings.getDefault().getSaveAll()) {
            LifecycleManager.getDefault().saveAll();
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            RemoteCompileCookie remoteCompileCookie = (RemoteCompileCookie)nodeArray[i].getCookie(class$org$netbeans$modules$distributed$common$cookies$RemoteCompileCookie == null ? RemoteCompileAction.class$("org.netbeans.modules.distributed.common.cookies.RemoteCompileCookie") : class$org$netbeans$modules$distributed$common$cookies$RemoteCompileCookie);
            if (remoteCompileCookie == null) continue;
            try {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? RemoteCompileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                RemoteCompileAction.refreshRemoteProjectSettings(dataObject.getPrimaryFile());
                remoteCompileCookie.compile();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.compileNodes2(nodeArray);
    }

    protected String message() {
        return NbBundle.getMessage((Class)Compiler.class, (String)"CTL_CompilationStarted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compileNodes2(Node[] nodeArray) {
        StatusDisplayer.getDefault().setStatusText(this.message());
        StatusDisplayer.getDefault().setStatusText("");
    }

    protected boolean enable(Node[] nodeArray) {
        int n = 0;
        if (nodeArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? RemoteCompileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dataObject == null) {
                return false;
            }
            if (dataObject.getPrimaryFile().isFolder() || dataObject.getPrimaryFile().isRoot()) {
                return false;
            }
            try {
                if (!(dataObject.getPrimaryFile().getFileSystem() instanceof NetworkFileSystem) && !(dataObject.getPrimaryFile().getFileSystem() instanceof FTPFileSystem)) {
                    return false;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return false;
            }
            if (dataObject.getCookie(class$org$netbeans$modules$distributed$common$cookies$RemoteCompileCookie == null ? RemoteCompileAction.class$("org.netbeans.modules.distributed.common.cookies.RemoteCompileCookie") : class$org$netbeans$modules$distributed$common$cookies$RemoteCompileCookie) == null) continue;
            ++n;
        }
        return n == nodeArray.length;
    }

    protected boolean asynchronous() {
        return false;
    }
}

