/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.propertyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.modules.distributed.common.propertyeditors.StringCustomEditorPlain;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPClient;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPException;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPFile;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPFileName;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSNode;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FileEditor
extends PropertyEditorSupport
implements ExPropertyEditor,
PropertyChangeListener {
    private PropertyEnv env;
    static final String PROPERTY_SHOW_DIRECTORIES = "directories";
    public static final String PROPERTY_SHOW_FILES = "files";
    public static final String PROPERTY_FILTER = "filter";
    static final String PROPERTY_CURRENT_DIR = "currentDir";
    static final String PROPERTY_BASE_DIR = "baseDir";
    static final String PROPERTY_FILE_HIDING = "file_hiding";
    private int mode = 2;
    private boolean directories = true;
    private boolean files = true;
    private boolean fileHiding = false;
    private javax.swing.filechooser.FileFilter fileFilter;
    private File currentDirectory;
    private File baseDirectory;
    private JFileChooser chooser;
    private boolean editable = true;
    private boolean inherited = false;
    private JPanel jPanel1;
    private JCheckBox jButton1;
    private static String fileName = "";

    public void attachEnv(PropertyEnv propertyEnv) {
        Object object;
        Object object2;
        Object object3;
        this.env = propertyEnv;
        this.directories = true;
        this.files = true;
        this.fileFilter = null;
        this.fileHiding = false;
        Object object4 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_SHOW_DIRECTORIES);
        if (object4 instanceof Boolean) {
            this.directories = (Boolean)object4;
        }
        if ((object3 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_SHOW_FILES)) instanceof Boolean) {
            this.files = (Boolean)object3;
        }
        if ((object2 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_FILTER)) instanceof FilenameFilter) {
            this.fileFilter = new DelegatingFilenameFilter((FilenameFilter)object2);
        } else if (object2 instanceof javax.swing.filechooser.FileFilter) {
            this.fileFilter = (javax.swing.filechooser.FileFilter)object2;
        } else if (object2 instanceof FileFilter) {
            this.fileFilter = new DelegatingFileFilter((FileFilter)object2);
        }
        Object object5 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_CURRENT_DIR);
        if (object5 instanceof File) {
            this.currentDirectory = (File)object5;
            if (!this.currentDirectory.isDirectory()) {
                ErrorManager.getDefault().log(16, "java.io.File will not accept currentDir=" + this.currentDirectory);
                this.currentDirectory = null;
            }
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_BASE_DIR)) instanceof File) {
            this.baseDirectory = (File)object;
            if (!this.baseDirectory.isDirectory() || !this.baseDirectory.isAbsolute()) {
                ErrorManager.getDefault().log(16, "java.io.File will not accept baseDir=" + this.baseDirectory);
                this.baseDirectory = null;
            }
        }
        this.mode = this.files ? (this.directories ? 2 : 0) : (this.directories ? 1 : 2);
        Object object6 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_FILE_HIDING);
        if (object6 instanceof Boolean) {
            this.fileHiding = (Boolean)object6;
        }
        if (propertyEnv.getFeatureDescriptor() instanceof Node.Property) {
            Node.Property property = (Node.Property)propertyEnv.getFeatureDescriptor();
            this.editable = property.canWrite();
        }
        if ((fileName = (String)propertyEnv.getFeatureDescriptor().getValue("fileName")) == null) {
            fileName = "";
        }
    }

    public String getAsText() {
        RemoteFSFile remoteFSFile = (RemoteFSFile)this.getValue();
        if (remoteFSFile == null) {
            return "";
        }
        String string = remoteFSFile.getPath();
        if (string.equals("")) {
            string = "";
        }
        return string;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null");
        }
        RemoteFSFile remoteFSFile = null;
        if (string.equals(".")) {
            string = "";
            remoteFSFile = new RemoteFSFile(string);
        } else {
            remoteFSFile = string.startsWith("/") ? new RemoteFSFile(string) : new RemoteFSFile(string, true);
        }
        this.setValue(remoteFSFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveDisableComponent(JComponent jComponent, boolean bl) {
        JComponent jComponent2 = jComponent;
        synchronized (jComponent2) {
            if (!jComponent.equals(this.jButton1)) {
                jComponent.setEnabled(bl);
            }
            for (int i = 0; i < jComponent.getComponentCount(); ++i) {
                Component component = jComponent.getComponent(i);
                if (!(component instanceof JComponent)) continue;
                this.recursiveDisableComponent((JComponent)component, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveDisableComponentStatic(JComponent jComponent, boolean bl) {
        JComponent jComponent2 = jComponent;
        synchronized (jComponent2) {
            if (!(jComponent instanceof JButton) || ((JButton)jComponent).getText() == null || !((JButton)jComponent).getText().equals("Cancel")) {
                jComponent.setEnabled(bl);
            }
            for (int i = 0; i < jComponent.getComponentCount(); ++i) {
                Component component = jComponent.getComponent(i);
                if (!(component instanceof JComponent)) continue;
                FileEditor.recursiveDisableComponentStatic((JComponent)component, bl);
            }
        }
    }

    public Object getObject() {
        return this.env.getFeatureDescriptor().getValue("object");
    }

    public Method getMethod() {
        return (Method)this.env.getFeatureDescriptor().getValue("method");
    }

    public String getParam() {
        return (String)this.env.getFeatureDescriptor().getValue("param");
    }

    public String getContext() {
        return (String)this.env.getFeatureDescriptor().getValue("context");
    }

    public File getInherit() {
        Method method = this.getMethod();
        Object object = this.getObject();
        String string = this.getParam();
        Object object2 = null;
        try {
            Object object3 = method.invoke(object, string);
            object2 = object3 instanceof String ? (object3.equals("") ? null : new File((String)object3)) : (File)object3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object2;
    }

    public Component getCustomEditor() {
        if (!this.editable) {
            String string = "";
            Object object = this.getValue();
            if (object instanceof File) {
                string = ((File)object).getAbsolutePath();
            }
            return new StringCustomEditorPlain(string, false);
        }
        if (this.chooser == null) {
            Serializable serializable;
            Object object = this.env.getFeatureDescriptor().getValue("3gl");
            Object object2 = object = object == null ? this.env.getFeatureDescriptor().getValue("context") : object;
            if (object != null) {
                serializable = DistributedSettings.getDefault().getRemoteRuntimes();
                Iterator iterator = serializable.iterator();
                RemoteRuntimeType remoteRuntimeType = null;
                boolean bl = false;
                while (iterator.hasNext()) {
                    remoteRuntimeType = (RemoteRuntimeType)iterator.next();
                    remoteRuntimeType.getRemoteRuntimeServerSafe();
                    if (!remoteRuntimeType.isConnected()) continue;
                    bl = true;
                }
                remoteRuntimeType = null;
                AbstractNetworkFileSystem abstractNetworkFileSystem = (AbstractNetworkFileSystem)this.env.getFeatureDescriptor().getValue("remoteFS");
                if (abstractNetworkFileSystem != null) {
                    remoteRuntimeType = abstractNetworkFileSystem.getRemoteRuntimeType();
                }
                RemoteFileSystemView remoteFileSystemView = remoteRuntimeType == null ? new RemoteFileSystemView() : new RemoteFileSystemView(remoteRuntimeType);
                this.chooser = FileEditor.createHackedFileChooser(remoteFileSystemView);
                if (!bl) {
                    this.chooser = FileEditor.createHackedFileChooser(false);
                    JTextArea jTextArea = new JTextArea();
                    jTextArea.setEditable(false);
                    jTextArea.setText("No Remote IDE Server is connected. Please go to the Runtime Tab and make a connection");
                    jTextArea.setBackground(new Color(236, 233, 216));
                    jTextArea.setLineWrap(true);
                    jTextArea.setWrapStyleWord(true);
                    jTextArea.setLocation((int)(jTextArea.getLocation().getX() - 14.0), (int)jTextArea.getLocation().getY());
                    jTextArea.setMargin(new Insets(2, 11, 2, 11));
                    this.recursiveDisableComponent(this.chooser, false);
                    this.chooser.setAccessory(jTextArea);
                    return this.chooser;
                }
            } else {
                this.chooser = FileEditor.createHackedFileChooser();
            }
            if (object == null) {
                serializable = (File)this.getValue();
                if (serializable != null && !((File)serializable).isAbsolute() && this.baseDirectory != null) {
                    serializable = new File(this.baseDirectory, ((File)serializable).getPath());
                }
                if (this.currentDirectory != null) {
                    this.chooser.setCurrentDirectory(this.currentDirectory);
                } else if (serializable != null && ((File)serializable).getParentFile() != null) {
                    this.chooser.setCurrentDirectory(((File)serializable).getParentFile());
                    this.chooser.setSelectedFile((File)serializable);
                }
            }
            this.chooser.setFileSelectionMode(this.mode);
            if (this.fileFilter != null) {
                this.chooser.setFileFilter(this.fileFilter);
            }
            switch (this.mode) {
                case 2: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFilesAndDirs"));
                    break;
                }
                case 0: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFiles"));
                    break;
                }
                case 1: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleDirs"));
                }
            }
            this.chooser.setFileHidingEnabled(this.fileHiding);
            this.chooser.setControlButtonsAreShown(false);
            this.chooser.addPropertyChangeListener("SelectedFileChangedProperty", this);
            this.chooser.addPropertyChangeListener("directoryChanged", this);
            HelpCtx.setHelpIDString((JComponent)this.chooser, (String)this.getHelpCtx().getHelpID());
            if (object != null) {
                this.jButton1 = new JCheckBox("");
                this.jButton1.setToolTipText("");
                this.jButton1.setText("Inherit from Project");
                this.jButton1.setMaximumSize(new Dimension(180, 27));
                this.jButton1.setPreferredSize(new Dimension(180, 27));
                this.jButton1.setLocation((int)(this.jButton1.getLocation().getX() - 14.0), (int)this.jButton1.getLocation().getY());
                this.jButton1.setMargin(new Insets(2, 11, 2, 11));
                this.jButton1.setFocusPainted(false);
                if (this.getContext() == null) {
                    if (this.getInherit() == null) {
                        this.jButton1.setSelected(true);
                        this.recursiveDisableComponent(this.chooser, false);
                        this.inherited = true;
                    } else {
                        this.jButton1.setSelected(false);
                        this.recursiveDisableComponent(this.chooser, true);
                        this.inherited = false;
                    }
                } else {
                    this.jButton1.setVisible(false);
                    this.inherited = false;
                }
                this.chooser.setAccessory(this.jButton1);
                this.jButton1.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        FileEditor.this.jButton1ActionPerformed(actionEvent);
                    }
                });
            }
        }
        return this.chooser;
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        try {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (jCheckBox.isSelected()) {
                RemoteFSFile remoteFSFile = (RemoteFSFile)this.env.getFeatureDescriptor().getValue("projvalue");
                this.setValue(remoteFSFile);
                if (remoteFSFile != null) {
                    if (remoteFSFile != null && !remoteFSFile.getAbsolutePath().equals(".") && !remoteFSFile.getAbsolutePath().equals("")) {
                        this.chooser.setSelectedFile(remoteFSFile);
                    } else if (remoteFSFile != null && (remoteFSFile.getAbsolutePath().equals(".") || remoteFSFile.getAbsolutePath().equals(""))) {
                        this.chooser.setSelectedFile(remoteFSFile);
                    }
                    this.setValue(null);
                }
                this.recursiveDisableComponent(this.chooser, false);
                this.jButton1.setEnabled(true);
                this.inherited = true;
            } else {
                this.recursiveDisableComponent(this.chooser, true);
                if (this.chooser.getSelectedFile() == null) {
                    if (this.files) {
                        if (this.getValue() == null || this.getValue().equals("")) {
                            this.setValue(null);
                            this.setAsText("");
                        } else {
                            RemoteFSFile remoteFSFile = new RemoteFSFile(null, null, ((RemoteFSFile)this.getValue()).getAbsolutePath(), ((RemoteFSFile)this.getValue()).getRemoteRuntimeType());
                            this.setValue(null);
                            this.setValue(remoteFSFile);
                        }
                    } else {
                        this.setValue((RemoteFSFile)this.chooser.getCurrentDirectory());
                    }
                } else {
                    String string = this.chooser.getSelectedFile().getAbsolutePath();
                    this.setValue(null);
                    this.setValue(this.chooser.getSelectedFile());
                }
                this.inherited = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getJavaInitializationString() {
        File file = (File)this.getValue();
        if (file == null) {
            return "null";
        }
        if (this.baseDirectory != null && !file.isAbsolute()) {
            return "new java.io.File(" + FileEditor.stringify(this.baseDirectory.getPath()) + ", " + FileEditor.stringify(file.getPath()) + ")";
        }
        return "new java.io.File(" + FileEditor.stringify(file.getAbsolutePath()) + ")";
    }

    static String stringify(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2 + 2);
        stringBuffer.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private HelpCtx getHelpCtx() {
        return new HelpCtx(FileEditor.class);
    }

    private static String getString(String string) {
        return NbBundle.getBundle((Class)FileEditor.class).getString(string);
    }

    static String getChildRelativePath(File file, File file2) {
        if (file2.equals(file)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(file2.getPath().length());
        stringBuffer.append(file2.getName());
        for (File file3 = file2.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
            if (file3.equals(file)) {
                return stringBuffer.toString();
            }
            stringBuffer.insert(0, File.separatorChar);
            stringBuffer.insert(0, file3.getName());
        }
        return null;
    }

    private void setTitle(JComponent jComponent, String string) {
        UIManager.put("FileChooser.lookInLabelText", string);
    }

    private static String makeNewTitle(String string, String string2, String string3, boolean bl) {
        String string4 = !bl ? string.substring(string.lastIndexOf("-") + 1) : string.substring(0, string.lastIndexOf("-")).trim();
        String string5 = " on " + string3;
        if (string4.trim().endsWith(string5)) {
            string4 = string.substring(0, string.indexOf("-"));
        }
        return string4.trim() + " - " + string2 + string5;
    }

    private static void changeTitle(JFileChooser jFileChooser, boolean bl) {
        for (Container container = jFileChooser.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Dialog)) continue;
            String string = ((RemoteFSFile)jFileChooser.getCurrentDirectory()).getRemoteRuntimeType().getHostName() + ":" + ((RemoteFSFile)jFileChooser.getCurrentDirectory()).getRemoteRuntimeType().getUserName();
            ((Dialog)container).setTitle(FileEditor.makeNewTitle(((Dialog)container).getTitle(), fileName, string, bl));
            break;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
        if (jFileChooser.getCurrentDirectory() instanceof RemoteFSFile) {
            // empty if block
        }
        if (propertyChangeEvent.getPropertyName().equals("directoryChanged")) {
            if (jFileChooser.getCurrentDirectory() instanceof RemoteFSFile) {
                this.setValue(jFileChooser.getCurrentDirectory());
                FileEditor.changeTitle(jFileChooser, true);
            }
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (!this.files && file.isFile()) {
            return;
        }
        if (!this.directories && file.isDirectory()) {
            return;
        }
        if (this.baseDirectory != null && (string = FileEditor.getChildRelativePath(this.baseDirectory, file)) != null) {
            file = new File(string);
        }
        this.setValue(file);
    }

    private static FileSystemView getFileSystemView(ArrayList arrayList, FTPClient fTPClient, boolean bl) {
        if (bl) {
            if (fTPClient == null) {
                return new FTPFileSystemView();
            }
            return new FTPFileSystemView(arrayList, fTPClient);
        }
        return FileSystemView.getFileSystemView();
    }

    private static JFileChooser createChooser(final FileSystemView fileSystemView) {
        Serializable serializable;
        Object object;
        final JFileChooser jFileChooser = new JFileChooser(fileSystemView);
        if (Utilities.getOperatingSystem() == 4096) {
            class MyFileView
            extends FileView {
                MyFileView() {
                }

                public String getDescription(File file) {
                    return super.getDescription(file);
                }

                public Icon getIcon(File file) {
                    if (file instanceof RemoteFSNode) {
                        return UIManager.getIcon("FileView.computerIcon");
                    }
                    return UIManager.getIcon(file.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
                }

                public String getName(File file) {
                    return file.getName();
                }

                public String getTypeDescription(File file) {
                    return super.getTypeDescription(file);
                }

                public Boolean isTraversable(File file) {
                    return file.isDirectory() || file instanceof RemoteFSNode ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            jFileChooser.setFileView(new MyFileView());
        }
        fileName = "";
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.getAccessibleContext().setAccessibleDescription(FileEditor.getString("ACSD_FileEditor"));
        jFileChooser.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (fileSystemView instanceof RemoteFileSystemView) {
                    FileEditor.changeTitle(jFileChooser, false);
                }
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        InputMap inputMap = jFileChooser.getInputMap(1);
        if (inputMap != null && (object = inputMap.get((KeyStroke)(serializable = KeyStroke.getKeyStroke(10, 0)))) == null) {
            inputMap.put((KeyStroke)serializable, "approveSelection");
        }
        if ((serializable = jFileChooser.getActionMap()) != null && (object = ((ActionMap)serializable).getParent()) != null) {
            final Action action = ((ActionMap)object).get("approveSelection");
            ((ActionMap)object).put("approveSelection", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file = jFileChooser.getSelectedFile();
                    if (file != null && file.isDirectory()) {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        jFileChooser.setCurrentDirectory(file);
                    } else if (action != null) {
                        action.actionPerformed(actionEvent);
                    }
                }
            });
        }
        return jFileChooser;
    }

    public static JFileChooser createRemoteFileChooser(RemoteRuntimeType remoteRuntimeType) {
        JFileChooser jFileChooser = FileEditor.createChooser(new RemoteFileSystemView(remoteRuntimeType));
        jFileChooser.putClientProperty("FileSystemViewChanged", Boolean.TRUE);
        return jFileChooser;
    }

    public static JFileChooser createRemoteFileChooser() {
        JFileChooser jFileChooser = FileEditor.createChooser(new RemoteFileSystemView());
        jFileChooser.putClientProperty("FileSystemViewChanged", Boolean.TRUE);
        return jFileChooser;
    }

    public static JFileChooser createHackedFileChooser() {
        return FileEditor.createHackedFileChooser(false);
    }

    public static JFileChooser createHackedFileChooserSafe(FileSystemView fileSystemView) {
        HashSet hashSet = DistributedSettings.getDefault().getRemoteRuntimes();
        Iterator iterator = hashSet.iterator();
        RemoteRuntimeType remoteRuntimeType = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            remoteRuntimeType = (RemoteRuntimeType)iterator.next();
            remoteRuntimeType.getRemoteRuntimeServerSafe();
            if (!remoteRuntimeType.isConnected()) continue;
            bl = true;
        }
        if (!bl) {
            JFileChooser jFileChooser = FileEditor.createHackedFileChooser(false);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setEditable(false);
            jTextArea.setText("No Remote IDE Server is connected. Please go to the Runtime Tab and make a connection");
            jTextArea.setBackground(new Color(236, 233, 216));
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setLocation((int)(jTextArea.getLocation().getX() - 14.0), (int)jTextArea.getLocation().getY());
            jTextArea.setMargin(new Insets(2, 11, 2, 11));
            FileEditor.recursiveDisableComponentStatic(jFileChooser, false);
            jFileChooser.setAccessory(jTextArea);
            return jFileChooser;
        }
        return FileEditor.createHackedFileChooser(fileSystemView);
    }

    public static JFileChooser createHackedFileChooser(FileSystemView fileSystemView) {
        JFileChooser jFileChooser = FileEditor.createChooser(fileSystemView);
        jFileChooser.putClientProperty("FileSystemViewChanged", Boolean.TRUE);
        return jFileChooser;
    }

    public static JFileChooser createHackedFileChooser(boolean bl, FTPClient fTPClient, ArrayList arrayList) {
        FileSystemView fileSystemView = FileEditor.getFileSystemView(arrayList, fTPClient, bl);
        return FileEditor.createChooser(fileSystemView);
    }

    public static JFileChooser createHackedFileChooser(boolean bl) {
        FileSystemView fileSystemView = FileEditor.getFileSystemView(null, null, bl);
        return FileEditor.createChooser(fileSystemView);
    }

    public static class FTPFileSystemView
    extends FileSystemView {
        private FTPClient ftpClient;
        private HashMap ftpClientMap = new HashMap();
        private boolean ftpOnly = false;
        private ArrayList roots;

        private List getRoots(FTPFileSystem fTPFileSystem) {
            return fTPFileSystem.getRemoteRuntimeType().listRoots();
        }

        public FTPFileSystemView() {
            Iterator iterator = OpenProjectList.getFsSet().iterator();
            this.roots = new ArrayList();
            while (iterator.hasNext()) {
                FileSystem fileSystem = (FileSystem)iterator.next();
                if (!(fileSystem instanceof FTPFileSystem)) continue;
                try {
                    if (!((FTPFileSystem)fileSystem).getClient().isConnected()) {
                        ((FTPFileSystem)fileSystem).getClient().connect();
                    }
                    List list = this.getRoots((FTPFileSystem)fileSystem);
                    this.ftpClientMap.put(((FTPFileSystem)fileSystem).getClient(), list == null ? new ArrayList() : list);
                }
                catch (IOException iOException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)iOException.getMessage(), 2));
                        }
                    });
                }
            }
        }

        public FTPFileSystemView(ArrayList arrayList, FTPClient fTPClient) {
            this.ftpOnly = true;
            this.ftpClient = fTPClient;
            this.roots = arrayList;
            try {
                if (!this.ftpClient.isConnected()) {
                    this.ftpClient.connect();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public File createFileObject(File file, String string) {
            if (file instanceof FTPFile) {
                return new FTPFile(file.getAbsolutePath(), string, ((FTPFile)file).getFTPClient());
            }
            return super.createFileObject(file, string);
        }

        public File createFileObject(String string) {
            if (string.charAt(0) == '/') {
                Object object;
                if (this.ftpOnly && this.ftpClient.getRoot().getFullName().equalsIgnoreCase(string)) {
                    return this.getFTPDirectory();
                }
                Set set = this.ftpClientMap.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    object = (FTPClient)((Object)iterator.next());
                    if (!((FTPClient)object).getRoot().getFullName().equalsIgnoreCase(string)) continue;
                    return this.getFTPDirectory((FTPClient)object);
                }
                object = string.substring(string.lastIndexOf(47) + 1, string.length());
                String string2 = string.substring(0, string.lastIndexOf(47) < 0 ? 0 : string.lastIndexOf(47));
                return new FTPFile(string2, (String)object, this.ftpClient);
            }
            return super.createFileObject(string);
        }

        protected File createFileSystemRoot(File file) {
            if (file instanceof FTPFile) {
                return this.createFileObject(file.getParentFile(), file.getName());
            }
            return super.createFileSystemRoot(file);
        }

        public File createNewFolder(File file) throws IOException {
            if (file instanceof FTPFile) {
                int n = 0;
                String string = null;
                for (n = 0; n < 100; ++n) {
                    string = "New_Folder_" + n;
                    try {
                        ((FTPFile)file).getFTPClient().mkdir(new FTPFileName(file.getAbsolutePath(), string, true));
                        break;
                    }
                    catch (IOException iOException) {
                        if (((FTPException)iOException).getResponse().getCode() == 550) continue;
                        throw iOException;
                    }
                }
                if (n == 100) {
                    throw new IOException("Directory already exists:" + string);
                }
                return this.createFileObject(file, string);
            }
            if (file == null) {
                throw new IOException("Containing directory is null:");
            }
            File file2 = null;
            String string = "New Folder";
            file2 = this.createFileObject(file, string);
            for (int i = 2; file2.exists() && i < 100; ++i) {
                file2 = this.createFileObject(file, MessageFormat.format(string, new Integer(i)));
            }
            if (file2.exists()) {
                throw new IOException("Directory already exists:" + file2.getAbsolutePath());
            }
            file2.mkdirs();
            return file2;
        }

        public File getChild(File file, String string) {
            if (file instanceof FTPFile) {
                return this.createFileObject(file, string);
            }
            return super.createFileObject(file, string);
        }

        public File getFTPDirectory() {
            String string = this.ftpClient.getRoot().getFullName();
            String string2 = string.substring(string.lastIndexOf(47) + 1, string.length());
            String string3 = "";
            return new FTPFile(true, true, true, false, string, string, "", 0L, 0L, this.ftpClient);
        }

        public File[] getFTPDirectories(ArrayList arrayList, FTPClient fTPClient) {
            File[] fileArray = new File[arrayList.size() + 1];
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                String string2 = string.substring(string.lastIndexOf(47) + 1, string.length());
                String string3 = "";
                fileArray[i] = new FTPFile(true, true, true, false, string, string, "", 0L, 0L, fTPClient);
            }
            fileArray[fileArray.length - 1] = this.getFTPDirectory(fTPClient);
            return fileArray;
        }

        public File getFTPDirectory(FTPClient fTPClient) {
            String string = fTPClient.getRoot().getFullName();
            String string2 = string.substring(string.lastIndexOf(47) + 1, string.length());
            String string3 = "";
            return new FTPFile(true, true, true, false, string, string, "", 0L, 0L, fTPClient);
        }

        public File getDefaultDirectory() {
            if (this.ftpOnly) {
                return this.getFTPDirectory();
            }
            return super.getDefaultDirectory();
        }

        public File[] getFiles(File file, boolean bl) {
            return file.listFiles();
        }

        public File getHomeDirectory() {
            return this.getFTPDirectory();
        }

        public File getParentDirectory(File file) {
            if (file instanceof FTPFile) {
                return ((FTPFile)file).getParentFile();
            }
            return super.getParentDirectory(file);
        }

        public File[] getRoots() {
            if (this.ftpOnly) {
                File[] fileArray = this.roots == null ? new File[]{this.getFTPDirectory()} : this.getFTPDirectories(this.roots, this.ftpClient);
                return fileArray;
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            File[] fileArray = super.getRoots();
            for (int i = 0; i < fileArray.length; ++i) {
                arrayList.add(fileArray[i]);
            }
            Set set = this.ftpClientMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FTPClient fTPClient = (FTPClient)iterator.next();
                ArrayList arrayList2 = (ArrayList)this.ftpClientMap.get(fTPClient);
                File[] fileArray2 = this.getFTPDirectories(arrayList2, fTPClient);
                for (int i = 0; i < fileArray2.length; ++i) {
                    arrayList.add(fileArray2[i]);
                }
            }
            return arrayList.toArray(new File[0]);
        }

        public String getSystemDisplayName(File file) {
            if (file instanceof FTPFile) {
                return file.getName();
            }
            return super.getSystemDisplayName(file);
        }

        public Icon getSystemIcon(File file) {
            if (file instanceof FTPFile) {
                return UIManager.getIcon(file.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
            }
            return super.getSystemIcon(file);
        }

        public String getSystemTypeDescription(File file) {
            if (file instanceof FTPFile) {
                return super.getSystemTypeDescription(file);
            }
            return super.getSystemTypeDescription(file);
        }

        public boolean isComputerNode(File file) {
            if (file instanceof FTPFile) {
                return false;
            }
            return super.isComputerNode(file);
        }

        public boolean isDrive(File file) {
            if (file instanceof FTPFile) {
                return false;
            }
            return super.isDrive(file);
        }

        public boolean isFileSystem(File file) {
            if (file instanceof FTPFile) {
                return true;
            }
            return super.isFileSystem(file);
        }

        public boolean isFileSystemRoot(File file) {
            if (file instanceof FTPFile) {
                return file.getAbsolutePath().equalsIgnoreCase(((FTPFile)file).getFTPClient().getRoot().getFullName());
            }
            return super.isFileSystemRoot(file);
        }

        public boolean isFloppyDrive(File file) {
            if (file instanceof FTPFile) {
                return false;
            }
            return super.isFloppyDrive(file);
        }

        public boolean isHiddenFile(File file) {
            if (file instanceof FTPFile) {
                return false;
            }
            return super.isHiddenFile(file);
        }

        public boolean isParent(File file, File file2) {
            if (file2 instanceof FTPFile) {
                return file2.getParent().equalsIgnoreCase(file.getAbsolutePath());
            }
            return super.isParent(file, file2);
        }

        public boolean isRoot(File file) {
            if (file instanceof FTPFile) {
                for (int i = 0; this.roots != null && i < this.roots.size(); ++i) {
                    if (!file.getAbsolutePath().equalsIgnoreCase((String)this.roots.get(i))) continue;
                    return true;
                }
                return false;
            }
            return super.isRoot(file);
        }

        public Boolean isTraversable(File file) {
            if (file instanceof FTPFile) {
                return file.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
            return super.isTraversable(file);
        }
    }

    public static class RemoteFileSystemView
    extends FileSystemView {
        private HashSet rrts;
        private ArrayList roots;
        private JFileChooser chooser;
        private File defaultDir;

        public RemoteFileSystemView() {
            this.rrts = DistributedSettings.getDefault().getRemoteRuntimes();
            Iterator iterator = this.rrts.iterator();
            RemoteRuntimeType remoteRuntimeType = null;
            while (iterator.hasNext()) {
                remoteRuntimeType = (RemoteRuntimeType)iterator.next();
                remoteRuntimeType.getRemoteRuntimeServerSafe();
            }
        }

        public RemoteFileSystemView(RemoteRuntimeType remoteRuntimeType) {
            this.rrts = new HashSet();
            remoteRuntimeType.getRemoteRuntimeServerSafe();
            this.rrts.add(remoteRuntimeType);
        }

        public File createFileObject(File file, String string) {
            if (file instanceof RemoteFSFile) {
                return new RemoteFSFile(file.getAbsolutePath(), file, string, ((RemoteFSFile)file).getRemoteRuntimeType());
            }
            return new RemoteFSFile(file.getAbsolutePath(), file, string, ((RemoteFSNode)file).getRemoteRuntimeType());
        }

        public File createFileObject(String string) {
            String string2 = null;
            this.defaultDir = this.getDefaultDirectory();
            if (string.equalsIgnoreCase(this.defaultDir.getAbsolutePath())) {
                string2 = this.defaultDir.getParent();
            } else if (string.startsWith("(")) {
                string2 = null;
            } else {
                String[] stringArray = this.defaultDir.getParentFile().list();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equalsIgnoreCase(stringArray[i])) continue;
                    string2 = this.defaultDir.getParent();
                    break;
                }
                if (string2 == null && string.lastIndexOf(47) > 0) {
                    string2 = string.substring(0, string.lastIndexOf(47));
                }
            }
            return new RemoteFSFile(string, string2, true, (RemoteRuntimeType)this.rrts.iterator().next());
        }

        protected File createFileSystemRoot(File file) {
            return this.createFileObject(file.getParentFile(), file.getName());
        }

        public File createNewFolder(File file) throws IOException {
            int n = 0;
            String string = null;
            for (n = 0; n < 100; ++n) {
                string = "New_Folder_" + n;
                try {
                    String string2 = file.getAbsolutePath();
                    string2 = string2.endsWith("/") ? string2 + string : string2 + "/" + string;
                    RemoteRuntimeType remoteRuntimeType = ((RemoteFSFile)file).getRemoteRuntimeType();
                    boolean bl = remoteRuntimeType.getRemoteFileService().mkdirs(string2);
                    if (bl) break;
                    continue;
                }
                catch (RemoteException remoteException) {
                    throw new IOException(remoteException.getMessage());
                }
            }
            if (n == 100) {
                throw new IOException("Directory already exists:" + string);
            }
            return this.createFileObject(file, string);
        }

        public File getChild(File file, String string) {
            return this.createFileObject(file, string);
        }

        public File getDefaultDirectory() {
            try {
                if (this.defaultDir != null) {
                    return this.defaultDir;
                }
                Iterator iterator = this.rrts.iterator();
                RemoteRuntimeType remoteRuntimeType = null;
                while (iterator.hasNext() && !(remoteRuntimeType = (RemoteRuntimeType)iterator.next()).isConnected()) {
                }
                if (remoteRuntimeType == null || !remoteRuntimeType.isConnected()) {
                    return null;
                }
                String string = remoteRuntimeType.getRemoteFileService().getDefaultDirectory();
                RemoteFSFile remoteFSFile = new RemoteFSFile("(" + remoteRuntimeType.getHostName() + ":" + remoteRuntimeType.getUserName() + ")", new RemoteFSNode(remoteRuntimeType), string, remoteRuntimeType, true, 0L, 0L);
                return remoteFSFile;
            }
            catch (RemoteException remoteException) {
                return null;
            }
        }

        public File[] getFiles(File file, boolean bl) {
            return file.listFiles();
        }

        public File getHomeDirectory() {
            return this.getDefaultDirectory();
        }

        public File getParentDirectory(File file) {
            return file.getParentFile();
        }

        public File[] getRoots() {
            if (this.roots != null) {
                return this.roots.toArray(new File[0]);
            }
            Iterator iterator = this.rrts.iterator();
            this.roots = new ArrayList();
            while (iterator.hasNext()) {
                RemoteRuntimeType remoteRuntimeType = (RemoteRuntimeType)iterator.next();
                if (remoteRuntimeType == null || remoteRuntimeType.getRemoteRuntime() == null) continue;
                RemoteFSNode remoteFSNode = new RemoteFSNode(remoteRuntimeType);
                this.roots.add(remoteFSNode);
            }
            return this.roots.toArray(new File[0]);
        }

        public String getSystemDisplayName(File file) {
            return file.getName();
        }

        public Icon getSystemIcon(File file) {
            if (file instanceof RemoteFSNode) {
                return UIManager.getIcon("FileView.computerIcon");
            }
            return UIManager.getIcon(file.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
        }

        public String getSystemTypeDescription(File file) {
            return super.getSystemTypeDescription(file);
        }

        public boolean isComputerNode(File file) {
            return file instanceof RemoteFSNode;
        }

        public boolean isDrive(File file) {
            return false;
        }

        public boolean isFileSystem(File file) {
            return true;
        }

        public boolean isFileSystemRoot(File file) {
            if (file instanceof RemoteFSNode) {
                return true;
            }
            File[] fileArray = this.getRoots();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getAbsolutePath().equalsIgnoreCase(file.getAbsolutePath())) continue;
                return true;
            }
            return false;
        }

        public boolean isFloppyDrive(File file) {
            return false;
        }

        public boolean isHiddenFile(File file) {
            return false;
        }

        public boolean isParent(File file, File file2) {
            return file2.getParent().equalsIgnoreCase(file.getAbsolutePath());
        }

        public boolean isRoot(File file) {
            return this.isFileSystemRoot(file);
        }

        public Boolean isTraversable(File file) {
            return file.isDirectory() || file instanceof RemoteFSNode ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    static class DelegatingFilenameFilter
    extends javax.swing.filechooser.FileFilter {
        private FilenameFilter filter;

        public DelegatingFilenameFilter(FilenameFilter filenameFilter) {
            this.filter = filenameFilter;
        }

        public boolean accept(File file) {
            return this.filter.accept(file.getParentFile(), file.getName());
        }

        public String getDescription() {
            return null;
        }
    }

    static class DelegatingFileFilter
    extends javax.swing.filechooser.FileFilter {
        private FileFilter filter;

        public DelegatingFileFilter(FileFilter fileFilter) {
            this.filter = fileFilter;
        }

        public boolean accept(File file) {
            return this.filter.accept(file);
        }

        public String getDescription() {
            return null;
        }
    }
}

