/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFile;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.SyncTablePanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class SynchResidenceAction
extends NodeAction
implements Presenter.Popup {
    static final long serialVersionUID = -7910677883191530622L;
    private RemoteFileSystem fs = null;
    public static final String CLIENT_ONLY_NO_ACTION = "Client Only";
    public static final String SERVER_ONLY_NO_ACTION = "Server Only";
    public static final String CLIENT_SERVER_NO_ACTION = "Client and Server";
    public static final String CLIENT_ONLY = "Make Client Only";
    public static final String SERVER_ONLY = "Make Server Only";
    public static final String CLIENT_SERVER = "Make Client and Server";
    public static final String FILE_MODE_TAG = "File Residence";
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public JMenuItem getPopupPresenter() {
        return new SpecialSubMenu((SystemAction)this, new ActSubMenuModel(this), true);
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? SynchResidenceAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dataObject == null) continue;
            FileObject fileObject = dataObject.getPrimaryFile();
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                if (!(fileSystem instanceof RemoteFileSystem)) {
                    return false;
                }
                if (((RemoteFileSystem)fileSystem).isConnected()) continue;
                return false;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return true;
    }

    protected void performAction(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            Set set = ((DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? SynchResidenceAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)).files();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    FileObject fileObject = (FileObject)iterator.next();
                    RemoteFileSystem remoteFileSystem = (RemoteFileSystem)fileObject.getFileSystem();
                    RemoteFile remoteFile = remoteFileSystem.getRemoteFile(fileObject.getPath());
                    SyncTablePanel.showSyncFiles(remoteFile, false, false);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)fileStateInvalidException.getMessage(), 0));
                }
                catch (IOException iOException) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)iOException.getMessage(), 0));
                }
            }
        }
    }

    protected void setFS(RemoteFileSystem remoteFileSystem) {
        this.fs = remoteFileSystem;
    }

    public String getName() {
        return FILE_MODE_TAG;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private static final class ActSubMenuModel
    implements Actions.SubMenuModel {
        private List targets = null;
        private List nodeList = null;
        private DataObject dobj = null;
        private final NodeAction action;

        ActSubMenuModel(NodeAction nodeAction) {
            this.action = nodeAction;
            this.targets = new ArrayList();
            this.nodeList = new ArrayList();
        }

        public int getCount() {
            if (this.targets == null) {
                return 0;
            }
            return this.targets.size();
        }

        public String getLabel(int n) {
            return (String)this.targets.get(n);
        }

        public HelpCtx getHelpCtx(int n) {
            return new HelpCtx("org.apache.tools.ant.module.executing-target");
        }

        private void recursivelyChangeState(FileObject fileObject, int n, HashSet hashSet) {
            if (fileObject.isFolder()) {
                FileObject[] fileObjectArray = fileObject.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    this.recursivelyChangeState(fileObjectArray[i], n, hashSet);
                }
            } else {
                try {
                    RemoteFileSystem remoteFileSystem = (RemoteFileSystem)fileObject.getFileSystem();
                    RemoteFile remoteFile = remoteFileSystem.getRemoteFile(fileObject.getPath());
                    if (remoteFileSystem.getServerOnlyFileExts().isRegistered(remoteFile.getName().getName()) && n != 1) {
                        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)(remoteFile.getName().getName() + "'s residence mode is fixed to \"Server Only\".\n Update the \"ServerOnly File Extensions\" propety of the FTP filesystem to change it"), -1, 2));
                    }
                    if (n == 0) {
                        if (remoteFile.getFileResidenceMode() != 1) {
                            remoteFile.setFileResidenceMode(1, fileObject);
                        }
                    } else if (n == 1) {
                        if (remoteFile.getFileResidenceMode() != 0) {
                            remoteFile.setFileResidenceMode(0, fileObject);
                        }
                    } else if (n == 2 && remoteFile.getFileResidenceMode() != 2) {
                        remoteFile.setFileResidenceMode(2, fileObject);
                    }
                    hashSet.add(fileObject.getParent());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)fileStateInvalidException.getMessage(), 0));
                }
                catch (IOException iOException) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)iOException.getMessage(), 0));
                }
            }
        }

        public void performActionAt(final int n) {
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    StatusDisplayer.getDefault().setStatusText("Performing File Residence Action Recursively");
                    String string = (String)ActSubMenuModel.this.targets.get(n);
                    HashSet hashSet = new HashSet();
                    for (int i = 0; i < ActSubMenuModel.this.nodeList.size(); ++i) {
                        Set set = ((DataObject)ActSubMenuModel.this.nodeList.get(i)).files();
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            ActSubMenuModel.this.recursivelyChangeState((FileObject)iterator.next(), n, hashSet);
                        }
                    }
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        ((FileObject)iterator.next()).refresh();
                    }
                    StatusDisplayer.getDefault().setStatusText("File Residence Action: Done");
                }
            });
        }

        void addNotify() {
            this.targets.add(SynchResidenceAction.CLIENT_ONLY);
            this.targets.add(SynchResidenceAction.SERVER_ONLY);
            this.targets.add(SynchResidenceAction.CLIENT_SERVER);
            Node[] nodeArray = this.action.getActivatedNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                this.nodeList.add((DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? SynchResidenceAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject));
            }
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private static final class SpecialSubMenu
    extends Actions.SubMenu {
        private final ActSubMenuModel model;

        SpecialSubMenu(SystemAction systemAction, ActSubMenuModel actSubMenuModel, boolean bl) {
            super(systemAction, (Actions.SubMenuModel)actSubMenuModel, bl);
            this.model = actSubMenuModel;
            this.addNotify();
        }

        public void addNotify() {
            this.model.addNotify();
            super.addNotify();
        }
    }
}

