/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFile;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.DownloadAllAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.Sync;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.SynchronizeAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.SynchronizeRecurseAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.UploadAllAction;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class FTPActions
extends NodeAction
implements Presenter.Popup {
    static final long serialVersionUID = -7910677883191530622L;
    private RemoteFileSystem fs = null;
    public static final String SYNCHRONIZE = "Synchronize";
    public static final String SYNCHRONIZE_RECURSE = "Synchronize Recursively";
    public static final String GET_ALL = "Get All Files From Server";
    public static final String PUT_ALL = "Put All Files To Server";
    public static final String GET_ONE = "Get File From Server";
    public static final String PUT_ONE = "Put File To Server";
    public static final String FILE_MODE_TAG = "FTP Actions";
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public JMenuItem getPopupPresenter() {
        return new SpecialSubMenu((SystemAction)this, new ActSubMenuModel(this), true);
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? FTPActions.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dataObject == null) continue;
            FileObject fileObject = dataObject.getPrimaryFile();
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                if (!(fileSystem instanceof RemoteFileSystem)) {
                    return false;
                }
                if (((RemoteFileSystem)fileSystem).isConnected()) continue;
                return false;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return true;
    }

    public void performAction(Node[] nodeArray) {
    }

    protected void setFS(RemoteFileSystem remoteFileSystem) {
        this.fs = remoteFileSystem;
    }

    public String getName() {
        return FILE_MODE_TAG;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private static final class ActSubMenuModel
    implements Actions.SubMenuModel {
        private List targets = null;
        private Node[] nodes = null;
        private DataObject dobj = null;
        private final NodeAction action;

        ActSubMenuModel(NodeAction nodeAction) {
            this.action = nodeAction;
            this.targets = new ArrayList();
        }

        public int getCount() {
            if (this.targets == null) {
                return 0;
            }
            return this.targets.size();
        }

        public String getLabel(int n) {
            return (String)this.targets.get(n);
        }

        public HelpCtx getHelpCtx(int n) {
            return new HelpCtx("org.apache.tools.ant.module.executing-target");
        }

        public void performActionAt(int n) {
            if (this.targets.get(n).equals(FTPActions.SYNCHRONIZE)) {
                final SynchronizeAction synchronizeAction = new SynchronizeAction();
                Thread thread = new Thread("FTP-Synchronize"){

                    public void run() {
                        synchronizeAction.performAction(ActSubMenuModel.this.nodes);
                    }
                };
                thread.start();
            } else if (this.targets.get(n).equals(FTPActions.SYNCHRONIZE_RECURSE)) {
                final SynchronizeRecurseAction synchronizeRecurseAction = new SynchronizeRecurseAction();
                Thread thread = new Thread("FTP-Synchronize"){

                    public void run() {
                        synchronizeRecurseAction.performAction(ActSubMenuModel.this.nodes);
                    }
                };
                thread.start();
            } else if (((String)this.targets.get(n)).startsWith("Get")) {
                DownloadAllAction downloadAllAction = new DownloadAllAction();
                downloadAllAction.performAction(this.nodes);
            } else if (((String)this.targets.get(n)).startsWith("Put")) {
                UploadAllAction uploadAllAction = new UploadAllAction();
                uploadAllAction.performAction(this.nodes);
            }
        }

        void addNotify() {
            this.nodes = this.action.getActivatedNodes();
            if (this.nodes != null && this.nodes.length > 0) {
                this.targets.add(FTPActions.SYNCHRONIZE);
                this.targets.add(FTPActions.SYNCHRONIZE_RECURSE);
                DataFolder dataFolder = (DataFolder)this.nodes[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = FTPActions.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                if (this.nodes.length == 1 && dataFolder == null) {
                    DataObject dataObject = (DataObject)this.nodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = FTPActions.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    FileObject fileObject = dataObject.getPrimaryFile();
                    try {
                        RemoteFileSystem remoteFileSystem = (RemoteFileSystem)fileObject.getFileSystem();
                        RemoteFile remoteFile = remoteFileSystem.getRemoteFile(fileObject.getPath());
                        if (!remoteFile.getClientStatus().equals(Sync.SyncState.Missing) && !remoteFile.getClientStatus().equals(Sync.SyncState.NoSuchFile)) {
                            this.targets.add(FTPActions.PUT_ONE);
                        }
                        if (!remoteFile.getServerStatus().equals(Sync.SyncState.Missing) && !remoteFile.getServerStatus().equals(Sync.SyncState.NoSuchFile)) {
                            this.targets.add(FTPActions.GET_ONE);
                        }
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        this.targets.add(FTPActions.PUT_ONE);
                        this.targets.add(FTPActions.GET_ONE);
                    }
                    catch (IOException iOException) {
                        this.targets.add(FTPActions.PUT_ONE);
                        this.targets.add(FTPActions.GET_ONE);
                    }
                } else {
                    boolean bl = false;
                    boolean bl2 = false;
                    for (int i = 0; i < this.nodes.length; ++i) {
                        dataFolder = (DataFolder)this.nodes[i].getCookie(class$org$openide$loaders$DataFolder == null ? FTPActions.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
                        if (dataFolder != null) {
                            bl = true;
                            bl2 = true;
                            break;
                        }
                        DataObject dataObject = (DataObject)this.nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? FTPActions.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                        try {
                            FileObject fileObject = dataObject.getPrimaryFile();
                            RemoteFileSystem remoteFileSystem = (RemoteFileSystem)fileObject.getFileSystem();
                            RemoteFile remoteFile = remoteFileSystem.getRemoteFile(fileObject.getPath());
                            if (!remoteFile.getClientStatus().equals(Sync.SyncState.Missing) && !remoteFile.getClientStatus().equals(Sync.SyncState.NoSuchFile)) {
                                bl = true;
                            }
                            if (!remoteFile.getServerStatus().equals(Sync.SyncState.Missing) && !remoteFile.getServerStatus().equals(Sync.SyncState.NoSuchFile)) {
                                bl2 = true;
                            }
                            if (!bl || !bl2) continue;
                            break;
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            bl = true;
                            bl2 = true;
                            continue;
                        }
                        catch (IOException iOException) {
                            bl = true;
                            bl2 = true;
                        }
                    }
                    if (bl) {
                        this.targets.add(FTPActions.PUT_ALL);
                    }
                    if (bl2) {
                        this.targets.add(FTPActions.GET_ALL);
                    }
                }
            }
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private static final class SpecialSubMenu
    extends Actions.SubMenu {
        private final ActSubMenuModel model;

        SpecialSubMenu(SystemAction systemAction, ActSubMenuModel actSubMenuModel, boolean bl) {
            super(systemAction, (Actions.SubMenuModel)actSubMenuModel, bl);
            this.model = actSubMenuModel;
            this.addNotify();
        }

        public void addNotify() {
            this.model.addNotify();
            super.addNotify();
        }
    }
}

