/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteClient;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteDefaultAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileName;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.RemoteOutputStream;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.Sync;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.SyncTablePanel;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.SyncTablePanelFileOpen;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.InputOutput;

public class RemoteFile {
    private static final boolean DEBUG = true;
    public static final String LAST_MODIFIED_CACHE = "ftp_cache_lastmodified";
    public static final String LAST_MODIFIED_SERVER = "ftp_remote_lastmodified";
    public static final int MAX_FTP_VMS_TXT_FILE_SIZE = 30000;
    private RemoteFile parent;
    private RemoteClient client;
    private Notify notify;
    private RemoteFileAttributes attrib;
    protected File file;
    private RemoteFile[] children = new RemoteFile[0];
    private Vector childrenvector = new Vector();
    private RequestProcessor rp;
    private static final String PATH_SEP = "/";
    private Sync.SyncState clientStatus = Sync.SyncState.Unknown;
    private Sync.SyncState serverStatus = Sync.SyncState.Unknown;
    public static final int NOT_EQUAL = 0;
    public static final int EQUAL = 1;
    public static final int NONE = 2;
    public static final int DIRECTORY = 3;
    private static final int OPEN = 4;
    public static final int SERVER_FILE_MISSING = 5;
    public static final int CLIENT_FILE_MISSING = 6;
    public static final int SERVER_MOD_CLIENT_MISSING = 7;
    public static final int CLIENT_MOD_SERVER_MISSING = 8;
    public static final int BOTH_MODIFIED = 9;
    public static final int SERVER_ONLY = 10;
    public static final int SERVER_NEW_CLIENT_MISSING = 11;
    public static final int CLIENT_NEW_SERVER_MISSING = 12;
    public static final int MISSING = -1;
    public static final int CACHE_MISSING = -1;
    public static final int SERVER_MISSING = -1;
    public static final int HISTORY_MISSING = -2;
    public static final int CACHE_HISTORY_MISSING = -2;
    public static final int SERVER_HISTORY_MISSING = -2;
    public static final int FILE_RES_SERVER_ONLY = 0;
    public static final int FILE_RES_CLIENT_ONLY = 1;
    public static final int FILE_RES_CLIENT_SERVER = 2;
    private boolean onserver;
    private long cachelastmodified = -2L;
    private long serverlastmodified = -2L;
    private boolean childrenchanged = false;
    private boolean nextnochildren = false;
    private RemoteFileSystem remoteFS;
    private String mimeType;
    private int fileResidenceMode = 2;
    private boolean fileOpen = false;

    public RemoteFile(RemoteFileAttributes remoteFileAttributes, RemoteFile remoteFile, RemoteClient remoteClient, Notify notify, RequestProcessor requestProcessor, File file, boolean bl, RemoteFileSystem remoteFileSystem) throws IOException {
        this.attrib = remoteFileAttributes;
        this.parent = remoteFile;
        this.client = remoteClient;
        this.notify = notify;
        this.file = file;
        this.onserver = bl;
        this.rp = requestProcessor;
        this.remoteFS = remoteFileSystem;
        if (remoteFileAttributes.isDirectory()) {
            if (remoteClient.isConnected()) {
                if (!bl) {
                    remoteClient.mkdir(this.getName());
                }
                this.onserver = true;
            }
            if (!file.exists()) {
                file.mkdirs();
            }
        } else {
            String string = file.getAbsolutePath().substring(remoteFileSystem.getLocalRoot().length() + 1);
            string = string.replace(File.separatorChar, '/');
            if (!file.exists()) {
                long l = -1L;
            } else {
                long l = file.lastModified();
            }
            Long l = (Long)this.remoteFS.getFileAttribute(string, LAST_MODIFIED_CACHE);
            this.cachelastmodified = l == null || l == 0L ? -2L : l;
            if (!bl) {
                long l2 = -1L;
            } else {
                long l3 = remoteFileAttributes.getDate().getTime();
            }
            l = (Long)this.remoteFS.getFileAttribute(string, LAST_MODIFIED_SERVER);
            this.serverlastmodified = l == null || l == 0L ? -2L : l;
            Integer n = (Integer)this.remoteFS.getFileAttribute(string, "file_residence_mode");
            this.fileResidenceMode = n != null ? n : (this.remoteFS.getServerOnlyFileExts().isRegistered(string) ? 0 : 2);
        }
    }

    public boolean isDir() {
        return this.attrib.isDirectory();
    }

    public File getFile() {
        return this.file;
    }

    public synchronized RemoteFile[] getChildren(RemoteFileSystem remoteFileSystem) {
        this.childrenchanged = false;
        try {
            this.getChildrenBlock(remoteFileSystem);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.distributed").notify((Throwable)iOException);
        }
        if (this.childrenchanged) {
            this.notify.fileChanged(this.getName().getFullName());
        }
        return this.children;
    }

    private RemoteFile[] getChildrenBlock(RemoteFileSystem remoteFileSystem) throws IOException {
        RemoteFile remoteFile;
        Object object;
        Object object2;
        File[] fileArray;
        Set<Object> set;
        Object object3;
        Set<Object> set2;
        if (this.children == null) {
            // empty if block
        }
        TreeMap<String, RemoteFile> treeMap = null;
        if (this.children == null) {
            set2 = new TreeSet(new CaseIgnoreComparator());
        } else {
            treeMap = new TreeMap<String, RemoteFile>(new CaseIgnoreComparator());
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                if (this.remoteFS.getIgnoredFiles() != null && this.remoteFS.getIgnoredFiles().isRegistered(this.children[i].getName().getName())) {
                    this.childrenvector.remove(this.children[i]);
                    this.children[i] = null;
                    continue;
                }
                if (this.remoteFS.getIgnoreHiddenFiles() && this.children[i].getName().getName().startsWith(".")) {
                    this.childrenvector.remove(this.children[i]);
                    this.children[i] = null;
                    continue;
                }
                if (this.remoteFS.getIgnoredFolders() != null && this.remoteFS.getIgnoredFolders().isRegistered(this.children[i].getName().getName())) {
                    this.childrenvector.remove(this.children[i]);
                    this.children[i] = null;
                    continue;
                }
                treeMap.put(this.children[i].getName().getName(), this.children[i]);
            }
            set2 = treeMap.keySet();
        }
        TreeMap<String, RemoteFileAttributes> treeMap2 = new TreeMap<String, RemoteFileAttributes>(new CaseIgnoreComparator());
        if (this.notify.isRefreshServer() && this.onserver && this.client.isConnected()) {
            object3 = this.client.list(this.getName());
            if (object3 != null) {
                for (int i = 0; i < ((RemoteFileAttributes[])object3).length; ++i) {
                    if (object3[i] != null && (this.remoteFS.getIgnoredFiles() != null && this.remoteFS.getIgnoredFiles().isRegistered(object3[i].getName().getName()) || this.remoteFS.getIgnoredFolders() != null && this.remoteFS.getIgnoredFolders().isRegistered(object3[i].getName().getName()) || this.remoteFS.getIgnoreHiddenFiles() && object3[i].getName().getName().startsWith(".")) || object3[i] == null) continue;
                    treeMap2.put(object3[i].getName().getName(), object3[i]);
                }
            }
            set = treeMap2.keySet();
        } else {
            set = new TreeSet(new CaseIgnoreComparator());
        }
        object3 = new TreeSet(new CaseIgnoreComparator());
        if (this.notify.isScanCache() && (fileArray = this.file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                object2 = fileArray[i].getName();
                if (object2 != null && (this.remoteFS.getIgnoredFiles() != null && this.remoteFS.getIgnoredFiles().isRegistered((String)object2) || this.remoteFS.getIgnoreHiddenFiles() && ((String)object2).startsWith(".") || this.remoteFS.getIgnoredFolders() != null && this.remoteFS.getIgnoredFolders().isRegistered((String)object2)) || ((String)object2).endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML) || ((String)object2).endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML + "~") || ((String)object2).endsWith(".shadow")) continue;
                if (fileArray[i].isFile() && ((String)object2).indexOf(46) < 0) {
                    object2 = "" + object2 + '.';
                }
                if (set.contains(object2)) {
                    ((TreeSet)object3).add(((RemoteFileAttributes)treeMap2.get(object2)).getName().getName());
                    continue;
                }
                ((TreeSet)object3).add(object2);
            }
        }
        if (!set2.containsAll((Collection<?>)object3) && !set.containsAll((Collection<?>)object3)) {
            TreeSet treeSet = new TreeSet(new CaseIgnoreComparator());
            treeSet.addAll(object3);
            treeSet.removeAll(set2);
            treeSet.removeAll(set);
            if (!treeSet.isEmpty()) {
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    boolean bl = new File(this.file, (String)object2).isDirectory();
                    object = new RemoteFileAttributes(this.getName().createNew((String)object2, bl), bl);
                    remoteFile = new RemoteFile((RemoteFileAttributes)object, this, this.client, this.notify, this.rp, new File(this.file, (String)object2), false, remoteFileSystem);
                    remoteFile.refresh();
                    if (remoteFile.getFileAttributes() != null && remoteFile.getFileAttributes().getSize() != 0L && remoteFile.getFileAttributes().getDate().getTime() != 0L) {
                        ((TreeSet)object3).remove(object2);
                        ((TreeSet)object3).add(remoteFile.getName().getName());
                    }
                    this.childrenvector.addElement(remoteFile);
                    this.childrenchanged = true;
                }
            }
        }
        TreeSet<Object> treeSet = new TreeSet<Object>(new CaseIgnoreComparator());
        treeSet.addAll(set);
        if (!set2.containsAll(set)) {
            TreeSet<Object> treeSet2 = new TreeSet<Object>(new CaseIgnoreComparator());
            treeSet2.addAll(set);
            treeSet2.removeAll(set2);
            if (!treeSet2.isEmpty()) {
                object2 = treeSet2.iterator();
                while (object2.hasNext()) {
                    RemoteFileAttributes remoteFileAttributes = (RemoteFileAttributes)treeMap2.get(object2.next());
                    object = new RemoteFile(remoteFileAttributes, this, this.client, this.notify, this.rp, new File(this.file, remoteFileAttributes.getName().getName()), true, remoteFileSystem);
                    ((RemoteFile)object).refresh(remoteFileAttributes);
                    this.childrenvector.addElement(object);
                    this.childrenchanged = true;
                }
                treeSet.removeAll(treeSet2);
            }
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            object2 = (RemoteFileAttributes)treeMap2.get(iterator.next());
            ((RemoteFile)treeMap.get(((RemoteFileAttributes)object2).getName().getName())).refresh((RemoteFileAttributes)object2);
        }
        if (!set.containsAll(set2)) {
            object2 = new TreeSet<Object>(new CaseIgnoreComparator());
            object2.addAll(set2);
            object2.removeAll(set);
            if (!object2.isEmpty()) {
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    object = (String)iterator2.next();
                    remoteFile = (RemoteFile)treeMap.get(object);
                    if (!this.onserver) {
                        remoteFile.onserver = false;
                    }
                    remoteFile.refresh();
                }
            }
        }
        this.children = this.childrenvector.toArray(this.children);
        return this.children;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    protected RemoteFileAttributes getFileAttributes() throws IOException {
        RemoteFileAttributes remoteFileAttributes = this.client.listFile(this.getParent() == null ? "" : this.getParent().getName().getFullName(), this.getName());
        if (remoteFileAttributes == null) {
            return null;
        }
        return remoteFileAttributes;
    }

    public void refresh(boolean bl) throws IOException {
        this.refresh(null, bl);
    }

    public void refresh(RemoteFileAttributes remoteFileAttributes) throws IOException {
        this.refresh(remoteFileAttributes, false);
    }

    public void refresh() throws IOException {
        this.refresh(null, false);
    }

    public Sync.SyncState getClientStatus() {
        return this.clientStatus;
    }

    public Sync.SyncState getServerStatus() {
        return this.serverStatus;
    }

    public String getStatusString() {
        return this.clientStatus + "|" + this.serverStatus;
    }

    public synchronized void copyToServer() throws IOException {
        this.save();
    }

    public synchronized void copyToClient() throws IOException {
        this.load();
    }

    private boolean isFileSaveMode() {
        return Thread.currentThread().getName().startsWith("AWT-EventQueue");
    }

    private boolean isManualRefreshMode() {
        return Thread.currentThread().getName().equals("FTP-Refresh");
    }

    private boolean isGetAllMode() {
        return Thread.currentThread().getName().startsWith("getall");
    }

    private boolean isFolderRefreshMode() {
        return Thread.currentThread().getName().equals("Folder recognizer");
    }

    private boolean isManualSyncMode() {
        return Thread.currentThread().getName().equals("FTP-Synchronize");
    }

    /*
     * Unable to fully structure code
     */
    private void doFileSyncAction(Sync.SyncAction var1_1, boolean var2_2) throws IOException {
        var3_3 = Utils.getStatusLogger((String)this.remoteFS.getLocalRoot(), (String)"sync");
        var4_4 = Utils.getStatusLogger((String)this.remoteFS.getLocalRoot(), (String)"refresh");
        if (this.isManualSyncMode()) {
            var3_3.info("Synchronizing " + this.file.getAbsolutePath());
            StatusDisplayer.getDefault().setStatusText("Synchronizing " + this.file.getAbsolutePath());
        } else if (this.isManualRefreshMode() || this.isFolderRefreshMode()) {
            var4_4.info("Refreshing " + this.file.getAbsolutePath());
            StatusDisplayer.getDefault().setStatusText("Refreshing " + this.file.getAbsolutePath());
        }
        if ((this.file.getName().toLowerCase().endsWith(".pdf") || this.file.getName().toLowerCase().endsWith(".xml")) && !this.file.exists()) {
            try {
                if (this.isManualSyncMode()) {
                    var3_3.info("Getting " + this.getName().getFullName());
                } else if (this.isManualRefreshMode() || this.isFolderRefreshMode()) {
                    var4_4.info("Getting " + this.getName().getFullName());
                }
                this.load();
            }
            catch (IOException var5_5) {
                if (this.isManualSyncMode()) {
                    var3_3.info("Error:" + var5_5.getMessage());
                }
                throw var5_5;
            }
        }
        if (var1_1 == Sync.SyncAction.server_to_client) {
            try {
                if (this.isManualSyncMode() || this.isFolderRefreshMode()) {
                    var3_3.info("Getting " + this.getName().getFullName());
                }
                if (!this.remoteFS.getAutoSync() && !this.isManualSyncMode() || this.isManualRefreshMode()) ** GOTO lbl48
                this.load();
            }
            catch (IOException var5_6) {
                if (this.isManualSyncMode()) {
                    var3_3.info("Error:" + var5_6.getMessage());
                }
                throw var5_6;
            }
        } else if (var1_1 == Sync.SyncAction.client_to_server) {
            try {
                if (this.isManualSyncMode() || this.isFolderRefreshMode()) {
                    var3_3.info("Putting " + this.file.getAbsolutePath());
                }
                if (!this.remoteFS.getAutoSync() && !this.isManualSyncMode() || this.isManualRefreshMode() || this.isGetAllMode()) ** GOTO lbl48
                this.save();
            }
            catch (IOException var5_7) {
                if (this.isManualSyncMode()) {
                    var3_3.info("Error:" + var5_7.getMessage());
                }
                throw var5_7;
            }
        } else if (var1_1 != Sync.SyncAction.none && var1_1 != Sync.SyncAction.remove_from_history && var1_1 != Sync.SyncAction.conflict_dialog && var1_1 == Sync.SyncAction.throw_exception) {
            this.fileOpen = false;
            throw new IOException("invalid state has occured :No such client nor server file");
        }
lbl48:
        // 6 sources

        if (this.fileOpen) {
            if (!(this.getClientStatus() != Sync.SyncState.Missing && this.getClientStatus() != Sync.SyncState.NoSuchFile || this.file.exists())) {
                this.file.createNewFile();
            }
            SyncTablePanelFileOpen.showSyncFiles(this, true);
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        if (!this.file.getName().endsWith("~") && var1_1 == Sync.SyncAction.conflict_dialog && (this.isManualSyncMode() || var2_2)) {
            SyncTablePanel.showSyncFiles(this, false, this.isManualSyncMode());
        }
        StatusDisplayer.getDefault().setStatusText("");
    }

    protected synchronized void refresh(RemoteFileAttributes remoteFileAttributes, boolean bl) throws IOException {
        if (this.isManualSyncMode()) {
            Logger logger = Utils.getStatusLogger((String)this.remoteFS.getLocalRoot(), (String)"sync");
            if (this.remoteFS.getPrintSyncAllStop() && this.remoteFS.getStopSyncAll()) {
                logger.info("Stopped!");
                this.remoteFS.setPrintSyncAllStop(false);
            } else if (this.remoteFS.getPrintSyncAllStop() && this.remoteFS.getRemoteRuntimeType() != null && this.remoteFS.getRemoteRuntimeType().getRemoteServerError()) {
                logger.info("Aborted due to disconnected server!");
                this.remoteFS.setPrintSyncAllStop(false);
            }
            if (this.remoteFS.getStopSyncAll() || this.remoteFS.getRemoteRuntimeType() != null && this.remoteFS.getRemoteRuntimeType().getRemoteServerError()) {
                return;
            }
        }
        try {
            if (!this.remoteFS.isConnected()) {
                return;
            }
            if (this.isDirectory()) {
                boolean bl2;
                String[] stringArray;
                boolean bl3;
                boolean bl4 = bl3 = !this.file.exists();
                if (remoteFileAttributes == null && this.client.isConnected()) {
                    stringArray = this.getFileAttributes();
                    if (stringArray == null) {
                        return;
                    }
                    bl2 = !stringArray.isDirectory() || stringArray.getDate().getTime() == 0L;
                } else {
                    boolean bl5 = bl2 = this.client.isConnected() && this.onserver && remoteFileAttributes != null && remoteFileAttributes.getDate().getTime() == 0L;
                }
                if (bl2) {
                    this.onserver = false;
                }
                if (bl3 && bl2) {
                    this.parent.deleteChild(this);
                    return;
                }
                if (bl3 && !bl2) {
                    if (!this.parent.file.exists()) {
                        this.file.mkdirs();
                    } else {
                        this.file.mkdir();
                    }
                }
                if (!bl2) {
                    this.onserver = true;
                }
                if (!bl3 && bl2) {
                    stringArray = this.file.list();
                    if (stringArray == null || stringArray.length == 0) {
                        this.deleteFile();
                        this.parent.deleteChild(this);
                    } else {
                        this.client.mkdir(this.getName());
                    }
                }
            } else {
                RemoteFileAttributes remoteFileAttributes2 = null;
                if (this.client.isConnected()) {
                    if (remoteFileAttributes == null) {
                        remoteFileAttributes2 = this.getFileAttributes();
                        if (remoteFileAttributes2 == null) {
                            return;
                        }
                    } else {
                        remoteFileAttributes2 = remoteFileAttributes;
                    }
                    this.onserver = false;
                    if (remoteFileAttributes2 != null) {
                        this.onserver = false;
                        if (!(this.onserver || remoteFileAttributes2.getDate().getTime() == 0L && remoteFileAttributes2.getSize() == 0L)) {
                            this.attrib = remoteFileAttributes2;
                            this.onserver = true;
                        }
                    }
                } else {
                    return;
                }
                long l = !this.onserver ? -1L : remoteFileAttributes2.getDate().getTime();
                long l2 = !this.file.exists() ? -1L : this.file.lastModified();
                if (l == -1L && l2 == -1L) {
                    this.parent.deleteChild(this);
                    this.fileOpen = false;
                    return;
                }
                this.clientStatus = Sync.getSyncState(this.cachelastmodified, l2);
                this.serverStatus = Sync.getSyncState(this.serverlastmodified, l);
                Sync.SyncAction syncAction = this.isManualSyncMode() || this.file.getName().endsWith(".class") ? Sync.getManualSyncAction(this.clientStatus, this.serverStatus) : Sync.getAction(this.clientStatus, this.serverStatus);
                if (this.getFileResidenceMode() == 1 || this.getFileResidenceMode() == 0 && !this.isFolderRefreshMode()) {
                    syncAction = Sync.SyncAction.none;
                }
                this.doFileSyncAction(syncAction, bl);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            this.fileOpen = false;
        }
    }

    public void downloadAll(InputOutput inputOutput) throws IOException {
        if (!this.client.isConnected()) {
            return;
        }
        Logger logger = Utils.getStatusLogger((String)this.remoteFS.getLocalRoot(), (String)"getall");
        if (this.isDirectory()) {
            if (!this.file.exists()) {
                StatusDisplayer.getDefault().setStatusText("Creating " + this.file.getAbsolutePath());
                logger.info("Creating " + this.file.getAbsolutePath());
                this.file.mkdirs();
            }
            this.getChildren(this.remoteFS);
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                if (!this.children[i].remoteFS.getStopDownloadAll()) {
                    if (this.children[i].getFileResidenceMode() == 1 || this.children[i].getFileResidenceMode() == 0) continue;
                    this.children[i].downloadAll(inputOutput);
                    this.children[i].refresh();
                    continue;
                }
                break;
            }
        } else if (this.onserver) {
            StatusDisplayer.getDefault().setStatusText("Getting " + this.getName().getFullName());
            logger.info("Getting " + this.getName().getFullName());
            this.load();
        } else {
            StatusDisplayer.getDefault().setStatusText(this.getName().getFullName() + " does not exist");
            logger.info(this.getName().getFullName() + " does not exist");
        }
    }

    public void uploadAll(InputOutput inputOutput) throws IOException {
        if (!this.client.isConnected()) {
            return;
        }
        Logger logger = Utils.getStatusLogger((String)this.remoteFS.getLocalRoot(), (String)"putall");
        if (this.isDirectory()) {
            if (!this.onserver) {
                StatusDisplayer.getDefault().setStatusText("Creating " + this.getName().getFullName());
                logger.log(Level.INFO, "Creating " + this.getName().getFullName());
                this.client.mkdir(this.getName());
            }
            this.onserver = true;
            this.getChildren(this.remoteFS);
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                if (!this.children[i].remoteFS.getStopUploadAll() && this.children[i].remoteFS.getRemoteRuntimeType() != null && !this.children[i].remoteFS.getRemoteRuntimeType().getRemoteServerError()) {
                    if (this.children[i].getFileResidenceMode() == 1) continue;
                    this.children[i].uploadAll(inputOutput);
                    this.children[i].refresh();
                    continue;
                }
                break;
            }
        } else if (this.file.exists()) {
            StatusDisplayer.getDefault().setStatusText("Putting " + this.file.getAbsolutePath());
            logger.info("Putting " + this.file.getAbsolutePath());
            this.save();
        } else {
            StatusDisplayer.getDefault().setStatusText(this.file.getAbsolutePath() + " does not exist");
            logger.info(this.file.getAbsolutePath() + " does not exist");
        }
    }

    public void cleanCache() throws IOException {
        if (this.isDirectory()) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                this.children[i].cleanCache();
            }
        } else {
            this.file.delete();
            String string = this.file.getAbsolutePath().substring(this.remoteFS.getLocalRoot().length());
            this.remoteFS.setFileAttribute(string, LAST_MODIFIED_CACHE, null);
        }
    }

    public String[] getStringChildren(RemoteFileSystem remoteFileSystem) throws IOException {
        this.getChildren(remoteFileSystem);
        String[] stringArray = new String[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == null) continue;
            String string = this.children[i].getName().getName();
            stringArray[i] = string.endsWith(".JAVA") ? string.replaceAll("\\.JAVA", ".java") : (string.endsWith(".CLASS") ? string.replaceAll("\\.CLASS", ".class") : (string.endsWith(".JAR") ? string.replaceAll("\\.JAR", ".jar") : string));
        }
        return stringArray;
    }

    public RemoteFile getChild(String string) throws IOException {
        this.getChildren(this.remoteFS);
        return this.getExistingChild(string);
    }

    public RemoteFile getExistingChild(String string) throws IOException {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == null || !this.children[i].getName().getName().equalsIgnoreCase(string)) continue;
            return this.children[i];
        }
        return null;
    }

    public RemoteFile find(String string) throws IOException {
        RemoteFile remoteFile = this;
        StringTokenizer stringTokenizer = new StringTokenizer(string, PATH_SEP);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            RemoteFile remoteFile2 = remoteFile.getExistingChild(string2);
            if (remoteFile2 == null) {
                remoteFile2 = remoteFile.getChild(string2);
            }
            if ((remoteFile = remoteFile2) != null) continue;
            break;
        }
        return remoteFile;
    }

    public RemoteFile getParent() {
        return this.parent;
    }

    public boolean isDirectory() {
        return this.attrib.isDirectory();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public RemoteFileName getName() {
        return this.attrib.getName();
    }

    protected void load() throws IOException {
        if (!this.client.isConnected()) {
            return;
        }
        if (this.isDirectory()) {
            return;
        }
        try {
            Object object;
            if (!this.client.isConnected()) {
                return;
            }
            String string = this.file.getAbsolutePath().substring(this.remoteFS.getLocalRoot().length() + 1);
            string = string.replace(File.separatorChar, '/');
            boolean bl = false;
            if (this.file.getName().toLowerCase().endsWith(".jar") || this.file.getName().toLowerCase().endsWith(".class")) {
                this.client.get(this.getName(), this.file, false);
                bl = true;
            } else if (this.file.getName().toLowerCase().endsWith(".form") || this.file.getName().endsWith("~")) {
                this.client.get(this.getName(), this.file, true);
                bl = true;
            } else if (this.remoteFS.getAsciiFileExts().isRegistered(string.substring(string.lastIndexOf(46) >= 0 ? string.lastIndexOf(46) : 0))) {
                this.client.get(this.getName(), this.file, true);
                bl = true;
            } else if (this.mimeType != null && this.mimeType.startsWith("text")) {
                this.client.get(this.getName(), this.file, true);
                bl = true;
            } else {
                object = (Boolean)this.remoteFS.getFileAttribute(string, "org.netbeans.modules.text.IsTextFile");
                if (object != null && ((Boolean)object).booleanValue()) {
                    this.client.get(this.getName(), this.file, true);
                    bl = true;
                } else {
                    this.mimeType = FileUtil.getMIMEType((String)string.substring(string.lastIndexOf(46) >= 0 ? string.lastIndexOf(46) + 1 : 0));
                    if (this.mimeType != null && this.mimeType.startsWith("text")) {
                        this.client.get(this.getName(), this.file, true);
                        bl = true;
                    } else {
                        this.client.get(this.getName(), this.file, false);
                        bl = true;
                    }
                }
            }
            object = this.getFileAttributes();
            if (bl) {
                if (object != null) {
                    this.attrib = object;
                    this.cachelastmodified = this.file.lastModified();
                    this.serverlastmodified = this.attrib.getDate().getTime();
                    this.remoteFS.setFileAttribute(string, LAST_MODIFIED_SERVER, new Long(this.serverlastmodified));
                    this.remoteFS.setFileAttribute(string, LAST_MODIFIED_CACHE, new Long(this.cachelastmodified));
                    this.clientStatus = Sync.SyncState.UpToDate;
                    this.serverStatus = Sync.SyncState.UpToDate;
                } else {
                    this.clientStatus = Sync.SyncState.Unknown;
                    this.serverStatus = Sync.SyncState.Unknown;
                }
            }
        }
        catch (IOException iOException) {
            if (iOException.getMessage().startsWith("550")) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(" File Name: " + FileUtility.unixPathToOpenVMSPath((String)RemoteFile.this.getName().getFullName(), (boolean)RemoteFile.this.isDirectory()) + "\n" + iOException.getMessage()), 2));
                    }
                });
            }
            throw iOException;
        }
        if (this.getName() != null) {
            StatusDisplayer.getDefault().setStatusText("");
        }
    }

    protected void save() throws IOException {
        Logger logger = Utils.getStatusLogger((String)this.remoteFS.getLocalRoot(), (String)"refresh");
        if (!this.file.exists()) {
            return;
        }
        if (!this.isDirectory()) {
            if (!this.client.isConnected()) {
                return;
            }
            try {
                Object object;
                String string = this.file.getAbsolutePath().substring(this.remoteFS.getLocalRoot().length() + 1);
                string = string.replace(File.separatorChar, '/');
                boolean bl = false;
                if ((this.file.getName().indexOf(42) >= 0 || this.file.getName().indexOf(37) >= 0) && this.fileResidenceMode != 1) {
                    this.fileResidenceMode = 1;
                    this.remoteFS.setFileAttribute(string, "file_residence_mode", new Integer(this.fileResidenceMode));
                    logger.info(this.file.getName() + " did not get copied to the server due to the illegal file name!");
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("The filename, \"" + RemoteFile.this.file.getName() + "\" ,contains the '*' or '%' character, which are not legal EFS characters on OpenVMS. The FTP residence of the file has been changed to client-only."), 2));
                        }
                    });
                } else if (this.file.getName().toLowerCase().endsWith(".jar") || this.file.getName().toLowerCase().endsWith(".class") || this.file.getName().toLowerCase().endsWith(".nbm")) {
                    if (!this.remoteFS.checkAndupdateRemoteServerError(string)) {
                        this.client.put(this.file, this.getName(), false);
                        this.remoteFS.changeBinFileToSTRMLF(FileUtility.unixPathToOpenVMSPath((String)this.getName().getFullName(), (boolean)false));
                        bl = true;
                    } else if (this.isManualRefreshMode() || this.isFolderRefreshMode()) {
                        logger.info(this.file.getName() + " did not get copied to the server due to the disconnected remote server!");
                        StatusDisplayer.getDefault().setStatusText(this.file.getName() + " did not get copied to the server due to the disconnected remote server!");
                    }
                } else if (this.file.getName().toLowerCase().endsWith(".form") || this.file.getName().endsWith("~")) {
                    FileUtility.fixCRLF((File)this.file);
                    this.client.put(this.file, this.getName(), true);
                    bl = true;
                } else if (this.remoteFS.getAsciiFileExts().isRegistered(string.substring(string.lastIndexOf(46) >= 0 ? string.lastIndexOf(46) : 0))) {
                    FileUtility.fixCRLF((File)this.file);
                    this.client.put(this.file, this.getName(), true);
                    bl = true;
                } else if (this.mimeType != null && this.mimeType.startsWith("text")) {
                    FileUtility.fixCRLF((File)this.file);
                    this.client.put(this.file, this.getName(), true);
                    bl = true;
                } else {
                    object = (Boolean)this.remoteFS.getFileAttribute(string, "org.netbeans.modules.text.IsTextFile");
                    if (object != null && ((Boolean)object).booleanValue()) {
                        FileUtility.fixCRLF((File)this.file);
                        this.client.put(this.file, this.getName(), true);
                        bl = true;
                    } else {
                        this.mimeType = FileUtil.getMIMEType((String)string.substring(string.lastIndexOf(46) >= 0 ? string.lastIndexOf(46) + 1 : 0));
                        if (this.mimeType != null && this.mimeType.startsWith("text")) {
                            FileUtility.fixCRLF((File)this.file);
                            this.client.put(this.file, this.getName(), true);
                            bl = true;
                        } else {
                            this.client.put(this.file, this.getName(), false);
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    object = this.getFileAttributes();
                    if (object != null) {
                        this.attrib = object;
                        this.serverlastmodified = this.attrib.getDate().getTime();
                        this.cachelastmodified = this.file.lastModified();
                        this.onserver = true;
                        this.remoteFS.setFileAttribute(string, LAST_MODIFIED_SERVER, new Long(this.serverlastmodified));
                        this.remoteFS.setFileAttribute(string, LAST_MODIFIED_CACHE, new Long(this.cachelastmodified));
                        this.clientStatus = Sync.SyncState.UpToDate;
                        this.serverStatus = Sync.SyncState.UpToDate;
                    } else {
                        this.clientStatus = Sync.SyncState.Unknown;
                        this.serverStatus = Sync.SyncState.Unknown;
                    }
                } else {
                    this.onserver = false;
                }
            }
            catch (IOException iOException) {
                if (iOException.getMessage().startsWith("550")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(" File Name: " + FileUtility.unixPathToOpenVMSPath((String)RemoteFile.this.getName().getFullName(), (boolean)RemoteFile.this.isDirectory()) + "\n" + iOException.getMessage()), 2));
                        }
                    });
                }
                throw iOException;
            }
        }
        StatusDisplayer.getDefault().setStatusText("");
    }

    public InputStream getInputStream() throws IOException {
        if (this.isDirectory()) {
            throw new FileNotFoundException("Can't get inputstream from directory " + this.file.getPath());
        }
        this.fileOpen = true;
        this.refresh();
        if (!this.file.exists()) {
            return null;
        }
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isDirectory()) {
            throw new IOException("Can't get outputstream from directory " + this.file.getPath());
        }
        return new RemoteOutputStream(this);
    }

    public long getSize() throws IOException {
        return this.file.length();
    }

    public boolean isReadOnly() {
        return false;
    }

    public Date lastModified() throws IOException {
        long l = this.file.lastModified();
        if (l == 0L) {
            long l2 = l = this.attrib != null ? this.attrib.getDate().getTime() : 0L;
            if (l == 0L) {
                l = new Date().getTime();
            }
        }
        return new Date(l);
    }

    protected void deleteFile() throws IOException {
        if (this.isDirectory()) {
            this.getChildren(this.remoteFS);
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] != null && !this.onserver) {
                    this.children[i].onserver = false;
                }
                if (this.children[i] == null) continue;
                this.children[i].deleteFile();
            }
            new File(this.file, ".nbattrs").delete();
            this.children = new RemoteFile[0];
            this.childrenchanged = true;
            this.childrenvector.removeAllElements();
            if (this.onserver && this.client.isConnected()) {
                this.client.rmdir(this.getName());
            }
        } else {
            if (this.onserver && this.client.isConnected()) {
                this.client.delete(this.getName());
            }
            String string = this.file.getAbsolutePath().substring(this.remoteFS.getLocalRoot().length() + 1);
            string = string.replace(File.separatorChar, '/');
            this.remoteFS.setFileAttribute(string, LAST_MODIFIED_SERVER, null);
            this.remoteFS.setFileAttribute(string, LAST_MODIFIED_CACHE, null);
            this.remoteFS.setFileAttribute(string, "file_residence_mode", null);
        }
        if (this.file.exists()) {
            this.file.delete();
        }
    }

    public void delete() throws IOException {
        this.deleteFile();
        this.parent.deleteChild(this);
    }

    public void deleteServerFile() throws IOException {
        if (this.onserver && this.client.isConnected()) {
            this.client.delete(this.getName());
        }
        String string = this.file.getAbsolutePath().substring(this.remoteFS.getLocalRoot().length() + 1);
        string = string.replace(File.separatorChar, '/');
        this.remoteFS.setFileAttribute(string, LAST_MODIFIED_SERVER, null);
        this.serverStatus = Sync.SyncState.NoSuchFile;
    }

    public void deleteClientFile() throws IOException {
        if (this.file.exists()) {
            // empty if block
        }
        if (this.file.delete()) {
            String string = this.file.getAbsolutePath().substring(this.remoteFS.getLocalRoot().length() + 1);
            string = string.replace(File.separatorChar, '/');
            this.remoteFS.setFileAttribute(string, LAST_MODIFIED_CACHE, null);
            this.clientStatus = Sync.SyncState.NoSuchFile;
        }
    }

    protected void deleteChild(RemoteFile remoteFile) {
        this.childrenvector.removeElement(remoteFile);
        this.children = this.childrenvector.toArray(this.children);
        this.childrenchanged = true;
    }

    public void rename(String string) throws IOException {
        if (this.isRoot()) {
            throw new IOException("Cannot rename root of filesystem");
        }
        if (this.parent.getChild(string) != null && !string.equalsIgnoreCase(".nbattrs~")) {
            throw new IOException("File " + this.getName().getFullName() + PATH_SEP + string + " already exists");
        }
        if (this.client.isConnected()) {
            this.client.rename(this.getName(), string);
        } else {
            this.onserver = false;
        }
        this.attrib.getName().setName(string);
        File file = new File(this.file.getParentFile(), string);
        this.file.renameTo(file);
        this.file = file;
    }

    public RemoteFile createData(String string, RemoteFileSystem remoteFileSystem) throws IOException {
        if (this.getChild(string) != null) {
            throw new IOException("File " + this.getName().getFullName() + PATH_SEP + string + " already exists");
        }
        return this.createFile(new RemoteFileAttributes(this.getName().createNew(string, false), false), false, remoteFileSystem);
    }

    public RemoteFile createFolder(String string, RemoteFileSystem remoteFileSystem) throws IOException {
        if (this.getChild(string) != null) {
            throw new IOException("Folder " + this.getName().getFullName() + PATH_SEP + string + " already exists");
        }
        return this.createFile(new RemoteFileAttributes(this.getName().createNew(string, true), true), false, remoteFileSystem);
    }

    private RemoteFile createFile(RemoteFileAttributes remoteFileAttributes, boolean bl, RemoteFileSystem remoteFileSystem) throws IOException {
        RemoteFile remoteFile = new RemoteFile(remoteFileAttributes, this, this.client, this.notify, this.rp, new File(this.file, remoteFileAttributes.getName().getName()), bl, remoteFileSystem);
        File file = new File(this.file, remoteFileAttributes.getName().getName());
        if (!file.exists()) {
            boolean bl2;
            boolean bl3 = bl2 = !file.createNewFile();
            boolean bl4 = bl2 ? true : (bl2 = !file.exists());
            if (bl2) {
                throw new IOException("Error creating a new file " + file.getAbsolutePath() + " on a local disk");
            }
        }
        this.childrenvector.addElement(remoteFile);
        this.childrenchanged = true;
        this.children = this.childrenvector.toArray(this.children);
        return remoteFile;
    }

    public File getCacheFile() {
        return this.file;
    }

    public RemoteFileSystem getRemoteFS() {
        return this.remoteFS;
    }

    public void setFileResidenceMode(int n, FileObject fileObject) throws IOException {
        if (this.fileResidenceMode == n) {
            return;
        }
        if (this.fileResidenceMode == 1) {
            if (n == 0) {
                // empty if block
            }
            if (n == 2) {
                this.fileResidenceMode = n;
                fileObject.setAttribute("file_residence_mode", (Object)new Integer(this.fileResidenceMode));
            }
        } else if (this.fileResidenceMode == 0) {
            if (n == 1) {
                // empty if block
            }
            if (n == 2) {
                this.fileResidenceMode = n;
                fileObject.setAttribute("file_residence_mode", (Object)new Integer(this.fileResidenceMode));
            }
        } else if (this.fileResidenceMode == 2) {
            if (n == 0) {
                if (this.getServerStatus() != Sync.SyncState.Missing && this.getServerStatus() != Sync.SyncState.NoSuchFile) {
                    this.deleteClientFile();
                    this.fileResidenceMode = n;
                }
            } else if (this.getClientStatus() != Sync.SyncState.Missing && this.getClientStatus() != Sync.SyncState.NoSuchFile) {
                this.deleteServerFile();
                this.fileResidenceMode = n;
            }
            fileObject.setAttribute("file_residence_mode", (Object)new Integer(this.fileResidenceMode));
        }
    }

    public int getFileResidenceMode() {
        if (this.remoteFS.getServerOnlyFileExts().isRegistered(this.file.getName())) {
            return 0;
        }
        return this.fileResidenceMode;
    }

    public boolean equals(Object object) {
        return this.file.getAbsolutePath().equalsIgnoreCase(((RemoteFile)object).file.getAbsolutePath());
    }

    static interface RequestProcessor {
        public void post(Runnable var1);
    }

    static interface Notify {
        public boolean isRefreshServer();

        public boolean isScanCache();

        public boolean isAlwaysRefresh();

        public void setAlwaysRefresh(boolean var1);

        public int notifyWhichFile(String var1, Date var2, long var3, Date var5, long var6);

        public int notifyBothFilesChanged(String var1, Date var2, long var3, Date var5, long var6);

        public boolean isDownloadServerChangedFile();

        public boolean notifyServerChanged(String var1, Date var2, long var3, Date var5, long var6);

        public boolean notifyCacheExtDelete(String var1, boolean var2);

        public boolean notifyServerExtDelete(String var1, boolean var2);

        public void fileChanged(String var1);

        public void notifyException(Exception var1);
    }

    class CaseIgnoreComparator
    implements Comparator {
        CaseIgnoreComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((String)object).toLowerCase().compareTo(((String)object2).toLowerCase());
        }

        public boolean equals(Object object) {
            return true;
        }
    }
}

