/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteJarFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkJarFileSystem;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class RemoteFSUtils {
    public static String _winPathToOpenVMSPath(String string, boolean bl, FileObject fileObject) {
        String string2 = string;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (fileObject.getFileSystem() instanceof FTPFileSystem) {
                FTPFileSystem fTPFileSystem = (FTPFileSystem)fileObject.getFileSystem();
                hashMap.put("REMOTE_ROOT", fTPFileSystem.getRemoteRoot());
                hashMap.put("LCOAL_ROOT", fTPFileSystem.getCache().getAbsolutePath());
            } else if (fileObject.getFileSystem() instanceof NetworkFileSystem) {
                NetworkFileSystem networkFileSystem = (NetworkFileSystem)fileObject.getFileSystem();
                hashMap.put("REMOTE_ROOT", networkFileSystem.getRemoteRoot());
                hashMap.put("LCOAL_ROOT", networkFileSystem.getRootDirectory().getAbsolutePath());
            } else {
                NetworkJarFileSystem networkJarFileSystem = (NetworkJarFileSystem)fileObject.getFileSystem();
                hashMap.put("REMOTE_ROOT", networkJarFileSystem.getRemoteJarRoot().getRemoteJarRoot());
                hashMap.put("LCOAL_ROOT", networkJarFileSystem.getJarFile().getAbsolutePath());
            }
            string2 = FileUtility.winPathToOpenVMSPath((String)string, (boolean)bl, hashMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String __winPathToOpenVMSPath(String string, boolean bl) {
        FileObject[] fileObjectArray = FileUtil.fromFile((File)new File(string));
        for (int i = 0; i < fileObjectArray.length; ++i) {
            try {
                if (!(fileObjectArray[i].getFileSystem() instanceof NetworkFileSystem) && !(fileObjectArray[i].getFileSystem() instanceof FTPFileSystem)) continue;
                return RemoteFSUtils._winPathToOpenVMSPath(string, bl, fileObjectArray[i]);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        Iterator iterator = OpenProjectList.getFsSet().iterator();
        while (iterator.hasNext()) {
            NetworkJarFileSystem networkJarFileSystem;
            Object e = iterator.next();
            if (!(e instanceof NetworkJarFileSystem) || !string.equals((networkJarFileSystem = (NetworkJarFileSystem)e).getJarFile().getAbsolutePath())) continue;
            return RemoteFSUtils._winPathToOpenVMSPath(string, false, networkJarFileSystem.getRoot());
        }
        return string;
    }

    public static String __unixPathToOpenVMSPath(String string, boolean bl) {
        FileObject[] fileObjectArray = FileUtil.fromFile((File)new File(string));
        for (int i = 0; i < fileObjectArray.length; ++i) {
            try {
                if (!(fileObjectArray[i].getFileSystem() instanceof NetworkFileSystem) && !(fileObjectArray[i].getFileSystem() instanceof FTPFileSystem)) continue;
                return RemoteFSUtils.unixPathToOpenVMSPath(string, bl, fileObjectArray[i]);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        Iterator iterator = OpenProjectList.getFsSet().iterator();
        while (iterator.hasNext()) {
            NetworkJarFileSystem networkJarFileSystem;
            Object e = iterator.next();
            if (!(e instanceof NetworkJarFileSystem) || !string.equals((networkJarFileSystem = (NetworkJarFileSystem)e).getJarFile().getAbsolutePath())) continue;
            return RemoteFSUtils.unixPathToOpenVMSPath(string, false, networkJarFileSystem.getRoot());
        }
        return string;
    }

    public static String unixPathToOpenVMSPath(String string, boolean bl, FileObject fileObject) {
        String string2 = string;
        try {
            String string3;
            String string4;
            Object object;
            HashMap hashMap = new HashMap();
            if (fileObject.getFileSystem() instanceof FTPFileSystem) {
                object = (FTPFileSystem)fileObject.getFileSystem();
                string4 = FileUtility.openVMSPathToUnixPath((String)((FTPFileSystem)object).getRemoteRoot(), (boolean)true);
                string3 = string2.substring(((FTPFileSystem)object).getCache().getAbsolutePath().length());
            } else if (fileObject.getFileSystem() instanceof NetworkFileSystem) {
                object = (NetworkFileSystem)fileObject.getFileSystem();
                string4 = FileUtility.openVMSPathToUnixPath((String)((NetworkFileSystem)object).getRemoteRoot(), (boolean)true);
                string3 = string2.substring(object.getRootDirectory().getAbsolutePath().length());
            } else {
                object = (NetworkJarFileSystem)fileObject.getFileSystem();
                string4 = FileUtility.openVMSPathToUnixPath((String)((RemoteJarFileSystem)object).getRemoteJarRoot().getRemoteJarRoot(), (boolean)true);
                string3 = string2.substring(object.getJarFile().getAbsolutePath().length());
            }
            object = string4 + (string3.indexOf(47) == 0 ? "" : "/") + string3;
            string2 = FileUtility.unixPathToOpenVMSPath((String)object, (boolean)bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String getRemoteJarShare(RemoteRuntimeType remoteRuntimeType, String string) {
        String string2 = FileUtility.getShareName((String)string);
        String string3 = "";
        String string4 = "";
        if (string2.length() > 0) {
            if (Utilities.isWindows()) {
                string3 = string2;
            } else {
                string3 = string2.substring(0, string2.indexOf(10));
                string4 = string2.substring(string2.indexOf(10) + 1, string2.length());
            }
            try {
                String string5 = remoteRuntimeType.getNetworkShareRoot(string3);
                if (string5 != null) {
                    return RemoteFSUtils.createRemoteJarFile(string5, string, string4);
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        return "";
    }

    private static String createRemoteJarFile(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        StringBuffer stringBuffer2 = new StringBuffer(string);
        String string4 = null;
        String string5 = null;
        if (Utilities.isWindows()) {
            string4 = string2.substring(string2.lastIndexOf(92) + 1);
            stringBuffer.delete(string2.lastIndexOf(92), string2.length());
            stringBuffer.delete(0, 2);
            string5 = stringBuffer.toString().replace('\\', '.');
        } else {
            string4 = string2.substring(string2.lastIndexOf(47) + 1);
            stringBuffer.delete(string2.lastIndexOf(47), string2.length());
            if (string3.length() > 0) {
                stringBuffer.delete(0, string3.length());
            }
            string5 = stringBuffer.toString().replace('/', '.');
        }
        if (string.endsWith("]")) {
            stringBuffer2.deleteCharAt(string.length() - 1);
        } else {
            stringBuffer2.append('[');
        }
        stringBuffer2.append(string5);
        stringBuffer2.append("]");
        stringBuffer2.append(string4);
        return stringBuffer2.toString();
    }

    public static String getServerOS(RemoteRuntimeType remoteRuntimeType) {
        String string = "";
        if (remoteRuntimeType == null || remoteRuntimeType.getRemoteRuntime() == null) {
            return string;
        }
        try {
            string = remoteRuntimeType.getRemoteRuntime().getOperatingSystem();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace(System.err);
        }
        return string;
    }

    public static File toFile(FileObject fileObject) {
        return (File)fileObject.getAttribute("java.io.File");
    }

    private static String getSearchRoot(String string, AbstractNetworkFileSystem abstractNetworkFileSystem) {
        RemoteRuntimeType remoteRuntimeType = abstractNetworkFileSystem.getRemoteRuntimeType();
        String string2 = string;
        if (RemoteFSUtils.getServerOS(remoteRuntimeType).equals(Utils.OS_VMS)) {
            string2 = string.endsWith(":") ? string : string.substring(0, string.length() - 1);
        }
        return string2;
    }

    public static void refreshParent(String string, String string2, char c, FileSystem fileSystem) {
        String string3 = string.substring(string2.length() + 1);
        string3 = string3.lastIndexOf(c) > 0 ? string3.substring(0, string3.lastIndexOf(c)).replace(c, '/') : "";
        FileObject fileObject = fileSystem.findResource(string3);
        if (fileObject != null) {
            fileObject.refresh();
        }
    }

    private static String getClientPath(String string, String string2, AbstractNetworkFileSystem abstractNetworkFileSystem) {
        RemoteRuntimeType remoteRuntimeType = abstractNetworkFileSystem.getRemoteRuntimeType();
        if (RemoteFSUtils.getServerOS(remoteRuntimeType).equals(Utils.OS_VMS)) {
            if (Utilities.isWindows()) {
                return FileUtility.openVMSPathToWinPath((String)string, (boolean)false, (String)abstractNetworkFileSystem.getLocalRoot(), (String)string2);
            }
            if (Utilities.isUnix()) {
                return FileUtility.openVMSPathToUnixPath((String)string, (boolean)false);
            }
            if (Utilities.getOperatingSystem() == 16384) {
                return FileUtility.openVMSPathToUnixPath((String)string, (boolean)false);
            }
        }
        return string;
    }

    public static FileObject[] fromFile(String string) {
        FileObject[] fileObjectArray;
        Iterator iterator = OpenProjectList.getFsSet().iterator();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        while (iterator.hasNext()) {
            fileObjectArray = (FileObject[])iterator.next();
            if (!(fileObjectArray instanceof NetworkFileSystem) && !(fileObjectArray instanceof FTPFileSystem)) continue;
            try {
                File file;
                FileObject fileObject;
                String string2;
                AbstractNetworkFileSystem abstractNetworkFileSystem = (AbstractNetworkFileSystem)fileObjectArray;
                File file2 = RemoteFSUtils.toFile(fileObjectArray.getRoot());
                if (file2 == null) continue;
                String string3 = file2.getCanonicalPath();
                String string4 = abstractNetworkFileSystem.getRemoteRoot();
                String string5 = RemoteFSUtils.getSearchRoot(string4, abstractNetworkFileSystem);
                if (string.toLowerCase().indexOf(string5.toLowerCase()) == 0 && (string.charAt(string4.length() - 1) == '.' || string.charAt(string4.length() - 1) == ']')) {
                    string = RemoteFSUtils.getClientPath(string, string4, abstractNetworkFileSystem);
                    string2 = string.substring(string3.length()).replace(File.separatorChar, '/');
                    RemoteFSUtils.refreshParent(string, string3, File.separatorChar, (FileSystem)fileObjectArray);
                    fileObject = fileObjectArray.findResource(string2);
                    File file3 = file = fileObject != null ? RemoteFSUtils.toFile(fileObject) : null;
                    if (fileObject == null || file == null) continue;
                    arrayList.add(fileObject);
                    continue;
                }
                if (RemoteFSUtils.getServerOS(abstractNetworkFileSystem.getRemoteRuntimeType()).toLowerCase().indexOf(Utils.OS_VMS.toLowerCase()) < 0) continue;
                string4 = FileUtility.openVMSPathToUnixPath((String)string4, (boolean)true);
                if (string.toLowerCase().indexOf(string4.toLowerCase()) != 0 || string.charAt(string4.length()) != '/') continue;
                string2 = string.substring(string4.length() + 1);
                RemoteFSUtils.refreshParent(string, string4, '/', (FileSystem)fileObjectArray);
                fileObject = fileObjectArray.findResource(string2);
                File file4 = file = fileObject != null ? RemoteFSUtils.toFile(fileObject) : null;
                if (fileObject == null || file == null) continue;
                arrayList.add(fileObject);
            }
            catch (IOException iOException) {}
        }
        fileObjectArray = new FileObject[arrayList.size()];
        arrayList.toArray(fileObjectArray);
        return fileObjectArray;
    }
}

