/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.pascalsupport.pascal.datasys;

import com.hp.openvms.netbeans.baseclasses.actions.RemoteCompilerAction;
import com.hp.openvms.netbeans.pascalsupport.pascal.PascalCompiler;
import com.hp.openvms.netbeans.pascalsupport.pascal.PascalCompilerGroup;
import com.hp.openvms.netbeans.pascalsupport.pascal.PascalCompilerType;
import com.hp.openvms.netbeans.pascalsupport.pascal.datasys.PascalDataNode;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.cookies.RemoteBuildCookie;
import org.netbeans.modules.distributed.common.cookies.RemoteCompileCookie;
import org.netbeans.modules.distributed.common.propertyeditors.BoolEditor;
import org.netbeans.modules.distributed.common.propertyeditors.NbProcessDescriptorEditor2;
import org.netbeans.modules.distributed.common.propertyeditors.StringEditor2;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.propertyeditor.FileEditor;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.ErrorManager;
import org.openide.compiler.CompilerSupport;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PascalCompilerSupport
extends CompilerSupport {
    public static final String PROP_DEFINE = "PascalDefine";
    public static final String PROP_BUILD_OPTION = "buildOption";
    public static final String PROP_OPTIMIZE = "optimize";
    public static final String PROP_CHECK = "check";
    public static final String PROP_OPTIONS = "options";
    public static final String PROP_BUILD_DIRECTORY = "buildDirectory";
    public static final String PROP_OBJECT_DIRECTORY = "objectDirectory";
    public static final String PROP_LIST_DIRECTORY = "listDirectory";
    public static final String PROP_OUTPUT_SWITCH = "outputSwitch";
    public static final String PROP_BUILD_COMMAND = "buildCommand";
    public static final String PROP_INCLUDE = "include";
    public static final String PROP_LIBRARY = "library";
    public static final String PROP_DEBUG = "debug";
    public static final String PROP_OTHER_OPTIONS = "otherOptions";
    public static final String PROP_EXTERNAL_COMPILER = "externalCompiler";
    public static final String PROP_MAKEFILE_COMPILER = "makefileCompiler";
    public static final String PROP_PASCAL_GLOBAL_QUALIFIER = "globalQualifier";
    public static final String PROP_PASCAL_LOCAL_QUALIFIER = "localQualifier";
    protected static final ResourceBundle bundle = NbBundle.getBundle((Class)PascalCompilerSupport.class);
    protected MultiDataObject.Entry entry;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile;
    static /* synthetic */ Class class$org$openide$execution$NbProcessDescriptor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Build;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Clean;
    static /* synthetic */ Class class$org$netbeans$modules$distributed$common$cookies$RemoteCompileCookie;
    static /* synthetic */ Class class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie;

    protected PascalCompilerSupport(MultiDataObject.Entry entry, Class clazz) {
        super(entry, clazz);
        this.entry = entry;
    }

    protected PascalCompilerType getProjCompilerType() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.getFileObject());
        if (project != null) {
            RemoteProjectSettings remoteProjectSettings = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
            if (remoteProjectSettings == null) {
                return new PascalCompilerType(this.getFileObject());
            }
            return (PascalCompilerType)((Object)remoteProjectSettings.getCompilerSettings("pascal"));
        }
        return null;
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createExternalCompilerProperty());
        set.put((Node.Property)this.createPascalLocalQualifierProperty());
        set.put((Node.Property)this.createPascalGlobalQualifierProperty());
    }

    public void addBuildOptionProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildOptionProperty());
    }

    public void addMakefileProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildDirectoryProperty());
        set.put((Node.Property)this.createMakefileCompilerProperty());
        set.put((Node.Property)this.createBuildCommandProperty());
        set.put((Node.Property)this.createOutputSwitchProperty());
        set.put((Node.Property)this.createXDisplayDeviceNumber());
    }

    public void addRemoteProperties(Sheet.Set set) {
        set.put((Node.Property)this.createRemoteFilePathProperty());
        try {
            if (this.entry.getFile().getFileSystem() instanceof FTPFileSystem) {
                set.put((Node.Property)this.createFileResidenceProperty());
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public Boolean getBuildOption() {
        Boolean bl = (Boolean)this.entry.getFile().getAttribute(PROP_BUILD_OPTION);
        if (bl == null) {
            return (Boolean)this.getProjCompilerType().getBuildOption();
        }
        return bl;
    }

    private synchronized void setBuildOption(Boolean bl) throws IOException {
        Node node = this.entry.getDataObject().getNodeDelegate();
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        if (bl == null) {
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, null);
            return;
        }
        if (node instanceof PascalDataNode) {
            if (bl.equals(Boolean.TRUE)) {
                propertySetArray[1].setHidden(true);
                propertySetArray[2].setHidden(false);
            } else {
                propertySetArray[1].setHidden(false);
                propertySetArray[2].setHidden(true);
            }
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, (Object)bl);
            ((PascalDataNode)node).firePropertySetChange2(null, propertySetArray);
        }
    }

    public RemoteFSFile getBuildDirectory() {
        Object object = this.entry.getFile().getAttribute(PROP_BUILD_DIRECTORY);
        if (object == null || object instanceof RemoteFSFile && ((RemoteFSFile)object).getAbsolutePath().equals("")) {
            return this.getProjCompilerType().getBuildDirectory();
        }
        if (object != null && !(object instanceof RemoteFSFile)) {
            try {
                this.entry.getFile().setAttribute(PROP_BUILD_DIRECTORY, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getBuildDirectory();
        }
        return (RemoteFSFile)object;
    }

    private synchronized void setBuildDirectory(RemoteFSFile remoteFSFile) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_DIRECTORY, (Object)remoteFSFile);
    }

    public Boolean getOutputSwitch() {
        Boolean bl = (Boolean)this.entry.getFile().getAttribute(PROP_OUTPUT_SWITCH);
        if (bl == null) {
            return this.getProjCompilerType().outputSwitch();
        }
        return bl;
    }

    private synchronized void setOutputSwitch(Boolean bl) throws IOException {
        this.entry.getFile().setAttribute(PROP_OUTPUT_SWITCH, (Object)bl);
    }

    public Integer getXDisplayNumber() {
        Integer n = (Integer)this.entry.getFile().getAttribute("xDisplayDeviceNumber");
        if (n == null) {
            return this.getProjCompilerType().xDisplayNumber();
        }
        return n;
    }

    private synchronized void setXDisplayNumber(Integer n) throws IOException {
        this.entry.getFile().setAttribute("xDisplayDeviceNumber", (Object)n);
    }

    public String getBuildCommand() {
        String string = (String)this.entry.getFile().getAttribute(PROP_BUILD_COMMAND);
        if (string == null) {
            return this.getProjCompilerType().getBuildCommand();
        }
        return string;
    }

    private synchronized void setBuildCommand(String string) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_COMMAND, (Object)string);
    }

    private String getCurrentFileDir() {
        try {
            String string = FileUtil.toFile((FileObject)this.entry.getDataObject().getPrimaryFile().getFileSystem().getRoot()).getAbsolutePath();
            String string2 = this.entry.getDataObject().getPrimaryFile().getParent().getPackageNameExt('/', '.');
            Object var3_4 = null;
            return string + '/' + string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public NbProcessDescriptor getExternalCompiler() {
        Object object = this.entry.getFile().getAttribute(PROP_EXTERNAL_COMPILER);
        if (object != null && object instanceof NbProcessDescriptor) {
            return (NbProcessDescriptor)object;
        }
        return this.getProjCompilerType().getExternalCompiler();
    }

    private void setExternalCompiler(NbProcessDescriptor nbProcessDescriptor) throws IOException {
        this.entry.getFile().setAttribute(PROP_EXTERNAL_COMPILER, (Object)nbProcessDescriptor);
    }

    public RemoteFSFile getMakefileCompiler() {
        Object object = this.entry.getFile().getAttribute(PROP_MAKEFILE_COMPILER);
        if (object != null && object instanceof RemoteFSFile) {
            return (RemoteFSFile)object;
        }
        if (object != null && object instanceof String) {
            try {
                this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getMakefileCompiler();
        }
        return this.getProjCompilerType().getMakefileCompiler();
    }

    private void setMakefileCompiler(RemoteFSFile remoteFSFile) throws IOException {
        this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, (Object)remoteFSFile);
    }

    private void setLocalQualifier(String string) throws IOException {
        this.entry.getFile().setAttribute(PROP_PASCAL_LOCAL_QUALIFIER, (Object)string);
    }

    private void setGlobalQualifier(String string) throws IOException {
        this.entry.getFile().setAttribute(PROP_PASCAL_GLOBAL_QUALIFIER, (Object)string);
    }

    public String getLocalQualifier() {
        String string = (String)this.entry.getFile().getAttribute(PROP_PASCAL_LOCAL_QUALIFIER);
        if (string == null) {
            return this.getProjCompilerType().getLocalQualifier();
        }
        return string;
    }

    public String getGlobalQualifier() {
        String string = (String)this.entry.getFile().getAttribute(PROP_PASCAL_GLOBAL_QUALIFIER);
        if (string == null) {
            return this.getProjCompilerType().getGlobalQualifier();
        }
        return string;
    }

    private PropertySupport createBuildOptionProperty() {
        class BuildOptionPropertySupport
        extends PropertySupport.ReadWrite {
            public BuildOptionPropertySupport() {
                super(PascalCompilerSupport.PROP_BUILD_OPTION, class$java$lang$Object == null ? (class$java$lang$Object = PascalCompilerSupport.class$("java.lang.Object")) : class$java$lang$Object, PascalCompilerSupport.this.getFlaggedNameBuildOption(PascalCompilerSupport.this.getString("PROP_BUILD_OPTION"), PascalCompilerSupport.PROP_BUILD_OPTION), PascalCompilerSupport.this.getString("HINT_BUILD_OPTION"));
                this.setValue("helpID", "com.hp.openvms.netbeans.pascalsupport.settings.PascalFileGeneralSettings");
                PascalCompilerSupport.this.setDefaultFunction((PropertySupport)this, PascalCompilerSupport.PROP_BUILD_OPTION, "org.openide.filesystems.FileObject");
                if (PascalCompilerSupport.this.getProjCompilerType().getBuildOption() != null) {
                    this.setValue("projValue", PascalCompilerSupport.this.getProjCompilerType().getBuildOption());
                }
            }

            public Object getValue() {
                return PascalCompilerSupport.this.getBuildOption();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof Boolean || object == null) {
                    try {
                        PascalCompilerSupport.this.setBuildOption((Boolean)object);
                        PascalCompilerSupport.this.flagProperty(PascalCompilerSupport.this.getFlaggedNameBuildOption(PascalCompilerSupport.this.getString("PROP_BUILD_OPTION"), PascalCompilerSupport.PROP_BUILD_OPTION), PascalCompilerSupport.PROP_BUILD_OPTION);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(PascalCompilerSupport.this.getBuildOption());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new BuildOptionPropertySupport();
    }

    private PropertySupport createBuildDirectoryProperty() {
        class PropertySupportBuildDirectory
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildDirectory() {
                super(PascalCompilerSupport.PROP_BUILD_DIRECTORY, class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile == null ? (class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile = PascalCompilerSupport.class$("org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile")) : class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile, PascalCompilerSupport.this.getFlaggedName(PascalCompilerSupport.this.getString("PROP_BUILD_DIRECTORY"), PascalCompilerSupport.PROP_BUILD_DIRECTORY), PascalCompilerSupport.this.getString("HINT_BUILD_DIRECTORY"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.FALSE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", PascalCompilerSupport.this.entry.getFile().getNameExt());
                if (PascalCompilerSupport.this.getProjCompilerType().getBuildDirectory() != null) {
                    this.setValue("projvalue", PascalCompilerSupport.this.getProjCompilerType().getBuildDirectory());
                }
                try {
                    if (PascalCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", PascalCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PascalCompilerSupport.this.setDefaultFunction((PropertySupport)this, PascalCompilerSupport.PROP_BUILD_DIRECTORY, "com.hp.openvms.netbeans.pascalsupport.settings.PascalFileMakefileSettings");
            }

            public Object getValue() {
                return PascalCompilerSupport.this.getBuildDirectory();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof RemoteFSFile || object == null) {
                    try {
                        PascalCompilerSupport.this.setBuildDirectory((RemoteFSFile)object);
                        PascalCompilerSupport.this.flagProperty(PascalCompilerSupport.this.getFlaggedName(PascalCompilerSupport.this.getString("PROP_BUILD_DIRECTORY"), PascalCompilerSupport.PROP_BUILD_DIRECTORY), PascalCompilerSupport.PROP_BUILD_DIRECTORY);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(PascalCompilerSupport.this.getBuildDirectory());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new PropertySupportBuildDirectory();
    }

    private PropertySupport createOutputSwitchProperty() {
        class OutputSwitchPropertySupport
        extends PropertySupport.ReadWrite {
            public OutputSwitchPropertySupport() {
                super(PascalCompilerSupport.PROP_OUTPUT_SWITCH, class$java$lang$Object == null ? (class$java$lang$Object = PascalCompilerSupport.class$("java.lang.Object")) : class$java$lang$Object, PascalCompilerSupport.this.getString("PROP_OUTPUT_SWITCH"), PascalCompilerSupport.this.getString("HINT_OUTPUT_SWITCH"));
                PascalCompilerSupport.this.setDefaultFunction((PropertySupport)this, PascalCompilerSupport.PROP_OUTPUT_SWITCH, "com.hp.openvms.netbeans.pascalsupport.settings.PascalFileGeneralSettings");
                if (PascalCompilerSupport.this.getProjCompilerType().outputSwitch() != null) {
                    this.setValue("projValue", PascalCompilerSupport.this.getProjCompilerType().outputSwitch());
                }
            }

            public Object getValue() {
                FileSystem fileSystem = null;
                try {
                    fileSystem = PascalCompilerSupport.this.entry.getFile().getFileSystem();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
                if (fileSystem instanceof AbstractNetworkFileSystem) {
                    Boolean bl = (Boolean)PascalCompilerSupport.this.entry.getFile().getAttribute("useXtermCompile");
                    if (bl != null) {
                        return bl;
                    }
                    return new Boolean(((AbstractNetworkFileSystem)fileSystem).getUseXtermCompile());
                }
                return PascalCompilerSupport.this.getOutputSwitch();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof Boolean || object == null) {
                    try {
                        FileSystem fileSystem = null;
                        try {
                            fileSystem = PascalCompilerSupport.this.entry.getFile().getFileSystem();
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            // empty catch block
                        }
                        if (fileSystem instanceof AbstractNetworkFileSystem) {
                            PascalCompilerSupport.this.entry.getFile().setAttribute("useXtermCompile", object);
                        } else {
                            PascalCompilerSupport.this.setOutputSwitch((Boolean)object);
                        }
                        PascalCompilerSupport.this.flagProperty(PascalCompilerSupport.this.getString("PROP_OUTPUT_SWITCH"), PascalCompilerSupport.PROP_OUTPUT_SWITCH);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                }
                throw new IllegalArgumentException();
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(PascalCompilerSupport.this.getOutputSwitch());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new OutputSwitchPropertySupport();
    }

    private PropertySupport createBuildCommandProperty() {
        class PropertySupportBuildCommand
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildCommand() {
                super(PascalCompilerSupport.PROP_BUILD_COMMAND, class$java$lang$String == null ? (class$java$lang$String = PascalCompilerSupport.class$("java.lang.String")) : class$java$lang$String, PascalCompilerSupport.this.getFlaggedName(PascalCompilerSupport.this.getString("PROP_BUILD_COMMAND"), PascalCompilerSupport.PROP_BUILD_COMMAND), PascalCompilerSupport.this.getString("HINT_BUILD_COMMAND"));
                PascalCompilerSupport.this.setDefaultFunction((PropertySupport)this, PascalCompilerSupport.PROP_BUILD_COMMAND, "com.hp.openvms.netbeans.pascalsupport.settings.PascalFileGeneralSettings");
            }

            public Object getValue() {
                return PascalCompilerSupport.this.getBuildCommand();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof String || object == null) {
                    try {
                        PascalCompilerSupport.this.setBuildCommand((String)object);
                        PascalCompilerSupport.this.flagProperty(PascalCompilerSupport.this.getFlaggedName(PascalCompilerSupport.this.getString("PROP_BUILD_COMMAND"), PascalCompilerSupport.PROP_BUILD_COMMAND), PascalCompilerSupport.PROP_BUILD_COMMAND);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(PascalCompilerSupport.this.getBuildCommand());
            }

            public boolean canWrite() {
                return !PascalCompilerSupport.this.entry.getFile().isReadOnly();
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new PropertySupportBuildCommand();
    }

    private PropertySupport createExternalCompilerProperty() {
        class ExternalCompilerPropertySupport
        extends PropertySupport.ReadWrite {
            public ExternalCompilerPropertySupport() {
                super(PascalCompilerSupport.PROP_EXTERNAL_COMPILER, class$org$openide$execution$NbProcessDescriptor == null ? (class$org$openide$execution$NbProcessDescriptor = PascalCompilerSupport.class$("org.openide.execution.NbProcessDescriptor")) : class$org$openide$execution$NbProcessDescriptor, PascalCompilerSupport.this.getFlaggedName(PascalCompilerSupport.this.getString("PROP_EXTERNAL_COMPILER"), PascalCompilerSupport.PROP_EXTERNAL_COMPILER), PascalCompilerSupport.this.getString("HINT_EXTERNAL_COMPILER"));
                PascalCompilerSupport.this.setDefaultFunction((PropertySupport)this, PascalCompilerSupport.PROP_EXTERNAL_COMPILER, "com.hp.openvms.netbeans.pascalsupport.settings.PascalFileGeneralSettings");
            }

            public Object getValue() {
                return PascalCompilerSupport.this.getExternalCompiler();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof NbProcessDescriptor || object == null) {
                    try {
                        PascalCompilerSupport.this.setExternalCompiler((NbProcessDescriptor)object);
                        PascalCompilerSupport.this.flagProperty(PascalCompilerSupport.this.getFlaggedName(PascalCompilerSupport.this.getString("PROP_EXTERNAL_COMPILER"), PascalCompilerSupport.PROP_EXTERNAL_COMPILER), PascalCompilerSupport.PROP_EXTERNAL_COMPILER);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public PropertyEditor getPropertyEditor() {
                return new NbProcessDescriptorEditor2();
            }
        }
        return new ExternalCompilerPropertySupport();
    }

    private PropertySupport createXDisplayDeviceNumber() {
        class XDisplayDeviceNumberPropertySupport
        extends PropertySupport.ReadWrite {
            public XDisplayDeviceNumberPropertySupport() {
                super("X Display Device Number", class$java$lang$Integer == null ? (class$java$lang$Integer = PascalCompilerSupport.class$("java.lang.Integer")) : class$java$lang$Integer, "X Display Device Number", "Defines the screen associated with the display device");
            }

            public Object getValue() {
                return PascalCompilerSupport.this.getXDisplayNumber();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof Integer || object == null) {
                    try {
                        PascalCompilerSupport.this.setXDisplayNumber((Integer)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new XDisplayDeviceNumberPropertySupport();
    }

    private PropertySupport createMakefileCompilerProperty() {
        class MakefileProperty
        extends PropertySupport.ReadWrite {
            public MakefileProperty() {
                super(PascalCompilerSupport.PROP_MAKEFILE_COMPILER, class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile == null ? (class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile = PascalCompilerSupport.class$("org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile")) : class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile, PascalCompilerSupport.this.getFlaggedNameMakefile(PascalCompilerSupport.this.getString("PROP_MAKEFILE_COMPILER"), PascalCompilerSupport.PROP_MAKEFILE_COMPILER), PascalCompilerSupport.this.getString("HINT_MAKEFILE_COMPILER"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.TRUE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", PascalCompilerSupport.this.entry.getFile().getNameExt());
                if (PascalCompilerSupport.this.getProjCompilerType().getMakefileCompiler() != null) {
                    this.setValue("projvalue", PascalCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
                }
                try {
                    if (PascalCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", PascalCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PascalCompilerSupport.this.setDefaultFunction((PropertySupport)this, PascalCompilerSupport.PROP_MAKEFILE_COMPILER, "com.hp.openvms.netbeans.pascalsupport.settings.PascalFileGeneralSettings");
            }

            public Object getValue() {
                return PascalCompilerSupport.this.getMakefileCompiler();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof RemoteFSFile || object == null) {
                    try {
                        PascalCompilerSupport.this.setMakefileCompiler((RemoteFSFile)object);
                        PascalCompilerSupport.this.flagProperty(PascalCompilerSupport.this.getFlaggedNameMakefile(PascalCompilerSupport.this.getString("PROP_MAKEFILE_COMPILER"), PascalCompilerSupport.PROP_MAKEFILE_COMPILER), PascalCompilerSupport.PROP_MAKEFILE_COMPILER);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(PascalCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new MakefileProperty();
    }

    private PropertySupport createFileResidenceProperty() {
        class FileResidenceProperty
        extends PropertySupport.ReadOnly {
            public FileResidenceProperty() {
                super("File Residence", class$java$lang$String == null ? (class$java$lang$String = PascalCompilerSupport.class$("java.lang.String")) : class$java$lang$String, "File Residence", "Determine if the file should reside in local disk, server or both");
            }

            public Object getValue() {
                Object object;
                FileObject fileObject = PascalCompilerSupport.this.entry.getFile();
                Object object2 = fileObject.getAttribute("file_residence_mode");
                try {
                    object = (RemoteFileSystem)fileObject.getFileSystem();
                    if (object.getServerOnlyFileExts().isRegistered(fileObject.getExt())) {
                        return "Server Only";
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                }
                if (object2 != null) {
                    object = (Integer)object2;
                    String string = "Make Client and Server";
                    switch ((Integer)object) {
                        case 1: {
                            string = "Client Only";
                            break;
                        }
                        case 0: {
                            string = "Server Only";
                            break;
                        }
                        case 2: {
                            string = "Client and Server";
                        }
                    }
                    return string;
                }
                return "Client and Server";
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new FileResidenceProperty();
    }

    private PropertySupport createRemoteFilePathProperty() {
        class RemoteFilePathPropertySupport
        extends PropertySupport.ReadOnly {
            public RemoteFilePathPropertySupport() {
                super("Remote File Path", class$java$lang$String == null ? (class$java$lang$String = PascalCompilerSupport.class$("java.lang.String")) : class$java$lang$String, "Remote File Path", "Remote File Path");
            }

            public Object getValue() {
                FileObject fileObject = PascalCompilerSupport.this.entry.getFile();
                Object object = fileObject.getAttribute("REMOTE_FILEPATH");
                if (object != null) {
                    return object;
                }
                String string = fileObject.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (Utilities.isWindows()) {
                        string = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        string = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return string;
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    FileObject fileObject = PascalCompilerSupport.this.entry.getFile();
                    fileObject.setAttribute("REMOTE_FILEPATH", object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                FileObject fileObject = PascalCompilerSupport.this.entry.getFile();
                String string = fileObject.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (Utilities.isWindows()) {
                        string = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        string = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    }
                    this.setValue(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new RemoteFilePathPropertySupport();
    }

    private PropertySupport createPascalLocalQualifierProperty() {
        class PascalLocalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public PascalLocalQualifierPropertySupport() {
                super(PascalCompilerSupport.PROP_PASCAL_LOCAL_QUALIFIER, class$java$lang$String == null ? (class$java$lang$String = PascalCompilerSupport.class$("java.lang.String")) : class$java$lang$String, PascalCompilerSupport.this.getFlaggedName(PascalCompilerSupport.this.getString("PROP_PASCAL_LOCAL_QUALIFIER"), PascalCompilerSupport.PROP_PASCAL_LOCAL_QUALIFIER), PascalCompilerSupport.this.getString("HINT_PASCAL_LOCAL_QUALIFIER"));
                PascalCompilerSupport.this.setDefaultFunction((PropertySupport)this, PascalCompilerSupport.PROP_PASCAL_LOCAL_QUALIFIER, "com.hp.openvms.netbeans.pascalsupport.settings.PascalFileGeneralSettings");
            }

            public Object getValue() {
                return PascalCompilerSupport.this.getLocalQualifier();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof String || object == null) {
                    try {
                        PascalCompilerSupport.this.setLocalQualifier((String)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(PascalCompilerSupport.this.getLocalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new PascalLocalQualifierPropertySupport();
    }

    private PropertySupport createPascalGlobalQualifierProperty() {
        class PascalGlobalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public PascalGlobalQualifierPropertySupport() {
                super(PascalCompilerSupport.PROP_PASCAL_GLOBAL_QUALIFIER, class$java$lang$String == null ? (class$java$lang$String = PascalCompilerSupport.class$("java.lang.String")) : class$java$lang$String, PascalCompilerSupport.this.getFlaggedName(PascalCompilerSupport.this.getString("PROP_PASCAL_GLOBAL_QUALIFIER"), PascalCompilerSupport.PROP_PASCAL_GLOBAL_QUALIFIER), PascalCompilerSupport.this.getString("HINT_PASCAL_GLOBAL_QUALIFIER"));
                PascalCompilerSupport.this.setDefaultFunction((PropertySupport)this, PascalCompilerSupport.PROP_PASCAL_GLOBAL_QUALIFIER, "com.hp.openvms.netbeans.pascalsupport.settings.PascalFileGeneralSettings");
            }

            public Object getValue() {
                return PascalCompilerSupport.this.getGlobalQualifier();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof String || object == null) {
                    try {
                        PascalCompilerSupport.this.setGlobalQualifier((String)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(PascalCompilerSupport.this.getGlobalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new PascalGlobalQualifierPropertySupport();
    }

    private String getFlaggedNameBuildOption(String string, String string2) {
        return string;
    }

    private String getFlaggedNameMakefile(String string, String string2) {
        return string;
    }

    private String getFlaggedName(String string, String string2) {
        return string;
    }

    protected String getString(String string) {
        return bundle.getString(string);
    }

    protected void flagProperty(String string, String string2) {
    }

    protected void setDefaultFunction(PropertySupport propertySupport, String string, String string2) {
        try {
            propertySupport.setValue("method", (Object)FileObject.class.getMethod("getAttribute", String.class));
            propertySupport.setValue("param", (Object)string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        propertySupport.setValue("object", (Object)this.entry.getFile());
        propertySupport.setValue("helpID", (Object)string2);
    }

    public FileObject getFileObject() {
        return this.entry.getFile();
    }

    public static class RemoteBuild
    extends PascalCompilerSupport
    implements RemoteBuildCookie {
        public RemoteBuild(MultiDataObject.Entry entry) {
            super(entry, class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie == null ? (class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie = PascalCompilerSupport.class$("org.netbeans.modules.distributed.common.cookies.RemoteBuildCookie")) : class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie);
        }
    }

    public static class RemoteCompile
    extends PascalCompilerSupport
    implements RemoteCompileCookie {
        public RemoteCompile(MultiDataObject.Entry entry) {
            super(entry, class$org$netbeans$modules$distributed$common$cookies$RemoteCompileCookie == null ? (class$org$netbeans$modules$distributed$common$cookies$RemoteCompileCookie = PascalCompilerSupport.class$("org.netbeans.modules.distributed.common.cookies.RemoteCompileCookie")) : class$org$netbeans$modules$distributed$common$cookies$RemoteCompileCookie);
        }

        public void compile() throws IOException {
            PascalCompiler pascalCompiler = new PascalCompiler(class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie == null ? (class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie = PascalCompilerSupport.class$("org.netbeans.modules.distributed.common.cookies.RemoteBuildCookie")) : class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie, this.getFileObject(), this.getExternalCompiler(), this.getProjCompilerType().getErrorExpression(), new PascalCompilerType(this.entry.getFile()));
            DataObject dataObject = null;
            dataObject = DataObject.find((FileObject)this.getFileObject());
            PascalCompilerGroup.PascalFormat pascalFormat = new PascalCompilerGroup.PascalFormat(new DataObject[]{dataObject}, new String[]{pascalCompiler.getFileName()}, true);
            RemoteCompilerAction.createRemoteProcess(this.getFileObject(), this.getOutputSwitch(), this.getXDisplayNumber(), this.getProjCompilerType().getErrorExpression(), pascalFormat, pascalFormat.getCmds());
        }
    }

    public static class Clean
    extends PascalCompilerSupport
    implements CompilerCookie.Clean {
        public Clean(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Clean == null ? (class$org$openide$cookies$CompilerCookie$Clean = PascalCompilerSupport.class$("org.openide.cookies.CompilerCookie$Clean")) : class$org$openide$cookies$CompilerCookie$Clean);
        }
    }

    public static class Build
    extends PascalCompilerSupport
    implements CompilerCookie.Build {
        public Build(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Build == null ? (class$org$openide$cookies$CompilerCookie$Build = PascalCompilerSupport.class$("org.openide.cookies.CompilerCookie$Build")) : class$org$openide$cookies$CompilerCookie$Build);
        }
    }

    public static class Compile
    extends PascalCompilerSupport
    implements CompilerCookie.Compile {
        public Compile(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = PascalCompilerSupport.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        }
    }
}

