/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.fortransupport.fortran;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompilerType;
import com.hp.openvms.netbeans.baseclasses.compiler.BogusCompiler;
import com.hp.openvms.netbeans.fortransupport.fortran.FortranCompiler;
import com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranDataObject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.util.Utils;
import org.openide.ErrorManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class FortranCompilerType
extends AlphaVMSCompilerType {
    public static final String PROP_SOURCE_FORM = "source_form";
    public static final String PROP_EXTEND_SOURCE = "extend_source";
    private Boolean updated;
    private static ResourceBundle bundle;
    private static final long serialVersionUID = 8662815563020991341L;

    public FortranCompilerType(FileObject fileObject) {
        super(fileObject);
        this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        FileObject fileObject2 = this.project.getProjectDirectory();
        String string = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
        this.settingsMap = Utils.getCompilerSettingsFrom3GLXML((String)string, (String)"fortran");
    }

    public static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)FortranCompilerType.class);
        }
        return bundle.getString(string);
    }

    public void prepareJob(CompilerJob compilerJob, Class clazz, DataObject dataObject) {
        if (dataObject instanceof FortranDataObject) {
            super.prepareJob(compilerJob, clazz, dataObject);
        } else {
            String string = MessageFormat.format(FortranCompilerType.getString("MSG_InvalidCompiler"), this.getName(), dataObject.getPrimaryFile().toString());
            Throwable throwable = ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("Invalid compiler"), 256, null, string, null, null);
            BogusCompiler bogusCompiler = new BogusCompiler(dataObject.getPrimaryFile(), throwable);
            compilerJob.add((Compiler)bogusCompiler);
        }
    }

    protected Compiler createCompiler(Class clazz, FileObject fileObject) {
        return new FortranCompiler(clazz, fileObject, this.getExternalCompiler(), this.getErrorExpression(), this);
    }

    public void flushSettings() throws IOException {
        Utils.writeCompilerSettingto3GLXML((Project)this.project, (String)"fortran", (Map)this.settingsMap);
    }
}

