/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.debugger;

import com.hp.openvms.netbeans.debugsupport.debugger.Field;
import com.hp.openvms.netbeans.debugsupport.debugger.InvalidExpressionException;
import com.hp.openvms.netbeans.debugsupport.debugger.LocalVariable;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;

public class LocalVariableImpl
implements LocalVariable,
Field {
    private String name;
    private String shortname;
    private String previousValueText;
    private String currentValueText;
    private String type;
    private String className;
    private int dimCount;
    private RemoteDebugger debugger;
    private Field[] fields;
    private Field[] staticFields;
    private Field[] inheritedFields;

    public LocalVariableImpl(String string, String string2, String string3) {
        this.setName(string);
        this.currentValueText = string3;
        this.previousValueText = string3;
        this.type = string2;
        this.dimCount = 1;
        this.debugger = null;
    }

    public String getName() {
        return this.shortname;
    }

    public void setName(String string) {
        this.name = string;
        this.shortname = string;
        int n = this.shortname.lastIndexOf(46);
        if (n >= 0) {
            if (++n < this.shortname.length()) {
                this.shortname = this.shortname.substring(n);
            }
            for (n = 0; n < string.length() && string.charAt(n) == '*'; ++n) {
                this.shortname = '*' + this.shortname;
            }
        }
    }

    public String getValue() {
        return this.currentValueText;
    }

    public void setValue(String string) throws InvalidExpressionException {
        if (this.debugger == null) {
            return;
        }
        String string2 = string;
        if (this.type.equals("char *")) {
            String string3;
            String string4 = null;
            String string5 = null;
            int n = string.indexOf(32);
            if (n >= 0) {
                string4 = string.substring(0, n);
                string5 = string.substring(n + 1);
            } else if (string.startsWith("0x")) {
                string4 = string;
            } else {
                string5 = string;
            }
            String string6 = this.getValue();
            if (string4 != null && !string6.startsWith(string4)) {
                string4 = string;
                this.debugger.setVariableValue(this.name, string4);
            }
            if ((n = string6.indexOf(32)) >= 0 && !(string3 = string6.substring(n + 1)).equals(string5)) {
                for (int i = 0; i < string5.length(); ++i) {
                    char c = string5.charAt(i);
                    if (c == string3.charAt(i)) continue;
                    if (i < 2) break;
                    int n2 = i - 2;
                    this.debugger.setVariableValue(this.name + "[" + n2 + "]", "'" + c + "'");
                }
            }
            return;
        }
        this.debugger.setVariableValue(this.name, string2);
    }

    public String getType() {
        if (this.type != null && !this.type.equals("")) {
            return this.type;
        }
        this.type = this.debugger.getVariableType(this.name);
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    private boolean typeIsSimple() {
        String string = this.getType();
        if (string == null) {
            return false;
        }
        return string.equals("char") || string.equals("short") || string.equals("int") || string.equals("long") || string.equals("long long") || string.equals("double") || string.equals("long double") || string.equals("unsigned char") || string.equals("unsigned short") || string.equals("unsigned int") || string.equals("unsigned long") || string.equals("unsigned long long");
    }

    public String getDeclaredType() {
        return this.type;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public boolean isStatic() {
        return false;
    }

    public int getDimCount() {
        return this.dimCount;
    }

    public void setDimCount(int n) {
        this.dimCount = n;
    }

    public void setDebugger(RemoteDebugger remoteDebugger) {
        this.debugger = remoteDebugger;
    }

    private void initFields() {
        this.fields = new Field[0];
        this.staticFields = new Field[0];
        this.inheritedFields = new Field[0];
    }

    public void addField(Field field) {
        if (this.fields == null) {
            this.initFields();
        }
        int n = this.fields.length;
        Field[] fieldArray = new Field[n + 1];
        System.arraycopy(this.fields, 0, fieldArray, 0, n);
        this.fields = fieldArray;
        this.fields[n] = field;
    }

    public int getFieldsCount() {
        if (this.fields == null) {
            this.initFields();
        }
        return this.fields.length;
    }

    public Field getField(String string) {
        if (this.fields == null) {
            return null;
        }
        int n = this.fields.length;
        for (int i = 0; i < n; ++i) {
            Field field = this.fields[i];
            if (!string.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public Field[] getFields(int n, int n2) {
        if (this.fields == null) {
            this.initFields();
        }
        if (n2 != 0) {
            n2 = Math.min(this.fields.length, n2);
            n = Math.min(this.fields.length, n);
            Field[] fieldArray = new Field[n2 - n];
            System.arraycopy(this.fields, n, fieldArray, 0, n2 - n);
            return fieldArray;
        }
        return this.fields;
    }
}

