/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.ActionsPanel;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContextBridge;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class LineBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private ActionsPanel actionsPanel;
    private LineBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JScrollPane spCondition;
    private JEditorPane tfCondition;
    private JTextField tfFileName;
    private JTextField tfLineNumber;

    public LineBreakpointPanel() {
        this(LineBreakpointPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public LineBreakpointPanel(LineBreakpoint lineBreakpoint) {
        Object object;
        String string = null;
        String string2 = lineBreakpoint.getURL();
        this.breakpoint = lineBreakpoint;
        this.initComponents();
        try {
            object = URLMapper.findFileObject((URL)new URL(string2));
            if (object != null) {
                string = object.getMIMEType();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (string2.length() > 0 && string != null && (string.equals("text/x-c++") || string.equals("text/x-c") || string.equals("text/x-fortran"))) {
            try {
                object = new URI(string2);
                String string3 = ((URI)object).getPath();
                if (Utilities.isWindows() && string3.charAt(0) == '/') {
                    string3 = string3.substring(1);
                }
                this.tfFileName.setText(string3);
            }
            catch (Exception exception) {
                this.tfFileName.setText(string2);
            }
        } else {
            this.tfFileName.setEditable(true);
        }
        this.tfLineNumber.setText(Integer.toString(lineBreakpoint.getLineNumber()));
        this.tfCondition.setText(lineBreakpoint.getCondition());
        this.setupConditionPane();
        this.actionsPanel = new ActionsPanel(lineBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
    }

    private static LineBreakpoint createBreakpoint() {
        String string = EditorContextBridge.getMostRecentURL();
        int n = EditorContextBridge.getMostRecentLineNumber();
        LineBreakpoint lineBreakpoint = LineBreakpoint.create(string, n);
        lineBreakpoint.setPrintText(NbBundle.getBundle((Class)LineBreakpointPanel.class).getString("CTL_Line_Breakpoint_Print_Text"));
        return lineBreakpoint;
    }

    private static int findNumLines(String string) {
        DataObject dataObject;
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return 0;
        }
        if (fileObject == null) {
            return 0;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return 0;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return 0;
        }
        editorCookie.prepareDocument().waitFinished();
        StyledDocument styledDocument = editorCookie.getDocument();
        if (!(styledDocument instanceof StyledDocument)) {
            return 0;
        }
        StyledDocument styledDocument2 = styledDocument;
        return NbDocument.findLineNumber((StyledDocument)styledDocument2, (int)styledDocument2.getLength());
    }

    private void setupConditionPane() {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointLineGDB");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.tfFileName = new JTextField();
        this.jLabel1 = new JLabel();
        this.tfLineNumber = new JTextField();
        this.spCondition = new JScrollPane();
        this.tfCondition = new JEditorPane();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pSettings.setLayout(new GridBagLayout());
        this.pSettings.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("L_Line_Breakpoint_BorderTitle")));
        this.jLabel3.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("MN_L_Line_Breakpoint_File_Name").charAt(0));
        this.jLabel3.setLabelFor(this.tfFileName);
        this.jLabel3.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("L_Line_Breakpoint_File_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("ACSD_L_Line_Breakpoint_File_Name"));
        this.jLabel5.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("MN_L_Line_Breakpoint_Condition").charAt(0));
        this.jLabel5.setLabelFor(this.tfCondition);
        this.jLabel5.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("L_Line_Breakpoint_Condition"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("ACSD_L_Line_Breakpoint_Condition"));
        this.tfFileName.setEditable(false);
        this.tfFileName.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("TTT_TF_Line_Breakpoint_File_Name"));
        this.tfFileName.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFileName, gridBagConstraints);
        this.tfFileName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("ACSD_TF_Line_Breakpoint_File_Name"));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("MN_L_Line_Breakpoint_Line_Number").charAt(0));
        this.jLabel1.setLabelFor(this.tfLineNumber);
        this.jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("L_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("ACSD_L_Line_Breakpoint_Line_Number"));
        this.tfLineNumber.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("TTT_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfLineNumber, gridBagConstraints);
        this.tfLineNumber.getAccessibleContext().setAccessibleName("Line number");
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("ACSD_TF_Line_Breakpoint_Line_Number"));
        this.spCondition.setHorizontalScrollBarPolicy(31);
        this.spCondition.setToolTipText(NbBundle.getMessage((Class)LineBreakpointPanel.class, (String)"ACSD_TF_Line_Breakpoint_Condition"));
        this.tfCondition.setEditable(false);
        this.tfCondition.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("HINT_UnimplementedCondition"));
        this.tfCondition.setToolTipText(NbBundle.getMessage((Class)LineBreakpointPanel.class, (String)"ACSD_TF_Line_Breakpoint_Condition"));
        this.tfCondition.setContentType("text/x-java");
        this.tfCondition.setEnabled(false);
        this.spCondition.setViewportView(this.tfCondition);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.spCondition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public boolean ok() {
        String string = this.validateBreakpoint();
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            return false;
        }
        this.actionsPanel.ok();
        this.breakpoint.setLineNumber(Integer.parseInt(this.tfLineNumber.getText().trim()));
        this.breakpoint.setCondition(this.tfCondition.getText());
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
        int n = breakpointArray.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3;
            if (!(breakpointArray[i] instanceof LineBreakpoint)) continue;
            LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpointArray[i];
            if (this.breakpoint.getLineNumber() != lineBreakpoint.getLineNumber() || !(string3 = this.breakpoint.getURL()).equals(lineBreakpoint.getURL()) || ((string2 = this.breakpoint.getCondition()) == null ? lineBreakpoint.getCondition() != null : !string2.equals(lineBreakpoint.getCondition()))) continue;
            if (!lineBreakpoint.isEnabled()) {
                breakpointArray[i].enable();
            }
            return true;
        }
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    private String validateBreakpoint() {
        File file;
        String string = this.tfFileName.getText();
        if (string == null || string.length() == 0) {
            return NbBundle.getMessage((Class)LineBreakpointPanel.class, (String)"MSG_No_File_Name_Spec");
        }
        if (!(string.charAt(0) != '/' && string.charAt(0) != '\'' || (file = new File(string)).exists())) {
            return NbBundle.getMessage((Class)LineBreakpointPanel.class, (String)"MSG_File_Name_Does_Not_Exist");
        }
        try {
            int n = Integer.parseInt(this.tfLineNumber.getText().trim());
            if (n <= 0) {
                return NbBundle.getMessage((Class)LineBreakpointPanel.class, (String)"MSG_NonPositive_Line_Number_Spec");
            }
            int n2 = LineBreakpointPanel.findNumLines(this.breakpoint.getURL());
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
            }
            if (n > n2) {
                return NbBundle.getMessage((Class)LineBreakpointPanel.class, (String)"MSG_TooBig_Line_Number_Spec", (Object)Integer.toString(n), (Object)Integer.toString(n2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            return NbBundle.getMessage((Class)LineBreakpointPanel.class, (String)"MSG_No_Line_Number_Spec");
        }
        return null;
    }
}

