/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import java.net.MalformedURLException;
import java.net.URL;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public class FunctionBreakpoint
extends RemoteBreakpoint {
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_URL = "url";
    public static final String PROP_FUNCTION_NAME = "functionName";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointType";
    public static final int TYPE_FUNCTION_ENTRY = 1;
    public static final int TYPE_FUNCTION_EXIT = 2;
    private String function = "";
    private String condition = "";
    private String url = "";
    private String path = "";
    private int lineNumber;
    private int type;
    static final /* synthetic */ boolean $assertionsDisabled;

    private FunctionBreakpoint() {
    }

    public static FunctionBreakpoint create(String string) {
        FunctionBreakpointComparable functionBreakpointComparable = new FunctionBreakpointComparable();
        functionBreakpointComparable.setID();
        functionBreakpointComparable.setFunctionName(string);
        return functionBreakpointComparable;
    }

    public String getFunctionName() {
        return this.function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFunctionName(String string) {
        String string2;
        FunctionBreakpoint functionBreakpoint = this;
        synchronized (functionBreakpoint) {
            int n;
            if (string == null) {
                string = "";
            }
            if ((n = string.indexOf(32)) > 0) {
                string = string.replaceAll(" ", "");
            }
            if ((n = string.indexOf("(void)")) > 0) {
                string = string.substring(0, n + 1) + string.substring(n + 5);
            }
            if (string.equals(this.function)) {
                return;
            }
            string2 = string;
            this.function = string;
        }
        this.firePropertyChange(PROP_FUNCTION_NAME, string2, string);
    }

    public String getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String string) {
        String string2;
        FunctionBreakpoint functionBreakpoint = this;
        synchronized (functionBreakpoint) {
            block11: {
                if (string == this.url || string != null && this.url != null && string.equals(this.url)) {
                    return;
                }
                if (!(string = string.replace(" ", "%20")).startsWith("file:/")) {
                    string = string.startsWith("/") ? "file:" + string : "file:/" + string;
                }
                try {
                    if (!$assertionsDisabled && string == null && Boolean.getBoolean("gdb.assertions.enabled")) {
                        throw new AssertionError();
                    }
                    FileObject fileObject = URLMapper.findFileObject((URL)new URL(string));
                    if (fileObject != null) {
                        this.path = Utilities.isWindows() ? fileObject.getPath() : "/" + fileObject.getPath();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    if (!$assertionsDisabled && Boolean.getBoolean("gdb.assertions.enabled")) {
                        throw new AssertionError();
                    }
                    return;
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || !Boolean.getBoolean("gdb.assertions.enabled")) break block11;
                    throw new AssertionError();
                }
            }
            string2 = this.url;
            this.url = string;
        }
        this.firePropertyChange(PROP_URL, string2, string);
    }

    public String getPath() {
        return this.path;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineNumber(int n) {
        int n2;
        FunctionBreakpoint functionBreakpoint = this;
        synchronized (functionBreakpoint) {
            if (n == this.lineNumber) {
                return;
            }
            n2 = this.lineNumber;
            this.lineNumber = n;
        }
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(n2), new Integer(n));
    }

    public void setBreakpointType(int n) {
        this.type = n;
    }

    public int getBreakpointType() {
        return this.type;
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String string) {
        String string2;
        FunctionBreakpoint functionBreakpoint = this;
        synchronized (functionBreakpoint) {
            if (string == null) {
                string = "";
            }
            if ((string = string.trim()) == this.condition || string != null && this.condition != null && this.condition.equals(string)) {
                return;
            }
            string2 = this.condition;
            this.condition = string;
        }
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public String toString() {
        return "FunctionBreakpoint " + this.function;
    }

    static {
        $assertionsDisabled = !FunctionBreakpoint.class.desiredAssertionStatus();
    }

    private static class FunctionBreakpointComparable
    extends FunctionBreakpoint
    implements Comparable {
        public int compareTo(Object object) {
            if (object instanceof FunctionBreakpointComparable) {
                FunctionBreakpointComparable functionBreakpointComparable = this;
                FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)((Object)object);
                return ((FunctionBreakpoint)functionBreakpointComparable).function.compareTo(functionBreakpoint.function);
            }
            return -1;
        }
    }
}

