/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.dclsupport.dcl.datasys;

import com.hp.openvms.netbeans.baseclasses.actions.MyPropertiesAction;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.ExecAction;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.SHDataObject;
import com.hp.openvms.netbeans.utils.Constants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.Format;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.SaveAsTemplateAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class SHDataLoader
extends UniFileLoader {
    private static ResourceBundle bundle;
    public static final String REQUIRED_MIME = "text/x-hp+openvms+sh";

    public SHDataLoader() {
        this(SHDataObject.class);
    }

    public SHDataLoader(Class clazz) {
        super(clazz);
    }

    public static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)SHDataLoader.class);
        }
        return bundle.getString(string);
    }

    protected String defaultDisplayName() {
        return "Bash Source Objects";
    }

    protected String actionsContext() {
        return "Loaders/text/x-hp+openvms+sh/Actions";
    }

    protected void initialize() {
        super.initialize();
        ExtensionList extensionList = new ExtensionList();
        for (int i = 0; i < Constants.SH_EXTENSIONS.length; ++i) {
            extensionList.addExtension(Constants.SH_EXTENSIONS[i]);
        }
        this.setExtensions(extensionList);
        this.getExtensions().addMimeType(REQUIRED_MIME);
    }

    protected SystemAction[] defaultActions() {
        return new SystemAction[]{SystemAction.get((Class)OpenAction.class), SystemAction.get((Class)FileSystemAction.class), null, SystemAction.get((Class)ExecAction.class), null, SystemAction.get((Class)CutAction.class), SystemAction.get((Class)CopyAction.class), SystemAction.get((Class)PasteAction.class), null, SystemAction.get((Class)DeleteAction.class), SystemAction.get((Class)RenameAction.class), null, SystemAction.get((Class)SaveAsTemplateAction.class), null, SystemAction.get((Class)ToolsAction.class), SystemAction.get((Class)MyPropertiesAction.class)};
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new SHDataObject(fileObject, this);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new SHFileEntry(multiDataObject, fileObject);
    }

    public class SHFileEntry
    extends FileEntry.Format {
        static final long serialVersionUID = 8244159045498569316L;
        boolean disableInputStream;
        private Collection activeReaders;

        public SHFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            String string2 = this.getFile().getExt();
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)string2);
            }
            FileObject fileObject2 = fileObject.createData(string, string2);
            Format format = this.createFormat(fileObject, string, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getFile().getInputStream()));
            try {
                FileLock fileLock = fileObject2.lock();
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject2.getOutputStream(fileLock)));
                    try {
                        String string3;
                        while ((string3 = bufferedReader.readLine()) != null) {
                            String string4 = format.format(string3);
                            bufferedWriter.write(string4);
                            bufferedWriter.write(10);
                        }
                    }
                    finally {
                        bufferedWriter.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
            finally {
                bufferedReader.close();
            }
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            fileObject2.setAttribute("template", null);
            return fileObject2;
        }

        protected Format createFormat(FileObject fileObject, String string, String string2) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("NAME", string);
            hashMap.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
            hashMap.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
            hashMap.put("USER", System.getProperty("user.name"));
            MapFormat mapFormat = new MapFormat(hashMap);
            mapFormat.setLeftBrace("__");
            mapFormat.setRightBrace("__");
            return mapFormat;
        }
    }
}

