/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.prop;

import com.hp.openvms.netbeans.cppsupport.prop.CustomPropertyPane;
import com.hp.openvms.netbeans.cppsupport.prop.EmptyPanel;
import com.hp.openvms.netbeans.cppsupport.prop.PropertySheetSettings;
import com.hp.openvms.netbeans.cppsupport.prop.PropertySheetTab;
import com.hp.openvms.netbeans.cppsupport.prop.PropertySheetToolbar;
import com.hp.openvms.netbeans.cppsupport.prop.ProxyNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PropertySheet
extends JPanel {
    static final long serialVersionUID = -7698351033045864945L;
    public static final String PROPERTY_SORTING_MODE = "sortingMode";
    public static final String PROPERTY_VALUE_COLOR = "valueColor";
    public static final String PROPERTY_DISABLED_PROPERTY_COLOR = "disabledPropertyColor";
    public static final String PROPERTY_CURRENT_PAGE = "currentPage";
    public static final String PROPERTY_PLASTIC = "plastic";
    public static final String PROPERTY_PROPERTY_PAINTING_STYLE = "propertyPaintingStyle";
    public static final String PROPERTY_DISPLAY_WRITABLE_ONLY = "displayWritableOnly";
    public static final int ALWAYS_AS_STRING = 1;
    public static final int STRING_PREFERRED = 2;
    public static final int PAINTING_PREFERRED = 3;
    public static final int UNSORTED = 0;
    public static final int SORTED_BY_NAMES = 1;
    public static final int SORTED_BY_TYPES = 2;
    private static final int INIT_DELAY = 70;
    private static final int MAX_DELAY = 350;
    protected static Icon iNoSort;
    protected static Icon iAlphaSort;
    protected static Icon iTypeSort;
    protected static Icon iDisplayWritableOnly;
    protected static Icon iCustomize;
    static final String PROP_HAS_CUSTOMIZER = "hasCustomizer";
    static final String PROP_PAGE_HELP_ID = "pageHelpID";
    private int savedSplitterPosition = -1;
    private transient JTabbedPane pages;
    private transient EmptyPanel emptyPanel;
    private transient int pageIndex = 0;
    private transient ChangeListener tabListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            int n = PropertySheet.this.pages.getSelectedIndex();
            PropertySheet.this.setCurrentPage(n);
        }
    };
    private Node activeNode;
    private NodeListener activeNodeListener;
    private boolean displayWritableOnly;
    private int propertyPaintingStyle;
    private int sortingMode;
    private boolean plastic;
    private Color disabledPropertyColor;
    private Color valueColor;
    static ThreadLocal current;
    private transient Node[] helperNodes;
    private transient RequestProcessor.Task scheduleTask;
    private transient RequestProcessor.Task initTask;
    private String storedTab = null;
    private boolean attached = false;

    private static String getString(String string) {
        return NbBundle.getBundle((Class)PropertySheet.class).getString(string);
    }

    public PropertySheet() {
        Serializable serializable;
        this.setLayout(new BorderLayout());
        boolean bl = false;
        try {
            serializable = Class.forName("org.openide.explorer.propertysheet.PropertySheet$PropertySheetSettingsInvoker");
            Runnable runnable = (Runnable)((Class)serializable).newInstance();
            current.set(this);
            runnable.run();
        }
        catch (Exception exception) {
            bl = true;
        }
        catch (LinkageError linkageError) {
            bl = true;
        }
        if (bl) {
            this.displayWritableOnly = false;
            this.propertyPaintingStyle = 3;
            this.sortingMode = 1;
            this.plastic = false;
            this.disabledPropertyColor = UIManager.getColor("textInactiveText");
            this.valueColor = new Color(0, 0, 128);
        }
        this.pages = new HelpAwareJTabbedPane();
        this.pages.getAccessibleContext().setAccessibleName(PropertySheet.getString("ACS_PropertySheetTabs"));
        this.pages.getAccessibleContext().setAccessibleDescription(PropertySheet.getString("ACSD_PropertySheetTabs"));
        this.pages.addChangeListener(this.tabListener);
        this.emptyPanel = new EmptyPanel(PropertySheet.getString("CTL_NoProperties"));
        this.pages.setTabPlacement(3);
        serializable = new PropertySheetToolbar(this);
        ((JComponent)serializable).setBorder(UIManager.getBorder("Toolbar.border"));
        this.addPropertyChangeListener((PropertyChangeListener)((Object)serializable));
        this.add((Component)serializable, "North");
        this.setPreferredSize(new Dimension(200, 300));
    }

    public void setNodes(Node[] nodeArray) {
        this.setHelperNodes(nodeArray);
    }

    private synchronized void setHelperNodes(Node[] nodeArray) {
        RequestProcessor.Task task = this.getScheduleTask();
        this.helperNodes = nodeArray;
        if (task.equals(this.initTask)) {
            this.scheduleTask.schedule(0);
            task.schedule(70);
        } else {
            int n = task.getDelay() * 2;
            if (n > 350) {
                n = 350;
            }
            if (n < 70) {
                n = 70;
            }
            task.schedule(n);
        }
    }

    private synchronized Node[] getHelperNodes() {
        return this.helperNodes;
    }

    private synchronized RequestProcessor.Task getScheduleTask() {
        if (this.scheduleTask == null) {
            this.scheduleTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Node[] nodeArray = PropertySheet.this.getHelperNodes();
                    final Node node = nodeArray.length == 1 ? nodeArray[0] : (nodeArray.length == 0 ? null : new ProxyNode(nodeArray));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            PropertySheet.this.setCurrentNode(node);
                        }
                    });
                }
            });
            this.initTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                }
            });
        }
        if (this.initTask.isFinished() && this.scheduleTask.isFinished()) {
            return this.initTask;
        }
        return this.scheduleTask;
    }

    public void setPropertyPaintingStyle(int n) {
        if (n == this.propertyPaintingStyle) {
            return;
        }
        int n2 = this.propertyPaintingStyle;
        this.propertyPaintingStyle = n;
        this.firePropertyChange(PROPERTY_PROPERTY_PAINTING_STYLE, new Integer(n2), new Integer(n));
    }

    public int getPropertyPaintingStyle() {
        return this.propertyPaintingStyle;
    }

    public void setSortingMode(int n) throws PropertyVetoException {
        if (this.sortingMode == n) {
            return;
        }
        int n2 = this.sortingMode;
        this.sortingMode = n;
        this.firePropertyChange(PROPERTY_SORTING_MODE, new Integer(n2), new Integer(n));
    }

    public int getSortingMode() {
        return this.sortingMode;
    }

    public void setCurrentPage(int n) {
        Component component;
        int n2;
        if (this.pageIndex == n) {
            return;
        }
        this.pageIndex = n;
        if (n < 0) {
            return;
        }
        if (n != this.pages.getSelectedIndex()) {
            this.pages.setSelectedIndex(n);
        }
        if ((n2 = this.pages.getSelectedIndex()) >= 0 && (component = this.pages.getComponentAt(n2)) instanceof PropertySheetTab) {
            ((PropertySheetTab)component).ensurePaneCreated();
        }
        this.firePropertyChange(PROP_PAGE_HELP_ID, null, null);
    }

    public boolean setCurrentPage(String string) {
        int n = this.pages.indexOfTab(string);
        if (n < 0) {
            return false;
        }
        this.setCurrentPage(n);
        return true;
    }

    public int getCurrentPage() {
        return this.pages.getSelectedIndex();
    }

    String getPageHelpID() {
        String string;
        Component component;
        if (this.isAncestorOf(this.pages) && (component = this.pages.getSelectedComponent()) instanceof PropertySheetTab && (string = ((PropertySheetTab)component).getHelpID()) != null) {
            return string;
        }
        return null;
    }

    public void setPlastic(boolean bl) {
        if (this.plastic == bl) {
            return;
        }
        this.plastic = bl;
        this.firePropertyChange(PROPERTY_PLASTIC, bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getPlastic() {
        return this.plastic;
    }

    public void setValueColor(Color color) {
        if (this.valueColor.equals(color)) {
            return;
        }
        Color color2 = this.valueColor;
        this.valueColor = color;
        this.firePropertyChange(PROPERTY_VALUE_COLOR, color2, color);
    }

    public Color getValueColor() {
        return this.valueColor;
    }

    public void setDisabledPropertyColor(Color color) {
        if (this.disabledPropertyColor.equals(color)) {
            return;
        }
        Color color2 = this.disabledPropertyColor;
        this.disabledPropertyColor = color;
        this.firePropertyChange(PROPERTY_DISABLED_PROPERTY_COLOR, color2, color);
    }

    public Color getDisabledPropertyColor() {
        return this.disabledPropertyColor;
    }

    public void setDisplayWritableOnly(boolean bl) {
        if (this.displayWritableOnly == bl) {
            return;
        }
        this.displayWritableOnly = bl;
        this.firePropertyChange(PROPERTY_DISPLAY_WRITABLE_ONLY, bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getDisplayWritableOnly() {
        return this.displayWritableOnly;
    }

    void setSavedPosition(int n) {
        this.savedSplitterPosition = n;
    }

    int getSavedPosition() {
        return this.savedSplitterPosition;
    }

    private final String detachFromNode() {
        String string = null;
        if (this.activeNode != null) {
            this.activeNode.removeNodeListener(this.activeNodeListener);
            this.attached = false;
            Node.PropertySet[] propertySetArray = this.activeNode.getPropertySets();
            if (propertySetArray == null) {
                ErrorManager.getDefault().log(16, "Node " + this.activeNode + ": getPropertySets() returns null!");
                propertySetArray = new Node.PropertySet[]{};
            }
            if (this.pageIndex >= 0 && this.pageIndex < propertySetArray.length) {
                string = propertySetArray[this.pageIndex].getDisplayName();
            }
            int n = this.pages.getTabCount();
            for (int i = 0; i < n; ++i) {
                ((PropertySheetTab)this.pages.getComponentAt(i)).detachPropertyChangeListener();
            }
            this.pages.removeAll();
        }
        return string;
    }

    public void addNotify() {
        super.addNotify();
        if (this.activeNode != null) {
            if (!this.attached) {
                this.attachToNode(this.activeNode);
                this.createPages();
                if (this.storedTab != null) {
                    this.navToCorrectPage(this.storedTab);
                    this.storedTab = null;
                } else if (this.pages.getTabCount() > 0) {
                    String string = this.pages.getTitleAt(0);
                    this.navToCorrectPage(string);
                } else {
                    this.add((Component)this.emptyPanel, "Center");
                }
            }
        } else {
            this.remove(this.pages);
            this.add((Component)this.emptyPanel, "Center");
        }
    }

    public void removeNotify() {
        if (this.attached) {
            this.storedTab = this.detachFromNode();
        }
        super.removeNotify();
    }

    private final void attachToNode(Node node) {
        if (this.activeNodeListener == null) {
            this.activeNodeListener = new ActiveNodeListener();
        }
        this.activeNode.addNodeListener(this.activeNodeListener);
        this.attached = true;
    }

    private final void createPages() {
        Node.PropertySet[] propertySetArray = this.activeNode.getPropertySets();
        if (propertySetArray == null) {
            ErrorManager.getDefault().log(16, "Node " + this.activeNode + ": getPropertySets() returns null!");
            propertySetArray = new Node.PropertySet[]{};
        }
        int n = propertySetArray.length;
        for (int i = 0; i < n; ++i) {
            Node.PropertySet propertySet = propertySetArray[i];
            if (propertySet.isHidden()) continue;
            this.pages.addTab(propertySet.getDisplayName(), null, new CustomPropertyPane(propertySet), propertySet.getShortDescription());
        }
    }

    private final void navToCorrectPage(String string) {
        Component component;
        int n;
        if (this.isAncestorOf(this.emptyPanel)) {
            this.remove(this.emptyPanel);
        }
        this.add((Component)this.pages, "Center");
        if (string != null) {
            this.setCurrentPage(string);
        }
        if ((n = this.pages.getSelectedIndex()) >= 0 && (component = this.pages.getComponentAt(n)) instanceof PropertySheetTab) {
            ((PropertySheetTab)component).ensurePaneCreated();
        }
    }

    private void setCurrentNode(Node node) {
        if (this.activeNode == node) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Current node for propertysheet set from off the AWT thread: " + Thread.currentThread());
        }
        String string = this.detachFromNode();
        this.activeNode = node;
        if (this.getParent() == null) {
            return;
        }
        if (this.activeNode != null) {
            this.attachToNode(this.activeNode);
            this.createPages();
            if (this.pages.getTabCount() > 0) {
                this.navToCorrectPage(string);
            } else if (this.isAncestorOf(this.pages)) {
                this.remove(this.pages);
                this.add((Component)this.emptyPanel, "Center");
            }
        } else if (this.isAncestorOf(this.pages)) {
            this.remove(this.pages);
            this.add((Component)this.emptyPanel, "Center");
        }
        this.revalidate();
        this.repaint();
        if (this.activeNode != null && this.activeNode.hasCustomizer()) {
            this.firePropertyChange(PROP_HAS_CUSTOMIZER, null, Boolean.TRUE);
        } else {
            this.firePropertyChange(PROP_HAS_CUSTOMIZER, null, Boolean.FALSE);
        }
        this.firePropertyChange(PROP_PAGE_HELP_ID, null, null);
    }

    void invokeCustomization() {
        NodeOperation.getDefault().customize(this.activeNode);
    }

    void invokeHelp() {
        HelpCtx helpCtx = new HelpCtx(this.getPageHelpID());
        try {
            Class<?> clazz = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass("org.netbeans.api.javahelp.Help");
            Object object = Lookup.getDefault().lookup(clazz);
            if (object != null) {
                Method method = clazz.getMethod("showHelp", HelpCtx.class);
                method.invoke(object, helpCtx);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        Toolkit.getDefaultToolkit().beep();
    }

    static {
        current = new ThreadLocal();
    }

    private static final class HelpAwareJTabbedPane
    extends JTabbedPane
    implements HelpCtx.Provider {
        public HelpAwareJTabbedPane() {
            if (Boolean.getBoolean("netbeans.scrolling.tabs")) {
                boolean bl;
                boolean bl2 = bl = Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0;
                if (bl) {
                    try {
                        Method method = this.getClass().getMethod("setTabLayoutPolicy", Integer.TYPE);
                        method.invoke((Object)this, new Integer(1));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
            }
        }

        public HelpCtx getHelpCtx() {
            String string;
            Component component = this.getSelectedComponent();
            if (component instanceof PropertySheetTab && (string = ((PropertySheetTab)component).getHelpID()) != null) {
                return new HelpCtx(string);
            }
            return HelpCtx.findHelp((Component)this.getParent());
        }
    }

    private class ActiveNodeListener
    extends NodeAdapter {
        int id;

        ActiveNodeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() != PropertySheet.this.activeNode) {
                return;
            }
            if (propertyChangeEvent.getPropertyName() == null || "propertySets".equals(propertyChangeEvent.getPropertyName())) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        Node.PropertySet[] propertySetArray;
                        String string = null;
                        if (PropertySheet.this.activeNode != null) {
                            propertySetArray = PropertySheet.this.activeNode.getPropertySets();
                            if (propertySetArray == null) {
                                ErrorManager.getDefault().log(16, "Node " + PropertySheet.this.activeNode + ": getPropertySets() returns null!");
                                propertySetArray = new Node.PropertySet[]{};
                            }
                            if (PropertySheet.this.pageIndex >= 0 && PropertySheet.this.pageIndex < propertySetArray.length) {
                                string = propertySetArray[PropertySheet.this.pageIndex].getDisplayName();
                            }
                        }
                        propertySetArray = PropertySheet.this.activeNode;
                        PropertySheet.this.setCurrentNode(null);
                        PropertySheet.this.setCurrentNode((Node)propertySetArray);
                        if (string != null) {
                            PropertySheet.this.setCurrentPage(string);
                        }
                    }
                });
            }
        }
    }

    private static class PropertySheetSettingsInvoker
    implements Runnable {
        public void run() {
            PropertySheet propertySheet = (PropertySheet)current.get();
            current.set(null);
            if (propertySheet == null) {
                throw new IllegalStateException();
            }
            PropertySheetSettings propertySheetSettings = PropertySheetSettings.getDefault();
            propertySheet.displayWritableOnly = propertySheetSettings.getDisplayWritableOnly();
            propertySheet.propertyPaintingStyle = propertySheetSettings.getPropertyPaintingStyle();
            propertySheet.sortingMode = propertySheetSettings.getSortingMode();
            propertySheet.plastic = propertySheetSettings.getPlastic();
            propertySheet.disabledPropertyColor = propertySheetSettings.getDisabledPropertyColor();
            propertySheet.valueColor = propertySheetSettings.getValueColor();
        }
    }
}

