/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.prop;

import com.hp.openvms.netbeans.cppsupport.prop.ExPropertyModel;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyEnv;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyModel;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyPanel;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class PropertyDialogManager
implements VetoableChangeListener {
    private PropertyChangeListener listener;
    private Object oldValue;
    private PropertyEditor editor;
    private PropertyModel model;
    private Node.Property prop;
    private boolean changed = false;
    private Component component;
    private Window dialog;
    private JButton okButton;
    private Runnable errorPerformer;
    private boolean okButtonState = true;
    private boolean defaultValue = false;
    private boolean isModal = true;
    private String title = null;
    private HelpCtx helpCtx = null;
    private Object defaultOption;
    private Object[] options;
    private Object envStateBeforeDisplay = null;
    private PropertyEnv env;
    private static ThreadLocal caller = new ThreadLocal();
    private ActionListener actionListener;
    private Object lastValueFromEditor;
    private static final String PROPERTY_DESCRIPTION = "description";
    private static Throwable doNotNotify;

    public PropertyDialogManager(String string, boolean bl, PropertyEditor propertyEditor, PropertyModel propertyModel, PropertyEnv propertyEnv) {
        Object object;
        this.editor = propertyEditor;
        if (propertyEnv != null) {
            propertyEnv.addVetoableChangeListener(this);
        }
        this.component = propertyEditor.getCustomEditor();
        this.model = propertyModel;
        this.env = propertyEnv;
        this.title = string;
        this.isModal = bl;
        this.actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialogManager.this.doButtonPressed(actionEvent);
            }
        };
        if (propertyEnv != null && (object = propertyEnv.getFeatureDescriptor().getValue("helpID")) != null && object instanceof String && this.component != null && this.component instanceof JComponent) {
            HelpCtx.setHelpIDString((JComponent)((JComponent)this.component), (String)((String)object));
            this.helpCtx = new HelpCtx((String)object);
        }
        this.createDialog();
        this.initializeListeners();
    }

    public Window getDialog() {
        return this.dialog;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (this.env != null && "state".equals(propertyChangeEvent.getPropertyName())) {
            boolean bl = this.okButtonState = propertyChangeEvent.getNewValue() != PropertyEnv.STATE_INVALID;
            if (this.okButton != null) {
                this.okButton.setEnabled(this.okButtonState);
            }
        }
    }

    private void createDialog() {
        Object object;
        Object object2;
        Class<?> clazz;
        if (this.component instanceof Window) {
            this.dialog = (Window)this.component;
            this.dialog.pack();
            return;
        }
        boolean bl = false;
        if (this.model instanceof ExPropertyModel && (clazz = ((ExPropertyModel)this.model).getFeatureDescriptor()) instanceof Node.Property) {
            this.prop = (Node.Property)clazz;
            bl = !this.prop.canWrite();
            this.defaultValue = this.prop.supportsDefaultValue();
        }
        if (this.editor == null || bl) {
            clazz = new JButton(PropertyDialogManager.getString("CTL_Close"));
            ((JButton)((Object)clazz)).getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_Close"));
            this.options = new Object[]{clazz};
            this.defaultOption = clazz;
        } else {
            this.okButton = new JButton(PropertyDialogManager.getString("CTL_OK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_OK"));
            clazz = new JButton(PropertyDialogManager.getString("CTL_Cancel"));
            ((JComponent)((Object)clazz)).setVerifyInputWhenFocusTarget(false);
            ((JButton)((Object)clazz)).getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_Cancel"));
            ((JButton)((Object)clazz)).setDefaultCapable(false);
            if (this.defaultValue) {
                object2 = new JButton(PropertyDialogManager.getString("CTL_Default"));
                ((AbstractButton)object2).setMnemonic(PropertyDialogManager.getString("CTL_DefaultMnemonic").charAt(0));
                ((JButton)object2).getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_Default"));
                ((JButton)object2).setDefaultCapable(false);
                ((JComponent)object2).setVerifyInputWhenFocusTarget(false);
                this.options = new Object[]{object2, this.okButton, clazz};
            } else {
                this.options = new Object[]{this.okButton, clazz};
            }
            this.defaultOption = this.okButton;
        }
        if (this.env != null && this.okButton != null) {
            boolean bl2 = this.okButtonState = this.env.getState() != PropertyEnv.STATE_INVALID;
            if (this.okButton != null) {
                this.okButton.setEnabled(this.okButtonState);
            }
        }
        if (this.env != null) {
            this.envStateBeforeDisplay = this.env.getState();
        }
        try {
            caller.set(this);
            clazz = Class.forName("org.openide.explorer.propertysheet.PropertyDialogManager$CreateDialogInvoker");
            object2 = (Runnable)clazz.newInstance();
            object2.run();
            return;
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        if (this.dialog == null) {
            object = new JOptionPane(this.component, -1, 1, null, this.options, this.defaultOption);
            if (this.okButton != null) {
                this.okButton.addActionListener(this.actionListener);
            }
            this.dialog = ((JOptionPane)object).createDialog(null, this.title);
        }
        if (this.env != null && (object = this.env.getFeatureDescriptor().getValue(PROPERTY_DESCRIPTION)) instanceof String) {
            this.dialog.getAccessibleContext().setAccessibleDescription((String)object);
        }
    }

    private void initializeListeners() {
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (PropertyDialogManager.this.editor != null && !(PropertyDialogManager.this.component instanceof Window)) {
                    PropertyDialogManager.this.cancelValue();
                }
                if (PropertyDialogManager.this.env != null) {
                    PropertyDialogManager.this.env.removeVetoableChangeListener(PropertyDialogManager.this);
                }
                PropertyDialogManager.this.dialog.dispose();
            }

            public void windowClosed(WindowEvent windowEvent) {
                if (PropertyDialogManager.this.component instanceof Window) {
                    if (PropertyDialogManager.this.component instanceof EnhancedCustomPropertyEditor) {
                        try {
                            Object object = ((EnhancedCustomPropertyEditor)PropertyDialogManager.this.component).getPropertyValue();
                            PropertyDialogManager.this.model.setValue(object);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            PropertyPanel.notifyUser(invocationTargetException, PropertyDialogManager.this.prop == null ? "" : PropertyDialogManager.this.prop.getDisplayName());
                        }
                        catch (IllegalStateException illegalStateException) {
                            PropertyDialogManager.notifyUser(illegalStateException);
                        }
                    } else if (PropertyDialogManager.this.env != null && !PropertyDialogManager.this.env.isChangeImmediate()) {
                        try {
                            PropertyDialogManager.this.model.setValue(PropertyDialogManager.this.lastValueFromEditor);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            PropertyPanel.notifyUser(invocationTargetException, PropertyDialogManager.this.prop == null ? "" : PropertyDialogManager.this.prop.getDisplayName());
                        }
                        catch (IllegalStateException illegalStateException) {
                            PropertyDialogManager.notifyUser(illegalStateException);
                        }
                    }
                }
                if (PropertyDialogManager.this.listener != null) {
                    PropertyDialogManager.this.editor.removePropertyChangeListener(PropertyDialogManager.this.listener);
                }
                PropertyDialogManager.this.dialog.removeWindowListener(this);
            }
        });
        if (this.editor != null) {
            try {
                this.oldValue = this.model.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lastValueFromEditor = this.editor.getValue();
            this.listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PropertyDialogManager.this.changed = true;
                    PropertyDialogManager.this.lastValueFromEditor = PropertyDialogManager.this.editor.getValue();
                    if ("propertyValueValid".equals(propertyChangeEvent.getPropertyName()) && PropertyDialogManager.this.okButton != null && propertyChangeEvent.getNewValue() instanceof Boolean) {
                        Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                        PropertyDialogManager.this.okButtonState = bl;
                        if (PropertyDialogManager.this.env != null) {
                            PropertyDialogManager.this.env.setState(PropertyDialogManager.this.okButtonState ? PropertyEnv.STATE_VALID : PropertyEnv.STATE_INVALID);
                        } else {
                            PropertyDialogManager.this.okButton.setEnabled(PropertyDialogManager.this.okButtonState);
                        }
                        if (propertyChangeEvent.getOldValue() instanceof Runnable) {
                            PropertyDialogManager.this.errorPerformer = (Runnable)propertyChangeEvent.getOldValue();
                        } else {
                            PropertyDialogManager.this.errorPerformer = null;
                        }
                    }
                }
            };
            this.editor.addPropertyChangeListener(this.listener);
            this.listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("helpCtx".equals(propertyChangeEvent.getPropertyName()) && PropertyDialogManager.this.dialog instanceof PropertyChangeListener) {
                        ((PropertyChangeListener)((Object)PropertyDialogManager.this.dialog)).propertyChange(propertyChangeEvent);
                    }
                }
            };
            this.component.addPropertyChangeListener(this.listener);
        }
    }

    private void cancelValue() {
        if (!this.changed || this.component instanceof EnhancedCustomPropertyEditor || this.env != null && !this.env.isChangeImmediate()) {
            if (this.env != null && this.envStateBeforeDisplay != null) {
                this.env.setState(this.envStateBeforeDisplay);
            }
            return;
        }
        try {
            this.model.setValue(this.oldValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doButtonPressed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(PropertyDialogManager.getString("CTL_Cancel"))) {
            this.cancelValue();
        }
        if (string.equals(PropertyDialogManager.getString("CTL_Default")) && this.prop != null) {
            try {
                this.prop.restoreDefaultValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                PropertyPanel.notifyUser(illegalAccessException, this.prop.getDisplayName());
            }
            catch (InvocationTargetException invocationTargetException) {
                PropertyPanel.notifyUser(invocationTargetException, this.prop.getDisplayName());
            }
        }
        if (string.equals(PropertyDialogManager.getString("CTL_OK"))) {
            if (this.env != null && this.env.getState() == PropertyEnv.STATE_NEEDS_VALIDATION) {
                this.env.setState(PropertyEnv.STATE_VALID);
                if (this.env.getState() != PropertyEnv.STATE_VALID) {
                    return;
                }
            }
            if (this.component instanceof EnhancedCustomPropertyEditor) {
                try {
                    Object object = ((EnhancedCustomPropertyEditor)this.component).getPropertyValue();
                    this.model.setValue(object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    PropertyPanel.notifyUser(invocationTargetException, this.prop == null ? "" : this.prop.getDisplayName());
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    PropertyDialogManager.notifyUser(illegalStateException);
                    return;
                }
            }
            if (this.env != null && !this.env.isChangeImmediate()) {
                try {
                    this.model.setValue(this.lastValueFromEditor);
                }
                catch (InvocationTargetException invocationTargetException) {
                    PropertyPanel.notifyUser(invocationTargetException, this.prop == null ? "" : this.prop.getDisplayName());
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    PropertyDialogManager.notifyUser(illegalStateException);
                    return;
                }
            }
            if (!this.okButtonState) {
                if (this.errorPerformer != null) {
                    this.errorPerformer.run();
                }
                return;
            }
        }
        this.changed = false;
        if (this.env != null) {
            this.env.removeVetoableChangeListener(this);
        }
        this.dialog.dispose();
    }

    private static String getString(String string) {
        return NbBundle.getBundle((Class)PropertyDialogManager.class).getString(string);
    }

    static void doNotNotify(Throwable throwable) {
        doNotNotify = throwable;
    }

    static void notify(Throwable throwable) {
        Throwable throwable2 = doNotNotify;
        doNotNotify = null;
        if (throwable2 == throwable) {
            return;
        }
        ErrorManager.getDefault().notify(throwable);
    }

    static void notify(int n, Throwable throwable) {
        Throwable throwable2 = doNotNotify;
        doNotNotify = null;
        if (throwable2 == throwable) {
            return;
        }
        ErrorManager.getDefault().notify(n, throwable);
    }

    private static void notifyUser(Exception exception) {
        ErrorManager errorManager = ErrorManager.getDefault();
        ErrorManager.Annotation[] annotationArray = errorManager.findAnnotations((Throwable)exception);
        String string = null;
        if (annotationArray != null) {
            for (int i = 0; i < annotationArray.length; ++i) {
                String string2 = annotationArray[i].getLocalizedMessage();
                if (string2 == null) continue;
                string = string2;
                break;
            }
        }
        if (string == null) {
            string = exception.getLocalizedMessage();
        }
        if (string != null) {
            Throwable throwable = errorManager.annotate((Throwable)exception, string);
            errorManager.notify(256, throwable);
        } else {
            errorManager.notify(1, (Throwable)exception);
        }
    }

    static Throwable annotate(Throwable throwable, int n, String string, String string2, Throwable throwable2, Date date) {
        return ErrorManager.getDefault().annotate(throwable, n, string, string2, throwable2, date);
    }

    static class CreateDialogInvoker
    implements Runnable {
        CreateDialogInvoker() {
        }

        public void run() {
            PropertyDialogManager propertyDialogManager = (PropertyDialogManager)caller.get();
            caller.set(null);
            if (propertyDialogManager == null) {
                throw new IllegalStateException("Parameter caller not passed.");
            }
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyDialogManager.component, propertyDialogManager.title, propertyDialogManager.isModal, propertyDialogManager.options, propertyDialogManager.defaultOption, 0, propertyDialogManager.helpCtx, propertyDialogManager.actionListener);
            propertyDialogManager.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        }
    }
}

