/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cobolsupport.cobol.datasys;

import com.hp.openvms.netbeans.baseclasses.actions.RemoteCompilerAction;
import com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompiler;
import com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompilerGroup;
import com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompilerType;
import com.hp.openvms.netbeans.cobolsupport.cobol.datasys.CobolDataNode;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.cookies.RemoteBuildCookie;
import org.netbeans.modules.distributed.common.cookies.RemoteCompileCookie;
import org.netbeans.modules.distributed.common.propertyeditors.BoolEditor;
import org.netbeans.modules.distributed.common.propertyeditors.NbProcessDescriptorEditor2;
import org.netbeans.modules.distributed.common.propertyeditors.StringEditor2;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.propertyeditor.FileEditor;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.ErrorManager;
import org.openide.compiler.CompilerSupport;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CobolCompilerSupport
extends CompilerSupport {
    public static final String PROP_DEFINE = "CobolDefine";
    public static final String PROP_BUILD_OPTION = "buildOption";
    public static final String PROP_ANSIFORMATTING = "ansiFormatting";
    public static final String PROP_OPTIMIZE = "optimize";
    public static final String PROP_CHECK = "check";
    public static final String PROP_OPTIONS = "options";
    public static final String PROP_BUILD_DIRECTORY = "buildDirectory";
    public static final String PROP_OBJECT_DIRECTORY = "objectDirectory";
    public static final String PROP_LIST_DIRECTORY = "listDirectory";
    public static final String PROP_OUTPUT_SWITCH = "outputSwitch";
    public static final String PROP_BUILD_COMMAND = "buildCommand";
    public static final String PROP_INCLUDE = "include";
    public static final String PROP_LIBRARY = "library";
    public static final String PROP_DEBUG = "debug";
    public static final String PROP_OTHER_OPTIONS = "otherOptions";
    public static final String PROP_EXTERNAL_COMPILER = "externalCompiler";
    public static final String PROP_MAKEFILE_COMPILER = "makefileCompiler";
    public static final String PROP_COBOL_GLOBAL_QUALIFIER = "globalQualifier";
    public static final String PROP_COBOL_LOCAL_QUALIFIER = "localQualifier";
    protected static final ResourceBundle bundle = NbBundle.getBundle((Class)CobolCompilerSupport.class);
    protected MultiDataObject.Entry entry;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$openide$execution$NbProcessDescriptor;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Build;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Clean;
    static /* synthetic */ Class class$org$netbeans$modules$distributed$common$cookies$RemoteCompileCookie;
    static /* synthetic */ Class class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie;

    protected CobolCompilerSupport(MultiDataObject.Entry entry, Class clazz) {
        super(entry, clazz);
        this.entry = entry;
    }

    protected CobolCompilerType getProjCompilerType() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.getFileObject());
        if (project != null) {
            RemoteProjectSettings remoteProjectSettings = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
            if (remoteProjectSettings == null) {
                return new CobolCompilerType(this.getFileObject());
            }
            return (CobolCompilerType)((Object)remoteProjectSettings.getCompilerSettings("cobol"));
        }
        return null;
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createExternalCompilerProperty());
        set.put((Node.Property)this.createAnsiFormattingProperty());
        set.put((Node.Property)this.createCobolLocalQualifierProperty());
        set.put((Node.Property)this.createCobolGlobalQualifierProperty());
    }

    public void addBuildOptionProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildOptionProperty());
    }

    public void addMakefileProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildDirectoryProperty());
        set.put((Node.Property)this.createMakefileCompilerProperty());
        set.put((Node.Property)this.createBuildCommandProperty());
        set.put((Node.Property)this.createOutputSwitchProperty());
        set.put((Node.Property)this.createXDisplayDeviceNumber());
    }

    public void addRemoteProperties(Sheet.Set set) {
        set.put((Node.Property)this.createRemoteFilePathProperty());
        try {
            if (this.entry.getFile().getFileSystem() instanceof FTPFileSystem) {
                set.put((Node.Property)this.createFileResidenceProperty());
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public Boolean getBuildOption() {
        Boolean bl = (Boolean)this.entry.getFile().getAttribute(PROP_BUILD_OPTION);
        if (bl == null) {
            return (Boolean)this.getProjCompilerType().getBuildOption();
        }
        return bl;
    }

    private synchronized void setBuildOption(Boolean bl) throws IOException {
        Node node = this.entry.getDataObject().getNodeDelegate();
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        if (bl == null) {
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, this.getProjCompilerType().getBuildOption());
            return;
        }
        if (node instanceof CobolDataNode) {
            if (bl.equals(Boolean.TRUE)) {
                propertySetArray[1].setHidden(true);
                propertySetArray[2].setHidden(false);
            } else {
                propertySetArray[1].setHidden(false);
                propertySetArray[2].setHidden(true);
            }
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, (Object)bl);
            ((CobolDataNode)node).firePropertySetChange2(null, propertySetArray);
        }
    }

    public Boolean getAnsiFormatting() {
        Boolean bl = (Boolean)this.entry.getFile().getAttribute(PROP_ANSIFORMATTING);
        if (bl == null) {
            return (Boolean)this.getProjCompilerType().getAnsiFormatting();
        }
        return bl;
    }

    private synchronized void setAnsiFormatting(Boolean bl) throws IOException {
        Node node = this.entry.getDataObject().getNodeDelegate();
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        if (bl == null) {
            this.entry.getFile().setAttribute(PROP_ANSIFORMATTING, null);
        } else if (node instanceof CobolDataNode) {
            this.entry.getFile().setAttribute(PROP_ANSIFORMATTING, (Object)bl);
        }
    }

    public RemoteFSFile getBuildDirectory() {
        Object object = this.entry.getFile().getAttribute(PROP_BUILD_DIRECTORY);
        if (object == null || object instanceof RemoteFSFile && ((RemoteFSFile)object).getAbsolutePath().equals("")) {
            return this.getProjCompilerType().getBuildDirectory();
        }
        if (object != null && !(object instanceof RemoteFSFile)) {
            try {
                this.entry.getFile().setAttribute(PROP_BUILD_DIRECTORY, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getBuildDirectory();
        }
        return (RemoteFSFile)object;
    }

    private synchronized void setBuildDirectory(RemoteFSFile remoteFSFile) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_DIRECTORY, (Object)remoteFSFile);
    }

    public Boolean getOutputSwitch() {
        Boolean bl = (Boolean)this.entry.getFile().getAttribute(PROP_OUTPUT_SWITCH);
        if (bl == null) {
            return this.getProjCompilerType().outputSwitch();
        }
        return bl;
    }

    private synchronized void setOutputSwitch(Boolean bl) throws IOException {
        this.entry.getFile().setAttribute(PROP_OUTPUT_SWITCH, (Object)bl);
    }

    public Integer getXDisplayNumber() {
        Integer n = (Integer)this.entry.getFile().getAttribute("xDisplayDeviceNumber");
        if (n == null) {
            return this.getProjCompilerType().xDisplayNumber();
        }
        return n;
    }

    private synchronized void setXDisplayNumber(Integer n) throws IOException {
        this.entry.getFile().setAttribute("xDisplayDeviceNumber", (Object)n);
    }

    public String getBuildCommand() {
        String string = (String)this.entry.getFile().getAttribute(PROP_BUILD_COMMAND);
        if (string == null) {
            return this.getProjCompilerType().getBuildCommand();
        }
        return string;
    }

    private synchronized void setBuildCommand(String string) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_COMMAND, (Object)string);
    }

    private String getCurrentFileDir() {
        try {
            String string = FileUtil.toFile((FileObject)this.entry.getDataObject().getPrimaryFile().getFileSystem().getRoot()).getAbsolutePath();
            String string2 = this.entry.getDataObject().getPrimaryFile().getParent().getPackageNameExt('/', '.');
            Object var3_4 = null;
            return string + '/' + string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public NbProcessDescriptor getExternalCompiler() {
        Object object = this.entry.getFile().getAttribute(PROP_EXTERNAL_COMPILER);
        if (object != null && object instanceof NbProcessDescriptor) {
            return (NbProcessDescriptor)object;
        }
        return this.getProjCompilerType().getExternalCompiler();
    }

    private void setExternalCompiler(NbProcessDescriptor nbProcessDescriptor) throws IOException {
        this.entry.getFile().setAttribute(PROP_EXTERNAL_COMPILER, (Object)nbProcessDescriptor);
    }

    public RemoteFSFile getMakefileCompiler() {
        Object object = this.entry.getFile().getAttribute(PROP_MAKEFILE_COMPILER);
        if (object != null && object instanceof RemoteFSFile) {
            return (RemoteFSFile)object;
        }
        if (object != null && object instanceof String) {
            try {
                this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getMakefileCompiler();
        }
        return this.getProjCompilerType().getMakefileCompiler();
    }

    private void setMakefileCompiler(RemoteFSFile remoteFSFile) throws IOException {
        this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, (Object)remoteFSFile);
    }

    private void setLocalQualifier(String string) throws IOException {
        this.entry.getFile().setAttribute(PROP_COBOL_LOCAL_QUALIFIER, (Object)string);
    }

    private void setGlobalQualifier(String string) throws IOException {
        this.entry.getFile().setAttribute(PROP_COBOL_GLOBAL_QUALIFIER, (Object)string);
    }

    public String getLocalQualifier() {
        String string = (String)this.entry.getFile().getAttribute(PROP_COBOL_LOCAL_QUALIFIER);
        if (string == null) {
            return this.getProjCompilerType().getLocalQualifier();
        }
        return string;
    }

    public String getGlobalQualifier() {
        String string = (String)this.entry.getFile().getAttribute(PROP_COBOL_GLOBAL_QUALIFIER);
        if (string == null) {
            return this.getProjCompilerType().getGlobalQualifier();
        }
        return string;
    }

    private PropertySupport createBuildOptionProperty() {
        class BuildOptionPropertySupport
        extends PropertySupport.ReadWrite {
            public BuildOptionPropertySupport() {
                super(CobolCompilerSupport.PROP_BUILD_OPTION, class$java$lang$Object == null ? (class$java$lang$Object = CobolCompilerSupport.class$("java.lang.Object")) : class$java$lang$Object, CobolCompilerSupport.this.getFlaggedNameBuildOption(CobolCompilerSupport.this.getString("PROP_BUILD_OPTION"), CobolCompilerSupport.PROP_BUILD_OPTION), CobolCompilerSupport.this.getString("HINT_BUILD_OPTION"));
                this.setValue("helpID", "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_BUILD_OPTION, "org.openide.filesystems.FileObject");
                if (CobolCompilerSupport.this.getProjCompilerType().getBuildOption() != null) {
                    this.setValue("projValue", CobolCompilerSupport.this.getProjCompilerType().getBuildOption());
                }
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getBuildOption();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof Boolean || object == null) {
                    try {
                        CobolCompilerSupport.this.setBuildOption((Boolean)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getBuildOption());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new BuildOptionPropertySupport();
    }

    private PropertySupport createAnsiFormattingProperty() {
        class AnsiFormattingPropertySupport
        extends PropertySupport.ReadWrite {
            public AnsiFormattingPropertySupport() {
                super(CobolCompilerSupport.PROP_ANSIFORMATTING, class$java$lang$Object == null ? (class$java$lang$Object = CobolCompilerSupport.class$("java.lang.Object")) : class$java$lang$Object, CobolCompilerSupport.this.getFlaggedNameAnsiFormatting(CobolCompilerSupport.this.getString("PROP_ANSIFORMATTING"), CobolCompilerSupport.PROP_ANSIFORMATTING), CobolCompilerSupport.this.getString("HINT_ANSIFORMATTING"));
                this.setValue("helpID", "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_ANSIFORMATTING, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileMakefileSettings");
                if (CobolCompilerSupport.this.getProjCompilerType().getAnsiFormatting() != null) {
                    this.setValue("projValue", CobolCompilerSupport.this.getProjCompilerType().getAnsiFormatting());
                }
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getAnsiFormatting();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof Boolean || object == null) {
                    try {
                        CobolCompilerSupport.this.setAnsiFormatting((Boolean)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getAnsiFormatting());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new AnsiFormattingPropertySupport();
    }

    private PropertySupport createBuildDirectoryProperty() {
        class PropertySupportBuildDirectory
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildDirectory() {
                super(CobolCompilerSupport.PROP_BUILD_DIRECTORY, class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile == null ? (class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile = CobolCompilerSupport.class$("org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile")) : class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile, CobolCompilerSupport.this.getFlaggedName(CobolCompilerSupport.this.getString("PROP_BUILD_DIRECTORY"), CobolCompilerSupport.PROP_BUILD_DIRECTORY), CobolCompilerSupport.this.getString("HINT_BUILD_DIRECTORY"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.FALSE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", CobolCompilerSupport.this.entry.getFile().getNameExt());
                try {
                    if (CobolCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", CobolCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (CobolCompilerSupport.this.getProjCompilerType().getBuildDirectory() != null) {
                    this.setValue("projvalue", CobolCompilerSupport.this.getProjCompilerType().getBuildDirectory());
                }
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_BUILD_DIRECTORY, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileMakefileSettings");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getBuildDirectory();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof RemoteFSFile || object == null) {
                    try {
                        CobolCompilerSupport.this.setBuildDirectory((RemoteFSFile)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getBuildDirectory());
                CobolCompilerSupport.this.changeResetProp(CobolCompilerSupport.PROP_BUILD_DIRECTORY, this.getValue());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new PropertySupportBuildDirectory();
    }

    private PropertySupport createXDisplayDeviceNumber() {
        class XDisplayDeviceNumberPropertySupport
        extends PropertySupport.ReadWrite {
            public XDisplayDeviceNumberPropertySupport() {
                super("X Display Device Number", class$java$lang$Integer == null ? (class$java$lang$Integer = CobolCompilerSupport.class$("java.lang.Integer")) : class$java$lang$Integer, "X Display Device Number", "Defines the screen associated with the display device");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getXDisplayNumber();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof Integer || object == null) {
                    try {
                        CobolCompilerSupport.this.setXDisplayNumber((Integer)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new XDisplayDeviceNumberPropertySupport();
    }

    private PropertySupport createOutputSwitchProperty() {
        class OutputSwitchPropertySupport
        extends PropertySupport.ReadWrite {
            public OutputSwitchPropertySupport() {
                super(CobolCompilerSupport.PROP_OUTPUT_SWITCH, class$java$lang$Object == null ? (class$java$lang$Object = CobolCompilerSupport.class$("java.lang.Object")) : class$java$lang$Object, CobolCompilerSupport.this.getString("PROP_OUTPUT_SWITCH"), CobolCompilerSupport.this.getString("HINT_OUTPUT_SWITCH"));
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_OUTPUT_SWITCH, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
                if (CobolCompilerSupport.this.getProjCompilerType().outputSwitch() != null) {
                    this.setValue("projValue", CobolCompilerSupport.this.getProjCompilerType().outputSwitch());
                }
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getOutputSwitch();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof Boolean || object == null) {
                    try {
                        CobolCompilerSupport.this.setOutputSwitch((Boolean)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getOutputSwitch());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new OutputSwitchPropertySupport();
    }

    private PropertySupport createBuildCommandProperty() {
        class PropertySupportBuildCommand
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildCommand() {
                super(CobolCompilerSupport.PROP_BUILD_COMMAND, class$java$lang$String == null ? (class$java$lang$String = CobolCompilerSupport.class$("java.lang.String")) : class$java$lang$String, CobolCompilerSupport.this.getFlaggedName(CobolCompilerSupport.this.getString("PROP_BUILD_COMMAND"), CobolCompilerSupport.PROP_BUILD_COMMAND), CobolCompilerSupport.this.getString("HINT_BUILD_COMMAND"));
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_BUILD_COMMAND, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getBuildCommand();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof String || object == null) {
                    try {
                        CobolCompilerSupport.this.setBuildCommand((String)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getBuildCommand());
                CobolCompilerSupport.this.changeResetProp(CobolCompilerSupport.PROP_BUILD_COMMAND, this.getValue());
            }

            public boolean canWrite() {
                return !CobolCompilerSupport.this.entry.getFile().isReadOnly();
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new PropertySupportBuildCommand();
    }

    private PropertySupport createExternalCompilerProperty() {
        class ExternalCompilerPropertySupport
        extends PropertySupport.ReadWrite {
            public ExternalCompilerPropertySupport() {
                super(CobolCompilerSupport.PROP_EXTERNAL_COMPILER, class$org$openide$execution$NbProcessDescriptor == null ? (class$org$openide$execution$NbProcessDescriptor = CobolCompilerSupport.class$("org.openide.execution.NbProcessDescriptor")) : class$org$openide$execution$NbProcessDescriptor, CobolCompilerSupport.this.getFlaggedName(CobolCompilerSupport.this.getString("PROP_EXTERNAL_COMPILER"), CobolCompilerSupport.PROP_EXTERNAL_COMPILER), CobolCompilerSupport.this.getString("HINT_EXTERNAL_COMPILER"));
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_EXTERNAL_COMPILER, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getExternalCompiler();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof NbProcessDescriptor || object == null) {
                    try {
                        CobolCompilerSupport.this.setExternalCompiler((NbProcessDescriptor)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public PropertyEditor getPropertyEditor() {
                return new NbProcessDescriptorEditor2();
            }
        }
        return new ExternalCompilerPropertySupport();
    }

    private PropertySupport createMakefileCompilerProperty() {
        class MakefileProperty
        extends PropertySupport.ReadWrite {
            public MakefileProperty() {
                super(CobolCompilerSupport.PROP_MAKEFILE_COMPILER, class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile == null ? (class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile = CobolCompilerSupport.class$("org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile")) : class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile, CobolCompilerSupport.this.getFlaggedNameMakefile(CobolCompilerSupport.this.getString("PROP_MAKEFILE_COMPILER"), CobolCompilerSupport.PROP_MAKEFILE_COMPILER), CobolCompilerSupport.this.getString("HINT_MAKEFILE_COMPILER"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.TRUE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", CobolCompilerSupport.this.entry.getFile().getNameExt());
                if (CobolCompilerSupport.this.getProjCompilerType().getMakefileCompiler() != null) {
                    this.setValue("projvalue", CobolCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
                }
                try {
                    if (CobolCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", CobolCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_MAKEFILE_COMPILER, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getMakefileCompiler();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof RemoteFSFile || object == null) {
                    try {
                        CobolCompilerSupport.this.setMakefileCompiler((RemoteFSFile)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(CobolCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
                CobolCompilerSupport.this.changeResetProp(CobolCompilerSupport.PROP_MAKEFILE_COMPILER, this.getValue());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new MakefileProperty();
    }

    private PropertySupport createFileResidenceProperty() {
        class FileResidenceProperty
        extends PropertySupport.ReadOnly {
            public FileResidenceProperty() {
                super("File Residence", class$java$lang$String == null ? (class$java$lang$String = CobolCompilerSupport.class$("java.lang.String")) : class$java$lang$String, "File Residence", "Determine if the file should reside in local disk, server or both");
            }

            public Object getValue() {
                Object object;
                FileObject fileObject = CobolCompilerSupport.this.entry.getFile();
                Object object2 = fileObject.getAttribute("file_residence_mode");
                try {
                    object = (RemoteFileSystem)fileObject.getFileSystem();
                    if (object.getServerOnlyFileExts().isRegistered(fileObject.getExt())) {
                        return "Server Only";
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                }
                if (object2 != null) {
                    object = (Integer)object2;
                    String string = "Make Client and Server";
                    switch ((Integer)object) {
                        case 1: {
                            string = "Client Only";
                            break;
                        }
                        case 0: {
                            string = "Server Only";
                            break;
                        }
                        case 2: {
                            string = "Client and Server";
                        }
                    }
                    return string;
                }
                return "Client and Server";
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new FileResidenceProperty();
    }

    private PropertySupport createRemoteFilePathProperty() {
        class RemoteFilePathPropertySupport
        extends PropertySupport.ReadOnly {
            public RemoteFilePathPropertySupport() {
                super("Remote File Path", class$java$lang$String == null ? (class$java$lang$String = CobolCompilerSupport.class$("java.lang.String")) : class$java$lang$String, "Remote File Path", "Remote File Path");
            }

            public Object getValue() {
                FileObject fileObject = CobolCompilerSupport.this.entry.getFile();
                Object object = fileObject.getAttribute("REMOTE_FILEPATH");
                if (object != null) {
                    return object;
                }
                String string = fileObject.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (Utilities.isWindows()) {
                        string = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        string = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return string;
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    FileObject fileObject = CobolCompilerSupport.this.entry.getFile();
                    fileObject.setAttribute("REMOTE_FILEPATH", object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                FileObject fileObject = CobolCompilerSupport.this.entry.getFile();
                String string = fileObject.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (Utilities.isWindows()) {
                        string = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        string = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    }
                    this.setValue(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new RemoteFilePathPropertySupport();
    }

    private PropertySupport createCobolLocalQualifierProperty() {
        class CobolLocalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public CobolLocalQualifierPropertySupport() {
                super(CobolCompilerSupport.PROP_COBOL_LOCAL_QUALIFIER, class$java$lang$String == null ? (class$java$lang$String = CobolCompilerSupport.class$("java.lang.String")) : class$java$lang$String, CobolCompilerSupport.this.getFlaggedName(CobolCompilerSupport.this.getString("PROP_COBOL_LOCAL_QUALIFIER"), CobolCompilerSupport.PROP_COBOL_LOCAL_QUALIFIER), CobolCompilerSupport.this.getString("HINT_COBOL_LOCAL_QUALIFIER"));
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_COBOL_LOCAL_QUALIFIER, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getLocalQualifier();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof String || object == null) {
                    try {
                        CobolCompilerSupport.this.setLocalQualifier((String)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getLocalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new CobolLocalQualifierPropertySupport();
    }

    private PropertySupport createCobolGlobalQualifierProperty() {
        class CobolGlobalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public CobolGlobalQualifierPropertySupport() {
                super(CobolCompilerSupport.PROP_COBOL_GLOBAL_QUALIFIER, class$java$lang$String == null ? (class$java$lang$String = CobolCompilerSupport.class$("java.lang.String")) : class$java$lang$String, CobolCompilerSupport.this.getFlaggedName(CobolCompilerSupport.this.getString("PROP_COBOL_GLOBAL_QUALIFIER"), CobolCompilerSupport.PROP_COBOL_GLOBAL_QUALIFIER), CobolCompilerSupport.this.getString("HINT_COBOL_GLOBAL_QUALIFIER"));
                CobolCompilerSupport.this.setDefaultFunction((PropertySupport)this, CobolCompilerSupport.PROP_COBOL_GLOBAL_QUALIFIER, "com.hp.openvms.netbeans.cobolsupport.settings.CobolFileGeneralSettings");
            }

            public Object getValue() {
                return CobolCompilerSupport.this.getGlobalQualifier();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof String || object == null) {
                    try {
                        CobolCompilerSupport.this.setGlobalQualifier((String)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CobolCompilerSupport.this.getGlobalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new CobolGlobalQualifierPropertySupport();
    }

    private String getFlaggedNameBuildOption(String string, String string2) {
        return string;
    }

    private String getFlaggedNameAnsiFormatting(String string, String string2) {
        return string;
    }

    private String getFlaggedNameMakefile(String string, String string2) {
        return string;
    }

    private String getFlaggedName(String string, String string2) {
        return string;
    }

    protected String getString(String string) {
        return bundle.getString(string);
    }

    protected void setDefaultFunction(PropertySupport propertySupport, String string, String string2) {
        try {
            propertySupport.setValue("method", (Object)FileObject.class.getMethod("getAttribute", String.class));
            propertySupport.setValue("param", (Object)string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        propertySupport.setValue("object", (Object)this.entry.getFile());
        propertySupport.setValue("helpID", (Object)string2);
    }

    private void changeResetProp(String string, Object object) {
        Node node = this.entry.getDataObject().getNodeDelegate();
        if (node instanceof CobolDataNode) {
            ((CobolDataNode)node).firePropertyChange2(string, null, object);
        }
    }

    public FileObject getFileObject() {
        return this.entry.getFile();
    }

    public static class RemoteBuild
    extends CobolCompilerSupport
    implements RemoteBuildCookie {
        public RemoteBuild(MultiDataObject.Entry entry) {
            super(entry, class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie == null ? (class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie = CobolCompilerSupport.class$("org.netbeans.modules.distributed.common.cookies.RemoteBuildCookie")) : class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie);
        }
    }

    public static class RemoteCompile
    extends CobolCompilerSupport
    implements RemoteCompileCookie {
        public RemoteCompile(MultiDataObject.Entry entry) {
            super(entry, class$org$netbeans$modules$distributed$common$cookies$RemoteCompileCookie == null ? (class$org$netbeans$modules$distributed$common$cookies$RemoteCompileCookie = CobolCompilerSupport.class$("org.netbeans.modules.distributed.common.cookies.RemoteCompileCookie")) : class$org$netbeans$modules$distributed$common$cookies$RemoteCompileCookie);
        }

        public void compile() throws IOException {
            CobolCompiler cobolCompiler = new CobolCompiler(class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie == null ? (class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie = CobolCompilerSupport.class$("org.netbeans.modules.distributed.common.cookies.RemoteBuildCookie")) : class$org$netbeans$modules$distributed$common$cookies$RemoteBuildCookie, this.getFileObject(), this.getExternalCompiler(), this.getProjCompilerType().getErrorExpression(), new CobolCompilerType(this.entry.getFile()));
            DataObject dataObject = null;
            dataObject = DataObject.find((FileObject)this.getFileObject());
            CobolCompilerGroup.CobolFormat cobolFormat = new CobolCompilerGroup.CobolFormat(new DataObject[]{dataObject}, new String[]{cobolCompiler.getFileName()}, true);
            RemoteCompilerAction.createRemoteProcess(this.getFileObject(), this.getOutputSwitch(), this.getXDisplayNumber(), this.getProjCompilerType().getErrorExpression(), cobolFormat, cobolFormat.getCmds());
        }
    }

    public static class Clean
    extends CobolCompilerSupport
    implements CompilerCookie.Clean {
        public Clean(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Clean == null ? (class$org$openide$cookies$CompilerCookie$Clean = CobolCompilerSupport.class$("org.openide.cookies.CompilerCookie$Clean")) : class$org$openide$cookies$CompilerCookie$Clean);
        }
    }

    public static class Build
    extends CobolCompilerSupport
    implements CompilerCookie.Build {
        public Build(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Build == null ? (class$org$openide$cookies$CompilerCookie$Build = CobolCompilerSupport.class$("org.openide.cookies.CompilerCookie$Build")) : class$org$openide$cookies$CompilerCookie$Build);
        }
    }

    public static class Compile
    extends CobolCompilerSupport
    implements CompilerCookie.Compile {
        public Compile(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = CobolCompilerSupport.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        }
    }
}

