/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.baseclasses.dataloaders;

import com.hp.openvms.netbeans.utils.Constants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class AlphaVMSDataLoader
extends MultiFileLoader {
    public static final String PROP_OBJ_EXTENSIONS = "objExtensions";
    private static final int EXTERNALIZED_VERSION = 1;
    private static ResourceBundle bundle;

    public AlphaVMSDataLoader() {
        super("com.hp.openvms.netbeans.baseclasses.dataobjects.AlphaVMSDataObject");
    }

    public AlphaVMSDataLoader(String string) {
        super(string);
    }

    public AlphaVMSDataLoader(Class clazz) {
        super(clazz);
    }

    public static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)AlphaVMSDataLoader.class);
        }
        return bundle.getString(string);
    }

    public ExtensionList getObjExtensions() {
        ExtensionList extensionList = (ExtensionList)this.getProperty(PROP_OBJ_EXTENSIONS);
        if (extensionList == null) {
            extensionList = new ExtensionList();
            for (int i = 0; i < Constants.OBJ_EXTENSIONS.length; ++i) {
                extensionList.addExtension(Constants.OBJ_EXTENSIONS[i]);
            }
            this.putProperty(PROP_OBJ_EXTENSIONS, extensionList, false);
        }
        return extensionList;
    }

    public void setObjExtensions(ExtensionList extensionList) {
        this.putProperty(PROP_OBJ_EXTENSIONS, extensionList, true);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(1);
        objectOutput.writeObject(this.getProperty(PROP_OBJ_EXTENSIONS));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        if (objectInput.available() > 0) {
            int n = objectInput.readInt();
            this.putProperty(PROP_OBJ_EXTENSIONS, objectInput.readObject(), false);
        }
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        return null;
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        JOptionPane.showConfirmDialog(null, "createMultiObject: returning null");
        return null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new AlphaVMSFileEntry(multiDataObject, fileObject);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        fileObject.setImportant(false);
        return new SecondaryFileEntry(multiDataObject, fileObject);
    }

    public class SecondaryFileEntry
    extends FileEntry {
        public SecondaryFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        public boolean isImportant() {
            return false;
        }
    }

    public class AlphaVMSFileEntry
    extends FileEntry.Format {
        public AlphaVMSFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            String string2 = this.getFile().getExt();
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.getFile().getName(), (String)string2);
            }
            FileObject fileObject2 = fileObject.createData(string, string2);
            Format format = this.createFormat(fileObject, string, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getFile().getInputStream()));
            try {
                FileLock fileLock = fileObject2.lock();
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject2.getOutputStream(fileLock)));
                    try {
                        String string3;
                        while ((string3 = bufferedReader.readLine()) != null) {
                            String string4 = format.format(string3);
                            bufferedWriter.write(string4);
                            bufferedWriter.write(10);
                        }
                    }
                    finally {
                        bufferedWriter.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
            finally {
                bufferedReader.close();
            }
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fileObject2);
            fileObject2.setAttribute("template", null);
            return fileObject2;
        }

        protected Format createFormat(FileObject fileObject, String string, String string2) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("NAME", string);
            hashMap.put("DATE", DateFormat.getDateInstance(1).format(new Date()));
            hashMap.put("TIME", DateFormat.getTimeInstance(3).format(new Date()));
            hashMap.put("USER", System.getProperty("user.name"));
            MapFormat mapFormat = new MapFormat(hashMap);
            mapFormat.setLeftBrace("__");
            mapFormat.setRightBrace("__");
            return mapFormat;
        }
    }
}

