/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.openide.nodes.Node;

public abstract class RevisionItem
implements Node.Cookie,
Comparable,
Serializable {
    public static final String PROP_REVISION = "revision";
    public static final String PROP_CURRENT_REVISION = "currentRevision";
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_MESSAGE = "message";
    public static final String PROP_DATE = "date";
    public static final String PROP_AUTHOR = "author";
    public static final String PROP_LOCKER = "locker";
    public static final String PROP_TAGS = "tags";
    public static final String PROP_ADDITIONAL_PROPERTIES = "additionalProperties";
    private String revision;
    private String revisionVCS;
    protected Vector branches;
    private String displayName;
    private String message;
    private String date;
    private String author;
    private String locker;
    private Vector tagNames;
    private boolean current;
    private Hashtable additionalProperties;
    private ArrayList additionalPropertiesSets;
    private transient EventListenerList listeners = null;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public RevisionItem(String revision) {
        this.revision = revision;
        this.revisionVCS = revision;
        this.branches = null;
        this.message = null;
        this.date = null;
        this.author = null;
        this.locker = null;
        this.tagNames = new Vector();
        this.current = false;
        this.additionalProperties = new Hashtable();
        this.additionalPropertiesSets = new ArrayList();
        this.displayName = revision;
    }

    public String getRevision() {
        return this.revisionVCS;
    }

    public String getRevisionVCS() {
        return this.revisionVCS;
    }

    public void setRevisionVCS(String revisionVCS) {
        this.revisionVCS = revisionVCS;
    }

    public boolean isRevision() {
        return this.branches == null;
    }

    public abstract boolean isBranch();

    public void setDisplayName(String displayName) {
        if (!displayName.equals(this.displayName)) {
            String oldDisplayName = this.displayName;
            this.displayName = displayName;
            this.firePropertyChange(PROP_DISPLAY_NAME, oldDisplayName, displayName);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setMessage(String message) {
        if (!message.equals(this.message)) {
            String oldMessage = this.message;
            this.message = message;
            this.firePropertyChange(PROP_MESSAGE, oldMessage, message);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setDate(String date) {
        if (!date.equals(this.date)) {
            String oldDate = this.date;
            this.date = date;
            this.firePropertyChange(PROP_DATE, oldDate, date);
        }
    }

    public String getDate() {
        return this.date;
    }

    public void setAuthor(String author) {
        if (!author.equals(this.author)) {
            String oldAuthor = this.author;
            this.author = author;
            this.firePropertyChange(PROP_AUTHOR, oldAuthor, author);
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public void setLocker(String locker) {
        if (!locker.equals(this.locker)) {
            String oldLocker = this.locker;
            this.locker = locker;
            this.firePropertyChange(PROP_LOCKER, oldLocker, locker);
        }
    }

    public String getLocker() {
        return this.locker;
    }

    public void addTagName(String tagName) {
        this.tagNames.add(tagName);
        if (this.isBranch()) {
            this.setDisplayName(this.revision + " (" + tagName + ")");
        }
        this.firePropertyChange(PROP_TAGS, null, null);
    }

    public boolean removeTagName(String tagName) {
        boolean removed = this.tagNames.remove(tagName);
        if (removed) {
            this.firePropertyChange(PROP_TAGS, null, null);
        }
        return removed;
    }

    public void setTagNames(String[] tagNames) {
        this.tagNames = new Vector<String>(Arrays.asList(tagNames));
        this.firePropertyChange(PROP_TAGS, null, null);
    }

    public String[] getTagNames() {
        return this.tagNames.toArray(new String[0]);
    }

    public void setCurrent(boolean current) {
        if (current != this.current) {
            this.current = current;
            this.firePropertyChange(PROP_CURRENT_REVISION, new Boolean(!current), new Boolean(current));
        }
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void addProperty(String name, String value) {
        this.additionalProperties.put(name, value);
        this.firePropertyChange(PROP_ADDITIONAL_PROPERTIES, null, null);
    }

    public Hashtable getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void addAdditionalPropertiesSet(String name, Map properties) {
        this.additionalPropertiesSets.add(name);
        this.additionalPropertiesSets.add(properties);
    }

    public String[] getAdditionalPropertiesSetNames() {
        ArrayList names = new ArrayList();
        for (int i = 0; i < this.additionalPropertiesSets.size(); i += 2) {
            names.add(this.additionalPropertiesSets.get(i));
        }
        return names.toArray(new String[0]);
    }

    public Map[] getAdditionalPropertiesSets() {
        ArrayList sets = new ArrayList();
        for (int i = 1; i < this.additionalPropertiesSets.size(); i += 2) {
            sets.add(this.additionalPropertiesSets.get(i));
        }
        return sets.toArray(new Map[0]);
    }

    protected abstract RevisionItem getNextItem();

    protected abstract int cmpRev(String var1);

    public abstract RevisionItem addRevision(String var1);

    public abstract RevisionItem addBranch(String var1);

    public void putToList(Collection list) {
        RevisionItem next;
        if (!list.contains(this)) {
            list.add(this);
        }
        if ((next = this.getNextItem()) != null) {
            next.putToList(list);
        }
        if (this.branches != null) {
            Enumeration enumeration = this.branches.elements();
            while (enumeration.hasMoreElements()) {
                ((RevisionItem)enumeration.nextElement()).putToList(list);
            }
        }
    }

    public int hashCode() {
        return this.revision.hashCode();
    }

    public int compareTo(Object p1) {
        return -this.cmpRev(((RevisionItem)p1).getRevision());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener l) {
        Serializable serializable;
        if (this.listeners == null) {
            serializable = this;
            synchronized (serializable) {
                if (this.listeners == null) {
                    this.listeners = new EventListenerList();
                }
            }
        }
        serializable = this.listeners;
        synchronized (serializable) {
            this.listeners.add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = RevisionItem.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            this.listeners.remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = RevisionItem.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void firePropertyChange(String property, Object oldValue, Object newValue) {
        PropertyChangeListener[] chListeners;
        if (this.listeners == null) {
            return;
        }
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            chListeners = (PropertyChangeListener[])this.listeners.getListeners(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = RevisionItem.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
        }
        for (int i = 0; i < chListeners.length; ++i) {
            chListeners[i].propertyChange(property == null ? null : new PropertyChangeEvent(this, property, oldValue, newValue));
        }
    }

    public String toString() {
        return "[" + this.revision + ", branches = " + (this.branches == null ? null : new ArrayList(this.branches)) + ", tags = " + this.getTagNames() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

