/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.cmsprofile.vcs.list;

import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.CMSRemoteUtil;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.CMSUtils;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.DCLExecutor;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.FileCache;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.FileUtility;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.GenDBEntry;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.RemoteExecuteCommand;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileInfo;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.cmdline.VcsAdditionalCommand;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;

public class CMSListFileCommand
implements VcsAdditionalCommand,
CommandDataOutputListener {
    private static boolean debug = Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.CMSListCommand") | Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.ALL");
    private String[] args = null;
    private Hashtable symbolicNames = new Hashtable();
    private String dir = null;
    private String localdir = null;
    private String mountpoint = null;
    private String localMountPoint = null;
    private File fsLocalRoot = null;
    private String lastReservedFile = null;
    private Hashtable vars = null;
    private VcsFileSystem fileSystem = null;
    private String processorDir = null;
    private String processorDirVMS = null;
    private static final String GPL_FILENAME = "gpl.txt";
    private static final String GPL_PACKAGE = "vcs/commands/";
    private static final String LIST_SENTINEL = " @@@@@@@@";
    public static final String STATUS_LADD = "Locally Added";
    public static final String STATUS_NCO = "No Local Copy";
    public static final String STATUS_NCOR = "No Local Copy Reserved";
    public static final String STATUS_UTD = "Up-to-Date";
    public static final String STATUS_LMOD = "Locally Modified";
    public static final String STATUS_UTDR = "Up-to-Date Reserved";
    public static final String STATUS_LMODR = "Locally Modified Reserved";
    public static final String STATUS_UNK = "Unknown";
    public static final String STATUS_UNKR = "Unknown Reserved";
    private HashMap localFiles = null;
    private HashSet fileSystemList = null;
    private HashSet CMSFilesNotInRoot = null;
    private HashSet CMSFilesInCurrentDir = new HashSet();
    private HashSet CMSElements = new HashSet();
    private Hashtable fileGenerationDB = null;
    private Hashtable reservedFiles = null;
    private HashSet differentFiles = null;
    private HashSet unknownFiles = new HashSet();
    private volatile String[] dirInfo = null;
    private volatile String[] fileInfo = null;
    private boolean gettingFolders = false;
    private boolean gettingLocalFiles = false;
    private boolean gettingCMSElements = false;
    private boolean gettingDifferentFiles = false;
    private boolean gettingReservedFiles = false;
    private boolean filesAreDifferent = false;
    private static FileChangeListener fileChangeListener = null;
    private Hashtable filesByName = null;
    private boolean shouldFail = false;
    private boolean isFileReserved = false;
    private boolean hideTempDir = true;
    private CommandOutputListener stderrNRListener;

    public CMSListFileCommand() {
        if (debug) {
            System.out.println("CMSListFileCommand object created");
        }
    }

    public void setFileSystem(VcsFileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    protected void finalize() throws IOException {
        if (debug) {
            System.out.println("CMSListFileCommand object destroyed");
        }
    }

    private boolean getReservedFileList() {
        try {
            String reservationcmd = this.args[2];
            this.gettingReservedFiles = true;
            this.reservedFiles = new Hashtable();
            if (debug) {
                System.out.println("Running the command to retrieve the reservation list");
            }
            if (!this.runCommand(this.vars, reservationcmd)) {
                return false;
            }
            this.gettingReservedFiles = false;
        }
        catch (InterruptedException iexc) {
            return false;
        }
        return true;
    }

    private boolean fileReserved(FileObject fo) {
        return this.getReservedFileList() && this.reservedFiles.containsKey(fo.getNameExt());
    }

    private void initDir(Hashtable vars) {
        if (debug) {
            System.out.println("Entering initDir...");
        }
        String rootDir = (String)vars.get("ROOTDIR");
        if (debug) {
            System.out.println("ROOTDIR = " + rootDir);
        }
        String localRootDir = (String)vars.get("LOCALROOTDIR");
        if (debug) {
            System.out.println("LOCAL ROOTDIR = " + localRootDir);
        }
        this.localMountPoint = localRootDir;
        this.mountpoint = rootDir;
        if (rootDir == null) {
            rootDir = ".";
        }
        if (localRootDir == null) {
            localRootDir = ".";
        }
        this.dir = (String)vars.get("DIR");
        this.localdir = (String)vars.get("LOCALDIR");
        if (debug) {
            System.out.println("DIR = " + this.dir + " LOCAL DIR = " + this.localdir);
        }
        if (this.dir == null) {
            this.dir = "";
        } else {
            if (this.dir.length() > 0 && this.dir.charAt(0) == '/') {
                this.dir = this.dir.substring(1);
            }
            if (this.localdir.length() > 0 && this.localdir.charAt(0) == File.separatorChar) {
                this.localdir = this.localdir.substring(1);
            }
        }
        if (this.localdir == null) {
            this.localdir = "";
        } else if (this.localdir.length() > 0 && this.localdir.charAt(0) == File.separatorChar) {
            this.localdir = this.localdir.substring(1);
        }
        if (debug) {
            System.out.println("dir = " + this.dir);
        }
        if (debug) {
            System.out.println("local dir = " + this.localdir);
        }
        String module = (String)vars.get("MODULE");
        if (debug) {
            System.out.println("module = " + module);
        }
        if (module != null && module.length() > 0) {
            this.mountpoint = this.mountpoint + '/' + module;
        }
        String localmodule = (String)vars.get("LOCALMODULE");
        if (debug) {
            System.out.println("local module = " + localmodule);
        }
        if (localmodule != null && localmodule.length() > 0) {
            this.localMountPoint = this.localMountPoint + File.separator + localmodule;
        }
        if (this.dir.equals("")) {
            this.dir = rootDir;
            if (module != null && module.length() > 0) {
                this.dir = this.dir + '/' + module;
            }
        } else {
            this.dir = module == null || module.equals("") ? rootDir + '/' + this.dir : rootDir + '/' + module + '/' + this.dir;
        }
        if (this.localdir.equals("")) {
            this.localdir = localRootDir;
            if (localmodule != null && localmodule.length() > 0) {
                this.localdir = this.localdir + File.separator + localmodule;
            }
        } else {
            this.localdir = localmodule == null || localmodule.equals("") ? localRootDir + File.separator + this.localdir : localRootDir + File.separator + module + File.separator + this.localdir;
        }
        if (this.dir.charAt(this.dir.length() - 1) == '/') {
            this.dir = this.dir.substring(0, this.dir.length() - 1);
        }
        if (this.localdir.charAt(this.localdir.length() - 1) == File.separatorChar) {
            this.localdir = this.localdir.substring(0, this.localdir.length() - 1);
        }
        if (debug) {
            System.out.println("The mount point is " + this.mountpoint + "; the current directory is " + this.dir);
            System.out.println("The local mount point is " + this.localMountPoint + "; the current local directory is " + this.localdir);
            System.out.println("...Leaving initDir");
        }
    }

    private void initFileList(String mpName, String tempDir) {
        if (debug) {
            System.out.println("Entering initFileList...");
        }
        try {
            this.fileSystemList = new HashSet();
            LocalFileSystem lf_source = new LocalFileSystem();
            File f_source = new File(mpName);
            lf_source.setRootDirectory(f_source);
            FileObject fo_source = lf_source.getRoot();
            Enumeration enumeration = fo_source.getChildren(true);
            while (enumeration.hasMoreElements()) {
                String parentDir;
                FileObject fod = (FileObject)enumeration.nextElement();
                if (debug) {
                    System.out.println("Processing: " + fod.getName() + "." + fod.getExt());
                }
                if ((parentDir = fod.getParent().toString()).equals(tempDir)) continue;
                this.fileSystemList.add(fod.getName() + "." + fod.getExt());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (debug) {
            System.out.println("...Leaving initFileList");
        }
    }

    private static File findFile(String f, File dir) {
        File resultantFileObj = null;
        String[] dirList = dir.list();
        if (dirList != null) {
            for (int i = 0; resultantFileObj == null && i < dirList.length; ++i) {
                if (dirList[i].equalsIgnoreCase(f)) {
                    resultantFileObj = new File(dir.getPath() + "\\" + dirList[i]);
                    if (!debug) continue;
                    System.out.println("File was found: " + dir.getPath() + "\\" + dirList[i]);
                    continue;
                }
                File curFile = new File(dir.getPath() + "\\" + dirList[i]);
                if (!curFile.isDirectory() || curFile.getName().equals("CMSINFO")) continue;
                resultantFileObj = CMSListFileCommand.findFile(f, curFile);
            }
        }
        return resultantFileObj;
    }

    private boolean getFileDifferencesByDate(String cmsCommand) {
        Object[] templist;
        GenDBEntry dbEntry = null;
        File tempFile = null;
        boolean fileCount = false;
        Hashtable<String, String> varsDiff = null;
        boolean status = true;
        if (debug) {
            System.out.println("Entering getFileDifferencesByDate...");
        }
        this.differentFiles = new HashSet();
        this.unknownFiles = new HashSet();
        Collection fileList = this.localFiles.values();
        if (fileList.size() > 0) {
            int numFiles = fileList.size();
            Iterator itr = fileList.iterator();
            if (debug) {
                System.out.println("Total number of local files to check: " + fileList.size());
            }
            while (itr.hasNext()) {
                FileCache currentFile = (FileCache)itr.next();
                if (this.CMSElements.contains(currentFile.getName())) {
                    if (debug) {
                        System.out.println("Local file " + currentFile.getName() + " is an element in the CMS repository");
                    }
                    if (this.fileGenerationDB != null) {
                        if (this.fileGenerationDB.containsKey(currentFile.getName())) {
                            dbEntry = (GenDBEntry)this.fileGenerationDB.get(currentFile.getName());
                            if (debug) {
                                System.out.println(currentFile.getName() + " is contained in the generation database; last modified: " + dbEntry.getFileDate());
                            }
                            if (debug) {
                                System.out.println("prevGen:" + dbEntry.getPreviousGen() + " reservedGen:" + dbEntry.getReservedGen());
                            }
                            if (dbEntry.getFileDate() != 0L) {
                                long fileDate = currentFile.lastModified();
                                if (debug) {
                                    System.out.println("Local file last modified: " + fileDate);
                                }
                                if (dbEntry.getFileDate() != fileDate || !dbEntry.getPreviousGen().equals("") && !dbEntry.getReservedGen().equals("") && !dbEntry.getPreviousGen().equals(dbEntry.getReservedGen())) {
                                    if (debug) {
                                        System.out.println("File has been modified; adding to list");
                                    }
                                    this.differentFiles.add(currentFile.getName());
                                    continue;
                                }
                                if (!debug) continue;
                                System.out.println("File has not been modified");
                                continue;
                            }
                            if (debug) {
                                System.out.println("The last modified time for " + currentFile.getName() + " has not been set");
                                System.out.println("Can't determine if file has been modified; adding to the unknown list");
                            }
                            this.unknownFiles.add(currentFile.getName());
                            continue;
                        }
                        if (debug) {
                            System.out.println(currentFile.getName() + " has no entry in the generation database");
                            System.out.println("Can't determine if file has been modified; adding to the unknown list");
                        }
                        this.unknownFiles.add(currentFile.getName());
                        continue;
                    }
                    if (debug) {
                        System.out.println("The generation database doesn't exist");
                        System.out.println("Can't determine if file has been modified; adding to the unknown list");
                    }
                    this.unknownFiles.add(currentFile.getName());
                    continue;
                }
                if (!debug) continue;
                System.out.println(currentFile + " is not an element in the CMS repository");
            }
        } else if (debug) {
            System.out.println(this.dir + " directory is empty");
        }
        if (Array.getLength(templist = this.unknownFiles.toArray()) > 0) {
            try {
                File tempDir = new File(this.processorDir);
                tempFile = File.createTempFile("CMSDIFF", ".txt", tempDir);
                tempFile.delete();
                this.createFileList(tempFile.getPath(), templist);
            }
            catch (IOException e) {
                if (debug) {
                    System.out.println("An error occurred while creating " + tempFile.getPath());
                    System.out.println("Error = " + e);
                }
                return false;
            }
            varsDiff = new Hashtable<String, String>(this.vars);
            varsDiff.put("TEMPFILELIST", this.processorDirVMS + tempFile.getName());
            FileObject fobj = CMSRemoteUtil.refreshLocalDir(tempFile.getPath(), false);
            varsDiff.put("TEMPFETCHDIR", varsDiff.get("MOUNTDIR") + "/" + "CMSINFO" + "/" + "FETCH");
            try {
                if (debug) {
                    System.out.println("Fetching the list of files...");
                }
                this.runCommand(varsDiff, cmsCommand);
            }
            catch (InterruptedException iexc) {
                status = false;
            }
            if (tempFile.exists()) {
                tempFile.delete();
            }
            if (debug) {
                System.out.println("Now need to get file dates");
            }
            String fetchPath = this.fsLocalRoot.getAbsolutePath() + File.separatorChar + "CMSINFO" + File.separatorChar + "FETCH";
            if (debug) {
                System.out.println("fetchPath = " + fetchPath);
            }
            for (int i = 0; i < Array.getLength(templist); ++i) {
                if (debug) {
                    System.out.println("Processing: " + templist[i]);
                }
                FileCache unkFile = new FileCache(new File(fetchPath, (String)templist[i]));
                FileCache workingFile = (FileCache)this.localFiles.get(templist[i]);
                if (debug) {
                    System.out.println("File exists: " + unkFile.exists());
                }
                if (this.fileGenerationDB.containsKey((String)templist[i])) {
                    if (debug) {
                        System.out.println("DB entry exists; adding date");
                    }
                    dbEntry = (GenDBEntry)this.fileGenerationDB.get((String)templist[i]);
                    dbEntry.setFileDate(unkFile.lastModified());
                    if (debug) {
                        System.out.println("File date was set to: " + dbEntry.getFileDate());
                    }
                } else {
                    if (debug) {
                        System.out.println("DB entry does not exist; creating new entry");
                    }
                    dbEntry = new GenDBEntry();
                    dbEntry.setFileName((String)templist[i]);
                    dbEntry.setFileDate(unkFile.lastModified());
                    if (debug) {
                        System.out.println("File name was set to: " + dbEntry.getFileName());
                        System.out.println("File date was set to: " + dbEntry.getFileDate());
                    }
                }
                if (workingFile.lastModified() != unkFile.lastModified()) {
                    this.differentFiles.add((String)templist[i]);
                }
                this.fileGenerationDB.put((String)templist[i], dbEntry);
                this.unknownFiles.remove(templist[i]);
            }
        } else {
            if (debug) {
                System.out.println("There are no unknown files in this directory");
            }
            status = true;
        }
        if (debug) {
            System.out.println("...Leaving getFileDifferencesByDate");
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFileList(String filename, Object[] fileList) throws IOException {
        GenDBEntry dbEntry = null;
        PrintWriter pout = null;
        int fileCount = 0;
        if (debug) {
            System.out.println("Entering createFileList...");
        }
        int numFiles = Array.getLength(fileList);
        if (debug) {
            System.out.println("Total number of files in the list: " + numFiles);
        }
        if (numFiles > 0) {
            try {
                FileOutputStream outFile = new FileOutputStream(filename);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outFile));
                pout = new PrintWriter((Writer)out, true);
                for (int index = 0; index < numFiles; ++index) {
                    String currentFile = fileList[index].toString();
                    if (this.CMSElements.contains(currentFile)) {
                        if (debug) {
                            System.out.println("Local file " + currentFile + " is an element in the CMS repository");
                        }
                        String dbGen = "-1";
                        if (this.fileGenerationDB != null) {
                            if (this.fileGenerationDB.containsKey(currentFile)) {
                                dbEntry = (GenDBEntry)this.fileGenerationDB.get(currentFile);
                                if (!dbEntry.getCurrentGen().equals("")) {
                                    dbGen = dbEntry.getCurrentGen();
                                }
                                if (debug) {
                                    System.out.println(currentFile + " is contained in the generation database; generation: " + dbEntry.getCurrentGen());
                                }
                            } else if (debug) {
                                System.out.println(currentFile + " has no entry in the generation database");
                            }
                        } else if (debug) {
                            System.out.println("The generation database doesn't exist");
                        }
                        if (debug) {
                            System.out.println("Adding " + currentFile + " to the file list; generation = " + dbGen);
                        }
                        pout.print(fileList[index].toString() + " " + dbGen + '\n');
                        ++fileCount;
                        continue;
                    }
                    if (!debug) continue;
                    System.out.println(currentFile + " is not an element in the CMS repository");
                }
                if (debug) {
                    System.out.println("File list " + filename + " was successfully created");
                }
            }
            finally {
                if (pout != null) {
                    pout.close();
                }
            }
        }
        if (debug) {
            System.out.println("Actual # of filesnames written: " + fileCount);
            System.out.println("...Leaving createFileList");
        }
    }

    private boolean createDirTree(String sourceFS) {
        boolean status = true;
        this.CMSFilesInCurrentDir = new HashSet();
        if (debug) {
            System.out.println("Entering createDirTree");
        }
        try {
            LocalFileSystem lf_source = new LocalFileSystem();
            LocalFileSystem lf_target = new LocalFileSystem();
            File f_source = new File(sourceFS);
            File f_target = new File(this.localdir);
            lf_source.setRootDirectory(f_source);
            lf_target.setRootDirectory(f_target);
            CMSRemoteUtil.getJavaTempFO(sourceFS);
            FileObject fo_source = lf_source.getRoot();
            Enumeration enumeration = fo_source.getChildren(false);
            while (enumeration.hasMoreElements()) {
                FileObject fod = (FileObject)enumeration.nextElement();
                if (debug) {
                    System.out.println("Processing " + fod.getNameExt());
                }
                try {
                    JavaDataObject jdo;
                    SourceElement editor;
                    Identifier ident;
                    DataObject doj = DataObject.find((FileObject)fod);
                    if (debug) {
                        System.out.println("DataObject retrieved - " + doj.toString());
                    }
                    if (!fod.getNameExt().endsWith(".java") && !fod.getNameExt().endsWith(".JAVA")) continue;
                    if (debug) {
                        System.out.println("Processing Java source file");
                    }
                    if ((ident = (editor = (jdo = (JavaDataObject)doj).getSource()).getPackage()) == null) {
                        if (!debug) continue;
                        System.out.println("This file does not contain a package statement");
                        continue;
                    }
                    String packname = ident.getFullName();
                    if (debug) {
                        System.out.println("Package name: " + packname);
                    }
                    if (packname != "") {
                        File targetdir;
                        String newdir = this.fsLocalRoot.getAbsolutePath() + File.separator + packname.replace('.', File.separatorChar);
                        if (debug) {
                            System.out.println("Full directory path: " + newdir);
                        }
                        if (!(targetdir = new File(newdir)).exists()) {
                            if (debug) {
                                System.out.println("The directory doesn't exist; creating it...");
                            }
                            FileUtil.createFolder((FileObject)this.fileSystem.getRoot(), (String)packname.replace('.', File.separatorChar));
                        }
                        if (newdir.equals(this.dir)) {
                            if (debug) {
                                System.out.println("This file belongs in the current directory");
                            }
                            this.CMSFilesInCurrentDir.add(fod.toString());
                            continue;
                        }
                        if (debug) {
                            System.out.println("This file does not belong in the current directory");
                        }
                        this.CMSFilesNotInRoot.add(fod.toString());
                        continue;
                    }
                    if (debug) {
                        System.out.println("This file does not belong in the current directory");
                    }
                    this.CMSFilesNotInRoot.add(fod.toString());
                }
                catch (DataObjectNotFoundException e) {
                    if (debug) {
                        System.out.println("Object not found - " + (Object)((Object)e));
                    }
                    status = false;
                }
            }
        }
        catch (Exception io) {
            if (debug) {
                System.out.println("Exception - " + io);
            }
            status = false;
        }
        if (debug) {
            System.out.println("...Leaving createDirTree");
        }
        return status;
    }

    private boolean runCommand(Hashtable vars, String cmdName) throws InterruptedException {
        String currentFile = (String)vars.get("FILE");
        String[] DCLCommandLine = new String[1];
        File tempFile = null;
        if (debug) {
            System.out.println("Entering runCommand...");
            System.out.println("The command symbol is " + cmdName);
            System.out.println("FILE = " + currentFile);
            System.out.println("DIR = " + (String)vars.get("DIR"));
            System.out.println("PATH = " + (String)vars.get("PATH"));
        }
        Hashtable runVars = new Hashtable(vars);
        VcsCommand cmd = this.fileSystem.getCommand(cmdName.toUpperCase());
        UserCommand wrapCmd = new UserCommand();
        wrapCmd.copyFrom(cmd);
        String cmdStr = cmd.getProperty("exec").toString();
        if (debug) {
            System.out.println("Raw command = " + cmdStr);
        }
        String prepared = Variables.expand(runVars, (String)cmdStr, (boolean)true);
        if (debug) {
            System.out.println("Prepared command: " + prepared);
        }
        DCLCommandLine[0] = new String("@" + prepared);
        Vector DCLCommandWrapper = DCLExecutor.preprocessDCLCmds(DCLCommandLine, 1);
        try {
            File tempDir = new File(this.processorDir);
            tempFile = File.createTempFile("CMS", ".txt", tempDir);
            tempFile.delete();
            if (debug) {
                System.out.println("DCLWrapper: " + tempFile.getPath());
            }
            DCLExecutor.createDCLFile(tempFile.getPath(), DCLCommandWrapper);
            if (debug) {
                System.out.println(tempFile.getPath() + " was successfully created");
            }
        }
        catch (IOException e) {
            if (debug) {
                System.out.println("An error occurred while creating " + tempFile.getPath());
                System.out.println("Error = " + e);
            }
            return false;
        }
        String tempFilePath = this.processorDirVMS + tempFile.getName();
        String tempFilePathUnix = FileUtility.openVMSPathToUnixPath(tempFilePath, false);
        if (debug) {
            System.out.println("remote command : @" + tempFilePath + " " + tempFilePathUnix);
        }
        wrapCmd.setProperty("exec", (Object)("@" + tempFilePath + " \"" + tempFilePathUnix + "\""));
        FileObject fobj = CMSRemoteUtil.refreshLocalDir(tempFile.getPath(), false);
        VcsCommandExecutor ec = CMSRemoteUtil.getCommandExecutor((VcsCommand)wrapCmd, runVars, this.fileSystem);
        ec.addDataOutputListener((CommandDataOutputListener)this);
        CMSRemoteUtil.preprocessCommand(ec, vars, this.fileSystem);
        VcsDescribedCommand myCmd = ((RemoteExecuteCommand)ec).getDescribedCommand();
        myCmd.setPreferredExec(wrapCmd.getProperty("exec").toString());
        CMSRemoteUtil.startExecutor(ec);
        try {
            CMSRemoteUtil.waitToFinish(ec);
        }
        catch (InterruptedException iexc) {
            CMSRemoteUtil.kill(ec);
            throw iexc;
        }
        if (ec.getExitStatus() == 0) {
            if (tempFile.exists()) {
                CMSRemoteUtil.cleanUp(fobj, tempFile.getName().substring(0, tempFile.getName().lastIndexOf(46)), "txt");
            }
            tempFile.delete();
        }
        if (debug) {
            System.out.println("Leaving runCommand");
        }
        return ec.getExitStatus() == 0;
    }

    private void fillFilesByName() {
        File mpDir = null;
        if (debug) {
            System.out.println("Entering fillFilesByName...");
        }
        mpDir = new File(this.localMountPoint);
        if (debug) {
            System.out.println("Processing local files...");
        }
        Iterator localList = this.localFiles.keySet().iterator();
        while (localList.hasNext()) {
            String currentFile = (String)localList.next();
            String[] fileEntry = new String[]{currentFile, "", ""};
            if (debug) {
                System.out.println("Determining status and generation for " + currentFile);
            }
            if (this.fileGenerationDB != null) {
                if (debug) {
                    System.out.println("The file generation DB has entries");
                }
                if (this.fileGenerationDB.containsKey(currentFile)) {
                    if (debug) {
                        System.out.println("File has an entry in the generation DB");
                    }
                    GenDBEntry dbEntry = (GenDBEntry)this.fileGenerationDB.get(currentFile);
                    if (debug) {
                        System.out.println("File: " + currentFile);
                        System.out.println("Generation: " + dbEntry.getCurrentGen());
                    }
                    fileEntry[2] = dbEntry.getCurrentGen();
                } else if (debug) {
                    System.out.println("The file generation DB does not contain: " + currentFile);
                }
            }
            if (!this.unknownFiles.contains(currentFile)) {
                if (this.CMSElements.contains(currentFile)) {
                    if (debug) {
                        System.out.println("The file exists in the CMS library");
                    }
                    if (this.differentFiles.contains(currentFile)) {
                        if (debug) {
                            System.out.println("The file has been changed");
                        }
                        if (this.reservedFiles.containsKey(currentFile)) {
                            if (debug) {
                                System.out.println("The file is contained in the reserved files list");
                            }
                            if (debug) {
                                System.out.println("The file is reserved");
                            }
                            fileEntry[1] = STATUS_LMODR;
                        } else {
                            if (debug) {
                                System.out.println("The file is not reserved");
                            }
                            fileEntry[1] = STATUS_LMOD;
                        }
                    } else {
                        if (debug) {
                            System.out.println("The file has not been changed");
                        }
                        if (this.reservedFiles.containsKey(currentFile)) {
                            if (debug) {
                                System.out.println("The file is contained in the reserved files list");
                            }
                            if (debug) {
                                System.out.println("The file is reserved");
                            }
                            fileEntry[1] = STATUS_UTDR;
                        } else {
                            if (debug) {
                                System.out.println("The file is not reserved");
                            }
                            fileEntry[1] = STATUS_UTD;
                        }
                    }
                } else {
                    if (debug) {
                        System.out.println("The file is not in the CMS library");
                    }
                    fileEntry[1] = STATUS_LADD;
                    fileEntry[2] = "";
                }
            } else {
                fileEntry[1] = this.reservedFiles.containsKey(currentFile) ? STATUS_UNKR : STATUS_UNK;
            }
            if (debug) {
                System.out.println("Adding - " + currentFile + "; status = " + fileEntry[1] + "; generation = " + fileEntry[2]);
            }
            this.filesByName.put(currentFile, fileEntry);
        }
        if (debug) {
            System.out.println("Processing remaining CMS elements...");
        }
        Object[] CMSlist = this.CMSElements.toArray();
        for (int n = 0; n < this.CMSElements.size(); ++n) {
            String currentFile = CMSlist[n].toString();
            String[] fileEntry = new String[]{currentFile, "", "1"};
            String generation = "";
            if (this.reservedFiles.containsKey(currentFile)) {
                String[] reserveEntry = new String[6];
                reserveEntry = (String[])this.reservedFiles.get(currentFile);
                generation = reserveEntry[3];
            }
            if (this.filesByName.containsKey(currentFile)) continue;
            if (debug) {
                System.out.println("Creating entry for " + currentFile);
            }
            if (this.CMSFilesInCurrentDir.contains(currentFile)) {
                if (debug) {
                    System.out.println("This file exists only in the CMS library");
                }
                if (this.reservedFiles.containsKey(currentFile)) {
                    fileEntry[1] = STATUS_NCOR;
                    fileEntry[2] = generation;
                } else {
                    fileEntry[1] = STATUS_NCO;
                }
            } else {
                String fname = null;
                int extIndex = currentFile.indexOf(".class");
                if (extIndex == -1) {
                    extIndex = currentFile.indexOf(".form");
                }
                if (extIndex != -1) {
                    fname = currentFile.substring(0, extIndex);
                }
                if (this.mountpoint.equals(this.dir) && !this.CMSFilesInCurrentDir.contains(fname + ".java") && currentFile.endsWith(".java")) {
                    fileEntry[1] = "";
                } else if (this.CMSFilesInCurrentDir.contains(fname + ".java")) {
                    if (debug) {
                        System.out.println("This file should be in this directory or elsewhere in the filesystem");
                    }
                    if (this.reservedFiles.containsKey(currentFile)) {
                        fileEntry[1] = STATUS_NCOR;
                        fileEntry[2] = generation;
                    } else {
                        fileEntry[1] = STATUS_NCO;
                    }
                } else {
                    if (debug && this.mountpoint.equals(this.dir)) {
                        System.out.println("This is the root directory of this filesystem");
                    }
                    if (this.mountpoint.equals(this.dir) && !this.CMSFilesNotInRoot.contains(fname + ".java") && !this.CMSFilesNotInRoot.contains(currentFile) && CMSListFileCommand.findFile(currentFile, mpDir) == null) {
                        if (debug) {
                            System.out.println("The file does not exist in this filesystem");
                        }
                        if (this.reservedFiles.containsKey(currentFile)) {
                            fileEntry[1] = STATUS_NCOR;
                            fileEntry[2] = generation;
                        } else {
                            fileEntry[1] = STATUS_NCO;
                        }
                    }
                }
            }
            if (fileEntry[1] == "") continue;
            if (debug) {
                System.out.println("Adding - " + currentFile + "; status = " + fileEntry[1] + "; generation = " + fileEntry[2]);
            }
            this.filesByName.put(currentFile, fileEntry);
        }
        if (debug) {
            System.out.println("...Leaving fillFilesByName");
        }
    }

    private boolean processDeletedJavaFile(File diskFile) {
        if (debug) {
            System.out.println("Entering processDeletedJavaFile");
        }
        boolean status = true;
        File tempFile = null;
        String fileName = diskFile.getName();
        try {
            File tempDir = new File(this.processorDir);
            tempFile = File.createTempFile("CMSJAVAFETCH", ".txt", tempDir);
            tempFile.delete();
            Object[] templist = new String[]{fileName};
            this.createFileList(tempFile.getPath(), templist);
            CMSRemoteUtil.refreshLocalDir(tempFile.getAbsolutePath(), false);
        }
        catch (IOException e) {
            if (debug) {
                System.out.println("An error occurred while creating " + tempFile.getPath());
                System.out.println("Error = " + e);
            }
            return false;
        }
        Hashtable<String, String> varsDiff = new Hashtable<String, String>(this.vars);
        varsDiff.put("TEMPFILELIST", FileUtility.unixPathToOpenVMSPath(tempFile.getPath(), false));
        varsDiff.put("PATH", "CMSINFO" + File.separatorChar + "FETCH");
        try {
            if (debug) {
                System.out.println("Fetching the list of files...");
            }
            if (!(status = this.runCommand(varsDiff, "LIST_FETCH_UNKNOWN_FILES"))) {
                return status;
            }
        }
        catch (InterruptedException iexc) {
            status = false;
        }
        if (tempFile.exists()) {
            tempFile.delete();
        }
        String fetchPath = (String)varsDiff.get("ROOTDIR") + File.separatorChar + (String)varsDiff.get("MODULE") + File.separatorChar + (String)varsDiff.get("PATH");
        if (debug) {
            System.out.println("fetchPath = " + varsDiff.get("PATH"));
        }
        if (debug) {
            System.out.println("Processing: " + fileName);
        }
        try {
            LocalFileSystem lf_source = new LocalFileSystem();
            File f_source = new File(fetchPath);
            lf_source.setRootDirectory(f_source);
            FileObject fo_source = lf_source.getRoot();
            Enumeration enumeration = fo_source.getChildren(true);
            while (enumeration.hasMoreElements()) {
                JavaDataObject jdo;
                SourceElement editor;
                Identifier ident;
                FileObject fod = (FileObject)enumeration.nextElement();
                if (!fod.getNameExt().equals(diskFile.getName())) continue;
                DataObject doj = DataObject.find((FileObject)fod);
                if (debug) {
                    System.out.println("DataObject retrieved - " + doj.toString());
                }
                if (debug) {
                    System.out.println("Processing Java source file");
                }
                if ((ident = (editor = (jdo = (JavaDataObject)doj).getSource()).getPackage()) == null) {
                    if (debug) {
                        System.out.println(this.mountpoint + " " + this.dir);
                    }
                    if (this.mountpoint.equals(this.dir)) {
                        if (debug) {
                            System.out.println("This file belongs in the current directory");
                        }
                        this.CMSFilesInCurrentDir.add(fod.toString());
                    } else if (debug) {
                        System.out.println("This file does not contain a package statement");
                    }
                }
                String packname = ident.getFullName();
                if (debug) {
                    System.out.println("package name + module " + packname + "  " + this.vars.get("DIR"));
                }
                if (!packname.replace('.', File.separatorChar).equals((String)this.vars.get("DIR"))) continue;
                this.CMSFilesInCurrentDir.add(diskFile.getName());
            }
        }
        catch (Exception e) {
            status = false;
        }
        if (debug) {
            System.out.println("Leaving processDeletedJavaFile");
        }
        return status;
    }

    public boolean exec(Hashtable vars, String[] args, CommandOutputListener stdoutNRListener, CommandOutputListener stderrNRListener, CommandDataOutputListener stdoutListener, String dataRegex, CommandDataOutputListener stderrListener, String errorRegex) {
        if (debug) {
            System.out.println("Entering LIST_FILE. . .");
        }
        this.stderrNRListener = stderrNRListener;
        this.args = args;
        this.vars = new Hashtable(vars);
        this.filesByName = new Hashtable();
        if (vars.get("DIR").toString().equalsIgnoreCase(File.separatorChar + "CMSINFO")) {
            return true;
        }
        if (args.length != 3) {
            if (stderrNRListener != null) {
                stderrNRListener.outputLine("Bad number of arguments. Expecting three arguments: LIST_FETCHER, LIST_FILE_READER and LIST_RESERVATION_READER");
            }
            return false;
        }
        if (debug) {
            System.out.println("Running listfile");
        }
        if (!CMSRemoteUtil.mountCMSFS(vars, this.fileSystem, this.fileSystem.getVariables(), stderrNRListener)) {
            return false;
        }
        CMSRemoteUtil.changeVariablesIntoUnixSpec(this.vars, this.fileSystem);
        this.fsLocalRoot = this.fileSystem.getRootDirectory();
        String mountDir = CMSRemoteUtil.windowToOpenVMSUNIXPath(this.fsLocalRoot.getAbsolutePath(), true);
        this.processorDirVMS = FileUtility.unixPathToOpenVMSPath(mountDir + "/" + "CMSINFO", true);
        if (debug) {
            System.out.println("MountDir : " + mountDir);
        }
        if (mountDir != null && mountDir.length() > 0) {
            this.vars.put("MOUNTDIR", mountDir);
        }
        String userDir = System.getProperty("netbeans.user");
        this.processorDir = this.fsLocalRoot.getAbsolutePath() + File.separatorChar + "CMSINFO";
        if (debug) {
            System.out.println("ProcessorDir : " + this.processorDir);
        }
        String processorName = vars.get("CMSPROC").toString();
        String processorPath = "/ide$cms/" + processorName;
        if (!CMSUtils.CMSLibraryIsValid(this.vars.get("LIBRARY").toString(), processorPath)) {
            if (stderrNRListener != null) {
                stderrNRListener.outputLine("\"" + this.vars.get("LIBRARY").toString() + "\" is not a valid library. ");
            }
            return false;
        }
        this.vars.put("CMSPROC", FileUtility.unixPathToOpenVMSPath(processorPath, false));
        if (debug) {
            System.out.println("Full DCL processor path: " + this.vars.get("CMSPROC"));
        }
        this.initDir(this.vars);
        String dirName = (String)vars.get("DIR");
        if (dirName != null && dirName.length() > 0 && dirName.charAt(0) == File.separatorChar) {
            dirName = dirName.substring(1);
            this.vars.put("DIR", dirName);
        }
        String fetchcmd = args[0];
        String diffcmd = args[1];
        String reservationcmd = args[2];
        this.fileGenerationDB = CMSUtils.readFileGenerationDB(this.fsLocalRoot.getAbsolutePath() + File.separatorChar + "CMSINFO");
        if (this.fileGenerationDB == null) {
            this.fileGenerationDB = new Hashtable();
        }
        File diskFile = new File(this.localdir + File.separatorChar + vars.get("FILE").toString());
        try {
            this.gettingCMSElements = true;
            this.CMSElements = new HashSet();
            this.CMSFilesNotInRoot = new HashSet();
            if (debug) {
                System.out.println("Running the Java file fetcher command");
            }
            if (!this.runCommand(this.vars, fetchcmd)) {
                return false;
            }
            this.gettingCMSElements = false;
            if (debug) {
                System.out.println("List of CMS elements:");
                Object[] templist = this.CMSElements.toArray();
                for (int tempn = 0; tempn < this.CMSElements.size(); ++tempn) {
                    System.out.println("Element - " + templist[tempn].toString());
                }
            }
            if (this.CMSElements.size() < 1 && !diskFile.exists()) {
                return true;
            }
        }
        catch (InterruptedException iexc) {
            if (debug) {
                System.out.println("An InterruptedException occurred - " + iexc);
            }
            return false;
        }
        if (!this.readLocalFile(this.dir, vars.get("FILE").toString())) {
            return false;
        }
        if (debug) {
            System.out.println(this.dir + '/' + vars.get("FILE").toString());
        }
        if (!diskFile.exists() && diskFile.getName().endsWith(".java") && this.CMSElements.size() > 0) {
            this.processDeletedJavaFile(diskFile);
        }
        if (this.CMSElements.size() > 0) {
            if (!this.getReservedFileList()) {
                return false;
            }
            if (!this.isFileReserved && this.fileGenerationDB != null && this.fileGenerationDB.containsKey(vars.get("FILE").toString())) {
                GenDBEntry dbEntry = (GenDBEntry)this.fileGenerationDB.get(vars.get("FILE").toString());
                if (debug) {
                    System.out.println("This file is not reserved, setting reserved gen to \"\"");
                }
                dbEntry.setReservedGen("");
                this.fileGenerationDB.put(vars.get("FILE").toString(), dbEntry);
            }
            this.getFileDifferencesByDate(diffcmd);
        }
        this.fillFilesByName();
        this.sendFilesByName(stdoutListener);
        CMSUtils.writeFileGenerationDB(this.fsLocalRoot.getAbsolutePath() + File.separatorChar + "CMSINFO", this.fileGenerationDB);
        if (debug) {
            System.out.println("Finished listfile");
        }
        if (debug) {
            System.out.println("...Leaving LIST_FILE");
        }
        return !this.shouldFail;
    }

    private void sendFilesByName(CommandDataOutputListener stdoutDataListener) {
        Iterator elIt = this.filesByName.values().iterator();
        while (elIt.hasNext()) {
            String[] elements = (String[])elIt.next();
            stdoutDataListener.outputData(elements);
        }
    }

    private boolean readLocalFile(String dir, String fname) {
        this.localFiles = new HashMap();
        if (debug) {
            System.out.println("Entering readLocalFiles...");
        }
        CMSRemoteUtil.refreshLocalDir(this.localdir, true);
        ArrayList subFiles = null;
        try {
            if (debug) {
                System.out.println("dir:" + dir + " fname:" + fname);
            }
            subFiles = CMSRemoteUtil.getRemoteFilesInfo(this.vars, dir, fname);
        }
        catch (IOException e) {
            this.stderrNRListener.outputLine(e.getMessage());
            return false;
        }
        if (subFiles == null) {
            this.stderrNRListener.outputLine("Local file listing is not valid. Please try refresh again.");
            return false;
        }
        for (int i = 0; i < subFiles.size(); ++i) {
            FileCache fCache = new FileCache((RemoteFileInfo)subFiles.get(i));
            if (fCache.isFile()) {
                if (debug) {
                    System.out.println("Adding local file: " + fCache.getName());
                }
            } else {
                this.stderrNRListener.outputLine("Can't Refresh File a folder");
                return false;
            }
            this.localFiles.put(fCache.getName(), fCache);
        }
        if (debug) {
            System.out.println("...Leaving readLocalFiles...");
        }
        return true;
    }

    public void outputData(String[] elements) {
        boolean addThisEntry = true;
        if (elements == null || elements.length == 0 || elements[0] == null) {
            return;
        }
        String stdoutLine = elements[0];
        if (this.gettingCMSElements) {
            int index = stdoutLine.indexOf(LIST_SENTINEL);
            if (index != -1) {
                this.CMSElements.add(stdoutLine.substring(0, index));
            }
            return;
        }
        if (this.gettingReservedFiles) {
            if (stdoutLine.length() > 0 && stdoutLine.charAt(0) != ' ') {
                this.lastReservedFile = stdoutLine;
            } else if (stdoutLine.length() > 4 && stdoutLine.charAt(4) == '(') {
                String[] reservedEntry = new String[6];
                StringTokenizer reservedStringTokens = new StringTokenizer(stdoutLine);
                reservedEntry[0] = this.lastReservedFile;
                for (int index = 1; index < reservedEntry.length; ++index) {
                    reservedEntry[index] = reservedStringTokens.nextToken();
                }
                if (debug) {
                    System.out.println("Reserved file: " + reservedEntry[0] + ", Generation: " + reservedEntry[3]);
                }
                this.isFileReserved = true;
                if (this.fileGenerationDB != null) {
                    if (this.fileGenerationDB.containsKey(reservedEntry[0])) {
                        GenDBEntry dbEntry = (GenDBEntry)this.fileGenerationDB.get(reservedEntry[0]);
                        if (dbEntry.getCurrentGen().equals("")) {
                            if (debug) {
                                System.out.println("This entry has no current generation in the DB; setting it to " + reservedEntry[3]);
                            }
                            dbEntry.setCurrentGen(reservedEntry[3]);
                            dbEntry.setReservedGen(reservedEntry[3]);
                            this.fileGenerationDB.put(reservedEntry[0], dbEntry);
                        } else {
                            if (debug) {
                                System.out.println("This entry has a current generation in the DB: " + dbEntry.getCurrentGen());
                            }
                            if (dbEntry.getCurrentGen().equals(reservedEntry[3])) {
                                if (debug) {
                                    System.out.println("The current gen of the local file is the same as the one reserved in CMS");
                                    System.out.println("This reserved entry will be added");
                                }
                                dbEntry.setReservedGen(reservedEntry[3]);
                                this.fileGenerationDB.put(reservedEntry[0], dbEntry);
                            } else if (dbEntry.getReservedGen().equals(reservedEntry[3])) {
                                if (debug) {
                                    System.out.println("The reserved gen of the local file is the same as the one reserved in CMS");
                                    System.out.println("This reserved entry will be added");
                                }
                            } else {
                                if (debug) {
                                    System.out.println("The current gen of the local file is different from the one reserved in CMS");
                                    System.out.println("This reserved entry will not be added");
                                }
                                addThisEntry = false;
                            }
                        }
                    } else {
                        if (debug) {
                            System.out.println("This entry is not in the DB; creating one...");
                        }
                        GenDBEntry dbEntry = new GenDBEntry();
                        dbEntry.setFileName(reservedEntry[0]);
                        dbEntry.setCurrentGen(reservedEntry[3]);
                        dbEntry.setReservedGen(reservedEntry[3]);
                        this.fileGenerationDB.put(reservedEntry[0], dbEntry);
                    }
                } else if (debug) {
                    System.out.println("File generation DB is null");
                }
                if (addThisEntry) {
                    this.reservedFiles.put(this.lastReservedFile, reservedEntry);
                }
            }
            return;
        }
        if (this.gettingDifferentFiles) {
            this.differentFiles.add(stdoutLine);
            return;
        }
    }
}

