/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.cmsprofile.vcs.commands;

import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.CMSRemoteUtil;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.CMSUtils;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.DCLExecutor;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.FileUtility;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.NumDotRevisionItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.cmdline.VcsAdditionalCommand;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.versioning.RevisionItem;
import org.netbeans.modules.vcscore.versioning.impl.NumDotRevisionList;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public class CMSRevisionListGetter
implements VcsAdditionalCommand,
CommandDataOutputListener {
    private static boolean debug = Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.CMSRevisionListGetter") | Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.ALL");
    private String lastGenerationFile = null;
    final StringBuffer buff = new StringBuffer();
    private ArrayList revisionItems = new ArrayList();
    private ArrayList lastRevisionItems = null;
    private VcsFileSystem fileSystem = null;
    private CommandOutputListener stdoutNRListener = null;
    private CommandOutputListener stderrNRListener = null;
    private CommandDataOutputListener stdoutListener = null;
    private CommandDataOutputListener stderrListener = null;
    private Hashtable vars = null;
    private String processorDir = null;
    private String processorDirVMS = null;
    private File fsLocalRoot = null;
    private static final String CMS_HISTORY_FILENAME = "IDE$CMS_HISTORY.EXE";
    private static final String CMS_HISTORY_PACKAGE = "vcs/commands/";

    public void setFileSystem(VcsFileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    private boolean myrunLog(Hashtable vars, String command) throws InterruptedException {
        boolean status = true;
        String[] DCLCommandLine = new String[1];
        File tempFile = null;
        this.revisionItems = new ArrayList();
        VcsCommand rawCmd = this.fileSystem.getCommand(command.toUpperCase());
        String cmdStr = rawCmd.getProperty("exec").toString();
        cmdStr = cmdStr.substring(cmdStr.indexOf(32) + 1);
        if (debug) {
            System.out.println("Raw command = " + cmdStr);
        }
        String prepared = Variables.expand((Hashtable)vars, (String)cmdStr, (boolean)true);
        if (debug) {
            System.out.println("Command: " + prepared);
        }
        DCLCommandLine[0] = new String("@" + prepared);
        if (debug) {
            System.out.println("Command: " + prepared);
        }
        Vector DCLCommandWrapper = DCLExecutor.preprocessDCLCmds(DCLCommandLine, 1);
        try {
            File tempDir = new File(this.processorDir);
            tempFile = File.createTempFile("CMS", ".txt", tempDir);
            tempFile.delete();
            if (debug) {
                System.out.println("DCLWrapper: " + tempFile.getName());
            }
            DCLExecutor.createDCLFile(tempFile.getPath(), DCLCommandWrapper);
            if (debug) {
                System.out.println(tempFile.getPath() + " was successfully created");
            }
        }
        catch (IOException e) {
            if (debug) {
                System.out.println("An error occurred while creating " + tempFile.getPath());
                System.out.println("Error = " + e);
            }
            return false;
        }
        UserCommand cmd = new UserCommand();
        cmd.setName("REVGETTER");
        cmd.setDisplayName(null);
        String tempFilePath = this.processorDirVMS + tempFile.getName();
        String tempFilePathUnix = FileUtility.openVMSPathToUnixPath(tempFilePath, false);
        if (debug) {
            System.out.println("remote command : @" + tempFilePath + " " + tempFilePathUnix);
        }
        cmd.setProperty("exec", (Object)("@" + tempFilePath + " \"" + tempFilePathUnix + "\""));
        FileObject tempFOFolder = CMSRemoteUtil.refreshLocalDir(tempFile.getPath(), false);
        cmd.setProperty("ignoreFail", (Object)new Boolean(true));
        VcsCommandExecutor ec = CMSRemoteUtil.getCommandExecutor((VcsCommand)cmd, vars, this.fileSystem);
        ec.addDataOutputListener((CommandDataOutputListener)this);
        CMSRemoteUtil.startExecutor(ec, this.fileSystem);
        try {
            CMSRemoteUtil.waitToFinish(ec);
        }
        catch (InterruptedException iexc) {
            CMSRemoteUtil.kill(ec);
            throw iexc;
        }
        if (!debug || (ec.getExitStatus() & 1) != 1) {
            CMSRemoteUtil.cleanUp(tempFOFolder, tempFile.getName().substring(0, tempFile.getName().lastIndexOf(46)), "txt");
            tempFile.delete();
        }
        if ((ec.getExitStatus() & 1) == 1) {
            status = false;
        }
        return status;
    }

    public boolean exec(Hashtable vars, String[] args, CommandOutputListener stdoutNRListener, CommandOutputListener stderrNRListener, CommandDataOutputListener stdoutListener, String dataRegex, CommandDataOutputListener stderrListener, String errorRegex) {
        boolean status;
        this.stdoutNRListener = stdoutNRListener;
        this.stderrNRListener = stderrNRListener;
        this.vars = new Hashtable(vars);
        CMSRemoteUtil.changeVariablesIntoUnixSpec(this.vars, this.fileSystem);
        this.fsLocalRoot = this.fileSystem.getRootDirectory();
        if (debug) {
            System.out.println("Entering RevisionListGetter...");
        }
        this.processorDir = this.fsLocalRoot.getAbsolutePath() + File.separatorChar + "CMSINFO";
        String mountDirVMS = Utilities.isWindows() ? CMSRemoteUtil.windowToOpenVMSPath(this.fsLocalRoot.getAbsolutePath(), true) : CMSRemoteUtil.unixToOpenVMSPath(this.fsLocalRoot.getAbsolutePath(), true);
        String mountDir = FileUtility.openVMSPathToUnixPath(mountDirVMS, true);
        this.processorDirVMS = FileUtility.unixPathToOpenVMSPath(mountDir + "/" + "CMSINFO", true);
        String processorName = this.vars.get("CMSPROC").toString();
        String processorPath = "/ide$cms/" + processorName;
        this.vars.put("CMSPROC", FileUtility.unixPathToOpenVMSPath(processorPath, false));
        if (!CMSUtils.CMSLibraryIsValid(this.vars.get("LIBRARY").toString(), processorPath)) {
            if (stderrNRListener != null) {
                stderrNRListener.outputLine("\"" + this.vars.get("LIBRARY").toString() + "\" is not a valid library. ");
            }
            return false;
        }
        this.vars.put("CMS_HISTORY_UTIL", "ide$cms:IDE$CMS_HISTORY.EXE");
        try {
            status = this.myrunLog(this.vars, args[0]);
        }
        catch (InterruptedException iexc) {
            status = false;
        }
        if (!status) {
            return status;
        }
        NumDotRevisionList list = new NumDotRevisionList();
        Object[] revisionItemsSorted = this.revisionItems.toArray(new RevisionItem[0]);
        Arrays.sort(revisionItemsSorted);
        this.revisionItems = new ArrayList<Object>(Arrays.asList(revisionItemsSorted));
        this.lastRevisionItems = this.revisionItems;
        Iterator it = this.revisionItems.iterator();
        while (it.hasNext()) {
            RevisionItem item = (RevisionItem)it.next();
            list.add((Object)item);
        }
        this.returnEncodedList(list, stdoutListener);
        if (debug) {
            System.out.println("Leaving RevisionListGetter...");
        }
        return true;
    }

    private void returnEncodedList(NumDotRevisionList list, CommandDataOutputListener dataListener) {
        String encodedList;
        try {
            encodedList = VcsUtilities.encodeValue((Object)list);
        }
        catch (IOException ioExc) {
            encodedList = null;
        }
        dataListener.outputData(new String[]{encodedList});
    }

    public void outputData(String[] elements) {
        String stdoutLine;
        if (debug) {
            System.out.println("Entering OutputData()...");
        }
        if (elements == null || elements.length == 0 || elements[0] == null || elements[0].toString().trim().equals("")) {
            return;
        }
        if (debug) {
            System.out.println("Element: '" + elements[0] + "'");
        }
        if ((stdoutLine = elements[0]).indexOf(32) < 0) {
            this.lastGenerationFile = stdoutLine;
            if (debug) {
                System.out.println("Filename found: " + this.lastGenerationFile);
            }
        } else if (stdoutLine.charAt(0) != '%') {
            StringTokenizer generationStringTokens = new StringTokenizer(stdoutLine);
            String revision = generationStringTokens.nextToken();
            String date = generationStringTokens.nextToken();
            String time = generationStringTokens.nextToken();
            String author = generationStringTokens.nextToken();
            StringBuffer comment = new StringBuffer("\"");
            while (generationStringTokens.hasMoreTokens()) {
                comment.append(generationStringTokens.nextToken());
                if (!generationStringTokens.hasMoreTokens()) continue;
                comment.append(' ');
            }
            comment.append('\"');
            String revisionVCS = new String(revision);
            StringBuffer revisionBuf = new StringBuffer();
            for (int i = 0; i < revision.length(); ++i) {
                if (Character.isLetter(revision.charAt(i)) || revision.charAt(i) == '_') {
                    revisionBuf.append('.');
                    while (Character.isLetter(revision.charAt(i)) || revision.charAt(i) == '_') {
                        ++i;
                    }
                    --i;
                    continue;
                }
                revisionBuf.append(revision.charAt(i));
            }
            revision = revisionBuf.toString();
            revision = revision.indexOf(46) < 0 ? revision + ".1" : revision.substring(0, revision.indexOf(46)) + ".1" + revision.substring(revision.indexOf(46));
            NumDotRevisionItem item = new NumDotRevisionItem(revision);
            item.setRevisionVCS(revisionVCS);
            item.setDate(date + " " + time);
            item.setAuthor(author);
            item.setMessage(comment.toString());
            this.revisionItems.add(item);
            if (debug) {
                System.out.println("Revision: " + item.getRevision());
                System.out.println("RevisionVCS: " + item.getRevisionVCS());
                System.out.println("Date: " + item.getDate());
                System.out.println("Author: " + item.getAuthor());
                System.out.println("Comment: " + item.getMessage());
            }
        }
        if (debug) {
            System.out.println("...Leaving OutputData()");
        }
    }
}

