/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.cmsprofile.vcs.commands;

import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.CMSRemoteUtil;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.CMSUtils;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.DCLExecutor;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.GenDBEntry;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.RemoteExecuteCommand;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileInfo;
import org.netbeans.modules.distributed.util.FileUtility;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.caching.VcsCacheDir;
import org.netbeans.modules.vcscore.caching.VcsFSCache;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.cmdline.VcsAdditionalCommand;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public class CMSCommandProcessor
implements VcsAdditionalCommand {
    private static boolean debug = Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.CMSCommandProcessor") | Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.ALL");
    private static final String GENERATION_MSG = "generation";
    private static final String RESERVE_SUCCESS_MSG = "%CMS-S-RESERVED";
    private static final String FETCH_SUCCESS_MSG = "%CMS-S-FETCHED";
    private static final String REPLACE_SUCCESS_MSG = "%CMS-S-GENCREATED";
    private static final String GROUP_RESERVE_SUCCESS_MSG = "%CMS-I-RESERVED";
    private static final String GROUP_FETCH_SUCCESS_MSG = "%CMS-I-FETCHED";
    private static final String GROUP_REPLACE_SUCCESS_MSG = "%CMS-I-GENCREATED";
    private static final String DIFF_FILENAME = "diff.exe";
    private static final String DIFF_PACKAGE = "vcs/commands/";
    private static final String CMS_STATUS_FILENAME = "NB$CMS_STATUS.EXE";
    private static final String CMS_STATUS_PACKAGE = "vcs/commands/";
    private final StringBuffer buff = new StringBuffer();
    private String processorDir = null;
    private String processorDirVMS = null;
    private HashSet directoryList = new HashSet();
    private Hashtable vars = null;
    private VcsFileSystem fileSystem;
    private String dir = null;
    private String localdir = null;
    private String mountpoint = null;
    private String localMountPoint = null;
    private File fsLocalRoot = null;
    private String dataRegex = null;
    private String errorRegex = null;
    private Hashtable fileGenerationDB = null;
    private CommandOutputListener stdoutNRListener = null;
    private CommandOutputListener stderrNRListener = null;
    private CommandDataOutputListener stdoutListener = null;
    private CommandDataOutputListener stderrListener = null;
    private HashMap remoteFileDates;
    private FileObject tempFOFolder;
    private boolean finished = false;

    public CMSCommandProcessor() {
        if (debug) {
            System.out.println("CMSCommandProcessor object created");
        }
    }

    protected void finalize() throws IOException {
        if (debug) {
            System.out.println("CMSCommandProcessor object destroyed");
        }
    }

    public void setFileSystem(VcsFileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    protected String array2string(String[] sa) {
        StringBuffer sb = new StringBuffer(255);
        if (sa != null) {
            for (int i = 0; i < sa.length; ++i) {
                if (sa[i] != "") {
                    sb.append(sa[i] + " ");
                    continue;
                }
                sb.append(sa[i] + "\"\" ");
            }
        }
        return new String(sb);
    }

    private long getRemoteLastModifiedDate(String fname) {
        if (this.remoteFileDates == null) {
            return 0L;
        }
        RemoteFileInfo rf = (RemoteFileInfo)this.remoteFileDates.get(fname);
        if (debug && rf != null) {
            System.out.println("remote last modified:" + fname + " " + rf.lastModified());
        }
        if (rf != null) {
            return rf.lastModified();
        }
        return 0L;
    }

    private static ArrayList getFilePaths(String paths, String qt) {
        ArrayList<String> files = new ArrayList<String>();
        String[] stok = paths.split(qt);
        for (int i = 0; i < stok.length; ++i) {
            String tok = stok[i].trim();
            if (tok.equals("") || files.contains(tok.replace(File.separatorChar, '/'))) continue;
            files.add(tok.replace(File.separatorChar, '/'));
            if (!debug) continue;
            System.out.println("getFilePaths:" + tok.replace(File.separatorChar, '/'));
        }
        return files;
    }

    private static Hashtable getFileTable(String paths, String prefix, char ps) {
        Hashtable<String, String> files = new Hashtable<String, String>();
        if (paths != null && paths.length() > 0) {
            int index;
            int len = paths.length();
            int begin = 0;
            do {
                if ((index = paths.indexOf("" + ps + ps, begin)) < 0) {
                    index = len;
                }
                String file = paths.substring(begin, index);
                String path = null;
                if (files.contains(file.replace(ps, '/'))) continue;
                int slashIndex = file.lastIndexOf(ps);
                if (slashIndex < 0) {
                    files.put(file, prefix);
                } else {
                    path = prefix + file.substring(0, slashIndex + 1);
                    file = file.substring(slashIndex + 1);
                    files.put(file, path);
                }
                if (!debug) continue;
                System.out.println("FileTable entry : " + file + " " + path);
            } while ((begin = index + 2) < len);
        }
        return files;
    }

    private static Hashtable getFileTableWin(String paths, String prefix, String qt) {
        Hashtable<String, String> files = new Hashtable<String, String>();
        String[] stok = paths.split(qt);
        for (int i = 0; i < stok.length; ++i) {
            String tok = stok[i].trim();
            if (tok.equals("")) continue;
            int lastSep = tok.lastIndexOf(File.separatorChar);
            int n = lastSep = lastSep == -1 ? 0 : lastSep + 1;
            if (files.contains(tok.substring(lastSep))) continue;
            files.put(tok.substring(lastSep), prefix + File.separatorChar + tok);
            if (!debug) continue;
            System.out.println("getFileTableWin:" + tok.substring(lastSep) + " " + prefix + File.separatorChar + tok);
        }
        return files;
    }

    private void initDir(Hashtable vars) {
        String localmodule;
        String localRootDir;
        String rootDir = (String)vars.get("ROOTDIR");
        if (rootDir == null) {
            rootDir = ".";
        }
        if ((localRootDir = (String)vars.get("LOCALROOTDIR")) == null) {
            localRootDir = ".";
        }
        this.dir = (String)vars.get("DIR");
        if (this.dir == null) {
            this.dir = "";
        }
        this.localdir = (String)vars.get("LOCALDIR");
        if (this.localdir == null) {
            this.localdir = "";
        }
        String module = (String)vars.get("MODULE");
        this.mountpoint = rootDir;
        this.localMountPoint = localRootDir;
        if (module != null && module.length() > 0) {
            this.mountpoint = this.mountpoint + '/' + module;
        }
        if ((localmodule = (String)vars.get("LOCALMODULE")) != null && localmodule.length() > 0) {
            this.localMountPoint = this.localMountPoint + File.separator + localmodule;
        }
        if (this.dir.equals("")) {
            this.dir = rootDir;
            if (module != null && module.length() > 0) {
                this.dir = this.dir + '/' + module;
            }
        } else {
            this.dir = module == null ? rootDir + '/' + this.dir : rootDir + '/' + module + '/' + this.dir;
        }
        if (this.localdir.equals("")) {
            this.localdir = localRootDir;
            if (localmodule != null && localmodule.length() > 0) {
                this.localdir = this.localdir + File.separator + localmodule;
            }
        } else {
            this.localdir = localmodule == null || localmodule.equals("") ? localRootDir + File.separator + this.localdir : localRootDir + File.separator + module + File.separator + this.localdir;
        }
        if (this.dir.charAt(this.dir.length() - 1) == '/') {
            this.dir = this.dir.substring(0, this.dir.length() - 1);
        }
        if (this.localdir.charAt(this.localdir.length() - 1) == File.separatorChar) {
            this.localdir = this.localdir.substring(0, this.localdir.length() - 1);
        }
        if (debug) {
            System.out.println("The mount point is " + this.mountpoint + "; the current directory is " + this.dir);
            System.out.println("The local mount point is " + this.localMountPoint + "; the current local directory is " + this.localdir);
            System.out.println("...Leaving initDir");
        }
    }

    private boolean isGroupCommand(String cmd) {
        return cmd.equalsIgnoreCase("get_group") || cmd.equalsIgnoreCase("remove_group") || cmd.equalsIgnoreCase("checkin_group") || cmd.equalsIgnoreCase("checkout_group") || cmd.equalsIgnoreCase("undo_checkout_group") || cmd.equalsIgnoreCase("history_group");
    }

    private String replaceToGroupCommand(String cmdName, String preparedCmd) {
        if (cmdName.equals("get_group")) {
            return preparedCmd.replaceAll("get_group", "get");
        }
        if (cmdName.equals("remove_group")) {
            return preparedCmd.replaceAll("remove_group", "\"remove group\"");
        }
        if (cmdName.equals("checkout_group")) {
            return preparedCmd.replaceAll("checkout_group", "checkout");
        }
        if (cmdName.equals("undo_checkout_group")) {
            return preparedCmd.replaceAll("undo_checkout_group", "undo_checkout");
        }
        if (cmdName.equals("history_group")) {
            return preparedCmd.replaceAll("history_group", "history");
        }
        return preparedCmd;
    }

    public boolean exec(Hashtable vars, String[] args, CommandOutputListener stdoutNRListener, CommandOutputListener stderrNRListener, CommandDataOutputListener stdoutListener, String dataRegex, CommandDataOutputListener stderrListener, String errorRegex) {
        String tmpRemark;
        String command;
        boolean status = false;
        boolean doMultiple = false;
        this.stdoutNRListener = stdoutNRListener;
        this.stderrNRListener = stderrNRListener;
        this.stdoutListener = stdoutListener;
        this.stderrListener = stderrListener;
        this.dataRegex = dataRegex;
        this.errorRegex = errorRegex;
        this.vars = new Hashtable(vars);
        if (debug) {
            Enumeration enumeration = vars.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                System.out.println("key:" + key.toString() + " value:" + vars.get(key));
            }
        }
        if ((command = args[1]).equalsIgnoreCase("delete_file") && !vars.containsKey("QPATHS")) {
            return true;
        }
        if (!CMSRemoteUtil.mountCMSFS(vars, this.fileSystem, this.fileSystem.getVariables(), stderrNRListener)) {
            return false;
        }
        CMSRemoteUtil.changeVariablesIntoUnixSpec(this.vars, this.fileSystem);
        this.fsLocalRoot = this.fileSystem.getRootDirectory();
        this.initDir(this.vars);
        if (debug) {
            System.out.println("Entering CMSCommandProcessor...");
            for (int n = 0; n < args.length; ++n) {
                System.out.println("var - " + args[n]);
            }
        }
        if (command.equalsIgnoreCase("delete_file")) {
            CMSRemoteUtil.refreshRoot(this.fsLocalRoot.getAbsolutePath());
            return this.runDeleteFile(command);
        }
        if (this.isGroupCommand(command) && (vars.get("GROUP_NAME") == null || ((String)vars.get("GROUP_NAME")).trim().equals(""))) {
            stdoutNRListener.outputLine("\n\n" + command.toUpperCase() + " command requires a group name.\n" + "Please fill in the group name and try again.");
            return false;
        }
        try {
            int numFiles = Integer.parseInt((String)vars.get("NUM_FILES"));
            if (numFiles == 1 && !this.isGroupCommand(command)) {
                CMSUtils.invokeCommand(this.fileSystem, "LIST_FILE", vars, stderrListener);
            } else {
                CMSUtils.invokeListCommand(this.fileSystem, this.localdir, null);
                this.finished = false;
                ChangeListener slistener = new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        StatusDisplayer s = (StatusDisplayer)e.getSource();
                        if (StatusDisplayer.getDefault().getStatusText().equals("Command Refresh finished.") || StatusDisplayer.getDefault().getStatusText().equals("Command Refresh failed.")) {
                            CMSCommandProcessor.this.finished = true;
                        }
                    }
                };
                StatusDisplayer.getDefault().addChangeListener(slistener);
                while (!this.finished) {
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                StatusDisplayer.getDefault().removeChangeListener(slistener);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (command.equalsIgnoreCase("UNDO_CHECKOUT") || command.equalsIgnoreCase("CHECKOUT") || command.equalsIgnoreCase("HISTORY") || command.equalsIgnoreCase("ADD") || command.equalsIgnoreCase("REMOVE") || command.equalsIgnoreCase("CHECKIN") || command.equalsIgnoreCase("GET") || command.equalsIgnoreCase("UNDO_CHECKOUT_GROUP") || command.equalsIgnoreCase("CHECKOUT_GROUP") || command.equalsIgnoreCase("HISTORY_GROUP") || command.equalsIgnoreCase("REMOVE_GROUP") || command.equalsIgnoreCase("CHECKIN_GROUP") || command.equalsIgnoreCase("GET_GROUP")) {
            doMultiple = true;
        }
        this.processorDir = this.fsLocalRoot.getAbsolutePath() + File.separatorChar + "CMSINFO";
        String processorName = this.vars.get("CMSPROC").toString();
        String processorPath = "/ide$cms/" + processorName;
        if (command.equalsIgnoreCase("UNDO_CHECKOUT") || command.equalsIgnoreCase("CHECKIN")) {
            // empty if block
        }
        if (!CMSUtils.CMSLibraryIsValid(this.vars.get("LIBRARY").toString(), processorPath)) {
            if (stderrNRListener != null) {
                stderrNRListener.outputLine("\"" + this.vars.get("LIBRARY").toString() + "\" is not a valid library. ");
            }
            return false;
        }
        this.vars.put("CMSPROC", FileUtility.unixPathToOpenVMSPath((String)processorPath, (boolean)false));
        if (debug) {
            System.out.println("Full DCL processor path (VMS format): " + this.vars.get("CMSPROC"));
        }
        String mountDirVMS = Utilities.isWindows() ? CMSRemoteUtil.windowToOpenVMSPath(this.fsLocalRoot.getAbsolutePath(), true) : CMSRemoteUtil.unixToOpenVMSPath(this.fsLocalRoot.getAbsolutePath(), true);
        String mountDir = FileUtility.openVMSPathToUnixPath((String)mountDirVMS, (boolean)true);
        this.processorDirVMS = FileUtility.unixPathToOpenVMSPath((String)(mountDir + "/" + "CMSINFO"), (boolean)true);
        if (debug) {
            System.out.println("MountDir : " + mountDir);
        }
        if (mountDir != null && mountDir.length() > 0) {
            this.vars.put("MOUNTDIR", mountDir);
        }
        this.vars.put("UNIXTMPDIR", mountDir + '/' + "CMSINFO" + '/');
        if (debug) {
            System.out.println("Full temporary directory path (Unix format): " + this.vars.get("UNIXTMPDIR"));
        }
        this.vars.put("VMSTMPDIR", FileUtility.unixPathToOpenVMSPath((String)(mountDir + '/' + "CMSINFO"), (boolean)true));
        if (debug) {
            System.out.println("Full temporary directory path (VMS format): " + this.vars.get("VMSTMPDIR"));
        }
        if (this.vars.containsKey("TEMPDIR")) {
            this.vars.put("VMSVCSTMPDIR", FileUtility.unixPathToOpenVMSPath((String)(mountDir + '/' + "CMSINFO"), (boolean)true));
            if (debug) {
                System.out.println("Full VCS temporary directory path (VMS format): " + this.vars.get("VMSVCSTMPDIR"));
            }
        }
        if (!this.vars.containsKey("KEEP_FILE")) {
            this.vars.put("KEEP_FILE", "");
            if (debug) {
                System.out.println("Initializing KEEP_FILE to prevent warning dialog");
            }
        }
        this.vars.put("VMSCMDDIR", this.processorDirVMS);
        if (debug) {
            System.out.println("Full command directory path (VMS format): " + this.vars.get("VMSCMDDIR"));
        }
        if ((tmpRemark = (String)this.vars.get("REMARK")) != null && !tmpRemark.equals("")) {
            tmpRemark = tmpRemark.replace('\"', '\u0080');
            this.vars.put("REMARK", tmpRemark);
        }
        this.fileGenerationDB = CMSUtils.readFileGenerationDB(this.fsLocalRoot.getAbsolutePath() + File.separatorChar + "CMSINFO");
        if (this.fileGenerationDB == null) {
            if (debug) {
                System.out.println("Reservation DB doesn't exist; creating empty hash table...");
            }
            this.fileGenerationDB = new Hashtable();
        }
        try {
            status = !doMultiple ? this.runCommand(this.vars, command, false) : this.runCommandOnce(this.vars, command, false);
        }
        catch (InterruptedException iexc) {
            // empty catch block
        }
        if (status) {
            CMSUtils.writeFileGenerationDB(this.fsLocalRoot.getAbsolutePath() + File.separatorChar + "CMSINFO", this.fileGenerationDB);
        }
        this.fileSystem.setPromptForVarsForEachFile(false);
        if (debug) {
            System.out.println("Finished " + args[1]);
        }
        if (debug) {
            System.out.println("...Leaving CMSCommandProcessor");
        }
        CMSRemoteUtil.refreshRoot(this.fsLocalRoot.getAbsolutePath());
        return status;
    }

    private boolean runDeleteFile(String cmdName) {
        String localPrefix = (String)this.vars.get("LOCALROOTDIR");
        Hashtable filePairsWin = CMSCommandProcessor.getFileTableWin((String)this.vars.get("QMPATHS"), localPrefix, "(\\Q${QUOTE}\\E)");
        if (cmdName.equalsIgnoreCase("DELETE_FILE")) {
            VcsFSCache fsp = (VcsFSCache)this.fileSystem.getStatusProvider();
            Iterator itr = filePairsWin.keySet().iterator();
            while (itr.hasNext()) {
                String fname = (String)itr.next();
                String fpath = (String)filePairsWin.get(fname);
                fpath = fpath.substring(this.fsLocalRoot.getAbsolutePath().length() + 1).replace(File.separatorChar, '/');
                String cacheStatus = fsp.getFileStatus(fpath);
                String rev = fsp.getFileRevision(fpath);
                if (!cacheStatus.equals("Locally Added") && !cacheStatus.equals("Local")) {
                    cacheStatus = cacheStatus.replaceAll("(Up-to-Date|(Locally Modified))", "No Local Copy");
                    this.stdoutListener.outputData(new String[]{fname, cacheStatus, rev});
                } else {
                    fsp.remove(fpath, false);
                }
                CMSRemoteUtil.notifySisterFS(fpath, this.fileSystem);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runCommandOnce(Hashtable vars, String cmdName, boolean addErrOut) throws InterruptedException {
        UserCommand wrapCmd;
        Hashtable<String, String> runVars;
        Hashtable filePairsWin;
        File tempListFile;
        File tempFile;
        boolean status;
        block68: {
            status = true;
            String currentFile = null;
            String currentPath = null;
            String[] DCLCommandLine = null;
            File tempDir = null;
            tempFile = null;
            tempListFile = null;
            if (debug) {
                System.out.println("Entering runCommandOnce...");
            }
            if (debug) {
                System.out.println("PATHS = " + vars.get("PATHS"));
            }
            ArrayList filePaths = CMSCommandProcessor.getFilePaths((String)vars.get("QMPATHS"), "(\\Q${QUOTE}\\E)");
            String rootDir = (String)vars.get("ROOTDIR");
            String module = (String)vars.get("MODULE");
            String ps = "/";
            String prefix = rootDir;
            String localRootDir = (String)vars.get("LOCALROOTDIR");
            String localModule = (String)vars.get("LOCALMODULE");
            String localPs = (String)vars.get("PS");
            String localPrefix = localRootDir;
            filePairsWin = CMSCommandProcessor.getFileTableWin((String)vars.get("QMPATHS"), localPrefix, "(\\Q${QUOTE}\\E)");
            DCLCommandLine = new String[filePaths.size()];
            runVars = new Hashtable<String, String>(vars);
            String savedRevision = (String)vars.get("REVISION");
            VcsCommand cmd = this.fileSystem.getCommand(cmdName.toUpperCase());
            wrapCmd = new UserCommand();
            String cmdStr = cmd.getProperty("exec").toString();
            if (cmdName.toUpperCase() != "LIST") {
                cmdStr = cmdStr.substring(cmdStr.indexOf(32) + 1);
            }
            if (debug) {
                System.out.println("Raw command = " + cmdStr);
            }
            tempDir = new File(this.processorDir);
            try {
                tempFile = File.createTempFile("CMS", ".txt", tempDir);
                tempListFile = File.createTempFile("CMSFileList", ".txt", tempDir);
                tempFile.delete();
                tempListFile.delete();
            }
            catch (IOException e) {
                if (debug) {
                    System.out.println("An error occurred while creating the temporary filename");
                    System.out.println("Error = " + e);
                }
                return false;
            }
            if (debug) {
                System.out.println("DCLWrapper: " + tempFile.getName());
            }
            PrintWriter pout = null;
            try {
                FileOutputStream outFile = new FileOutputStream(tempListFile.getAbsolutePath());
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outFile));
                pout = new PrintWriter((Writer)out, true);
                for (int index = 0; index < filePaths.size(); ++index) {
                    String revision;
                    String prepared;
                    block66: {
                        prepared = new String();
                        if (!this.isGroupCommand(cmdName)) {
                            if (debug) {
                                System.out.println("Processing: " + filePaths.get(index));
                            }
                            this.buff.delete(0, this.buff.length());
                            currentFile = filePaths.get(index).toString();
                            currentPath = currentFile.indexOf(47) != -1 ? currentFile.substring(0, currentFile.lastIndexOf(47)) : "";
                            if (currentFile.indexOf(47) != -1) {
                                currentFile = currentFile.substring(currentFile.lastIndexOf(47) + 1);
                            }
                            if (debug) {
                                System.out.println("File: " + currentFile);
                                System.out.println("Path: " + currentPath);
                            }
                            if (!this.directoryList.contains(currentPath)) {
                                if (debug) {
                                    System.out.println("Adding \"" + currentPath + "\" to directory list");
                                }
                                this.directoryList.add(new String(currentPath));
                            }
                        }
                        revision = new String(savedRevision);
                        if (debug) {
                            System.out.println("REVISION = " + revision);
                        }
                        if (revision == null || revision.equals("") && !cmdName.equals("get") && !cmdName.equals("get_group")) {
                            if (debug) {
                                System.out.println("REVISION is empty");
                            }
                            if (this.fileGenerationDB != null && !this.isGroupCommand(cmdName)) {
                                if (debug) {
                                    System.out.println("The file generation DB has entries");
                                }
                                if (this.fileGenerationDB.containsKey(currentFile)) {
                                    GenDBEntry dbEntry = (GenDBEntry)this.fileGenerationDB.get(currentFile);
                                    String dbGen = dbEntry.getCurrentGen();
                                    if (debug) {
                                        System.out.println(currentFile + " is contained in the generation database; setting REVISION variable to " + dbGen);
                                    }
                                    revision = new String(dbGen);
                                } else {
                                    revision = "-1";
                                    if (debug) {
                                        System.out.println(currentFile + " has no entry in the generation DB");
                                    }
                                }
                            } else if (cmdName.equals("checkin_group")) {
                                revision = "0";
                            } else if (cmdName.equals("undo_checkout_group")) {
                                revision = "0";
                            } else {
                                revision = "-1";
                                if (debug) {
                                    System.out.println("The file generation DB is empty");
                                }
                            }
                        } else if (cmdName.equals("checkin")) {
                            try {
                                Integer.parseInt(revision.substring(0, 1));
                            }
                            catch (NumberFormatException e) {
                                if (this.fileGenerationDB == null) break block66;
                                if (debug) {
                                    System.out.println("The file generation DB has entries");
                                }
                                if (this.fileGenerationDB.containsKey(currentFile)) {
                                    GenDBEntry dbEntry = (GenDBEntry)this.fileGenerationDB.get(currentFile);
                                    String dbGen = dbEntry.getCurrentGen();
                                    revision = new String(dbGen + revision);
                                    if (debug) {
                                        System.out.println(currentFile + " is contained in the generation database; setting REVISION variable to " + revision);
                                    }
                                }
                                if (!debug) break block66;
                                System.out.println(currentFile + " has no entry in the generation DB");
                            }
                        }
                    }
                    if (debug) {
                        System.out.println("REVISION = " + revision);
                    }
                    if (revision.equals("") || revision == null) {
                        revision = "-1";
                    }
                    if (this.isGroupCommand(cmdName)) {
                        pout.write((String)vars.get("GROUP_NAME") + " " + revision + " " + FileUtility.unixPathToOpenVMSPath((String)this.dir, (boolean)true) + '\n');
                        System.out.println("prepared command: " + (String)vars.get("GROUP_NAME") + " " + revision + " " + FileUtility.unixPathToOpenVMSPath((String)this.dir, (boolean)true));
                        break;
                    }
                    prepared = VcsUtilities.getFileNamePart((String)filePaths.get(index).toString()) + " " + revision + " " + FileUtility.unixPathToOpenVMSPath((String)(prefix + '/' + currentPath), (boolean)true);
                    if (debug) {
                        System.out.println("Prepared command: " + prepared);
                    }
                    pout.print(prepared + '\n');
                }
            }
            catch (IOException ie) {
                ie.printStackTrace();
                boolean out = false;
                return out;
            }
            finally {
                if (pout != null) {
                    pout.close();
                }
            }
            runVars.put("TEMPFILELIST", this.processorDirVMS + tempListFile.getName());
            String preparedCmd = Variables.expand(runVars, (String)cmdStr, (boolean)true);
            preparedCmd = this.replaceToGroupCommand(cmdName, preparedCmd);
            if (debug) {
                System.out.println("Prepared command: " + preparedCmd);
            }
            DCLCommandLine[0] = new String("@" + preparedCmd);
            Vector DCLCommandWrapper = DCLExecutor.preprocessDCLCmds(DCLCommandLine, 1);
            try {
                DCLExecutor.createDCLFile(tempFile.getPath(), DCLCommandWrapper);
                if (debug) {
                    System.out.println(tempFile.getPath() + " was successfully created");
                }
            }
            catch (IOException e) {
                if (!debug) break block68;
                System.out.println("An error occurred while creating " + tempFile.getPath());
                System.out.println("Error = " + e);
            }
        }
        this.tempFOFolder = CMSRemoteUtil.refreshLocalDir(tempFile.getPath(), false);
        wrapCmd.setName("CMS_COMMAND");
        wrapCmd.setDisplayName(null);
        String tempFilePath = this.processorDirVMS + tempFile.getName();
        String tempFilePathUnix = FileUtility.openVMSPathToUnixPath((String)tempFilePath, (boolean)false);
        if (debug) {
            System.out.println("remote command : @" + tempFilePath + " " + tempFilePathUnix);
        }
        wrapCmd.setProperty("exec", (Object)("@" + tempFilePath + " \"" + tempFilePathUnix + "\""));
        wrapCmd.setProperty("ignoreFail", (Object)new Boolean(true));
        wrapCmd.setProperty("refreshCurrentFolder", (Object)new Boolean(false));
        VcsCommandExecutor ec = CMSRemoteUtil.getCommandExecutor((VcsCommand)wrapCmd, runVars, this.fileSystem);
        CMSRemoteUtil.preprocessCommand(ec, vars, this.fileSystem);
        VcsDescribedCommand myCmd = ((RemoteExecuteCommand)ec).getDescribedCommand();
        myCmd.setPreferredExec(wrapCmd.getProperty("exec").toString());
        ec.addOutputListener(new CommandOutputListener(){

            public void outputLine(String line) {
                CMSCommandProcessor.this.buff.append((line != null ? line : "") + "\n");
            }
        });
        if (addErrOut) {
            ec.addDataErrorOutputListener(this.stderrListener);
        }
        ec.addOutputListener(this.stdoutNRListener);
        ec.addErrorOutputListener(this.stderrNRListener);
        CMSRemoteUtil.startExecutor(ec);
        try {
            CMSRemoteUtil.waitToFinish(ec);
        }
        catch (InterruptedException iexc) {
            CMSRemoteUtil.kill(ec);
            throw iexc;
        }
        if (!debug || (ec.getExitStatus() & 1) != 1) {
            CMSRemoteUtil.cleanUp(this.tempFOFolder, tempFile.getName().substring(0, tempFile.getName().lastIndexOf(46)), "txt");
            tempFile.delete();
        }
        if ((ec.getExitStatus() & 1) == 1) {
            status = false;
            return status;
        }
        status = true;
        try {
            ArrayList list = null;
            if (this.isGroupCommand(cmdName)) {
                String fname = this.getRemoteFileDatesForGroupCommand(cmdName);
                list = CMSRemoteUtil.getRemoteFilesInfo(vars, "", FileUtility.openVMSPathToUnixPath((String)fname, (boolean)false));
            } else {
                list = CMSRemoteUtil.getRemoteFilesInfo(vars, "", FileUtility.openVMSPathToUnixPath((String)((String)runVars.get("TEMPFILELIST")), (boolean)false));
            }
            this.remoteFileDates = new HashMap();
            for (int i = 0; i < list.size(); ++i) {
                if (debug) {
                    System.out.println(((RemoteFileInfo)list.get(i)).getFileName() + " " + (RemoteFileInfo)list.get(i));
                }
                this.remoteFileDates.put(((RemoteFileInfo)list.get(i)).getFileName(), (RemoteFileInfo)list.get(i));
            }
        }
        catch (IOException e) {
            if (debug) {
                e.printStackTrace();
            }
            this.stderrNRListener.outputLine(e.getMessage());
            status = false;
        }
        CMSRemoteUtil.cleanUp(this.tempFOFolder, tempListFile.getName().substring(0, tempListFile.getName().lastIndexOf(46)), "txt");
        tempListFile.delete();
        if (status) {
            this.trackFileGeneration(cmdName, filePairsWin);
        }
        if (debug) {
            System.out.println("...Leaving runCommandOnce");
        }
        return status;
    }

    protected boolean runCommand(Hashtable vars, String cmdName, boolean addErrOut) throws InterruptedException {
        boolean status = true;
        String[] DCLCommandLine = new String[1];
        File tempDir = null;
        File tempFile = null;
        if (debug) {
            System.out.println("Entering runCommand...");
        }
        if (debug) {
            System.out.println("PATHS = " + vars.get("PATHS"));
        }
        ArrayList filePaths = CMSCommandProcessor.getFilePaths((String)vars.get("QMPATHS"), "(\\Q${QUOTE}\\E)");
        if (debug) {
            System.out.println("MODULE = " + vars.get("MODULE"));
            System.out.println("ROOTDIR = " + vars.get("ROOTDIR"));
            System.out.println("REVISION = " + vars.get("REVISION"));
        }
        String rootPath = !vars.get("MODULE").equals("") ? (String)vars.get("ROOTDIR") + '/' + (String)vars.get("MODULE") + '/' : (String)vars.get("ROOTDIR") + '/';
        if (debug) {
            System.out.println("rootPath = " + rootPath);
        }
        Hashtable<String, String> runVars = new Hashtable<String, String>(vars);
        String savedRevision = (String)runVars.get("REVISION");
        VcsCommand cmd = this.fileSystem.getCommand(cmdName.toUpperCase());
        UserCommand wrapCmd = new UserCommand();
        String cmdStr = cmd.getProperty("exec").toString();
        if (cmdName.toUpperCase() != "LIST") {
            cmdStr = cmdStr.substring(cmdStr.indexOf(32) + 1);
        }
        if (debug) {
            System.out.println("Raw command = " + cmdStr);
        }
        tempDir = new File(this.processorDir);
        try {
            tempFile = File.createTempFile("CMS", ".txt", tempDir);
            tempFile.delete();
        }
        catch (IOException e) {
            if (debug) {
                System.out.println("An error occurred while creating the temporary filename");
                System.out.println("Error = " + e);
            }
            return false;
        }
        if (debug) {
            System.out.println("DCLWrapper: " + tempFile.getName());
        }
        for (int index = 0; index < filePaths.size(); ++index) {
            block38: {
                if (debug) {
                    System.out.println("Processing: " + filePaths.get(index));
                }
                runVars.put("REVISION", savedRevision);
                this.buff.delete(0, this.buff.length());
                String currentFile = filePaths.get(index).toString();
                String currentPath = currentFile.indexOf(47) != -1 ? currentFile.substring(0, currentFile.lastIndexOf(47)) : "";
                if (currentFile.indexOf(47) != -1) {
                    currentFile = currentFile.substring(currentFile.lastIndexOf(47) + 1);
                }
                if (debug) {
                    System.out.println("File: " + currentFile);
                    System.out.println("Path: " + currentPath);
                }
                if (!this.directoryList.contains(currentPath)) {
                    if (debug) {
                        System.out.println("Adding \"" + currentPath + "\" to directory list");
                    }
                    this.directoryList.add(currentPath);
                }
                if (debug) {
                    System.out.println("REVISION = " + runVars.get("REVISION"));
                }
                if (runVars.get("REVISION") == null || runVars.get("REVISION").equals("") && !cmdName.equals("get") && !cmdName.equals("get_group")) {
                    if (debug) {
                        System.out.println("REVISION is empty");
                    }
                    if (this.fileGenerationDB != null) {
                        if (debug) {
                            System.out.println("The file generation DB has entries");
                        }
                        if (this.fileGenerationDB.containsKey(currentFile)) {
                            GenDBEntry dbEntry = (GenDBEntry)this.fileGenerationDB.get(currentFile);
                            String dbGen = dbEntry.getCurrentGen();
                            if (debug) {
                                System.out.println(currentFile + " is contained in the generation database; setting REVISION variable to " + dbGen);
                            }
                            runVars.put("REVISION", dbGen);
                        } else if (debug) {
                            System.out.println(currentFile + " has no entry in the generation DB");
                        }
                    } else if (debug) {
                        System.out.println("The file generation DB is empty");
                    }
                }
                if (debug) {
                    System.out.println("REVISION = " + runVars.get("REVISION"));
                }
                String prepared = Variables.expand(runVars, (String)cmdStr, (boolean)true);
                if (debug) {
                    System.out.println("Prepared command: " + prepared);
                }
                DCLCommandLine[0] = new String("@" + prepared);
                Vector DCLCommandWrapper = DCLExecutor.preprocessDCLCmds(DCLCommandLine, 1);
                try {
                    DCLExecutor.createDCLFile(tempFile.getPath(), DCLCommandWrapper);
                    if (!debug) break block38;
                    System.out.println(tempFile.getPath() + " was successfully created");
                }
                catch (IOException e) {
                    if (!debug) continue;
                    System.out.println("An error occurred while creating " + tempFile.getPath());
                    System.out.println("Error = " + e);
                    continue;
                }
            }
            this.tempFOFolder = CMSRemoteUtil.refreshLocalDir(tempFile.getPath(), false);
            wrapCmd.setName("CMS_COMMAND");
            wrapCmd.setDisplayName(null);
            String tempFilePath = this.processorDirVMS + tempFile.getName();
            String tempFilePathUnix = FileUtility.openVMSPathToUnixPath((String)tempFilePath, (boolean)false);
            if (debug) {
                System.out.println("remote command : @" + tempFilePath + " " + tempFilePathUnix);
            }
            wrapCmd.setProperty("exec", (Object)("@" + tempFilePath + " \"" + tempFilePathUnix + "\""));
            if (debug) {
                System.out.println("PROPERTY_EXEC: " + wrapCmd.getProperty("exec"));
            }
            wrapCmd.setProperty("ignoreFail", (Object)new Boolean(true));
            wrapCmd.setProperty("refreshCurrentFolder", (Object)new Boolean(false));
            VcsCommandExecutor ec = CMSRemoteUtil.getCommandExecutor((VcsCommand)wrapCmd, runVars, this.fileSystem);
            CMSRemoteUtil.preprocessCommand(ec, vars, this.fileSystem);
            VcsDescribedCommand myCmd = ((RemoteExecuteCommand)ec).getDescribedCommand();
            myCmd.setPreferredExec(wrapCmd.getProperty("exec").toString());
            ec.addOutputListener(new CommandOutputListener(){

                public void outputLine(String line) {
                    CMSCommandProcessor.this.buff.append((line != null ? line : "") + "\n");
                }
            });
            ec.addDataOutputListener(this.stdoutListener);
            if (addErrOut) {
                ec.addDataErrorOutputListener(this.stderrListener);
            }
            ec.addOutputListener(this.stdoutNRListener);
            ec.addErrorOutputListener(this.stderrNRListener);
            CMSRemoteUtil.startExecutor(ec);
            try {
                CMSRemoteUtil.waitToFinish(ec);
            }
            catch (InterruptedException iexc) {
                CMSRemoteUtil.kill(ec);
                throw iexc;
            }
            if (!debug || (ec.getExitStatus() & 1) != 1) {
                CMSRemoteUtil.cleanUp(this.tempFOFolder, tempFile.getName().substring(0, tempFile.getName().lastIndexOf(46)), "txt");
                tempFile.delete();
            }
            if ((ec.getExitStatus() & 1) != 1) continue;
            status = false;
            break;
        }
        if (debug) {
            System.out.println("...Leaving runCommand");
        }
        return status;
    }

    private void sendFileRefresh(GenDBEntry dbEntry, String status, String command) {
        if (status.equals("removed")) {
            return;
        }
        String[] fileEntry = new String[]{dbEntry.getFileName(), status, dbEntry.getCurrentGen()};
        if (fileEntry[2].equals("") && !status.equals("Locally Added")) {
            fileEntry[2] = "1";
        }
        this.stdoutListener.outputData(fileEntry);
        String module = (String)this.vars.get("MODULE");
        String path = module == null || module != null && module.length() == 0 ? dbEntry.getFileName() : this.dir + '/' + dbEntry.getFileName();
        if (command.equalsIgnoreCase("get") || command.equalsIgnoreCase("get_group") || command.equalsIgnoreCase("checkin") || command.equalsIgnoreCase("checkin_group") || command.equalsIgnoreCase("checkout") || command.equalsIgnoreCase("checkout_group")) {
            CMSRemoteUtil.notifySisterFS(path, this.fileSystem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoteFileDatesForGroupCommand(String commandName) throws IOException {
        int i;
        if (debug) {
            System.out.println("Entering getRemoteFileDatesForGroupCommand");
            System.out.println("Command output = " + this.buff.toString());
        }
        StringTokenizer reservationStringTokens = new StringTokenizer(this.buff.toString(), ", \t\n\r\f");
        ArrayList<String> fnameList = new ArrayList<String>();
        boolean msgFound = false;
        while (reservationStringTokens.hasMoreTokens()) {
            String fileName = null;
            String tmpString = reservationStringTokens.nextToken();
            if (commandName.equals("add") || commandName.equals("remove") || commandName.equals("remove_group") || commandName.equals("undo_checkout") || commandName.equals("undo_checkout_group")) {
                if (!tmpString.equals("%CMS-S-DELETED") && !tmpString.equals("%CMS-I-DELETED") && !tmpString.equals("%CMS-S-CREATED") && !tmpString.equals("%CMS-S-UNRESERVED") && !tmpString.equals("%CMS-I-UNRESERVED")) continue;
                reservationStringTokens.nextToken();
                fileName = reservationStringTokens.nextToken();
                int lastIndex = fileName.lastIndexOf(93);
                if (lastIndex < 0) {
                    lastIndex = fileName.lastIndexOf(58);
                }
                fileName = fileName.substring(lastIndex + 1);
                fnameList.add(fileName);
                continue;
            }
            if (!commandName.equals("checkin") && !commandName.equals("checkin_group") && !commandName.equals("checkout") && !commandName.equals("checkout_group") && !commandName.equals("get") && !commandName.equals("get_group")) continue;
            if (!msgFound) {
                if (!tmpString.equals(REPLACE_SUCCESS_MSG) && !tmpString.equals(GROUP_REPLACE_SUCCESS_MSG) && !tmpString.equals(RESERVE_SUCCESS_MSG) && !tmpString.equals(GROUP_RESERVE_SUCCESS_MSG) && !tmpString.equals(FETCH_SUCCESS_MSG) && !tmpString.equals(GROUP_FETCH_SUCCESS_MSG)) continue;
                msgFound = true;
                continue;
            }
            if (!tmpString.equals(GENERATION_MSG)) continue;
            String generation = reservationStringTokens.nextToken();
            for (i = 0; i < 2; ++i) {
                reservationStringTokens.nextToken();
            }
            fileName = reservationStringTokens.nextToken();
            int lastIndex = fileName.lastIndexOf(93);
            if (lastIndex < 0) {
                lastIndex = fileName.lastIndexOf(58);
            }
            fileName = fileName.substring(lastIndex + 1);
            fnameList.add(fileName);
            msgFound = false;
        }
        File tempListFile = null;
        File tempDir = new File(this.processorDir);
        tempListFile = File.createTempFile("CMSFileList", ".txt", tempDir);
        tempListFile.delete();
        PrintWriter pout = null;
        try {
            FileOutputStream outFile = new FileOutputStream(tempListFile.getAbsolutePath());
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outFile));
            pout = new PrintWriter((Writer)out, true);
            for (i = 0; i < fnameList.size(); ++i) {
                pout.print((String)fnameList.get(i) + " -1 " + FileUtility.unixPathToOpenVMSPath((String)this.dir, (boolean)true) + '\n');
            }
        }
        finally {
            if (pout != null) {
                pout.close();
            }
        }
        FileObject tempFOFolder = CMSRemoteUtil.refreshLocalDir(tempListFile.getPath(), false);
        if (debug) {
            System.out.println("...Leaving getRemoteFileDatesForGroupCommand");
        }
        return this.processorDirVMS + tempListFile.getName();
    }

    private boolean trackFileGeneration(String commandName, Hashtable pathTable) {
        if (debug) {
            System.out.println("Command output = " + this.buff.toString());
        }
        StringTokenizer reservationStringTokens = new StringTokenizer(this.buff.toString(), ", \t\n\r\f");
        boolean msgFound = false;
        while (reservationStringTokens.hasMoreTokens()) {
            long fileDate;
            String fileName = null;
            GenDBEntry dbEntry = null;
            GenDBEntry fileEntry = new GenDBEntry();
            String statusCMS = "";
            String tmpString = reservationStringTokens.nextToken();
            if (commandName.equals("add") || commandName.equals("remove") || commandName.equals("undo_checkout") || commandName.equals("remove_group") || commandName.equals("undo_checkout_group")) {
                if (!tmpString.equals("%CMS-S-DELETED") && !tmpString.equals("%CMS-S-CREATED") && !tmpString.equals("%CMS-S-UNRESERVED") && !tmpString.equals("%CMS-I-DELETED") && !tmpString.equals("%CMS-I-UNRESERVED")) continue;
                if (debug) {
                    System.out.println(commandName + " " + tmpString);
                }
                reservationStringTokens.nextToken();
                fileName = reservationStringTokens.nextToken();
                int lastIndex = fileName.lastIndexOf(93);
                if (lastIndex < 0) {
                    lastIndex = fileName.lastIndexOf(58);
                }
                if (this.fileGenerationDB.containsKey(fileName = fileName.substring(lastIndex + 1))) {
                    if (debug) {
                        System.out.println("File has an entry in the generation DB");
                    }
                    dbEntry = (GenDBEntry)this.fileGenerationDB.get(fileName);
                    if (debug) {
                        System.out.println("Previous generation: " + dbEntry.getPreviousGen());
                        System.out.println("Current generation: " + dbEntry.getCurrentGen());
                        System.out.println("Reserved generation: " + dbEntry.getReservedGen());
                    }
                } else if (debug) {
                    System.out.println("File does not have an entry in the generation DB");
                }
                if (debug) {
                    System.out.println("Getting last modified date for " + fileName + ", pathTable path: " + pathTable.get(fileName));
                }
                File fileInfo = null;
                fileInfo = this.isGroupCommand(commandName) ? new File(this.localdir + File.separatorChar + fileName) : new File((String)pathTable.get(fileName));
                fileDate = this.getRemoteLastModifiedDate(fileName);
                long l = fileDate = fileDate == 0L ? fileInfo.lastModified() : fileDate;
                if (debug) {
                    System.out.println("Last modified date = " + fileDate);
                }
                if (commandName.equals("add")) {
                    if (debug) {
                        System.out.println("Add new entry with file generation = 1");
                    }
                    fileEntry.setFileName(fileName);
                    fileEntry.setPreviousGen("");
                    fileEntry.setCurrentGen("1");
                    fileEntry.setFileDate(fileDate);
                    statusCMS = "Up-to-Date";
                }
                if (commandName.equals("remove") || commandName.equals("remove_group")) {
                    this.fileGenerationDB.remove(fileName);
                    fileEntry.setFileName(fileName);
                    if (fileInfo.exists()) {
                        statusCMS = "Locally Added";
                    } else {
                        statusCMS = "removed";
                        VcsFSCache fsp = (VcsFSCache)this.fileSystem.getStatusProvider();
                        String fpath = fileInfo.getAbsolutePath().substring(this.fsLocalRoot.getAbsolutePath().length() + 1).replace(File.separatorChar, '/');
                        String dpath = "";
                        if (!fileInfo.getParent().equalsIgnoreCase(this.fsLocalRoot.getAbsolutePath())) {
                            dpath = fileInfo.getParent().substring(this.fsLocalRoot.getAbsolutePath().length() + 1).replace(File.separatorChar, '/');
                        }
                        VcsCacheDir cdir = (VcsCacheDir)this.fileSystem.getCacheProvider().getDir(dpath);
                        cdir.removeFile(fileName, true);
                        cdir.writeToDisk();
                        this.fileSystem.getCacheProvider().remove(fpath, false);
                    }
                }
                if (commandName.equals("undo_checkout") || commandName.equals("undo_checkout_group")) {
                    fileEntry.setFileName(fileName);
                    fileEntry.setPreviousGen("");
                    if (dbEntry != null) {
                        fileEntry.setCurrentGen(!dbEntry.getPreviousGen().equals("") ? dbEntry.getPreviousGen() : dbEntry.getCurrentGen());
                        fileEntry.setFileDate(fileDate);
                        fileEntry.setReservedGen("");
                    } else {
                        fileEntry.setCurrentGen("");
                    }
                    statusCMS = dbEntry != null && fileDate != dbEntry.getFileDate() ? "Locally Modified" : (fileDate != 0L ? "Up-to-Date" : "No Local Copy");
                }
                if (!commandName.equals("remove") && !commandName.equals("remove_group") && fileEntry.getFileName() != null) {
                    if (debug) {
                        System.out.println("Adding new/updated entry to generation database");
                    }
                    this.fileGenerationDB.put(fileEntry.getFileName(), fileEntry);
                }
                if (debug) {
                    System.out.println("File: " + fileEntry.getFileName() + ", current generation: " + fileEntry.getCurrentGen() + ", previous generation: " + fileEntry.getPreviousGen() + ", reserved generation: " + fileEntry.getReservedGen());
                }
                this.sendFileRefresh(fileEntry, statusCMS, commandName);
                continue;
            }
            if (!commandName.equals("checkin") && !commandName.equals("checkin_group") && !commandName.equals("checkout") && !commandName.equals("checkout_group") && !commandName.equals("get") && !commandName.equals("get_group")) continue;
            if (!msgFound) {
                if (!tmpString.equals(REPLACE_SUCCESS_MSG) && !tmpString.equals(GROUP_REPLACE_SUCCESS_MSG) && !tmpString.equals(RESERVE_SUCCESS_MSG) && !tmpString.equals(GROUP_RESERVE_SUCCESS_MSG) && !tmpString.equals(FETCH_SUCCESS_MSG) && !tmpString.equals(GROUP_FETCH_SUCCESS_MSG)) continue;
                if (debug) {
                    System.out.println("Replace/reserve/fetch success message was found");
                }
                msgFound = true;
                continue;
            }
            if (!tmpString.equals(GENERATION_MSG)) continue;
            String generation = reservationStringTokens.nextToken();
            if (debug) {
                System.out.println("File generation was found; generation = " + generation);
            }
            for (int i = 0; i < 2; ++i) {
                reservationStringTokens.nextToken();
            }
            fileName = reservationStringTokens.nextToken();
            int lastIndex = fileName.lastIndexOf(93);
            if (lastIndex < 0) {
                lastIndex = fileName.lastIndexOf(58);
            }
            if (this.fileGenerationDB.containsKey(fileName = fileName.substring(lastIndex + 1))) {
                if (debug) {
                    System.out.println("File has an entry in the generation DB");
                }
                dbEntry = (GenDBEntry)this.fileGenerationDB.get(fileName);
                fileEntry.setFileDate(dbEntry.getFileDate());
                if (debug) {
                    System.out.println("Previous generation: " + dbEntry.getPreviousGen());
                    System.out.println("Current generation: " + dbEntry.getCurrentGen());
                    System.out.println("Reserved generation: " + dbEntry.getReservedGen());
                }
            } else if (debug) {
                System.out.println("File does not have an entry in the generation DB");
            }
            File fileInfo = null;
            fileInfo = this.isGroupCommand(commandName) ? new File(this.localdir + File.separatorChar + fileName) : new File((String)pathTable.get(fileName));
            fileDate = this.getRemoteLastModifiedDate(fileName);
            long l = fileDate = fileDate == 0L ? fileInfo.lastModified() : fileDate;
            if (debug) {
                System.out.println("Last modified date = Disk " + fileDate);
            }
            if (commandName.equals("checkout") || commandName.equals("checkout_group")) {
                if (debug) {
                    System.out.println("This is the checkout command");
                }
                fileEntry.setReservedGen(generation);
                if (!this.vars.get("FETCH_FILE").toString().equals("")) {
                    if (debug) {
                        System.out.println("File was fetched; FETCH_FILE = " + this.vars.get("FETCH_FILE").toString());
                    }
                    fileEntry.setPreviousGen(generation);
                    fileEntry.setCurrentGen(generation);
                    statusCMS = "Up-to-Date Reserved";
                } else {
                    if (debug) {
                        System.out.println("File was not fetched; FETCH_FILE = " + this.vars.get("FETCH_FILE").toString());
                    }
                    if (dbEntry != null) {
                        fileEntry.setPreviousGen(dbEntry.getCurrentGen());
                        fileEntry.setCurrentGen(generation);
                    } else {
                        fileEntry.setPreviousGen("");
                        fileEntry.setCurrentGen(generation);
                    }
                    statusCMS = !fileInfo.exists() ? "No Local Copy Reserved" : (dbEntry != null && dbEntry.getFileDate() != fileDate || dbEntry != null && !dbEntry.getPreviousGen().equals("") && !generation.equals(dbEntry.getPreviousGen()) ? "Locally Modified Reserved" : "Up-to-Date Reserved");
                }
            } else if (commandName.equals("checkin") || commandName.equals("checkin_group")) {
                if (debug) {
                    System.out.println("This is the checkin command");
                }
                fileEntry.setPreviousGen(generation);
                fileEntry.setCurrentGen(generation);
                fileEntry.setReservedGen("");
                statusCMS = "Up-to-Date";
            } else {
                if (debug) {
                    System.out.println("This is the get command");
                }
                if (dbEntry == null || dbEntry.getReservedGen().equals("")) {
                    if (debug) {
                        System.out.println("Reserved generation isn't set");
                    }
                    fileEntry.setPreviousGen("");
                    fileEntry.setCurrentGen(generation);
                    statusCMS = "Up-to-Date";
                } else {
                    if (debug) {
                        System.out.println("Reserved generation= " + dbEntry.getReservedGen());
                    }
                    fileEntry.setPreviousGen(generation);
                    fileEntry.setCurrentGen(dbEntry.getCurrentGen());
                    fileEntry.setReservedGen(dbEntry.getReservedGen());
                    statusCMS = !generation.equals(dbEntry.getReservedGen()) ? "Locally Modified Reserved" : "Up-to-Date Reserved";
                }
            }
            fileEntry.setFileName(fileName);
            if ((commandName.equals("checkout") || commandName.equals("checkout_group")) && !this.vars.get("FETCH_FILE").toString().equals("") || commandName.equals("checkin") || commandName.equals("checkin_group") || commandName.equals("get") || commandName.equals("get_group")) {
                if ((commandName.equals("get") || commandName.equals("get_group")) && !fileEntry.getReservedGen().equals("") && dbEntry != null && dbEntry.getFileDate() != 0L) {
                    if (debug) {
                        System.out.println("\"get\" command on reserved file; don't update the entry's date");
                    }
                } else {
                    if (debug) {
                        System.out.println("Updating the file info DB entry's date");
                    }
                    fileEntry.setFileDate(fileDate);
                }
            }
            if (fileEntry.getFileName() != null) {
                if (debug) {
                    System.out.println("Adding new/updated entry to generation database");
                }
                this.fileGenerationDB.put(fileEntry.getFileName(), fileEntry);
            }
            if (debug) {
                System.out.println("File: " + fileEntry.getFileName() + ", current generation: " + fileEntry.getCurrentGen() + ", previous generation: " + fileEntry.getPreviousGen() + ", reserved generation: " + fileEntry.getReservedGen());
            }
            msgFound = false;
            this.sendFileRefresh(fileEntry, statusCMS, commandName);
        }
        if (debug) {
            System.out.println("...Leaving trackFileGeneration");
        }
        return true;
    }
}

