/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cobolsupport.cobol;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompilerType;
import com.hp.openvms.netbeans.baseclasses.compiler.BogusCompiler;
import com.hp.openvms.netbeans.beans.editors.AlphaVMSCompilationQualifier;
import com.hp.openvms.netbeans.beans.editors.AlphaVMSListQualifier;
import com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompiler;
import com.hp.openvms.netbeans.cobolsupport.cobol.datasys.CobolDataObject;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.distributed.remotefs.core.RemoteFSFile;
import org.openide.ErrorManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class CobolCompilerType
extends AlphaVMSCompilerType {
    public static final String PROP_BUILD_DIRECTORY = "buildDirectory";
    public static final String PROP_MAKEFILE_COMPILER = "makefileCompiler";
    public static final String PROP_OBJECT_DIRECTORY = "objectDirectory";
    public static final String PROP_LIST_DIRECTORY = "listDirectory";
    public static final String PROP_DIAGNOSTIC_DIRECTORY = "dignosticDirectory";
    public static final String PROP_ANALYSIS_DIRECTORY = "analysisDirectory";
    public static final String PROP_INCLUDE = "include";
    public static final String PROP_LIBRARY = "library";
    public static final String PROP_OPTIMIZE = "optimize";
    public static final String PROP_CHECK = "check";
    public static final String PROP_OPTIONS = "options";
    public static final String PROP_DEBUG = "debug";
    public static final String PROP_OTHER_OPTIONS = "otherOptions";
    public static final String PROP_BUILD_OPTION = "buildOption";
    public static final String PROP_ANSIFORMATTING = "ansiFormatting";
    public static final String PROP_OUTPUT_SWITCH = "outputSwitch";
    public static final String PROP_EXTERNAL_COMPILER = "externalCompiler";
    public static final String PROP_BUILD_COMMAND = "buildCommand";
    public static final String PROP_COBOL_GLOBAL_QUALIFIER = "globalQualifier";
    public static final String PROP_COBOL_LOCAL_QUALIFIER = "localQualifier";
    private File objectDirectory;
    private String listDirectory = "/NOLIST";
    private String makefileCompiler;
    private RemoteFSFile makefileCompilerRemote;
    private AlphaVMSListQualifier include;
    private AlphaVMSCompilationQualifier options;
    private String library = "";
    private String optimize = "";
    private String check = "/NOCHECK";
    private String debug = "";
    private String otherOptions = "";
    private File buildDirectory;
    private RemoteFSFile buildDirectoryRemote;
    private Boolean buildOption = Boolean.FALSE;
    private Boolean ansiFormatting = Boolean.FALSE;
    private Boolean outputSwitch = Boolean.FALSE;
    private NbProcessDescriptor externalCompiler;
    private String buildCommand;
    private Boolean updated;
    private String globalQualifier;
    private String localQualifier;
    private static ResourceBundle bundle;
    static final long serialVersionUID = 3952144683021797629L;
    static /* synthetic */ Class class$com$hp$openvms$netbeans$cobolsupport$cobol$CobolCompilerType;

    public static String getString(String name) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$com$hp$openvms$netbeans$cobolsupport$cobol$CobolCompilerType == null ? (class$com$hp$openvms$netbeans$cobolsupport$cobol$CobolCompilerType = CobolCompilerType.class$("com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompilerType")) : class$com$hp$openvms$netbeans$cobolsupport$cobol$CobolCompilerType));
        }
        return bundle.getString(name);
    }

    public File getObjectDirectory() {
        if (this.objectDirectory == null) {
            return new File("");
        }
        return this.objectDirectory;
    }

    public String getListDirectory() {
        if (this.listDirectory == null) {
            return "";
        }
        return this.listDirectory;
    }

    public void setObjectDirectory(File objectDir) {
        File oldDir = this.objectDirectory;
        this.objectDirectory = objectDir;
        this.firePropertyChange(PROP_OBJECT_DIRECTORY, oldDir, this.objectDirectory);
    }

    public void setListDirectory(String listDir) {
        String oldDir = this.listDirectory;
        this.listDirectory = listDir;
        this.firePropertyChange(PROP_LIST_DIRECTORY, oldDir, this.listDirectory);
    }

    public AlphaVMSListQualifier getInclude() {
        if (this.include == null) {
            return new AlphaVMSListQualifier("");
        }
        return this.include;
    }

    public synchronized void setInclude(AlphaVMSListQualifier newInclude) {
        AlphaVMSListQualifier oldInclude = this.include;
        this.include = newInclude;
        this.firePropertyChange(PROP_INCLUDE, oldInclude, this.include);
    }

    public String getLibrary() {
        if (this.library == null) {
            return "";
        }
        return this.library;
    }

    public void setLibrary(String newLibrary) {
        String oldLibrary = this.library;
        this.library = newLibrary;
        this.firePropertyChange(PROP_LIBRARY, oldLibrary, this.library);
    }

    public AlphaVMSCompilationQualifier getOptions() {
        if (this.options == null) {
            return new AlphaVMSCompilationQualifier("");
        }
        return this.options;
    }

    public String getList() {
        if (this.options.getList() == null) {
            return "";
        }
        return this.options.getList().getAbsolutePath();
    }

    public void setOptions(AlphaVMSCompilationQualifier newOptions) {
        AlphaVMSCompilationQualifier oldOptions = this.options;
        this.options = newOptions;
        this.firePropertyChange(PROP_LIBRARY, oldOptions, this.options);
    }

    public String getCheck() {
        if (this.check == null) {
            return "/nocheck";
        }
        return this.check;
    }

    public synchronized void setCheck(String newCheck) {
        String old = this.check;
        this.check = newCheck;
        this.firePropertyChange(PROP_CHECK, old, this.check);
    }

    public String getOptimize() {
        if (this.optimize == null) {
            return "/optimize";
        }
        return this.optimize;
    }

    public synchronized void setOptimize(String newOptimize) {
        String old = this.optimize;
        this.optimize = newOptimize;
        this.firePropertyChange(PROP_OPTIMIZE, old, this.optimize);
    }

    public String getDebug() {
        return this.debug;
    }

    public synchronized void setDebug(String newDebug) {
        String old = this.debug;
        this.debug = newDebug;
        this.firePropertyChange(PROP_DEBUG, old, this.debug);
    }

    public String getOtherOptions() {
        return this.otherOptions;
    }

    public synchronized void setOtherOptions(String newOtherOptions) {
        String old = this.otherOptions;
        this.otherOptions = newOtherOptions;
        this.firePropertyChange(PROP_OTHER_OPTIONS, old, this.otherOptions);
    }

    public RemoteFSFile getBuildDirectory() {
        return this.buildDirectoryRemote;
    }

    public synchronized void setBuildDirectory(RemoteFSFile newBuildDirectory) {
        if (newBuildDirectory != null && newBuildDirectory.getAbsolutePath().equals("")) {
            newBuildDirectory = null;
        }
        RemoteFSFile old = this.buildDirectoryRemote;
        this.buildDirectoryRemote = newBuildDirectory;
        this.firePropertyChange(PROP_BUILD_DIRECTORY, old, this.buildDirectoryRemote);
    }

    public Boolean getAnsiFormatting() {
        if (this.ansiFormatting == null) {
            return Boolean.FALSE;
        }
        return this.ansiFormatting;
    }

    public synchronized void setAnsiFormatting(Boolean newAnsi) {
        Boolean old = this.ansiFormatting;
        this.ansiFormatting = newAnsi;
        this.firePropertyChange(PROP_ANSIFORMATTING, old, this.ansiFormatting);
    }

    public Boolean getBuildOption() {
        if (this.buildOption == null) {
            return Boolean.FALSE;
        }
        return this.buildOption;
    }

    public void setBuildOption(Boolean newBuildOption) {
        Boolean old = this.buildOption;
        this.buildOption = newBuildOption;
        this.firePropertyChange(PROP_BUILD_OPTION, old, this.buildOption);
    }

    public Boolean getOutputSwitch() {
        if (this.outputSwitch == null) {
            return Boolean.FALSE;
        }
        return this.outputSwitch;
    }

    public void setOutputSwitch(Boolean newOutputSwitch) {
        Boolean oldOutputSwitch = this.outputSwitch;
        this.outputSwitch = newOutputSwitch;
        this.firePropertyChange(PROP_OUTPUT_SWITCH, oldOutputSwitch, newOutputSwitch);
    }

    public NbProcessDescriptor getExternalCompiler() {
        if (this.updated == null) {
            this.externalCompiler = this.createCobolDescriptor();
            this.updated = Boolean.TRUE;
        }
        if (this.externalCompiler != null && this.externalCompiler instanceof NbProcessDescriptor) {
            return this.externalCompiler;
        }
        return this.createCobolDescriptor();
    }

    public void setExternalCompiler(NbProcessDescriptor ext) {
        NbProcessDescriptor oldExt = this.externalCompiler;
        this.externalCompiler = ext;
        this.firePropertyChange(PROP_EXTERNAL_COMPILER, oldExt, this.externalCompiler);
    }

    public String getBuildCommand() {
        if (this.buildCommand == null) {
            return this.createDefaultBuildCommand();
        }
        return this.buildCommand;
    }

    public String createDefaultBuildCommand() {
        return "@{command file} {file}";
    }

    public void setBuildCommand(String newBuildCommand) {
        String oldBuildCommand = this.buildCommand;
        this.buildCommand = newBuildCommand;
        this.firePropertyChange(PROP_BUILD_COMMAND, oldBuildCommand, this.buildCommand);
    }

    public RemoteFSFile getMakefileCompiler() {
        return this.makefileCompilerRemote;
    }

    public void setMakefileCompiler(RemoteFSFile ext) {
        RemoteFSFile oldExt = this.makefileCompilerRemote;
        this.makefileCompilerRemote = ext;
        this.firePropertyChange(PROP_MAKEFILE_COMPILER, oldExt, this.makefileCompilerRemote);
    }

    public String createOldCobolDescriptor() {
        return "{others} ";
    }

    public NbProcessDescriptor createCobolDescriptor() {
        return new NbProcessDescriptor("cobol", "{Global Qualifiers} {ANSI Formatting} {file} {Local Qualifiers}", "");
    }

    public String getGlobalQualifier() {
        if (this.globalQualifier == null) {
            this.globalQualifier = this.createGlobalQualifier();
            return this.globalQualifier;
        }
        return this.globalQualifier;
    }

    private String createGlobalQualifier() {
        MapFormat mapFormat = new MapFormat(new HashMap(2));
        Map map = mapFormat.getMap();
        map.put("others", this.getOptions().getOthers());
        String desc = this.createOldCobolDescriptor();
        return mapFormat.format((Object)desc);
    }

    public String getLocalQualifier() {
        if (this.localQualifier == null) {
            this.localQualifier = "";
            return this.localQualifier;
        }
        return this.localQualifier;
    }

    public void setGlobalQualifier(String val) {
        String oldGlobalQualifier = this.globalQualifier;
        this.globalQualifier = val;
        this.firePropertyChange(PROP_COBOL_GLOBAL_QUALIFIER, oldGlobalQualifier, this.globalQualifier);
    }

    public void setLocalQualifier(String val) {
        String oldLocalQualifier = this.localQualifier;
        this.localQualifier = val;
        this.firePropertyChange(PROP_COBOL_LOCAL_QUALIFIER, oldLocalQualifier, this.localQualifier);
    }

    public void prepareJob(CompilerJob job, Class type, DataObject obj) {
        if (obj instanceof CobolDataObject) {
            super.prepareJob(job, type, obj);
        } else {
            String message = MessageFormat.format(CobolCompilerType.getString("MSG_InvalidCompiler"), this.getName(), obj.getPrimaryFile().toString());
            Throwable t = ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("Invalid compiler"), 256, null, message, null, null);
            BogusCompiler compiler = new BogusCompiler(obj.getPrimaryFile(), t);
            job.add((Compiler)compiler);
        }
    }

    protected Compiler createCompiler(Class type, FileObject fo) {
        return new CobolCompiler(type, fo, this.getExternalCompiler(), this.getErrorExpression(), this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

