/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.netbeans.modules.distributed.DistributedModule;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkJarFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Utilities;

public final class FileUtility {
    public static final int OPENVMS = 0;
    public static final int UNIX_LIKE = 1;
    public static final int WIN = 2;
    public static final String REMOTE_ROOT = "REMOTE_ROOT";
    public static final String LOCAL_ROOT = "LCOAL_ROOT";
    public static final String UNIX_SHARE_FOLDER = "/distributed/get_share_unix";
    public static final String OPENVMS_EFS_SPECIAL_CHARS = "!@#+={}:\"'<>~|/().,;[]%^& ";

    private FileUtility() {
    }

    public static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static boolean isOct(char c) {
        return c >= '0' && c <= '7';
    }

    private static String handleEscape(String fileName) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fileName.length(); ++i) {
            char curChar = fileName.charAt(i);
            if (curChar == '\\') {
                if (i + 5 < fileName.length() && fileName.charAt(i + 1) == 'u' && FileUtility.isHex(fileName.charAt(i + 2)) && FileUtility.isHex(fileName.charAt(i + 3)) && FileUtility.isHex(fileName.charAt(i + 4)) && FileUtility.isHex(fileName.charAt(i + 5))) {
                    sb.append("^U" + fileName.substring(i + 2, i + 6).toUpperCase());
                    i += 5;
                    continue;
                }
                if (i + 3 < fileName.length() && FileUtility.isOct(fileName.charAt(i + 1)) && FileUtility.isOct(fileName.charAt(i + 2)) && FileUtility.isOct(fileName.charAt(i + 3))) {
                    String octNumStr = fileName.substring(i + 1, i + 4);
                    int octNum = Integer.parseInt(octNumStr, 8);
                    String hexNumStr = Integer.toString(octNum, 16);
                    sb.append("^" + hexNumStr);
                    i += 3;
                    continue;
                }
                sb.append(curChar);
                continue;
            }
            if (OPENVMS_EFS_SPECIAL_CHARS.indexOf(curChar) >= 0) {
                sb.append("^" + curChar);
                continue;
            }
            sb.append(curChar);
        }
        return sb.toString();
    }

    private static int handleUnEscape(String vmsPath, int curPos, StringBuffer sb) {
        boolean endOfLine;
        char curChar = vmsPath.charAt(curPos);
        boolean bl = endOfLine = curPos + 1 == vmsPath.length();
        if (FileUtility.isHex(curChar)) {
            char nextChar;
            if (!endOfLine && FileUtility.isHex(nextChar = vmsPath.charAt(curPos + 1))) {
                String hexNumStr = vmsPath.substring(curPos, curPos + 2);
                int hexNum = Integer.parseInt(hexNumStr, 16);
                String octNumStr = Integer.toString(hexNum, 8);
                sb.append("\\");
                for (int i = 0; i < 3 - octNumStr.length(); ++i) {
                    sb.append("0");
                }
                sb.append(octNumStr);
                return 2;
            }
        } else if (curChar == 'U') {
            if (curPos + 4 < vmsPath.length() && FileUtility.isHex(vmsPath.charAt(curPos + 1)) && FileUtility.isHex(vmsPath.charAt(curPos + 2)) && FileUtility.isHex(vmsPath.charAt(curPos + 3)) && FileUtility.isHex(vmsPath.charAt(curPos + 4))) {
                sb.append("\\u" + vmsPath.substring(curPos + 1, curPos + 5).toLowerCase());
                return 5;
            }
        } else {
            if (OPENVMS_EFS_SPECIAL_CHARS.indexOf(curChar) >= 0) {
                sb.append(curChar);
                return 1;
            }
            if (curChar == '_') {
                sb.append(' ');
                return 1;
            }
        }
        if (sb.length() == 0) {
            sb.append("^");
            sb.append(curChar);
        }
        return 1;
    }

    public static String removeVersion(String vmsPath) {
        int fileLength = vmsPath.length();
        int verIndex = -1;
        int dotCount = 0;
        int semiCount = 0;
        StringBuffer verBuffer = new StringBuffer();
        for (int i = fileLength - 1; i >= 0 && vmsPath.charAt(i) != ']' && vmsPath.charAt(i) != '>' && vmsPath.charAt(i) != ':'; --i) {
            if (vmsPath.charAt(i) == '.') {
                if (i - 1 >= 0 && vmsPath.charAt(i - 1) == '^') continue;
                if (dotCount > 0) {
                    ++dotCount;
                    break;
                }
                ++dotCount;
                verIndex = i;
                continue;
            }
            if (vmsPath.charAt(i) != ';' || i - 1 >= 0 && vmsPath.charAt(i - 1) == '^') continue;
            ++semiCount;
            verIndex = i;
            break;
        }
        if (dotCount > 1 || semiCount > 0) {
            String verString = vmsPath.substring(verIndex + 1, vmsPath.length());
            if (verString.length() != 0) {
                try {
                    int verInt = Integer.parseInt(verString);
                    if (verInt >= -99999 && verInt <= 99999) {
                        return vmsPath.substring(0, verIndex);
                    }
                }
                catch (NumberFormatException e) {}
            } else if (verString.length() == 0 && semiCount > 0) {
                return vmsPath.substring(0, verIndex - 1);
            }
        }
        return vmsPath;
    }

    public static String translateFilePath(String src, int fromOS, int toOS, boolean isDir, Object info) {
        if (fromOS == 1) {
            if (toOS == 0) {
                return FileUtility.unixPathToOpenVMSPath(src, isDir);
            }
        } else if (fromOS == 0) {
            if (toOS == 1) {
                return FileUtility.openVMSPathToUnixPath(src, isDir);
            }
        } else if (fromOS == 2 && toOS == 0) {
            return FileUtility.winPathToOpenVMSPath(src, isDir, info);
        }
        return "";
    }

    public static String openVMSPathToWinPath(String vmsPath, boolean isDir, String localDrive, String remoteRoot) {
        int i;
        if (vmsPath.length() == 0) {
            return "";
        }
        if (!localDrive.endsWith("\\")) {
            localDrive = localDrive + "\\";
        }
        if (remoteRoot.endsWith("]")) {
            remoteRoot = remoteRoot.substring(0, remoteRoot.lastIndexOf(93));
        }
        if (!vmsPath.toLowerCase().startsWith(remoteRoot.toLowerCase())) {
            return null;
        }
        if ((vmsPath = vmsPath.substring(remoteRoot.length())).startsWith(".") && vmsPath.indexOf("]") > 0) {
            vmsPath = vmsPath.substring(1);
        }
        StringBuffer winPath = new StringBuffer();
        StringBuffer tokenB = new StringBuffer();
        Vector<String> files = new Vector<String>();
        boolean START = false;
        boolean DEVICE_END = true;
        int DIRECTORY_BEGIN = 2;
        int DIRECTORY_END = 3;
        int state = 0;
        int numFiles = 0;
        boolean deviceExist = false;
        boolean pathAppend = false;
        vmsPath = FileUtility.removeVersion(vmsPath);
        block6: for (i = 0; i < vmsPath.length(); ++i) {
            char curChar = vmsPath.charAt(i);
            boolean endOfLine = vmsPath.length() == i + 1;
            switch (curChar) {
                case '^': {
                    if (!endOfLine) {
                        StringBuffer escaped = new StringBuffer();
                        i += FileUtility.handleUnEscape(vmsPath, i + 1, escaped);
                        tokenB.append(escaped);
                        continue block6;
                    }
                    tokenB.append(curChar);
                    continue block6;
                }
                case '<': 
                case '[': {
                    state = 2;
                    files.addElement(tokenB.toString());
                    tokenB.delete(0, tokenB.length());
                    continue block6;
                }
                case '>': 
                case ']': {
                    state = 3;
                    files.addElement(tokenB.toString());
                    tokenB.delete(0, tokenB.length());
                    continue block6;
                }
                case '.': {
                    if (state == 3 || state == 1 || state == 0) {
                        tokenB.append('.');
                        continue block6;
                    }
                    files.addElement(tokenB.toString());
                    tokenB.delete(0, tokenB.length());
                    continue block6;
                }
                default: {
                    tokenB.append(curChar);
                }
            }
        }
        files.addElement(tokenB.toString());
        numFiles = files.size();
        for (i = 0; i < numFiles; ++i) {
            String file = (String)files.get(i);
            if (file.length() <= 0) continue;
            if (file.indexOf("-") >= 0) {
                int j = 0;
                for (j = 0; j < file.length() && file.charAt(j) == '-'; ++j) {
                }
                if (j == file.length()) {
                    StringBuffer sb = new StringBuffer();
                    for (int k = 0; k < j; ++k) {
                        sb.append("..");
                        if (k >= j - 1) continue;
                        sb.append("\\");
                    }
                    file = sb.toString();
                }
            }
            winPath.append(file + "\\");
            pathAppend = true;
        }
        if (numFiles > 0 && pathAppend) {
            winPath.deleteCharAt(winPath.length() - 1);
        }
        if (!isDir && ((String)files.lastElement()).indexOf(46) == -1) {
            winPath.append('.');
        }
        return localDrive + winPath.toString();
    }

    public static String __unixPathToOpenVMSPath(String unixPath, boolean isDir) {
        FileObject[] fobjs = FileUtil.fromFile((File)new File(unixPath));
        for (int i = 0; i < fobjs.length; ++i) {
            try {
                if (!(fobjs[i].getFileSystem() instanceof NetworkFileSystem) && !(fobjs[i].getFileSystem() instanceof NetworkJarFileSystem)) continue;
                return FileUtility.unixPathToOpenVMSPath(unixPath, isDir, fobjs[i]);
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        Enumeration jarFs = Repository.getDefault().getFileSystems();
        while (jarFs.hasMoreElements()) {
            NetworkJarFileSystem njfs;
            Object obj = jarFs.nextElement();
            if (!(obj instanceof NetworkJarFileSystem) || !unixPath.equals((njfs = (NetworkJarFileSystem)obj).getJarFile().getAbsolutePath())) continue;
            return FileUtility.unixPathToOpenVMSPath(unixPath, false, njfs.getRoot());
        }
        return unixPath;
    }

    public static String __winPathToOpenVMSPath(String winPath, boolean isDir) {
        FileObject[] fobjs = FileUtil.fromFile((File)new File(winPath));
        for (int i = 0; i < fobjs.length; ++i) {
            try {
                if (!(fobjs[i].getFileSystem() instanceof NetworkFileSystem) && !(fobjs[i].getFileSystem() instanceof FTPFileSystem)) continue;
                return FileUtility._winPathToOpenVMSPath(winPath, isDir, fobjs[i]);
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        Enumeration jarFs = Repository.getDefault().getFileSystems();
        while (jarFs.hasMoreElements()) {
            NetworkJarFileSystem njfs;
            Object obj = jarFs.nextElement();
            if (!(obj instanceof NetworkJarFileSystem) || !winPath.equals((njfs = (NetworkJarFileSystem)obj).getJarFile().getAbsolutePath())) continue;
            return FileUtility._winPathToOpenVMSPath(winPath, false, njfs.getRoot());
        }
        return winPath;
    }

    public static String _winPathToOpenVMSPath(String winPath, boolean isDir, FileObject fobj) {
        String vmsPath = winPath;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            if (fobj.getFileSystem() instanceof FTPFileSystem) {
                FTPFileSystem nfs = (FTPFileSystem)fobj.getFileSystem();
                map.put(REMOTE_ROOT, nfs.getRemoteRoot());
                map.put(LOCAL_ROOT, nfs.getCache().getAbsolutePath());
            } else if (fobj.getFileSystem() instanceof NetworkFileSystem) {
                NetworkFileSystem nfs = (NetworkFileSystem)fobj.getFileSystem();
                map.put(REMOTE_ROOT, nfs.getRemoteRoot());
                map.put(LOCAL_ROOT, nfs.getRootDirectory().getAbsolutePath());
            } else {
                NetworkJarFileSystem nfs = (NetworkJarFileSystem)fobj.getFileSystem();
                map.put(REMOTE_ROOT, nfs.getRemoteJarRoot().getRemoteJarRoot());
                map.put(LOCAL_ROOT, nfs.getJarFile().getAbsolutePath());
            }
            vmsPath = FileUtility.winPathToOpenVMSPath(winPath, isDir, map);
        }
        catch (Exception e) {
            // empty catch block
        }
        return vmsPath;
    }

    public static String unixPathToOpenVMSPath(String unixPath, boolean isDir, FileObject fobj) {
        String vmsPath = unixPath;
        try {
            String localRelPath;
            String unixRoot;
            AbstractNetworkFileSystem nfs;
            HashMap map = new HashMap();
            if (fobj.getFileSystem() instanceof NetworkFileSystem) {
                nfs = (NetworkFileSystem)fobj.getFileSystem();
                unixRoot = FileUtility.openVMSPathToUnixPath(((NetworkFileSystem)nfs).getRemoteRoot(), true);
                localRelPath = vmsPath.substring(nfs.getRootDirectory().getAbsolutePath().length());
            } else {
                nfs = (NetworkJarFileSystem)fobj.getFileSystem();
                unixRoot = FileUtility.openVMSPathToUnixPath(((NetworkJarFileSystem)nfs).getRemoteJarRoot().getRemoteJarRoot(), true);
                localRelPath = vmsPath.substring(nfs.getJarFile().getAbsolutePath().length());
            }
            String tmpPath = unixRoot + (localRelPath.indexOf(47) == 0 ? "" : "/") + localRelPath;
            vmsPath = FileUtility.unixPathToOpenVMSPath(tmpPath, isDir);
        }
        catch (Exception e) {
            // empty catch block
        }
        return vmsPath;
    }

    public static String winPathToOpenVMSPath(String winPath, boolean isDir, Object info) {
        if (winPath.length() == 0) {
            return "";
        }
        HashMap tbl = (HashMap)info;
        String rootDir = (String)tbl.get(REMOTE_ROOT);
        String localRootDir = (String)tbl.get(LOCAL_ROOT);
        if (localRootDir.endsWith("\\") && localRootDir.length() > 3) {
            localRootDir = localRootDir.substring(0, localRootDir.length() - 1);
        }
        if ((winPath = winPath.substring(localRootDir.length())).endsWith("\\")) {
            winPath = winPath.substring(0, winPath.length() - 1);
        }
        if (winPath.length() == 0) {
            return rootDir;
        }
        if (!isDir) {
            if (winPath.lastIndexOf(92) == 0) {
                return rootDir + winPath.substring(1);
            }
            if (winPath.indexOf(92) == -1) {
                return rootDir + winPath;
            }
        }
        if (rootDir.endsWith("]")) {
            if ((rootDir = rootDir.substring(0, rootDir.length() - 1)).length() > 1 && rootDir.endsWith(".")) {
                if (rootDir.charAt(rootDir.lastIndexOf(46) - 1) == '^') {
                    rootDir = rootDir + ".";
                }
            } else if (rootDir.length() > 1) {
                rootDir = rootDir + ".";
            }
        } else if (rootDir.endsWith(":")) {
            rootDir = rootDir + "[";
        }
        StringTokenizer stoken = new StringTokenizer(winPath, "\\");
        LinkedList<String> tokenList = new LinkedList<String>();
        StringBuffer dirPath = new StringBuffer();
        String fileName = new String();
        int tokenIndex = 0;
        while (stoken.hasMoreTokens()) {
            String token = stoken.nextToken();
            tokenList.add(token);
        }
        int endTokenIndex = isDir ? tokenList.size() : tokenList.size() - 1;
        for (int i = tokenIndex; i < endTokenIndex; ++i) {
            String curToken = (String)tokenList.get(i);
            if (curToken.equals("..")) {
                dirPath.append("-");
            } else {
                if (curToken.equals(".")) continue;
                dirPath.append(FileUtility.handleEscape(curToken));
            }
            dirPath.append('.');
        }
        if (dirPath.length() > 0) {
            dirPath.deleteCharAt(dirPath.length() - 1);
        }
        if (isDir) {
            dirPath.append(']');
            return rootDir + dirPath;
        }
        fileName = (String)tokenList.get(tokenList.size() - 1);
        if ((fileName = FileUtility.handleEscape(fileName)).indexOf(46) < 0) {
            fileName = fileName + ".";
        } else {
            StringBuffer sb = new StringBuffer(fileName);
            sb.deleteCharAt(fileName.lastIndexOf(94));
            fileName = sb.toString();
        }
        if (dirPath.length() > 0) {
            dirPath.append(']');
        }
        return rootDir + dirPath + fileName;
    }

    public static String openVMSPathToUnixPath(String vmsPath, boolean isDir) {
        int i;
        if (vmsPath.length() == 0) {
            return "";
        }
        StringBuffer unixPath = new StringBuffer();
        StringBuffer tokenB = new StringBuffer();
        Vector<String> files = new Vector<String>();
        boolean START = false;
        boolean DEVICE_END = true;
        int DIRECTORY_BEGIN = 2;
        int DIRECTORY_END = 3;
        int state = 0;
        int numFiles = 0;
        boolean deviceExist = false;
        boolean pathAppend = false;
        vmsPath = FileUtility.removeVersion(vmsPath);
        block7: for (i = 0; i < vmsPath.length(); ++i) {
            char curChar = vmsPath.charAt(i);
            boolean endOfLine = vmsPath.length() == i + 1;
            switch (curChar) {
                case '^': {
                    if (!endOfLine) {
                        StringBuffer escaped = new StringBuffer();
                        i += FileUtility.handleUnEscape(vmsPath, i + 1, escaped);
                        tokenB.append(escaped);
                        continue block7;
                    }
                    tokenB.append(curChar);
                    continue block7;
                }
                case ':': {
                    state = 1;
                    deviceExist = true;
                    files.addElement(tokenB.toString());
                    tokenB.delete(0, tokenB.length());
                    continue block7;
                }
                case '<': 
                case '[': {
                    state = 2;
                    files.addElement(tokenB.toString());
                    tokenB.delete(0, tokenB.length());
                    continue block7;
                }
                case '>': 
                case ']': {
                    state = 3;
                    files.addElement(tokenB.toString());
                    tokenB.delete(0, tokenB.length());
                    continue block7;
                }
                case '.': {
                    if (state == 3 || state == 1 || state == 0) {
                        tokenB.append('.');
                        continue block7;
                    }
                    files.addElement(tokenB.toString());
                    tokenB.delete(0, tokenB.length());
                    continue block7;
                }
                default: {
                    tokenB.append(curChar);
                }
            }
        }
        files.addElement(tokenB.toString());
        numFiles = files.size();
        for (i = 0; i < numFiles; ++i) {
            String file = (String)files.get(i);
            if (file.length() <= 0) continue;
            if (file.indexOf("-") >= 0) {
                int j = 0;
                for (j = 0; j < file.length() && file.charAt(j) == '-'; ++j) {
                }
                if (j == file.length()) {
                    StringBuffer sb = new StringBuffer();
                    for (int k = 0; k < j; ++k) {
                        sb.append("..");
                        if (k >= j - 1) continue;
                        sb.append("/");
                    }
                    file = sb.toString();
                }
            }
            unixPath.append(file + "/");
            pathAppend = true;
        }
        if (numFiles > 0 && pathAppend) {
            unixPath.deleteCharAt(unixPath.length() - 1);
        }
        if (deviceExist) {
            unixPath.insert(0, "/");
        } else if (state == 3) {
            unixPath.insert(0, "./");
        }
        if (!isDir && ((String)files.lastElement()).indexOf(46) == -1) {
            unixPath.append('.');
        }
        return unixPath.toString();
    }

    public static String unixPathToOpenVMSPath(String unixPath, boolean isDir) {
        if (unixPath.length() == 0) {
            return "";
        }
        StringTokenizer stoken = new StringTokenizer(unixPath, "/");
        LinkedList<String> tokenList = new LinkedList<String>();
        StringBuffer dirPath = new StringBuffer();
        String deviceName = new String();
        String fileName = new String();
        int tokenIndex = 0;
        boolean rootExist = false;
        boolean relativePath = false;
        while (stoken.hasMoreTokens()) {
            String token = stoken.nextToken();
            tokenList.add(token);
        }
        if (unixPath.charAt(0) == '/') {
            rootExist = true;
        }
        if (tokenList.isEmpty()) {
            return "sys$login:";
        }
        if (tokenList.size() == 1 && rootExist) {
            if (isDir) {
                return FileUtility.handleEscape((String)tokenList.get(tokenIndex++)) + ":";
            }
            deviceName = "sys$login:";
        } else if (rootExist) {
            deviceName = FileUtility.handleEscape((String)tokenList.get(tokenIndex++)) + ":";
        }
        int endTokenIndex = isDir ? tokenList.size() : tokenList.size() - 1;
        for (int i = tokenIndex; i < endTokenIndex; ++i) {
            String curToken = (String)tokenList.get(i);
            if (curToken.equals("..")) {
                dirPath.append("-");
            } else {
                if (curToken.equals(".")) {
                    if (i != tokenIndex || rootExist) continue;
                    relativePath = true;
                    continue;
                }
                dirPath.append(FileUtility.handleEscape(curToken));
            }
            dirPath.append('.');
        }
        if (dirPath.length() > 0) {
            dirPath.deleteCharAt(dirPath.length() - 1);
        }
        if (isDir) {
            dirPath.insert(0, '[');
            if (deviceName.length() == 0 && dirPath.length() > 1) {
                dirPath.insert(1, '.');
            }
            dirPath.append(']');
            return deviceName + dirPath;
        }
        fileName = (String)tokenList.get(tokenList.size() - 1);
        if ((fileName = FileUtility.handleEscape(fileName)).indexOf(46) < 0) {
            fileName = fileName + ".";
        } else {
            StringBuffer sb = new StringBuffer(fileName);
            sb.deleteCharAt(fileName.lastIndexOf(94));
            fileName = sb.toString();
        }
        if (dirPath.length() > 0) {
            dirPath.insert(0, '[');
            if (relativePath) {
                dirPath.insert(1, '.');
            }
            dirPath.append(']');
        } else if (relativePath) {
            dirPath.append("[]");
        }
        return deviceName + dirPath + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String winGetShare(String localDirectory) {
        shareName = "";
        br = null;
        try {
            try {
                proc = Runtime.getRuntime().exec("cmd /c net use " + localDirectory.substring(0, 2) + " | findstr /i Remote");
                br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while ((line = br.readLine()) != null) {
                    if (line.lastIndexOf(92) <= 0) continue;
                    shareName = line.substring(line.lastIndexOf(92) + 1).trim();
                    break;
                }
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 2));
                    }
                });
                var6_7 = null;
                try {
                    if (br == null) return shareName;
                    br.close();
                    return shareName;
                }
                catch (IOException e) {
                    return shareName;
                }
            }
            var6_6 = null;
        }
        catch (Throwable var5_12) {
            var6_8 = null;
            ** try [egrp 2[TRYBLOCK] [4 : 135->146)] { 
lbl29:
            // 1 sources

            if (br == null) throw var5_12;
            br.close();
            throw var5_12;
lbl32:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            throw var5_12;
        }
        try {}
        catch (IOException e) {}
        if (br == null) return shareName;
        br.close();
        return shareName;
        return shareName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String unixGetShare(String localDirectory) {
        String shareName;
        block13: {
            BufferedReader br;
            block12: {
                shareName = "";
                br = null;
                String rootdir = System.getProperty("netbeans.user");
                if (!new File(rootdir + UNIX_SHARE_FOLDER).exists()) {
                    rootdir = System.getProperty("netbeans.home");
                }
                System.err.println("Fileutil:getShare:executing" + rootdir + "/distributed/get_share_unix  " + localDirectory);
                Process proc = Runtime.getRuntime().exec(new String[]{"sh", rootdir + UNIX_SHARE_FOLDER, localDirectory});
                br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                int status = proc.waitFor();
                System.err.println("Fileutil:getShare:status:" + status);
                String line = br.readLine();
                if (line == null) break block12;
                System.err.println("Fileutil:getShare:output:" + line);
                shareName = line.substring(line.lastIndexOf(47) + 1, line.length());
                shareName = shareName + "\n" + br.readLine();
                System.err.println("Fileutil:getShare:finished shareName:" + shareName);
            }
            Object var8_8 = null;
            try {
                if (br != null) {
                    br.close();
                }
                break block13;
            }
            catch (IOException e2) {}
            break block13;
            {
                catch (Exception e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 2));
                        }
                    });
                    Object var8_9 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block13;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return shareName;
    }

    public static String getShareName(String localDirectory) {
        if (Utilities.isWindows()) {
            return FileUtility.winGetShare(localDirectory);
        }
        return FileUtility.unixGetShare(localDirectory);
    }

    public static String getRemoteDirectoryShare(RemoteRuntimeType rrt, String localDirectory) {
        block6: {
            String shareInfo = FileUtility.getShareName(localDirectory);
            String shareName = "";
            String localRoot = "";
            if (shareInfo.length() > 0) {
                if (Utilities.isWindows()) {
                    shareName = shareInfo;
                } else {
                    shareName = shareInfo.substring(0, shareInfo.indexOf(10));
                    localRoot = shareInfo.substring(shareInfo.indexOf(10) + 1, shareInfo.length());
                }
                try {
                    String remoteRootTmp = rrt.getNetworkShareRoot(shareName);
                    if (remoteRootTmp != null) {
                        return FileUtility.createRemoteDirectory(remoteRootTmp, localDirectory, localRoot);
                    }
                }
                catch (Exception e) {
                    if (DistributedModule.err == null) break block6;
                    DistributedModule.err.log(e.getMessage());
                }
            }
        }
        return "";
    }

    private static String createRemoteDirectory(String remoteRootTmp, String localDirectory, String localRoot) {
        StringBuffer localDir = new StringBuffer(localDirectory);
        StringBuffer remoteDir = new StringBuffer(remoteRootTmp);
        String relRemoteDir = null;
        if (Utilities.isWindows()) {
            if (localDirectory.length() == 3) {
                return remoteRootTmp;
            }
            if (localDirectory.endsWith("\\")) {
                localDir.deleteCharAt(localDirectory.length() - 1);
            }
            localDir.delete(0, 2);
            relRemoteDir = localDir.toString().replace('\\', '.');
        } else {
            if (localDirectory.length() == localRoot.length()) {
                return remoteRootTmp;
            }
            if (localDirectory.endsWith("/")) {
                localDir.deleteCharAt(localDirectory.length() - 1);
            }
            localDir.delete(0, localRoot.length());
            relRemoteDir = localDir.toString().replace('/', '.');
        }
        if (remoteRootTmp.endsWith("]")) {
            remoteDir.deleteCharAt(remoteRootTmp.length() - 1);
        } else {
            remoteDir.append('[');
        }
        remoteDir.append(relRemoteDir);
        remoteDir.append("]");
        return remoteDir.toString();
    }

    public static String getRemoteJarShare(RemoteRuntimeType rrt, String localJarFile) {
        block6: {
            String shareInfo = FileUtility.getShareName(localJarFile);
            String shareName = "";
            String localRoot = "";
            if (shareInfo.length() > 0) {
                if (Utilities.isWindows()) {
                    shareName = shareInfo;
                } else {
                    shareName = shareInfo.substring(0, shareInfo.indexOf(10));
                    localRoot = shareInfo.substring(shareInfo.indexOf(10) + 1, shareInfo.length());
                }
                try {
                    String remoteRootTmp = rrt.getNetworkShareRoot(shareName);
                    if (remoteRootTmp != null) {
                        return FileUtility.createRemoteJarFile(remoteRootTmp, localJarFile, localRoot);
                    }
                }
                catch (Exception e) {
                    if (DistributedModule.err == null) break block6;
                    DistributedModule.err.notify(1, (Throwable)e);
                }
            }
        }
        return "";
    }

    private static String createRemoteJarFile(String remoteRootTmp, String localJarFile, String localRoot) {
        StringBuffer localDir = new StringBuffer(localJarFile);
        StringBuffer remoteDir = new StringBuffer(remoteRootTmp);
        String jarFileName = null;
        String relRemoteDir = null;
        if (Utilities.isWindows()) {
            jarFileName = localJarFile.substring(localJarFile.lastIndexOf(92) + 1);
            localDir.delete(localJarFile.lastIndexOf(92), localJarFile.length());
            localDir.delete(0, 2);
            relRemoteDir = localDir.toString().replace('\\', '.');
        } else {
            jarFileName = localJarFile.substring(localJarFile.lastIndexOf(47) + 1);
            localDir.delete(localJarFile.lastIndexOf(47), localJarFile.length());
            if (localRoot.length() > 0) {
                localDir.delete(0, localRoot.length());
            }
            relRemoteDir = localDir.toString().replace('/', '.');
        }
        if (remoteRootTmp.endsWith("]")) {
            remoteDir.deleteCharAt(remoteRootTmp.length() - 1);
        } else {
            remoteDir.append('[');
        }
        remoteDir.append(relRemoteDir);
        remoteDir.append("]");
        remoteDir.append(jarFileName);
        return remoteDir.toString();
    }

    private static String getClientPath(String fileName, String remoteRootName, AbstractNetworkFileSystem nfs) {
        RemoteRuntimeType rrt = nfs.getRemoteRuntimeType();
        if (Utils.getServerOS(rrt).equals(Utils.OS_VMS)) {
            if (Utilities.isWindows()) {
                return FileUtility.openVMSPathToWinPath(fileName, false, nfs.getLocalRoot(), remoteRootName);
            }
            if (Utilities.isUnix()) {
                return FileUtility.openVMSPathToUnixPath(fileName, false);
            }
            if (Utilities.getOperatingSystem() == 8192) {
                return FileUtility.openVMSPathToUnixPath(fileName, false);
            }
        }
        return fileName;
    }

    public static void refreshParent(String fileName, String root, char sep, FileSystem fs) {
        String parent = fileName.substring(root.length() + 1);
        parent = parent.lastIndexOf(sep) > 0 ? parent.substring(0, parent.lastIndexOf(sep)).replace(sep, '/') : "";
        FileObject pfo = fs.findResource(parent);
        if (pfo != null) {
            pfo.refresh();
        }
    }

    private static String getSearchRoot(String remoteRootName, AbstractNetworkFileSystem nfs) {
        RemoteRuntimeType rrt = nfs.getRemoteRuntimeType();
        String searchRootName = remoteRootName;
        if (Utils.getServerOS(rrt).equals(Utils.OS_VMS)) {
            searchRootName = remoteRootName.endsWith(":") ? remoteRootName : remoteRootName.substring(0, remoteRootName.length() - 1);
        }
        return searchRootName;
    }

    public static File toFile(FileObject fo) {
        return (File)fo.getAttribute("java.io.File");
    }

    public static FileObject[] fromFile(String fileName) {
        Enumeration en = Repository.getDefault().getFileSystems();
        ArrayList<FileObject> list = new ArrayList<FileObject>();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            if (!(fs instanceof NetworkFileSystem) && !(fs instanceof FTPFileSystem)) continue;
            try {
                File file2Fo;
                FileObject fo;
                String res;
                AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)fs;
                File root = FileUtility.toFile(fs.getRoot());
                if (root == null) continue;
                String rootName = root.getCanonicalPath();
                String remoteRootName = nfs.getRemoteRoot();
                String searchRootName = FileUtility.getSearchRoot(remoteRootName, nfs);
                if (fileName.toLowerCase().indexOf(searchRootName.toLowerCase()) == 0 && (fileName.charAt(remoteRootName.length() - 1) == '.' || fileName.charAt(remoteRootName.length() - 1) == ']')) {
                    fileName = FileUtility.getClientPath(fileName, remoteRootName, nfs);
                    res = fileName.substring(rootName.length()).replace(File.separatorChar, '/');
                    FileUtility.refreshParent(fileName, rootName, File.separatorChar, fs);
                    fo = fs.findResource(res);
                    File file = file2Fo = fo != null ? FileUtility.toFile(fo) : null;
                    if (fo == null || file2Fo == null) continue;
                    list.add(fo);
                    continue;
                }
                if (!Utils.getServerOS(nfs.getRemoteRuntimeType()).equals(Utils.OS_VMS)) continue;
                remoteRootName = FileUtility.openVMSPathToUnixPath(remoteRootName, true);
                if (fileName.toLowerCase().indexOf(remoteRootName.toLowerCase()) != 0 || fileName.charAt(remoteRootName.length()) != '/') continue;
                res = fileName.substring(remoteRootName.length() + 1);
                FileUtility.refreshParent(fileName, remoteRootName, '/', fs);
                fo = fs.findResource(res);
                File file = file2Fo = fo != null ? FileUtility.toFile(fo) : null;
                if (fo == null || file2Fo == null) continue;
                list.add(fo);
            }
            catch (IOException iexc) {}
        }
        FileObject[] results = new FileObject[list.size()];
        list.toArray(results);
        return results;
    }

    public static void fixCRLF(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file.getAbsolutePath()));
        File fout = File.createTempFile("nb36", "distnb");
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(fout)));
        char[] buf = new char[2];
        int c = br.read();
        int prev = -1;
        StringBuffer sb = new StringBuffer();
        while (c > 0 && c != 10) {
            prev = c;
            sb.append((char)c);
            c = br.read();
        }
        if (c > 0 && prev == 13 && c == 10) {
            br.close();
            pw.close();
            fout.delete();
            return;
        }
        if (c < 0) {
            return;
        }
        String line = sb.toString();
        while (line != null) {
            pw.print(line + "\r\n");
            line = br.readLine();
        }
        br.close();
        pw.close();
        file.delete();
        fout.renameTo(file);
    }

    public static void main(String[] args) {
        String winPath = "i:\\";
        String rootDir = "EFS$:[ISAO]";
        String vmsPath = "EFS$:[ISAO.distnb.exeshared.vmsauth]netbeans$vms_auth_sysuaf.C;3";
        String localDrive = "i:\\";
        System.out.println(FileUtility.winPathToOpenVMSPath(winPath, false, rootDir));
        System.out.println(FileUtility.openVMSPathToWinPath(vmsPath, false, localDrive, rootDir));
    }
}

