/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.distributed.DistributedModule;
import org.netbeans.modules.distributed.property.RemoteJarRootProperty;
import org.netbeans.modules.distributed.property.RemoteRootProperty;
import org.netbeans.modules.distributed.remotefs.ExLocalFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkJarFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpclient.FTPClient;
import org.netbeans.modules.distributed.remotefs.ftpclient.FTPFileName;
import org.netbeans.modules.distributed.remotefs.ftpclient.FTPLogInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPJarFileSystem;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteFSChooserPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteFTPJarSelectPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteFTPSelectPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteJarRootPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRootPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRuntimePanel;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.util.FileUtility;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class RemoteFSIterator
implements TemplateWizard.Iterator {
    public static final String LOCAL_DIRECTORY = "local_directory";
    public static final String REMOTE_DIRECTORY = "remote_directory";
    public static final String REMOTE_RUNTIME = "remote_runtime";
    public static final String FTP_FS = "ftp_filesystem";
    public static final String HIDE = "hide";
    public static final String SELECTED_FS = "SELECTED_FS";
    public static final String AUTO_SYNC = "AUTO_SYNC";
    public static final String READ_ONLY = "READ_ONLY";
    public static final String IS_PASSIVE = "IS_PASSIVE";
    public static final String SSH_FORWARD = "SSH_FORWARD";
    public static final String FTP_PORT = "FTP_PORT";
    private DataObject template = null;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;

    protected WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new RemoteRuntimePanel(), new RemoteFSChooserPanel(), new RemoteRootPanel(), new RemoteJarRootPanel(), new RemoteFTPSelectPanel(), new RemoteFTPJarSelectPanel()};
    }

    public static synchronized RemoteFSIterator createRemoteFS() {
        return new RemoteFSIterator();
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage((Class)RemoteFSIterator.class, (String)"LBL_step_1"), NbBundle.getMessage((Class)RemoteFSIterator.class, (String)"LBL_step_2"), NbBundle.getMessage((Class)RemoteFSIterator.class, (String)"LBL_step_3")};
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        return this.instantiate((WizardDescriptor)wiz);
    }

    private void preSyncJarFile(String localFile, String remoteFile) throws IOException {
        int port = 21;
        try {
            port = (Integer)this.wiz.getProperty(FTP_PORT);
        }
        catch (NumberFormatException e) {
            throw new IOException(e.getMessage());
        }
        boolean sshForward = ((Boolean)this.wiz.getProperty(SSH_FORWARD)).equals(Boolean.TRUE);
        boolean isPassive = ((Boolean)this.wiz.getProperty(IS_PASSIVE)).equals(Boolean.TRUE);
        RemoteRuntimeType rt = (RemoteRuntimeType)this.wiz.getProperty(REMOTE_RUNTIME);
        FTPLogInfo loginfo = new FTPLogInfo(rt.getHostName(), port, rt.getUserName(), rt.getPassword());
        FTPClient fc = new FTPClient(loginfo, null, null);
        try {
            fc.setPassiveMode(isPassive);
            fc.setSSHForward(sshForward);
            fc.connect();
            String dir = remoteFile.substring(0, remoteFile.lastIndexOf("]") + 1);
            String fname = remoteFile.substring(remoteFile.lastIndexOf("]") + 1, remoteFile.length());
            dir = FileUtility.openVMSPathToUnixPath(dir, true);
            fname = FileUtility.openVMSPathToUnixPath(fname, false);
            FTPFileName ftpName = new FTPFileName(dir, fname);
            fc.get(ftpName, new File(localFile + File.separatorChar + fname), false);
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Set instantiate(WizardDescriptor wiz) throws IOException {
        if (wiz.getProperty(SELECTED_FS).equals("FTP_JAR")) {
            String rfile = (String)wiz.getProperty(REMOTE_DIRECTORY);
            String rfilefile = rfile.substring(rfile.lastIndexOf(93) + 1);
            String lfile = (String)wiz.getProperty(LOCAL_DIRECTORY);
            this.preSyncJarFile(lfile, rfile);
            FTPJarFileSystem fs = new FTPJarFileSystem((RemoteRuntimeType)wiz.getProperty(REMOTE_RUNTIME));
            fs.setRemoteJarRoot(new RemoteJarRootProperty(fs, rfile, lfile + File.separatorChar + rfilefile));
            try {
                fs.setJarFile(new File(lfile + File.separatorChar + rfilefile));
                Repository.getDefault().addFileSystem((FileSystem)fs);
            }
            catch (PropertyVetoException e) {
                DistributedModule.err.notify((Throwable)e);
            }
            catch (IOException e) {
                DistributedModule.err.notify((Throwable)e);
                throw e;
            }
        } else if (wiz.getProperty(SELECTED_FS).equals("NETWORK_SHARE_JAR")) {
            NetworkJarFileSystem fs = new NetworkJarFileSystem((RemoteRuntimeType)wiz.getProperty(REMOTE_RUNTIME));
            fs.setRemoteJarRoot(new RemoteJarRootProperty(fs, (String)wiz.getProperty(REMOTE_DIRECTORY), (String)wiz.getProperty(LOCAL_DIRECTORY)));
            try {
                fs.setJarFile(new File((String)wiz.getProperty(LOCAL_DIRECTORY)));
                Repository.getDefault().addFileSystem((FileSystem)fs);
            }
            catch (PropertyVetoException e) {
                DistributedModule.err.notify((Throwable)e);
            }
            catch (IOException e) {
                DistributedModule.err.notify((Throwable)e);
                throw e;
            }
        } else {
            if (wiz.getProperty(SELECTED_FS).equals("FTP")) {
                int port = 21;
                try {
                    port = (Integer)wiz.getProperty(FTP_PORT);
                }
                catch (NumberFormatException e) {
                    DistributedModule.err.notify((Throwable)e);
                }
                try {
                    FTPFileSystem fs = new FTPFileSystem((RemoteRuntimeType)wiz.getProperty(REMOTE_RUNTIME), port, (String)wiz.getProperty(LOCAL_DIRECTORY), (String)wiz.getProperty(REMOTE_DIRECTORY), ((Boolean)wiz.getProperty(SSH_FORWARD)).equals(Boolean.TRUE), ((Boolean)wiz.getProperty(IS_PASSIVE)).equals(Boolean.TRUE));
                    fs.setReadOnly(((Boolean)wiz.getProperty(READ_ONLY)).equals(Boolean.TRUE));
                    fs.setAutoSync(((Boolean)wiz.getProperty(AUTO_SYNC)).equals(Boolean.TRUE));
                    Repository.getDefault().addFileSystem((FileSystem)fs);
                }
                catch (IOException e) {
                    DistributedModule.err.notify((Throwable)e);
                    throw e;
                }
            }
            if (wiz.getProperty(SELECTED_FS).equals("NETWORK_SHARE")) {
                Object fs;
                Enumeration fse = Repository.getDefault().getFileSystems();
                while (fse.hasMoreElements()) {
                    String lroot;
                    fs = (FileSystem)fse.nextElement();
                    if (!(fs instanceof NetworkFileSystem) || !(lroot = ((LocalFileSystem)fs).getRootDirectory().getAbsolutePath()).equalsIgnoreCase((String)wiz.getProperty(LOCAL_DIRECTORY))) continue;
                    fs.setHidden(false);
                    ((NetworkFileSystem)fs).incRefCount();
                    return Collections.EMPTY_SET;
                }
                fs = new NetworkFileSystem((RemoteRuntimeType)wiz.getProperty(REMOTE_RUNTIME));
                ((NetworkFileSystem)fs).setRemoteRoot(new RemoteRootProperty((NetworkFileSystem)fs, (String)wiz.getProperty(REMOTE_DIRECTORY), (String)wiz.getProperty(LOCAL_DIRECTORY), false));
                try {
                    int state = NetworkFileSystem.checkIfFSStreamLF((String)wiz.getProperty(LOCAL_DIRECTORY), (String)wiz.getProperty(REMOTE_DIRECTORY), (RemoteRuntimeType)wiz.getProperty(REMOTE_RUNTIME));
                    Object[] arguments = new Object[]{(String)wiz.getProperty(LOCAL_DIRECTORY)};
                    if (state != 1) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(state == 0 ? "The selected SMB share {0} is not configured to have a default RMS file format of STREAM_LF.\n\nDistributed NetBeans requires that writeable SMB shares used for remote filesystems\nhave STREAM_LF as the default RMS record format.\n\nThe remote filesystem is being mounted as read-only.\n\nIn order to mount this remote filesystem as writeable, you must\n    - modify the SMB share on your OpenVMS server to have STREAM_LF as the default format,\n    - then unmount and re-mount the remote filesystem in Distributed NetBeans.\n\nPlese see the user documentation for your SMB server for more details on setting the\ndefault record format for files." : "The selected SMB share {0} is not writable.\n\nThe remote filesystem is being mounted as a read-only filesystem.", arguments), 2));
                        fs.setReadOnly(true);
                    }
                    ((ExLocalFileSystem)fs).setRootDirectory(new File((String)wiz.getProperty(LOCAL_DIRECTORY)));
                    Repository.getDefault().addFileSystem((FileSystem)fs);
                }
                catch (PropertyVetoException e) {
                    DistributedModule.err.notify((Throwable)e);
                }
                catch (IOException e) {
                    DistributedModule.err.notify((Throwable)e);
                    throw e;
                }
            }
        }
        return Collections.EMPTY_SET;
    }

    private Class instanceClass() {
        try {
            InstanceCookie ic = this.getInstanceCookie();
            return ic.instanceClass();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
        catch (ClassNotFoundException cnfe) {
            ErrorManager.getDefault().notify((Throwable)cnfe);
        }
        throw new IllegalStateException("Cannot determine instance class");
    }

    private InstanceCookie getInstanceCookie() {
        if (this.template == null) {
            throw new NullPointerException("template is null");
        }
        return (InstanceCookie)this.template.getCookie(InstanceCookie.class);
    }

    public Set instantiated(TemplateWizard wiz) throws IOException {
        String name = wiz.getTargetName();
        DataFolder targetFolder = wiz.getTargetFolder();
        DataObject template = wiz.getTemplate();
        DataObject result = name == null ? template.createFromTemplate(targetFolder) : template.createFromTemplate(targetFolder, name);
        OpenCookie open = (OpenCookie)result.getCookie(OpenCookie.class);
        if (open != null) {
            open.open();
        }
        return Collections.singleton(result);
    }

    public void initialize(TemplateWizard wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.template = wiz.getTemplate();
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage((Class)RemoteFSIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public boolean hasNext() {
        switch (this.index) {
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
        }
        return true;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.index = this.index == 1 ? (((RemoteFSChooserPanel)this.panels[this.index]).getSelectedFS().equals("NETWORK_SHARE") ? ++this.index : (((RemoteFSChooserPanel)this.panels[this.index]).getSelectedFS().equals("FTP") ? (this.index += 3) : (((RemoteFSChooserPanel)this.panels[this.index]).getSelectedFS().equals("FTP_JAR") ? (this.index += 4) : (this.index += 2)))) : ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        switch (this.index) {
            case 1: {
                --this.index;
                break;
            }
            case 2: {
                --this.index;
                break;
            }
            case 3: {
                this.index -= 2;
                break;
            }
            case 4: {
                this.index -= 3;
                break;
            }
            case 5: {
                this.index -= 4;
            }
        }
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

