/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpclient;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.netbeans.modules.distributed.remotefs.core.RemoteFileAttributes;
import org.netbeans.modules.distributed.remotefs.ftpclient.FTPClient;
import org.netbeans.modules.distributed.remotefs.ftpclient.FTPFileName;
import org.netbeans.modules.distributed.util.FileUtility;

public class FTPFile
extends File {
    private boolean canRead;
    private boolean canWrite;
    private boolean isDir;
    private boolean isHidden;
    private boolean isExist;
    private String absName;
    private String name;
    private String parent;
    private long lastModified;
    private long size;
    private FTPClient ftpClient;

    public FTPFile(boolean canRead, boolean canWrite, boolean isDir, boolean isHidden, String absName, String name, String parent, long lastModified, long size, FTPClient ftpClient) {
        super(absName);
        this.ftpClient = ftpClient;
        this.canWrite = canWrite;
        this.canRead = canRead;
        this.isDir = isDir;
        this.isHidden = isHidden;
        this.absName = absName;
        this.name = name;
        this.lastModified = lastModified;
        this.size = size;
        this.parent = parent;
        this.isExist = true;
    }

    public FTPFile(String parent, String name, FTPClient ftpClient) {
        super(parent, name);
        this.ftpClient = ftpClient;
        this.parent = parent;
        this.name = name;
        RemoteFileAttributes rf = null;
        parent = FileUtility.openVMSPathToUnixPath(parent, true);
        name = FileUtility.openVMSPathToUnixPath(name, true);
        try {
            if (name.indexOf(parent) == 0 && name.length() > parent.length() && (name = name.substring(parent.length(), name.length())).startsWith("/")) {
                name = name.substring(1, name.length());
            }
            FTPFileName prf = new FTPFileName(parent, "", true);
            FTPFileName crf = new FTPFileName(parent, name);
            rf = ftpClient.listFile(prf.getFullName(), crf);
        }
        catch (IOException e) {
            return;
        }
        if (rf != null && rf.getName() != null) {
            this.canWrite = true;
            this.canRead = true;
            this.isDir = rf.isDirectory();
            this.isHidden = false;
            this.absName = rf.getName().getFullName();
            this.lastModified = rf.getDate().getTime();
            this.size = rf.getSize();
            this.isExist = true;
        } else {
            this.absName = parent + "/" + name;
            this.isDir = true;
        }
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public int compareTo(File pathname) {
        return this.absName.compareTo(pathname.getAbsolutePath());
    }

    public int compareTo(Object o) {
        return this.absName.compareTo(o.toString());
    }

    public boolean createNewFile() {
        return false;
    }

    public static File createTempFile(String prefix, String suffix) {
        return null;
    }

    public static File createTempFile(String prefix, String suffix, File directory) {
        return null;
    }

    public boolean delete() {
        FTPFileName ftpFile = new FTPFileName(this.parent, this.name, this.isDirectory());
        try {
            this.ftpClient.delete(ftpFile);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void deleteOnExit() {
    }

    public boolean equals(Object o) {
        if (this.toString() == null || o == null || o.toString() == null) {
            return false;
        }
        return this.compareTo(o) == 0;
    }

    public boolean exists() {
        return this.isExist;
    }

    public File getAbsoluteFile() {
        return this;
    }

    public String getAbsolutePath() {
        if (this.absName == null) {
            return this.parent;
        }
        return this.absName;
    }

    public File getCanonicalFile() {
        return this.getAbsoluteFile();
    }

    public String getCanonicalPath() {
        return this.getAbsolutePath();
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public File getParentFile() {
        if (this.parent.equalsIgnoreCase(this.ftpClient.getRoot().getFullName())) {
            return new FTPFile(true, true, true, false, this.parent, this.parent, "", 0L, 0L, this.ftpClient);
        }
        if (this.parent != null && this.parent.length() > 0) {
            String pName = this.parent.substring(this.parent.lastIndexOf(47) + 1, this.parent.length());
            String pParent = this.parent.substring(0, this.parent.lastIndexOf(47));
            if (pParent.equals("")) {
                return new FTPFile(true, true, true, false, this.parent, this.parent, "", 0L, 0L, this.ftpClient);
            }
            return new FTPFile(pParent, pName, this.ftpClient);
        }
        return null;
    }

    public String getPath() {
        return FileUtility.unixPathToOpenVMSPath(this.getAbsolutePath(), this.isDirectory());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isAbsolute() {
        return false;
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public long length() {
        return this.size;
    }

    public String[] list() {
        RemoteFileAttributes[] remoteFiles = null;
        try {
            remoteFiles = this.ftpClient.list(new FTPFileName(this.parent, this.name, this.isDirectory()));
        }
        catch (IOException e) {
            // empty catch block
        }
        String[] files = new String[remoteFiles == null ? 0 : remoteFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = remoteFiles[i].getName().getFullName();
        }
        return files;
    }

    public String[] list(FilenameFilter filter) {
        return null;
    }

    public File[] listFiles() {
        RemoteFileAttributes[] remoteFiles = null;
        try {
            remoteFiles = this.ftpClient.list(new FTPFileName(this.parent, this.name, this.isDirectory()));
        }
        catch (IOException e) {
            // empty catch block
        }
        File[] files = new FTPFile[remoteFiles == null ? 0 : remoteFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new FTPFile(true, true, remoteFiles[i].isDirectory(), false, remoteFiles[i].getName().getFullName(), remoteFiles[i].getName().getName(), this.absName, remoteFiles[i].getDate().getTime(), remoteFiles[i].getSize(), this.ftpClient);
        }
        return files;
    }

    public File[] listFiles(FilenameFilter filter) {
        return null;
    }

    public static File[] listRoots() {
        return null;
    }

    public boolean mkdir() {
        try {
            this.ftpClient.mkdir(new FTPFileName(this.parent, this.name, this.isDirectory()));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean mkdirs() {
        try {
            this.ftpClient.mkdir(new FTPFileName(this.parent, this.name, this.isDirectory()));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean renameTo(File dest) {
        try {
            if (this.isDirectory()) {
                this.ftpClient.rmdir(new FTPFileName(this.parent, this.name, this.isDirectory()));
                this.ftpClient.mkdir(new FTPFileName(this.parent, dest.getName(), this.isDirectory()));
            } else {
                this.ftpClient.rename(new FTPFileName(this.parent, this.name, this.isDirectory()), dest.getName());
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean setLastModified(long time) {
        return false;
    }

    public boolean setReadOnly() {
        return false;
    }

    public String toString() {
        return this.absName;
    }

    public URI toURI() {
        return null;
    }

    public URL toURL() {
        return null;
    }

    public FTPClient getFTPClient() {
        return this.ftpClient;
    }
}

