/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.distributed.DistributedModule;
import org.netbeans.modules.distributed.remotefs.core.RemoteFile;
import org.netbeans.modules.distributed.remotefs.core.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.core.Sync;
import org.netbeans.modules.distributed.util.FileUtility;
import org.netbeans.modules.distributed.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class SyncTablePanel
extends JDialog {
    private JTable jTable1;
    private JScrollPane scrollPane;
    private JButton jButton1;
    private JButton jButton2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private MyJPopupMenu popupMenu;
    private String password;
    private static SyncTablePanel syncTable;
    private static Object[] longValues;
    private static int preferedTableWidth;
    private static final Object synchronizedObject;

    public SyncTablePanel() {
        this.myInitComponents();
    }

    public SyncTableModel getTableModel() {
        return (SyncTableModel)this.jTable1.getModel();
    }

    public JTable getTable() {
        return this.jTable1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void update(RemoteFile rf) {
        SyncTableModel sm = syncTable.getTableModel();
        Object object = synchronizedObject;
        synchronized (object) {
            ArrayList list = sm.getFiles();
            Map map = sm.getMap();
            Object[] objs = (Object[])map.get(rf) != null ? (Object[])map.get(rf) : new Object[7];
            RemoteFileSystem fs = rf.getRemoteFS();
            if (rf.getClientStatus() == Sync.SyncState.UpToDate && rf.getServerStatus() == Sync.SyncState.UpToDate && (Object[])map.get(rf) == null) {
                return;
            }
            objs[0] = rf;
            objs[1] = rf.getCacheFile().getAbsolutePath();
            SyncTablePanel.longValues[0] = ((String)objs[1]).length() > ((String)longValues[0]).length() ? objs[1] : longValues[0];
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("REMOTE_ROOT", fs.getRootFile());
            hm.put("LCOAL_ROOT", fs.getLocalRoot());
            objs[2] = FileUtility.winPathToOpenVMSPath((String)objs[1], false, hm);
            SyncTablePanel.longValues[1] = ((String)objs[2]).length() > ((String)longValues[1]).length() ? objs[2] : longValues[1];
            objs[3] = rf.getStatusString();
            SyncTablePanel.longValues[2] = ((String)objs[3]).length() > ((String)longValues[2]).length() ? objs[3] : longValues[2];
            objs[4] = new Boolean(false);
            objs[5] = new Boolean(false);
            objs[6] = new Boolean(true);
            if (!map.containsKey(rf)) {
                map.put(rf, objs);
                list.add(objs);
            }
            sm.fireTableDataChanged();
            SyncTablePanel.initColumnSizes(syncTable.getTable());
        }
    }

    public static synchronized void bringupTable(final boolean doModal) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = synchronizedObject;
                synchronized (object) {
                    SyncTableModel sm;
                    ArrayList list;
                    if (syncTable == null) {
                        DistributedModule.logger.info("creating a new sync resolve table");
                        syncTable = new SyncTablePanel();
                        syncTable.setModal(doModal);
                    }
                    if ((list = (sm = syncTable.getTableModel()).getFiles()) == null || list.size() == 0) {
                        return;
                    }
                    syncTable.pack();
                    syncTable.show();
                }
            }
        });
    }

    public static synchronized void showSyncFiles(final RemoteFile rf, final boolean doModal, final boolean isManualSynch) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = synchronizedObject;
                synchronized (object) {
                    if (syncTable == null) {
                        DistributedModule.logger.info("creating a new sync resolve table");
                        syncTable = new SyncTablePanel();
                        if (rf.getClientStatus() == Sync.SyncState.UpToDate && rf.getServerStatus() == Sync.SyncState.UpToDate) {
                            syncTable = null;
                            return;
                        }
                        syncTable;
                        SyncTablePanel.update(rf);
                        if (!isManualSynch) {
                            syncTable.setModal(doModal);
                            syncTable.pack();
                            syncTable.show();
                        }
                    } else {
                        syncTable;
                        SyncTablePanel.update(rf);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeTable() {
        DistributedModule.logger.info("sync resolve table being purged");
        SyncTableModel sm = (SyncTableModel)this.jTable1.getModel();
        ArrayList alist = null;
        SyncTableModel syncTableModel = sm;
        synchronized (syncTableModel) {
            alist = sm.getFiles();
            Map map = sm.getMap();
            Iterator itr = alist.iterator();
            while (itr.hasNext()) {
                Object[] objs = (Object[])itr.next();
                if (((RemoteFile)objs[0]).getClientStatus() != Sync.SyncState.UpToDate || ((RemoteFile)objs[0]).getServerStatus() != Sync.SyncState.UpToDate) continue;
                itr.remove();
                map.remove(objs[0]);
            }
        }
        if (alist.size() == 0) {
            syncTable = null;
            DistributedModule.logger.info("sync resolve table being purged finished");
            this.exitForm(null);
            return;
        }
        sm.fireTableDataChanged();
        DistributedModule.logger.info("sync resolve table being purged finished");
    }

    private int getSelectedColumnHeaderIdx(MouseEvent evt) {
        JTable table = ((JTableHeader)evt.getSource()).getTable();
        TableColumnModel colModel = table.getColumnModel();
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        if (vColIndex == -1) {
            return -1;
        }
        return vColIndex;
    }

    private static void initColumnSizes(JTable table) {
        SyncTableModel model = (SyncTableModel)table.getModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int margin = table.getColumnModel().getColumnMargin();
        for (int i = 0; i < 6; ++i) {
            column = table.getColumnModel().getColumn(i);
            comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width;
            comp = table.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(table, longValues[i], false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
            if (i > 2) {
                preferedTableWidth += Math.max(headerWidth, cellWidth);
                continue;
            }
            if (i == 2) {
                column.setPreferredWidth(Math.max(headerWidth, cellWidth));
                continue;
            }
            column.setPreferredWidth(Math.min(250, cellWidth));
        }
        table.setPreferredScrollableViewportSize(new Dimension(preferedTableWidth += 600, (int)table.getPreferredScrollableViewportSize().getHeight()));
        preferedTableWidth = 0;
    }

    private void myInitComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.popupMenu = new MyJPopupMenu();
        this.getContentPane().setLayout(new GridBagLayout());
        this.jTable1 = new JTable(){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                if (rowIndex >= this.getRowCount()) {
                    return null;
                }
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setToolTipText(null);
                    if (vColIndex < 2 && rowIndex < this.getModel().getRowCount()) {
                        jc.setToolTipText((String)this.getValueAt(rowIndex, vColIndex));
                    }
                }
                return c;
            }
        };
        this.setTitle("FTP Filesystem - Conflict Resolution");
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.jTable1);
        this.jPanel2.setLayout(new FlowLayout(2));
        this.jButton1.setText("Synchronize");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SyncTablePanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton1.setEnabled(false);
        this.jPanel2.add(this.jButton1);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SyncTablePanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.scrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        JMenuItem menuItem = new JMenuItem("Select All");
        this.jTable1.setModel(new SyncTableModel());
        this.jTable1.setColumnSelectionAllowed(true);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedColumn = SyncTablePanel.this.jTable1.getSelectedColumn();
                if (selectedColumn < 0) {
                    selectedColumn = SyncTablePanel.this.popupMenu.getColumnIndex();
                }
                for (int i = 0; i < SyncTablePanel.this.jTable1.getRowCount(); ++i) {
                    SyncTablePanel.this.jTable1.getModel().setValueAt(Boolean.TRUE, i, selectedColumn);
                }
            }
        });
        this.popupMenu.add(menuItem);
        PopupListener popupListener = new PopupListener();
        this.jTable1.addMouseListener(popupListener);
        JTableHeader header = this.jTable1.getTableHeader();
        header.addMouseListener(new ColumnHeaderListener());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                syncTable = null;
            }
        });
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        SyncTableModel st = (SyncTableModel)this.jTable1.getModel();
        final ArrayList fobjs = st.getFiles();
        final HashMap folders = new HashMap();
        this.jButton1.setEnabled(false);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = synchronizedObject;
                synchronized (object) {
                    RemoteFileSystem fs;
                    DistributedModule.logger.info("sync resolve table being synchronized");
                    InputOutput io = TopManager.getDefault().getIO("FTP Filesystem - Conflict Resolution", false);
                    try {
                        io.select();
                        io.getOut().reset();
                        io.setFocusTaken(true);
                        io.setErrVisible(false);
                        io.setErrSeparated(false);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    StatusDisplayer.getDefault().setStatusText("Resolving Conflicts");
                    for (int i = 0; i < fobjs.size(); ++i) {
                        try {
                            RemoteFile rfile = (RemoteFile)((Object[])fobjs.get(i))[0];
                            fs = rfile.getRemoteFS();
                            if (rfile.getClientStatus() == Sync.SyncState.UpToDate && rfile.getServerStatus() == Sync.SyncState.UpToDate) continue;
                            if (((Object[])fobjs.get(i))[4].equals(Boolean.TRUE)) {
                                rfile.copyToClient();
                                io.getOut().println("Copying " + rfile.getName().getFullName() + " to client");
                            } else {
                                if (!((Object[])fobjs.get(i))[5].equals(Boolean.TRUE)) continue;
                                rfile.copyToServer();
                                io.getOut().println("Copying " + rfile.getCacheFile().getAbsolutePath() + " to server");
                            }
                            ((Object[])fobjs.get((int)i))[3] = rfile.getStatusString();
                            String name = rfile.getCacheFile().getParent().equalsIgnoreCase(fs.getLocalRoot()) ? "" : rfile.getCacheFile().getParentFile().getAbsolutePath().substring(fs.getLocalRoot().length() + 1);
                            name = name.replace(File.separatorChar, '/');
                            if (name.lastIndexOf(47) > 0) {
                                name = name.substring(0, name.lastIndexOf(47));
                            }
                            folders.put(name, fs);
                            continue;
                        }
                        catch (FileStateInvalidException e) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                            continue;
                        }
                        catch (IOException e) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                        }
                    }
                    io.getOut().println("Done");
                    Iterator itr = folders.keySet().iterator();
                    while (itr.hasNext()) {
                        String name = (String)itr.next();
                        fs = (FileSystem)folders.get(name);
                        FileObject fobj = fs.findResource(name);
                        if (fobj == null) continue;
                        fobj.refresh();
                    }
                    SyncTablePanel.this.purgeTable();
                    DistributedModule.logger.info("sync resolve table being  synchronized finished");
                    StatusDisplayer.getDefault().setStatusText("Resolving Conflicts: Done");
                    Utils.closeActiveEditorFile();
                }
            }
        });
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        syncTable = null;
        this.exitForm(null);
    }

    private void initComponents() {
        this.setTitle("FTP Filesystem - Conflict Resolution");
    }

    private void exitForm(WindowEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
    }

    static {
        longValues = new Object[]{"", "", "", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
        synchronizedObject = new Object();
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (SyncTablePanel.this.jTable1.getSelectedColumn() > 2) {
                this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (SyncTablePanel.this.jTable1.getSelectedColumn() > 2) {
                this.showPopup(e);
            }
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SyncTablePanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class MyJPopupMenu
    extends JPopupMenu {
        private int index;

        MyJPopupMenu() {
        }

        public void setColumnIndex(int idx) {
            this.index = idx;
        }

        public int getColumnIndex() {
            return this.index;
        }
    }

    class ColumnHeaderListener
    extends MouseAdapter {
        ColumnHeaderListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            if (SyncTablePanel.this.getSelectedColumnHeaderIdx(evt) > 2) {
                this.showPopup(evt);
            }
        }

        private void showPopup(MouseEvent e) {
            SyncTablePanel.this.popupMenu.setColumnIndex(SyncTablePanel.this.getSelectedColumnHeaderIdx(e));
            SyncTablePanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class SyncTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Local File", "Remote File", "Status", "Server->Client", "Client->Server", "No Action"};
        private ArrayList data = new ArrayList();
        private HashMap map = new HashMap();
        private HashSet actionList = new HashSet();

        public ArrayList getFiles() {
            return this.data;
        }

        public Map getMap() {
            return this.map;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return ((Object[])this.data.get(row))[col + 1];
        }

        public Class getColumnClass(int c) {
            return longValues[c].getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col > 2;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col > 2 && value.equals(Boolean.TRUE)) {
                Boolean resetValue = Boolean.FALSE;
                if (col == 3) {
                    ((Object[])this.data.get((int)row))[col + 2] = resetValue;
                    ((Object[])this.data.get((int)row))[col + 3] = resetValue;
                    SyncTablePanel.this.jButton1.setEnabled(true);
                    this.fireTableCellUpdated(row, col + 2);
                    this.fireTableCellUpdated(row, col + 3);
                    this.actionList.add(new Integer(row));
                } else if (col == 4) {
                    ((Object[])this.data.get((int)row))[col] = resetValue;
                    ((Object[])this.data.get((int)row))[col + 2] = resetValue;
                    this.fireTableCellUpdated(row, col - 1);
                    this.fireTableCellUpdated(row, col + 2);
                    SyncTablePanel.this.jButton1.setEnabled(true);
                    this.actionList.add(new Integer(row));
                } else if (col == 5) {
                    ((Object[])this.data.get((int)row))[col] = resetValue;
                    ((Object[])this.data.get((int)row))[col - 1] = resetValue;
                    this.fireTableCellUpdated(row, col - 2);
                    this.fireTableCellUpdated(row, col - 1);
                    this.actionList.remove(new Integer(row));
                    if (this.actionList.size() == 0) {
                        SyncTablePanel.this.jButton1.setEnabled(false);
                    }
                }
                ((Object[])this.data.get((int)row))[col + 1] = value;
                this.fireTableCellUpdated(row, col + 1);
            } else if (col == 2) {
                ((Object[])this.data.get((int)row))[col + 1] = value;
                this.fireTableCellUpdated(row, col + 1);
            }
        }
    }
}

