/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.netbeans.modules.distributed.DistributedModule;
import org.netbeans.modules.distributed.remotefs.core.ConnectAction;
import org.netbeans.modules.distributed.remotefs.core.FTPActions;
import org.netbeans.modules.distributed.remotefs.core.FTPRecurseRefreshAction;
import org.netbeans.modules.distributed.remotefs.core.FTPRefreshAction;
import org.netbeans.modules.distributed.remotefs.core.LogInfo;
import org.netbeans.modules.distributed.remotefs.core.RemoteClient;
import org.netbeans.modules.distributed.remotefs.core.RemoteDefaultAttributes;
import org.netbeans.modules.distributed.remotefs.core.RemoteFile;
import org.netbeans.modules.distributed.remotefs.core.RemoteFileAttributes;
import org.netbeans.modules.distributed.remotefs.core.RemoteFileName;
import org.netbeans.modules.distributed.remotefs.core.SynchResidenceAction;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileService;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.settings.DistributedProjectSettings;
import org.netbeans.modules.distributed.util.FileUtility;
import org.netbeans.modules.distributed.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.ExtensionList;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;

public abstract class RemoteFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.List,
AbstractFileSystem.Info,
AbstractFileSystem.Change,
RemoteFile.Notify,
RemoteFile.RequestProcessor,
Runnable {
    static final long serialVersionUID = 5562503683369874863L;
    private static final boolean DEBUG = true;
    private static final String DEVICE = "sys$disk:";
    protected transient RemoteClient client;
    protected transient RemoteFile rootFile;
    protected File cachedir = null;
    protected String startdir = "/";
    protected LogInfo loginfo;
    protected boolean readOnly;
    protected boolean confirmDeleteAlways = true;
    protected boolean autoSync = true;
    protected boolean displayStatus = true;
    protected boolean ignoreHiddenFiles = true;
    protected boolean keepItConnected = true;
    private Boolean useXtermCompile;
    private Boolean useXtermExecution;
    private Integer xDisplayNumber;
    protected boolean ftpPassiveMode;
    protected boolean SSHForwarding;
    private transient Object downloadAllLock = new Object();
    private transient Object uploadAllLock = new Object();
    private transient Object synchLock = new Object();
    private transient boolean stopDownloadAll = false;
    private transient boolean stopUploadAll = false;
    private transient boolean stopSyncAll = false;
    private transient boolean printDownloadStop = true;
    private transient boolean printUploadStop = true;
    private transient boolean printSyncAllStop = true;
    protected transient RequestProcessor requestproc;
    private ExtensionList backupExtensions;
    private static ExtensionList DEFAULT_EXTENSIONS = new ExtensionList();
    private static ExtensionList DEFAULT_SERVER_ONLY_EXTENSIONS = new ExtensionList();
    private static ExtensionList DEFAULT_ASCII_EXTENSIONS = new ExtensionList();
    public static final String BACKUP_EXT = System.getProperty("org.netbeans.core.ExLocalFileSystem.BACKUP_EXT", "~");
    private ExtensionList ignoredFiles;
    private ExtensionList ignoredFolders;
    private transient Pattern ignoredRE;
    private static final String IGNORED_FILES_PROP = "netbeans.ignored.files";
    private ExtensionList asciiFileExts;
    private ExtensionList serverOnlyFileExts;

    private static void setDefaultServerOnlyExtension() {
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("obj");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("exe");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("pen");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("tlb");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("bck");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("iis");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("pcsi");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("olb");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("ana");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("r32");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("req");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("tif");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("mlb");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("nlb");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("uid");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("stb");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("esw");
    }

    private static void setDefaultAsciiExtension() {
        DEFAULT_ASCII_EXTENSIONS.addExtension("bas");
        DEFAULT_ASCII_EXTENSIONS.addExtension("c");
        DEFAULT_ASCII_EXTENSIONS.addExtension("cpp");
        DEFAULT_ASCII_EXTENSIONS.addExtension("cxx");
        DEFAULT_ASCII_EXTENSIONS.addExtension("h");
        DEFAULT_ASCII_EXTENSIONS.addExtension("hpp");
        DEFAULT_ASCII_EXTENSIONS.addExtension("hxx");
        DEFAULT_ASCII_EXTENSIONS.addExtension("cc");
        DEFAULT_ASCII_EXTENSIONS.addExtension("com");
        DEFAULT_ASCII_EXTENSIONS.addExtension("cob");
        DEFAULT_ASCII_EXTENSIONS.addExtension("lis");
        DEFAULT_ASCII_EXTENSIONS.addExtension("log");
        DEFAULT_ASCII_EXTENSIONS.addExtension("dat");
        DEFAULT_ASCII_EXTENSIONS.addExtension("fdl");
        DEFAULT_ASCII_EXTENSIONS.addExtension("pl");
        DEFAULT_ASCII_EXTENSIONS.addExtension("pas");
        DEFAULT_ASCII_EXTENSIONS.addExtension("bas");
        DEFAULT_ASCII_EXTENSIONS.addExtension("for");
        DEFAULT_ASCII_EXTENSIONS.addExtension("f");
        DEFAULT_ASCII_EXTENSIONS.addExtension("inc");
        DEFAULT_ASCII_EXTENSIONS.addExtension("f77");
        DEFAULT_ASCII_EXTENSIONS.addExtension("f90");
        DEFAULT_ASCII_EXTENSIONS.addExtension("b32");
        DEFAULT_ASCII_EXTENSIONS.addExtension("bli");
        DEFAULT_ASCII_EXTENSIONS.addExtension("cld");
        DEFAULT_ASCII_EXTENSIONS.addExtension("pli");
        DEFAULT_ASCII_EXTENSIONS.addExtension("ada");
        DEFAULT_ASCII_EXTENSIONS.addExtension("opt");
        DEFAULT_ASCII_EXTENSIONS.addExtension("pcsi$desc");
        DEFAULT_ASCII_EXTENSIONS.addExtension("pcsi$text");
        DEFAULT_ASCII_EXTENSIONS.addExtension("mms");
        DEFAULT_ASCII_EXTENSIONS.addExtension("sh");
        DEFAULT_ASCII_EXTENSIONS.addExtension("properties");
        DEFAULT_ASCII_EXTENSIONS.addExtension("mf");
        DEFAULT_ASCII_EXTENSIONS.addExtension("htm");
        DEFAULT_ASCII_EXTENSIONS.addExtension("ps");
        DEFAULT_ASCII_EXTENSIONS.addExtension("html");
        DEFAULT_ASCII_EXTENSIONS.addExtension("xml");
        DEFAULT_ASCII_EXTENSIONS.addExtension("rno");
        DEFAULT_ASCII_EXTENSIONS.addExtension("sco");
        DEFAULT_ASCII_EXTENSIONS.addExtension("sc");
    }

    public RemoteFileSystem() {
        RemoteFileSystem.setDefaultServerOnlyExtension();
        RemoteFileSystem.setDefaultAsciiExtension();
        this.ignoredRE = null;
        this.info = this;
        this.change = this;
        InnerAttrs a = new InnerAttrs(this, this.info, this.change, this);
        this.attr = a;
        this.list = a;
        TopManager.getDefault().getRepository().addRepositoryListener(new RepositoryListener(){

            public void fileSystemAdded(RepositoryEvent ev) {
                RemoteFileSystem.this.addedFSProjectSwitch(ev.getFileSystem());
            }

            public void fileSystemRemoved(RepositoryEvent ev) {
                RemoteFileSystem.this.removedFS(ev.getFileSystem());
            }

            public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
            }
        });
    }

    public Object getSynchLock() {
        return this.synchLock;
    }

    public Object getFileAttribute(String name, String attrName) {
        return this.attr.readAttribute(name.replace(File.separatorChar, '/'), attrName);
    }

    public void setFileAttribute(String name, String attrName, Object value) {
        try {
            this.attr.writeAttribute(name.replace(File.separatorChar, '/'), attrName, value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getFile(String name) {
        return new File(this.cachedir, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupIfNecessary(String name) throws IOException {
        block13: {
            ExtensionList b;
            ExtensionList extensionList = b = this.backupExtensions == null ? DEFAULT_EXTENSIONS : this.backupExtensions;
            if (b.isRegistered(name) && !name.toLowerCase().endsWith(".nbattrs~")) {
                InputStream is = null;
                try {
                    is = this.inputStream(name);
                    if (is == null) {
                        return;
                    }
                    String backupName = name + BACKUP_EXT;
                    RemoteFile f = this.getRemoteFile(backupName);
                    OutputStream os = null;
                    if (f == null) {
                        this.createData(backupName);
                    }
                    if ((os = this.outputStream(backupName)) == null) break block13;
                    try {
                        FileUtil.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        os.close();
                    }
                }
                catch (FileNotFoundException fex) {
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
    }

    public void removedFS(FileSystem fs) {
        if (fs == this) {
            if (this.requestproc != null) {
                this.requestproc.stop();
                this.requestproc = null;
            }
            if (this.isConnected()) {
                this.removeClient();
            }
        }
    }

    protected void addedFS(FileSystem fs) throws IOException {
        if (fs == this) {
            DistributedModule.logger.info("FTP FS " + fs.getDisplayName() + " is being added");
            if (!this.isConnected()) {
                this.connectOnBackgroundFirstTime(this.keepItConnected, true);
            }
        }
        Utils.createStatusLogger(this.getLocalRoot(), "refresh");
    }

    public void addedFSProjectSwitch(FileSystem fs) {
        if (fs == this) {
            DistributedModule.logger.info("FTP FS " + fs.getDisplayName() + " is being added");
            if (!this.isConnected()) {
                this.connectOnBackgroundFirstTime(this.keepItConnected, true);
            }
        }
    }

    public RemoteFileSystem(FileSystemCapability cap) {
        this();
        this.setCapability(cap);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.asciiFileExts == null) {
            RemoteFileSystem.setDefaultAsciiExtension();
            this.asciiFileExts = (ExtensionList)DEFAULT_ASCII_EXTENSIONS.clone();
        }
        if (this.serverOnlyFileExts == null) {
            RemoteFileSystem.setDefaultServerOnlyExtension();
            this.serverOnlyFileExts = (ExtensionList)DEFAULT_SERVER_ONLY_EXTENSIONS.clone();
        }
        if (this.downloadAllLock == null) {
            this.downloadAllLock = new Object();
        }
        if (this.uploadAllLock == null) {
            this.uploadAllLock = new Object();
        }
        if (this.synchLock == null) {
            this.synchLock = new Object();
        }
        this.stopDownloadAll = false;
        this.stopUploadAll = false;
        this.stopSyncAll = false;
        this.printDownloadStop = true;
        this.printUploadStop = true;
        this.printSyncAllStop = true;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    public SystemAction[] getActions() {
        SystemAction[] actions = super.getActions();
        SystemAction[] newactions = new SystemAction[actions.length + 5];
        for (int i = 0; i < actions.length; ++i) {
            newactions[i] = actions[i];
        }
        newactions[actions.length] = this.getAction(FTPRefreshAction.class);
        newactions[actions.length + 1] = this.getAction(FTPRecurseRefreshAction.class);
        newactions[actions.length + 2] = this.getAction(FTPActions.class);
        newactions[actions.length + 3] = this.getAction(SynchResidenceAction.class);
        newactions[actions.length + 4] = this.getAction(ConnectAction.class);
        ((ConnectAction)newactions[actions.length + 4]).setFS(this);
        return newactions;
    }

    private SystemAction getAction(Class clazz) {
        return (SystemAction)SharedClassObject.findObject((Class)clazz, (boolean)true);
    }

    protected void removeClient() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void connectOnBackgroundFirstTime(boolean b, final boolean isFirstTime) {
        this.setConnected(b);
        this.post(new Runnable(){

            public void run() {
                DistributedModule.logger.info("FTP Connecting on a background");
                if (RemoteFileSystem.this.isConnected()) {
                    DistributedModule.logger.info("FTP server connected");
                    if (!isFirstTime) {
                        DistributedModule.logger.info("refreshing all the existing fileobjects:" + RemoteFileSystem.this.getRoot().getName());
                        Enumeration enums = RemoteFileSystem.this.existingFileObjects(RemoteFileSystem.this.getRoot());
                        while (enums.hasMoreElements()) {
                            Object obj = enums.nextElement();
                            if (!((FileObject)obj).isFolder()) continue;
                            ((FileObject)obj).refresh();
                        }
                    } else {
                        DistributedModule.logger.info("refreshing top level root:" + RemoteFileSystem.this.getRoot().getName());
                        RemoteFileSystem.this.getRoot().refresh(false);
                    }
                } else {
                    DistributedModule.logger.info("not connected refreshing top level root:" + RemoteFileSystem.this.getRoot().getName());
                    RemoteFileSystem.this.getRoot().refresh(false);
                }
            }
        }, "");
    }

    public void connectOnBackground(boolean b) {
        this.connectOnBackgroundFirstTime(b, false);
    }

    public boolean isConnected() {
        if (this.client == null) {
            return false;
        }
        boolean ret = this.client.isConnected();
        return ret;
    }

    private synchronized void setConnected(boolean connected) {
        if (!connected) {
            DistributedModule.logger.info("disconnecting from ftp server");
            if (this.client != null) {
                this.client.close();
            }
            this.keepItConnected = false;
            this.firePropertyChange("keepItConnected", null, Boolean.FALSE);
            this.firePropertyChange("displayName", null, this.getDisplayName());
        } else {
            DistributedModule.logger.info("connecting to ftp server");
            boolean isError = false;
            try {
                this.client = this.createClient(this.loginfo, this.cachedir, this.startdir);
                DistributedModule.logger.info("ftp client is created");
                StatusDisplayer.getDefault().setStatusText("connecting to the FTP server : " + this.loginfo.displayName());
                if (this.client.isConnected()) {
                    this.client.disconnect();
                }
                this.client.connect();
                RemoteFileName ftpName = new RemoteFileName(){

                    public String getName() {
                        return RemoteFileSystem.this.startdir;
                    }

                    public void setName(String newname) {
                    }

                    public String getFullName() {
                        return RemoteFileSystem.this.startdir;
                    }

                    public RemoteFileName createNew(String name, boolean isDir) {
                        return null;
                    }

                    public boolean isDirectory() {
                        return true;
                    }
                };
                RemoteFileAttributes fileAt = this.client.listFile("", ftpName);
                DistributedModule.logger.info("connected to ftp server");
                this.keepItConnected = true;
                this.firePropertyChange("keepItConnected", null, Boolean.TRUE);
                StatusDisplayer.getDefault().setStatusText("succeeded connecting to the FTP server : " + this.loginfo.displayName());
                this.firePropertyChange("displayName", null, this.getDisplayName());
            }
            catch (IOException e) {
                if (connected && this.client != null) {
                    this.client.close();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Object obj = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)("Error while mouting " + RemoteFileSystem.this.getDisplayName() + "\nThe error message was : " + e.getMessage()), -1, 2));
                    }
                });
                DistributedModule.logger.info("error connecting to ftp server:" + e.getMessage());
                boolean bl = true;
            }
        }
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, this.getRoot(), true, true));
        this.firePropertyChange("connected", null, this.isConnected() ? Boolean.TRUE : Boolean.FALSE);
    }

    public abstract RemoteClient createClient(LogInfo var1, File var2, String var3) throws IOException;

    protected abstract RemoteFile createRootFile(RemoteClient var1, File var2) throws IOException;

    public void setReadOnly(boolean flag) {
        if (flag != this.readOnly) {
            this.readOnly = flag;
            this.firePropertyChange("readOnly", !flag ? Boolean.TRUE : Boolean.FALSE, flag ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        environment.addClassPath(this.cachedir.toString());
    }

    protected abstract void isReadyToModify() throws IOException;

    protected abstract void isReadyToRead() throws IOException;

    protected abstract boolean isReady();

    public RemoteFile getRemoteFile(String name) throws IOException {
        RemoteFile ftpfile = this.rootFile.find(name);
        if (ftpfile == null && (name.endsWith("filesystem.attributes") || name.endsWith(".nbattrs") || name.endsWith(".nbattrs~"))) {
            this.createData(name);
            return this.rootFile.find(name);
        }
        return ftpfile;
    }

    public void synchronize(String name) {
    }

    private void doUploadDone(boolean oneFile) {
        if (oneFile) {
            StatusDisplayer.getDefault().setStatusText("Put File To Server Done");
        } else {
            StatusDisplayer.getDefault().setStatusText("Put All Files To Server Done");
        }
        Utils.getStatusLogger(this.getLocalRoot(), "putall").info("Done");
        if (this.getRemoteRuntimeType() != null) {
            this.getRemoteRuntimeType().setRemoteServerError(false);
        }
        this.setStopUploadAll(false);
        this.setPrintUploadStop(true);
        this.run();
    }

    public void uploadAll(String name, final boolean printDone, final boolean oneFile) {
        if (!this.isReady()) {
            return;
        }
        DistributedModule.logger.info("Uploading all started");
        final Logger logger = Utils.getStatusLogger(this.getLocalRoot(), "putall");
        try {
            final RemoteFile f = this.getRemoteFile(name);
            if (f != null) {
                this.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = RemoteFileSystem.this.uploadAllLock;
                        synchronized (object) {
                            if (RemoteFileSystem.this.getStopUploadAll() || RemoteFileSystem.this.getRemoteRuntimeType() != null && RemoteFileSystem.this.getRemoteRuntimeType().getRemoteServerError() || RemoteFileSystem.this.getRemoteRuntimeType() == null) {
                                if (printDone) {
                                    RemoteFileSystem.this.doUploadDone(oneFile);
                                }
                                return;
                            }
                            try {
                                f.refresh();
                                if (f.getFileResidenceMode() == 1 || f.getFileResidenceMode() == 0) {
                                    if (oneFile && !f.isDirectory()) {
                                        f.uploadAll(null);
                                    }
                                } else {
                                    f.uploadAll(null);
                                }
                            }
                            catch (IOException e) {
                                RemoteFileSystem.this.setStopUploadAll(true);
                                RemoteFileSystem.this.setPrintUploadStop(true);
                                SwingUtilities.invokeLater(new Runnable(this, e){
                                    private final /* synthetic */ IOException val$e;
                                    private final /* synthetic */ 5 this$1;
                                    {
                                        this.this$1 = this$1;
                                        this.val$e = val$e;
                                    }

                                    public void run() {
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.val$e.getMessage(), 2));
                                    }
                                });
                            }
                            if (RemoteFileSystem.this.getStopUploadAll() && RemoteFileSystem.this.getPrintUploadStop()) {
                                logger.info("Stopped!");
                                RemoteFileSystem.this.setPrintUploadStop(false);
                            } else if ((RemoteFileSystem.this.getRemoteRuntimeType().getRemoteServerError() || RemoteFileSystem.this.getRemoteRuntimeType() == null) && RemoteFileSystem.this.getPrintUploadStop()) {
                                logger.info("Aborted due to disconnected server!");
                                RemoteFileSystem.this.setPrintUploadStop(false);
                            }
                            if (printDone) {
                                RemoteFileSystem.this.doUploadDone(oneFile);
                            }
                        }
                    }
                }, "putall");
            }
        }
        catch (IOException e) {
            logger.info("Stopped!");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 2));
                }
            });
        }
    }

    public boolean getStopDownloadAll() {
        return this.stopDownloadAll;
    }

    public void setStopDownloadAll(boolean stop) {
        this.stopDownloadAll = stop;
    }

    public boolean getStopUploadAll() {
        return this.stopUploadAll;
    }

    public void setStopUploadAll(boolean stop) {
        this.stopUploadAll = stop;
    }

    public boolean getPrintDownloadStop() {
        return this.printDownloadStop;
    }

    public void setPrintDownloadStop(boolean bool) {
        this.printDownloadStop = bool;
    }

    public boolean getPrintUploadStop() {
        return this.printUploadStop;
    }

    public void setPrintUploadStop(boolean bool) {
        this.printUploadStop = bool;
    }

    public boolean getPrintSyncAllStop() {
        return this.printSyncAllStop;
    }

    public void setPrintSyncAllStop(boolean bool) {
        this.printSyncAllStop = bool;
    }

    public boolean getStopSyncAll() {
        return this.stopSyncAll;
    }

    public void setStopSyncAll(boolean bool) {
        this.stopSyncAll = bool;
    }

    private void doDownloadDone(boolean oneFile) {
        if (oneFile) {
            StatusDisplayer.getDefault().setStatusText("Get File From Server Done");
        } else {
            StatusDisplayer.getDefault().setStatusText("Get All Files From Server Done");
        }
        Utils.getStatusLogger(this.getLocalRoot(), "getall").info("Done");
        this.setStopDownloadAll(false);
        this.setPrintDownloadStop(true);
        this.run();
    }

    public void downloadAll(String name, final boolean printDone, final boolean oneFile) {
        if (!this.isReady()) {
            return;
        }
        DistributedModule.logger.info("downloading all from " + name + " started");
        try {
            final RemoteFile f = this.getRemoteFile(name);
            if (f != null) {
                this.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = RemoteFileSystem.this.downloadAllLock;
                        synchronized (object) {
                            Logger logger = Utils.getStatusLogger(RemoteFileSystem.this.getLocalRoot(), "getall");
                            if (RemoteFileSystem.this.getStopDownloadAll()) {
                                if (printDone) {
                                    RemoteFileSystem.this.doDownloadDone(oneFile);
                                }
                                return;
                            }
                            try {
                                f.refresh();
                                if (f.getFileResidenceMode() == 1 || f.getFileResidenceMode() == 0) {
                                    if (oneFile && !f.isDirectory()) {
                                        f.downloadAll(null);
                                    }
                                } else {
                                    f.downloadAll(null);
                                }
                            }
                            catch (IOException e) {
                                RemoteFileSystem.this.setStopDownloadAll(true);
                                RemoteFileSystem.this.setPrintUploadStop(true);
                                SwingUtilities.invokeLater(new Runnable(this, e){
                                    private final /* synthetic */ IOException val$e;
                                    private final /* synthetic */ 8 this$1;
                                    {
                                        this.this$1 = this$1;
                                        this.val$e = val$e;
                                    }

                                    public void run() {
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.val$e.getMessage(), 2));
                                    }
                                });
                            }
                            if (RemoteFileSystem.this.getStopDownloadAll() && RemoteFileSystem.this.getPrintDownloadStop()) {
                                logger.info("Stopped!");
                                RemoteFileSystem.this.setPrintDownloadStop(false);
                            }
                            if (printDone) {
                                RemoteFileSystem.this.doDownloadDone(oneFile);
                            }
                        }
                    }
                }, "getall");
            }
        }
        catch (IOException e) {
            TopManager.getDefault().notifyException((Throwable)e);
        }
    }

    public void cleanCache(String name) {
        if (!this.isReady()) {
            return;
        }
        try {
            RemoteFile f = this.getRemoteFile(name);
            if (f != null) {
                f.cleanCache();
            }
        }
        catch (IOException e) {
            TopManager.getDefault().notifyException((Throwable)e);
        }
    }

    public String[] children(String name) {
        String[] seznam = new String[]{};
        if (!this.isReady()) {
            return seznam;
        }
        try {
            RemoteFile f = this.getRemoteFile(name);
            if (f != null && f.isDirectory()) {
                seznam = f.getStringChildren(this);
                this.statusChanged(name, true);
            }
        }
        catch (IOException e) {
            TopManager.getDefault().notifyException((Throwable)e);
        }
        for (int i = 0; i < seznam.length; ++i) {
            if (!(seznam[i] != null && seznam[i].endsWith(BACKUP_EXT) || seznam[i] != null && this.ignoredFiles != null && this.ignoredFiles.isRegistered(seznam[i]) || seznam[i] != null && this.ignoreHiddenFiles && seznam[i].startsWith(".")) && (seznam[i] == null || this.ignoredFolders == null || !this.ignoredFolders.isRegistered(seznam[i]))) continue;
            seznam[i] = null;
        }
        return seznam;
    }

    public abstract void statusChanged(String var1);

    public abstract void statusChanged(String var1, boolean var2);

    public abstract String getLocalRoot();

    public abstract RemoteRuntimeType getRemoteRuntimeType();

    public abstract RemoteRuntimeType getRemoteRuntimeTypeRef();

    public void createFolder(String name) throws IOException {
        this.isReadyToModify();
        DistributedModule.logger.info("folder " + name + " is being created");
        RemoteFile f = null;
        String relname = null;
        int lastslash = name.lastIndexOf("/");
        if (lastslash == -1) {
            relname = name;
            f = this.rootFile;
        } else {
            relname = name.substring(lastslash + 1);
            f = this.rootFile.find(name.substring(0, lastslash));
        }
        if (f != null) {
            f.createFolder(relname, this);
        }
    }

    public void createData(String name) throws IOException {
        this.isReadyToModify();
        DistributedModule.logger.info("data " + name + "is being created");
        RemoteFile f = null;
        String relname = null;
        int lastslash = name.lastIndexOf("/");
        if (lastslash == -1) {
            relname = name;
            f = this.rootFile;
        } else {
            relname = name.substring(lastslash + 1);
            f = this.rootFile.find(name.substring(0, lastslash));
        }
        if (f != null) {
            f.createData(relname, this);
        }
    }

    public void rename(String oldName, String newName) throws IOException {
        DistributedModule.logger.info("file " + oldName + "being renamed");
        if (newName.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML)) {
            new File(this.getLocalRoot(), oldName).renameTo(new File(this.getLocalRoot(), newName));
            return;
        }
        this.isReadyToModify();
        RemoteFile of = this.getRemoteFile(oldName);
        if (of != null) {
            int slash2;
            int slash1;
            String name = null;
            String oname = oldName;
            String nname = newName;
            if (!oldName.startsWith("/")) {
                oname = "/" + oldName;
            }
            if (!newName.startsWith("/")) {
                nname = "/" + newName;
            }
            if ((slash1 = oname.lastIndexOf(47)) != (slash2 = nname.lastIndexOf(47)) || !oname.substring(0, slash1).equals(nname.substring(0, slash2))) {
                IOException e = new IOException("Can't rename !!!!!!");
                e.printStackTrace();
                throw e;
            }
            name = slash2 == -1 ? newName : nname.substring(slash2 + 1);
            of.rename(name);
        }
    }

    public Date lastModified(String name) {
        Date date = new Date();
        if (!this.isReady()) {
            return date;
        }
        try {
            RemoteFile f = this.getRemoteFile(name);
            if (f != null) {
                date = f.lastModified();
            }
        }
        catch (IOException e) {
            TopManager.getDefault().notifyException((Throwable)e);
        }
        return date;
    }

    public boolean folder(String name) {
        if (!this.isReady()) {
            return true;
        }
        try {
            RemoteFile f = this.getRemoteFile(name);
            if (f != null) {
                return f.isDirectory();
            }
        }
        catch (IOException e) {
            TopManager.getDefault().notifyException((Throwable)e);
        }
        return true;
    }

    public boolean readOnly(String name) {
        if (!this.isReady()) {
            return false;
        }
        try {
            RemoteFile f = this.getRemoteFile(name);
            if (f != null) {
                return f.isReadOnly();
            }
        }
        catch (IOException e) {
            TopManager.getDefault().notifyException((Throwable)e);
        }
        return false;
    }

    public String mimeType(String name) {
        return null;
    }

    public long size(String name) {
        try {
            if (name.endsWith("filesystem.attributes") || name.endsWith(".nbattrs") || name.endsWith(".nbattrs~")) {
                return new File(this.getLocalRoot() + File.separatorChar + name).length();
            }
            if (!this.isReady()) {
                return 0L;
            }
            RemoteFile f = this.getRemoteFile(name);
            if (f != null) {
                return f.getSize();
            }
        }
        catch (IOException e) {
            TopManager.getDefault().notifyException((Throwable)e);
        }
        return 0L;
    }

    public InputStream inputStream(String name) throws FileNotFoundException {
        InputStream is = null;
        try {
            RemoteFile f;
            block8: {
                DistributedModule.logger.info("inputstream " + name + " is being opened");
                File localFile = new File(this.getLocalRoot(), name);
                if (localFile.length() == 0L && localFile.getName().toLowerCase().endsWith(".xml") || localFile.length() == 0L && localFile.getName().toLowerCase().endsWith(".java")) {
                    this.setFileAttribute(name, "ftp_cache_lastmodified", null);
                    localFile.delete();
                    f = this.getRemoteFile(name);
                    f.load();
                }
                if (name.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML) || name.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML + "~")) {
                    return new FileInputStream(new File(this.getLocalRoot(), name));
                }
                try {
                    this.isReadyToRead();
                }
                catch (IOException e) {
                    FileSystem fs = TopManager.getDefault().getRepository().findFileSystem(this.getSystemName());
                    if (fs == null) break block8;
                    throw e;
                }
            }
            f = this.getRemoteFile(name);
            if (f != null) {
                RemoteFile secondaryFile;
                is = f.getInputStream();
                FileObject fobj = this.findResource(name);
                if (fobj.getExt().toLowerCase().equals("java") && (secondaryFile = this.getRemoteFile(fobj.getPackageName('/') + ".form")) != null) {
                    secondaryFile.getInputStream();
                }
                HashSet<FileObject> fos = new HashSet<FileObject>();
                fos.add(fobj);
                this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, fos, true, true));
            }
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.toString());
        }
        return is;
    }

    public OutputStream outputStream(String name) throws IOException {
        DistributedModule.logger.info("outputstream being opended:" + name);
        if (name.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML) || name.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML + "~")) {
            return new FileOutputStream(new File(this.getLocalRoot(), name));
        }
        this.isReadyToModify();
        RemoteFile f = this.getRemoteFile(name);
        if (f != null) {
            this.backupIfNecessary(name);
            System.out.println(f.getName().getName());
            return f.getOutputStream();
        }
        return null;
    }

    public void lock(String name) throws IOException {
    }

    public void unlock(String name) {
    }

    public void markUnimportant(String name) {
    }

    protected abstract void startdirNotFound(String var1, String var2, String var3);

    protected abstract void errorConnect(String var1, String var2);

    public void post(Runnable run, String name) {
        this.requestproc = new RequestProcessor(name + " " + this.loginfo.displayName());
        this.requestproc.post(run);
    }

    public void post(Runnable run) {
        this.requestproc = new RequestProcessor("Remote File System Request Processor " + this.loginfo.displayName());
        this.requestproc.post(run);
    }

    public void setBackupExtensions(ExtensionList l) {
        this.backupExtensions = l;
        this.firePropertyChange("backupExtensions", null, null);
    }

    public ExtensionList getBackupExtensions() {
        if (this.backupExtensions == null) {
            return (ExtensionList)DEFAULT_EXTENSIONS.clone();
        }
        return this.backupExtensions;
    }

    public void setAsciiFileExts(ExtensionList l) {
        this.asciiFileExts = l;
        this.firePropertyChange("asciiFileExts", null, null);
        this.run();
    }

    public void run() {
        DistributedModule.logger.info("FTP FS " + this.getDisplayName() + " is being refreshed");
        Enumeration e = this.existingFileObjects(this.getRoot());
        while (e.hasMoreElements()) {
            FileObject fo = (FileObject)e.nextElement();
            if (!fo.isFolder()) continue;
            fo.refresh(true);
        }
    }

    public ExtensionList getServerOnlyFileExts() {
        if (this.serverOnlyFileExts == null) {
            return (ExtensionList)DEFAULT_SERVER_ONLY_EXTENSIONS.clone();
        }
        return this.serverOnlyFileExts;
    }

    public void setServerOnlyFileExts(ExtensionList l) {
        this.serverOnlyFileExts = l;
        this.firePropertyChange("serverOnlyFileExts", null, null);
        this.run();
    }

    public ExtensionList getAsciiFileExts() {
        if (this.asciiFileExts == null) {
            return (ExtensionList)DEFAULT_ASCII_EXTENSIONS.clone();
        }
        return this.asciiFileExts;
    }

    public void setIgnoreHiddenFiles(boolean flag) {
        if (flag != this.ignoreHiddenFiles) {
            this.ignoreHiddenFiles = flag;
            this.firePropertyChange("displayStatus", !flag ? Boolean.TRUE : Boolean.FALSE, flag ? Boolean.TRUE : Boolean.FALSE);
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    public boolean getIgnoreHiddenFiles() {
        return this.ignoreHiddenFiles;
    }

    public void setDisplayStatus(boolean flag) {
        if (flag != this.displayStatus) {
            this.displayStatus = flag;
            this.firePropertyChange("displayStatus", !flag ? Boolean.TRUE : Boolean.FALSE, flag ? Boolean.TRUE : Boolean.FALSE);
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    public boolean getDisplayStatus() {
        return this.displayStatus;
    }

    public void setAutoSync(boolean flag) {
        if (flag != this.autoSync) {
            this.autoSync = flag;
            this.firePropertyChange("autoSync", !flag ? Boolean.TRUE : Boolean.FALSE, flag ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getAutoSync() {
        return this.autoSync;
    }

    public boolean getUseXtermCompile() {
        if (this.useXtermCompile == null) {
            return DistributedProjectSettings.getDefault().getUseXtermCompile();
        }
        return this.useXtermCompile;
    }

    public int getXDisplayDeviceNumber() {
        if (this.xDisplayNumber == null) {
            return DistributedProjectSettings.getDefault().getXDisplayDeviceNumber();
        }
        return this.xDisplayNumber;
    }

    public void setXDisplayDeviceNumber(int n) {
        this.xDisplayNumber = new Integer(n);
        this.firePropertyChange("xDisplayNumber", null, this.xDisplayNumber);
    }

    public void setUseXtermCompile(boolean useX) {
        this.useXtermCompile = new Boolean(useX);
        this.firePropertyChange("useXtermCompile", null, this.useXtermCompile);
    }

    public boolean getUseXtermExecution() {
        if (this.useXtermExecution == null) {
            return DistributedProjectSettings.getDefault().getUseXtermExecution();
        }
        return this.useXtermExecution;
    }

    public void setUseXtermExecution(boolean useX) {
        this.useXtermExecution = new Boolean(useX);
        this.firePropertyChange("useXtermExecution", null, this.useXtermExecution);
    }

    public ExtensionList getIgnoredFolders() {
        if (this.ignoredFolders == null) {
            this.ignoredFolders = new ExtensionList();
        }
        return this.ignoredFolders;
    }

    public synchronized void setIgnoredFolders(ExtensionList nue) throws IllegalArgumentException {
        if (!nue.equals((Object)this.ignoredFolders)) {
            this.ignoredFolders = nue;
            this.firePropertyChange("ignoredFolders", null, null);
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    public ExtensionList getIgnoredFiles() {
        if (this.ignoredFiles == null) {
            this.ignoredFiles = new ExtensionList();
        }
        return this.ignoredFiles;
    }

    public synchronized void setIgnoredFiles(ExtensionList nue) throws IllegalArgumentException {
        if (!nue.equals((Object)this.ignoredFiles)) {
            this.ignoredFiles = nue;
            this.firePropertyChange("ignoredFiles", null, null);
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    public String getRootFile() {
        if (this.rootFile != null) {
            return FileUtility.unixPathToOpenVMSPath(this.rootFile.getName().getFullName(), true);
        }
        return "<invalid>";
    }

    public boolean checkAndupdateRemoteServerError(final String name) {
        RemoteRuntimeType rrt = this.getRemoteRuntimeType();
        if (rrt == null || rrt.getRemoteRuntime() == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Error while converting " + name + " to strmlf :\n" + "Remote server " + RemoteFileSystem.this.getRemoteRuntimeTypeRef().getHostName() + ":" + RemoteFileSystem.this.getRemoteRuntimeTypeRef().getUserName() + " is disconnected.\nPlease go to the Runtime Tab and make a connection"), 2));
                }
            });
            if (rrt != null) {
                rrt.setRemoteServerError(true);
            }
            return true;
        }
        return rrt.getRemoteServerError();
    }

    public boolean changeBinFileToSTRMLF(String name) {
        RemoteRuntimeType rrt = this.getRemoteRuntimeType();
        try {
            DistributedModule.logger.info(name + " is being strmlfed");
            if (rrt == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Error while converting " + name + " to strmlf : \n" + "No matching remote server is found.\nPlease go to the Runtime Tab and create a remote server"), 2));
                rrt.setRemoteServerError(true);
            } else {
                RemoteRuntime remoteRuntime = rrt.getRemoteRuntime();
                if (remoteRuntime == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Error while converting " + name + " to strmlf :\n" + "Remote server " + rrt.getHostName() + ":" + rrt.getUserName() + " is disconnected.\nPlease go to the Runtime Tab and make a connection"), 2));
                    rrt.setRemoteServerError(true);
                } else {
                    RemoteFileService rsvc = remoteRuntime.getRemoteFileService();
                    if (rsvc != null) {
                        rsvc.changeBinFileToSTRMLF(DEVICE, name);
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Error while converting " + name + " to strmlf :\n" + "Remote server " + rrt.getHostName() + ":" + rrt.getUserName() + " is disconnected.\nPlease go to the Runtime Tab and make a connection"), 2));
                        rrt.setRemoteServerError(true);
                    }
                }
            }
        }
        catch (RemoteException e) {
            rrt.setRemoteServerError(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 2));
                }
            });
            return false;
        }
        return true;
    }

    private static class InnerAttrs
    extends RemoteDefaultAttributes {
        static final long serialVersionUID = 1257351369229921993L;
        RemoteFileSystem rfs;

        public InnerAttrs(RemoteFileSystem rfs, AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list) {
            super(info, change, list);
            this.rfs = rfs;
        }

        public Object readAttribute(String name, String attrName) {
            if (attrName.equals("java.io.File")) {
                return this.rfs.getFile(name);
            }
            return super.readAttribute(name.toLowerCase(), attrName);
        }

        public void writeAttribute(String name, String attrName, Object value) throws IOException {
            super.writeAttribute(name.toLowerCase(), attrName, value);
        }
    }
}

