/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.propertyeditors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.settings.DistributedSettings;
import org.openide.util.NbBundle;

public class RemoteRuntimeTypeJPanel
extends JPanel {
    private RemoteRuntimeType rrt;
    private NoEditJTable jTable1;
    private JComboBox jComboBox1;

    public RemoteRuntimeTypeJPanel() {
        this.initComponents();
        this.setName(NbBundle.getMessage((Class)RemoteRuntimeTypeJPanel.class, (String)"TITLE_RemoteRuntimePanel"));
        this.setupComponents();
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.rrt;
    }

    private void setupTable() {
        this.jTable1 = new NoEditJTable(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Name", "Value"});
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        JScrollPane scrollPane = new JScrollPane(this.jTable1);
        scrollPane.setBorder(new TitledBorder("Remote Server Properties"));
        this.add((Component)scrollPane, gridBagConstraints);
    }

    private void fillupTable(RemoteRuntimeType rrt) {
        String OS;
        String jdkVersion;
        try {
            jdkVersion = rrt.getRemoteRuntime().getJDKVersion();
            OS = rrt.getRemoteRuntime().getOperatingSystem();
        }
        catch (RemoteException re) {
            jdkVersion = "Unknown";
            OS = "unknown";
        }
        TableModel tm = this.jTable1.getModel();
        tm.setValueAt("Host Name", 0, 0);
        tm.setValueAt(rrt.getHostName(), 0, 1);
        tm.setValueAt("User Name", 1, 0);
        tm.setValueAt(rrt.getUserName(), 1, 1);
        tm.setValueAt("Port Number", 2, 0);
        tm.setValueAt(new Integer(rrt.getPort()), 2, 1);
        tm.setValueAt("JDK version", 3, 0);
        tm.setValueAt(jdkVersion, 3, 1);
        tm.setValueAt("OS", 4, 0);
        tm.setValueAt(OS, 4, 1);
    }

    private void setupComboBox() {
        Vector<Pair> rtList = new Vector<Pair>();
        HashSet runtimes = DistributedSettings.getDefault().getRemoteRuntimes();
        Iterator itr = runtimes.iterator();
        boolean firstItem = true;
        while (itr.hasNext()) {
            RemoteRuntimeType curRrt = (RemoteRuntimeType)itr.next();
            if (!curRrt.isConnected()) continue;
            if (firstItem) {
                this.fillupTable(curRrt);
                firstItem = false;
                this.rrt = curRrt;
            }
            Pair item = new Pair(curRrt.getHostName() + ":" + curRrt.getUserName(), curRrt);
            rtList.add(item);
        }
        this.jComboBox1 = new JComboBox(rtList);
        this.jComboBox1.setBorder(new TitledBorder("Remote Servers"));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                Pair item = (Pair)cb.getSelectedItem();
                RemoteRuntimeTypeJPanel.this.rrt = (RemoteRuntimeType)item.getSecond();
                RemoteRuntimeTypeJPanel.this.fillupTable(RemoteRuntimeTypeJPanel.this.rrt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jComboBox1, gridBagConstraints);
    }

    private void setupComponents() {
        this.setupTable();
        this.setupComboBox();
        JTextArea jtextArea = new JTextArea();
        jtextArea.setText("Select the Remote Server to perform remote operations on this file system. If no Remote Server is listed on the Combo box, go to the Runtime Tab, find \"Remote Servers\", and add desired Remote Server");
        jtextArea.setOpaque(false);
        jtextArea.setEditable(false);
        jtextArea.setLineWrap(true);
        jtextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jtextArea, gridBagConstraints);
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getRemoteRuntimeType();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
    }

    class NoEditJTable
    extends JTable {
        public NoEditJTable(Object[][] rowData, Object[] columnNames) {
            super(rowData, columnNames);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    class Pair
    implements Serializable {
        private Object p1;
        private transient Object p2;

        public Pair(Object p1, Object p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        public Object getFirst() {
            return this.p1;
        }

        public Object getSecond() {
            return this.p2;
        }

        public boolean equals(Object pair) {
            return this.p1.equals(((Pair)pair).getFirst());
        }

        public String toString() {
            return this.p1.toString();
        }
    }
}

