/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.propertyeditors;

import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.modules.distributed.property.RemoteRootProperty;
import org.netbeans.modules.distributed.propertyeditors.RemoteRootEditor;
import org.netbeans.modules.distributed.propertyeditors.RemoteRootJPanel;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.openide.util.NbBundle;

public class RemoteRootCustomEditor
extends RemoteRootJPanel
implements PropertyChangeListener {
    private RemoteRootEditor remoteRootEditor;

    public RemoteRootCustomEditor(RemoteRootEditor editor) {
        super("Network Drive Root", "Remote Root", "Remote Directory:");
        this.remoteRootEditor = editor;
        this.setName(NbBundle.getMessage((Class)RemoteRootJPanel.class, (String)"TITLE_remote_root"));
        String remoteDir = this.remoteRootEditor.getRemoteDirectory(this.getFileChooser().getCurrentDirectory().getAbsolutePath());
        if (!remoteDir.equals("")) {
            this.getTextField().setText(remoteDir);
        }
    }

    public RemoteRootCustomEditor(RemoteRootEditor editor, boolean alwayHide) {
        super("Network Drive Root", "Remote Root", "Remote Directory:", alwayHide, false, null);
        this.remoteRootEditor = editor;
        this.setName(NbBundle.getMessage((Class)RemoteRootJPanel.class, (String)"TITLE_remote_root"));
        String remoteDir = this.remoteRootEditor.getRemoteDirectory(this.getFileChooser().getCurrentDirectory().getAbsolutePath());
        if (!remoteDir.equals("")) {
            this.getTextField().setText(remoteDir);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public Object getPropertyValue() throws IllegalStateException {
        RemoteRootProperty rrp = (RemoteRootProperty)this.remoteRootEditor.getValue();
        NetworkFileSystem nfs = rrp.getNetworkFS();
        return new RemoteRootProperty(nfs, this.getRemoteDirectory(), this.getLocalDirectory(), this.isHideChecked());
    }

    private void fireValueChanged() {
        if (this.remoteRootEditor != null) {
            this.remoteRootEditor.setValue(this.getPropertyValue());
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop) || "SelectedFileChangedProperty".equals(prop)) {
            JFileChooser fileChooser = this.getFileChooser();
            File selFile = fileChooser.getSelectedFile();
            if (selFile == null) {
                selFile = fileChooser.getCurrentDirectory();
            }
            this.getTextField().setText("");
            String remoteDir = this.remoteRootEditor.getRemoteDirectory(selFile.getAbsolutePath());
            if (!remoteDir.equals("")) {
                this.getTextField().setText(remoteDir);
            }
            this.fireValueChanged();
        }
    }

    public void createRemoteDirectory() {
        this.getFileChooser().addPropertyChangeListener(this);
        this.getTextField().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        RemoteRootCustomEditor.access$100(1.access$000(this.this$1));
                    }
                });
            }

            static /* synthetic */ RemoteRootCustomEditor access$000(1 x0) {
                return x0.RemoteRootCustomEditor.this;
            }
        });
    }

    static /* synthetic */ void access$100(RemoteRootCustomEditor x0) {
        x0.fireValueChanged();
    }
}

