/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.execute;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.openide.ErrorManager;

final class ReaderCharSequence
implements CharSequence {
    private final Reader r;
    private char[] buf;
    private int size = 0;
    private int origin = 0;
    private int horizon;
    private boolean eof = false;
    private final float loadFactor;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void invariants() {
        if (!$assertionsDisabled && this.buf.length <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.size < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.origin < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.origin > this.size) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.horizon < this.size) {
            throw new AssertionError();
        }
    }

    public ReaderCharSequence(Reader r) {
        this(r, 4096, Integer.MAX_VALUE, 1.3333334f);
    }

    public ReaderCharSequence(Reader r, int bufsize, int horizon, float loadFactor) {
        this.r = r;
        this.buf = new char[bufsize];
        this.horizon = horizon;
        this.loadFactor = loadFactor;
    }

    public void prune(int pos) throws IndexOutOfBoundsException {
        if (pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (pos > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (pos > this.origin && pos <= this.size) {
            int delta = pos - this.origin;
            this.origin = pos;
        }
        this.invariants();
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.horizon) {
            throw new IndexOutOfBoundsException();
        }
        while (index >= this.origin) {
            if (index < this.size) {
                return this.buf[index % this.buf.length];
            }
            if (this.eof) {
                return '\uffff';
            }
            this.readOneChar();
        }
        return '\uffff';
    }

    private void readOneChar() {
        int c;
        if (!$assertionsDisabled && this.eof) {
            throw new AssertionError();
        }
        try {
            c = this.r.read();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            c = -1;
        }
        if (c == -1) {
            this.eof = true;
        } else {
            char cc = (char)c;
            if (this.size - this.origin == this.buf.length) {
                this.realloc();
            } else if (!$assertionsDisabled && this.size - this.origin >= this.buf.length) {
                throw new AssertionError();
            }
            this.buf[this.size++ % this.buf.length] = cc;
            if (this.horizon != Integer.MAX_VALUE) {
                ++this.horizon;
            }
        }
        this.invariants();
    }

    private void realloc() {
        int l1 = this.buf.length;
        int l2 = (int)((float)l1 * this.loadFactor);
        char[] nbuf = new char[l2];
        int delta = l2 - l1;
        for (int i = this.origin; i < this.size; ++i) {
            nbuf[i % l2] = this.buf[i % l1];
        }
        this.buf = nbuf;
        this.invariants();
    }

    public int length() {
        if (this.eof) {
            return this.size;
        }
        return this.horizon;
    }

    public CharSequence subSequence(int start, int end) {
        return new SubCharSequence(start, end);
    }

    private String substring(int start, int end) {
        int start2;
        if (!$assertionsDisabled && start < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && start > end) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && end > this.size) {
            throw new AssertionError();
        }
        int l = this.buf.length;
        if (start >= this.origin && start % l <= end % l) {
            return new String(this.buf, start % l, end - start);
        }
        char[] nbuf = new char[end - start];
        if (start < this.origin) {
            Arrays.fill(nbuf, 0, this.origin - start, '\uffff');
            start2 = this.origin;
        } else {
            start2 = start;
        }
        for (int i = start2; i < end; ++i) {
            nbuf[i - start] = this.buf[i % this.buf.length];
        }
        return new String(nbuf);
    }

    public String toString() {
        while (!this.eof) {
            this.readOneChar();
        }
        return this.substring(0, this.size);
    }

    static {
        $assertionsDisabled = !ReaderCharSequence.class.desiredAssertionStatus();
    }

    private final class SubCharSequence
    implements CharSequence {
        private final int start;
        private final int end;

        public SubCharSequence(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public char charAt(int index) {
            if (index < 0 || index >= this.length()) {
                throw new IndexOutOfBoundsException();
            }
            return ReaderCharSequence.this.charAt(this.start + index);
        }

        public int length() {
            if (ReaderCharSequence.this.eof && this.start > ReaderCharSequence.this.size) {
                return 0;
            }
            if (ReaderCharSequence.this.eof && this.end > ReaderCharSequence.this.size) {
                return ReaderCharSequence.this.size - this.start;
            }
            return this.end - this.start;
        }

        public CharSequence subSequence(int start, int end) {
            return new SubCharSequence(this.start + start, this.start + end);
        }

        public String toString() {
            while (!ReaderCharSequence.this.eof && this.end > ReaderCharSequence.this.size) {
                ReaderCharSequence.this.readOneChar();
            }
            if (this.start > ReaderCharSequence.this.size) {
                return new String();
            }
            if (this.end > ReaderCharSequence.this.size) {
                return ReaderCharSequence.this.substring(this.start, ReaderCharSequence.this.size);
            }
            return ReaderCharSequence.this.substring(this.start, this.end);
        }
    }
}

