/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.beans.editors;

import com.hp.openvms.netbeans.beans.editors.AlphaVMSListQualifier;
import com.hp.openvms.netbeans.beans.editors.AlphaVMSListQualifierEditor;
import com.hp.openvms.netbeans.beans.editors.FileEditor2;
import com.hp.openvms.netbeans.beans.editors.StringCustomEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class AlphaVMSListQualifierCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    private static File lastDirFolder = null;
    private static File lastJarFolder = null;
    private AlphaVMSListQualifierEditor editor;
    private DefaultListModel listModel = new DefaultListModel();
    private boolean isCancel = true;
    private JButton addDirButton;
    private JCheckBox defaultButton;
    private JButton downButton;
    private JPanel innerPanel;
    private JLabel pathLabel;
    private JList pathList;
    private JScrollPane pathScrollPane;
    private JButton removeButton;
    private JButton upButton;
    static /* synthetic */ Class class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor;

    public AlphaVMSListQualifierCustomEditor() {
        this.initComponents();
        this.pathList.setModel(this.listModel);
        this.pathScrollPane.setViewportView(this.pathList);
        this.pathLabel.setDisplayedMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_Classpath.Border_Mnemonic").charAt(0));
        this.addDirButton.setMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_AddDirectory_Mnemonic").charAt(0));
        this.upButton.setMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_MoveUp_Mnemonic").charAt(0));
        this.downButton.setMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_MoveDown_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_Remove_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_Default_Mnemonic").charAt(0));
        this.defaultButton.setMnemonic(AlphaVMSListQualifierCustomEditor.getString("CTL_Default").charAt(0));
        this.pathList.getAccessibleContext().setAccessibleDescription(AlphaVMSListQualifierCustomEditor.getString("ACSD_PathList"));
        this.addDirButton.getAccessibleContext().setAccessibleDescription(AlphaVMSListQualifierCustomEditor.getString("ACSD_AddDirectory"));
        this.upButton.getAccessibleContext().setAccessibleDescription(AlphaVMSListQualifierCustomEditor.getString("ACSD_MoveUp"));
        this.downButton.getAccessibleContext().setAccessibleDescription(AlphaVMSListQualifierCustomEditor.getString("ACSD_MoveDown"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(AlphaVMSListQualifierCustomEditor.getString("ACSD_Remove"));
        this.getAccessibleContext().setAccessibleDescription(AlphaVMSListQualifierCustomEditor.getString("ACSD_AlphaVMSListQualifierCustomEditor"));
    }

    AlphaVMSListQualifierCustomEditor(AlphaVMSListQualifierEditor propEd) {
        this();
        this.editor = propEd;
        Object value = propEd.getValue();
        if (value instanceof AlphaVMSListQualifier) {
            this.setAlphaVMSListQualifier(((AlphaVMSListQualifier)value).getPlainList());
        }
        if (this.editor.getContext() == null) {
            if (this.editor.getInherit() == null) {
                this.defaultButton.setSelected(true);
                this.disableButtons();
            } else {
                this.defaultButton.setSelected(false);
                this.addDirButton.setEnabled(true);
                this.enableButtons();
            }
        } else {
            this.defaultButton.setVisible(false);
        }
        HelpCtx.setHelpIDString((JComponent)this, (String)this.editor.getHelpID());
    }

    private void disableButtons() {
        this.removeButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.addDirButton.setEnabled(false);
    }

    private void initComponents() {
        this.innerPanel = new JPanel();
        this.addDirButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.removeButton = new JButton();
        this.pathScrollPane = new JScrollPane();
        this.pathList = new JList();
        this.pathLabel = new JLabel();
        this.defaultButton = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.innerPanel.setLayout(new GridBagLayout());
        this.innerPanel.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.addDirButton.setText(NbBundle.getBundle((Class)(class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor == null ? (class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor = AlphaVMSListQualifierCustomEditor.class$("com.hp.openvms.netbeans.beans.editors.AlphaVMSListQualifierCustomEditor")) : class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor)).getString("CTL_AddDirectory"));
        this.addDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AlphaVMSListQualifierCustomEditor.this.addDirButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.addDirButton, gridBagConstraints);
        this.upButton.setText(NbBundle.getBundle((Class)(class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor == null ? (class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor = AlphaVMSListQualifierCustomEditor.class$("com.hp.openvms.netbeans.beans.editors.AlphaVMSListQualifierCustomEditor")) : class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor)).getString("CTL_MoveUp"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AlphaVMSListQualifierCustomEditor.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setText(NbBundle.getBundle((Class)(class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor == null ? (class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor = AlphaVMSListQualifierCustomEditor.class$("com.hp.openvms.netbeans.beans.editors.AlphaVMSListQualifierCustomEditor")) : class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor)).getString("CTL_MoveDown"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AlphaVMSListQualifierCustomEditor.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.innerPanel.add((Component)this.downButton, gridBagConstraints);
        this.removeButton.setText(NbBundle.getBundle((Class)(class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor == null ? (class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor = AlphaVMSListQualifierCustomEditor.class$("com.hp.openvms.netbeans.beans.editors.AlphaVMSListQualifierCustomEditor")) : class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor)).getString("CTL_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AlphaVMSListQualifierCustomEditor.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.innerPanel.add((Component)this.removeButton, gridBagConstraints);
        this.pathList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                AlphaVMSListQualifierCustomEditor.this.pathListValueChanged(evt);
            }
        });
        this.pathList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AlphaVMSListQualifierCustomEditor.this.pathListMouseClicked(evt);
            }
        });
        this.pathScrollPane.setViewportView(this.pathList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.innerPanel.add((Component)this.pathScrollPane, gridBagConstraints);
        this.pathLabel.setLabelFor(this.pathList);
        this.pathLabel.setText(NbBundle.getBundle((Class)(class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor == null ? (class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor = AlphaVMSListQualifierCustomEditor.class$("com.hp.openvms.netbeans.beans.editors.AlphaVMSListQualifierCustomEditor")) : class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor)).getString("CTL_Classpath.Border_Title"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.innerPanel.add((Component)this.pathLabel, gridBagConstraints);
        this.defaultButton.setToolTipText("");
        this.defaultButton.setText(ResourceBundle.getBundle("com/hp/openvms/netbeans/beans/editors/Bundle").getString("CTL_Default"));
        this.defaultButton.setPreferredSize(new Dimension(180, 25));
        this.defaultButton.setMaximumSize(new Dimension(180, 25));
        this.defaultButton.setFocusPainted(false);
        this.defaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AlphaVMSListQualifierCustomEditor.this.defaultButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        this.innerPanel.add((Component)this.defaultButton, gridBagConstraints);
        this.add((Component)this.innerPanel, "Center");
    }

    private void defaultButtonActionPerformed(ActionEvent evt) {
        try {
            JCheckBox jb = (JCheckBox)evt.getSource();
            if (jb.isSelected()) {
                this.editor.setValue(null);
                this.listModel.removeAllElements();
                AlphaVMSListQualifier value = (AlphaVMSListQualifier)this.editor.getValue();
                this.setAlphaVMSListQualifier(value.getPlainList());
                this.disableButtons();
            } else {
                this.enableButtons();
            }
        }
        catch (Exception nsme) {
            nsme.printStackTrace();
        }
    }

    private void pathListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() != 2) {
            return;
        }
        this.triggerEdit(this.pathList.getSelectedIndex());
    }

    private void pathListValueChanged(ListSelectionEvent evt) {
        this.enableButtons();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int index = this.pathList.getSelectedIndex();
        Object[] selectedValues = this.pathList.getSelectedValues();
        for (int i = 0; i < selectedValues.length; ++i) {
            this.listModel.removeElement(selectedValues[i]);
            this.fireValueChanged();
        }
        int size = this.listModel.getSize();
        if (index >= 0 && size > 0) {
            if (size == index) {
                this.pathList.setSelectedIndex(index - 1);
            } else if (size > index) {
                this.pathList.setSelectedIndex(index);
            } else {
                this.pathList.setSelectedIndex(0);
            }
        }
        this.enableButtons();
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int i = this.pathList.getSelectedIndex();
        this.swap(i);
        this.pathList.setSelectedIndex(i + 1);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int i = this.pathList.getSelectedIndex();
        this.swap(i - 1);
        this.pathList.setSelectedIndex(i - 1);
    }

    private void addDirButtonActionPerformed(ActionEvent evt) {
        StringCustomEditor editor = new StringCustomEditor("", true);
        this.isCancel = false;
        DialogDescriptor desc = new DialogDescriptor((Object)editor, "Include Directory", true, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource().equals(DialogDescriptor.CANCEL_OPTION)) {
                    AlphaVMSListQualifierCustomEditor.this.isCancel = true;
                }
                if (evt.getSource().equals(DialogDescriptor.OK_OPTION)) {
                    AlphaVMSListQualifierCustomEditor.this.isCancel = false;
                }
            }
        });
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.show();
        if (editor.getPropertyValue().length() > 0 && !this.isCancel) {
            this.listModel.addElement(editor.getPropertyValue());
            this.fireValueChanged();
        }
    }

    private void fireValueChanged() {
        if (this.editor != null) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    private void triggerEdit(int index) {
        if (index < 0) {
            return;
        }
        String selectedItem = (String)this.listModel.elementAt(index);
        File selectedF = new File(selectedItem);
        if (selectedF.isDirectory()) {
            File f;
            JFileChooser chooser = FileEditor2.createHackedFileChooser();
            chooser.setFileSelectionMode(1);
            chooser.setDialogTitle(AlphaVMSListQualifierCustomEditor.getString("CTL_Edit_Local_Dialog_Title"));
            if (selectedF.getParentFile() != null) {
                chooser.setCurrentDirectory(selectedF.getParentFile());
                chooser.setSelectedFile(selectedF);
            }
            if (chooser.showDialog(WindowManager.getDefault().getMainWindow(), AlphaVMSListQualifierCustomEditor.getString("CTL_Approve_Button_Title")) == 0 && (f = chooser.getSelectedFile()) != null && f.isDirectory()) {
                lastDirFolder = chooser.getCurrentDirectory();
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                this.listModel.set(index, f.getAbsolutePath());
                this.fireValueChanged();
            }
        } else if (selectedF.isFile()) {
            File f;
            JFileChooser chooser = FileEditor2.createHackedFileChooser();
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".jar") || f.getName().endsWith(".zip");
                }

                public String getDescription() {
                    return AlphaVMSListQualifierCustomEditor.getString("CTL_JarArchivesMask");
                }
            });
            chooser.setCurrentDirectory(selectedF.getParentFile());
            chooser.setSelectedFile(selectedF);
            chooser.setDialogTitle(AlphaVMSListQualifierCustomEditor.getString("CTL_Edit_Jar_Dialog_Title"));
            if (chooser.showDialog(WindowManager.getDefault().getMainWindow(), AlphaVMSListQualifierCustomEditor.getString("CTL_Approve_Button_Title")) == 0 && (f = chooser.getSelectedFile()) != null && f.isFile()) {
                lastJarFolder = chooser.getCurrentDirectory();
                this.listModel.set(index, f.getAbsolutePath());
                this.fireValueChanged();
            }
        }
    }

    private void swap(int index) {
        if (index < 0 || index >= this.listModel.size() - 1) {
            return;
        }
        Object value = this.listModel.elementAt(index);
        this.listModel.removeElement(value);
        this.listModel.add(index + 1, value);
        this.fireValueChanged();
    }

    private void enableButtons() {
        this.addDirButton.setEnabled(true);
        this.removeButton.setEnabled(this.pathList.getSelectedIndices().length > 0);
        if (this.pathList.getSelectedIndices().length == 1) {
            this.downButton.setEnabled(this.pathList.getSelectedIndices()[0] < this.pathList.getModel().getSize() - 1);
            this.upButton.setEnabled(this.pathList.getSelectedIndices()[0] > 0);
        } else {
            this.downButton.setEnabled(false);
            this.upButton.setEnabled(false);
        }
    }

    private void setAlphaVMSListQualifier(String fileList) {
        StringTokenizer tok = new StringTokenizer(fileList, ",");
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.startsWith("(")) {
                s = s.substring(1);
            }
            if (s.endsWith(")")) {
                s = s.substring(0, s.length() - 1);
            }
            this.listModel.addElement(s.trim());
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (this.defaultButton.isSelected()) {
            return null;
        }
        ArrayList list = new ArrayList();
        Enumeration e = this.listModel.elements();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        String[] arr = list.toArray(new String[list.size()]);
        return new AlphaVMSListQualifier(arr);
    }

    private static final String getString(String s) {
        return NbBundle.getBundle((Class)(class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor == null ? (class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor = AlphaVMSListQualifierCustomEditor.class$("com.hp.openvms.netbeans.beans.editors.AlphaVMSListQualifierCustomEditor")) : class$com$hp$openvms$netbeans$beans$editors$AlphaVMSListQualifierCustomEditor)).getString(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

