/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.rmi.impl;

import com.sun.crypto.provider.SunJCE;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.netbeans.modules.distributed.rmi.protocol.SecurityContext;
import org.netbeans.modules.distributed.rmi.protocol.ServerOutput;

public class SecurityContextImpl
implements Serializable,
SecurityContext {
    private byte[] authenticationHash;
    private String remoteRuntimeID;
    private long pid;
    private String JDKVersion;
    private int numUsers;
    private ArrayList userIDs;
    private HashMap serverInfo;

    private void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            this.byte2hex(block[i], buf);
            if (i >= len - 1) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    public SecurityContextImpl(byte[] authenticationHash, String remoteRuntimeID) {
        this.authenticationHash = new byte[authenticationHash.length];
        System.arraycopy(authenticationHash, 0, this.authenticationHash, 0, authenticationHash.length);
        this.remoteRuntimeID = remoteRuntimeID;
        this.userIDs = new ArrayList();
        this.serverInfo = new HashMap();
    }

    public SecurityContextImpl(HashMap info, String remoteRuntimeID, long pid) throws NoSuchAlgorithmException, InvalidKeyException {
        this.remoteRuntimeID = remoteRuntimeID;
        this.pid = pid;
        this.JDKVersion = (String)info.get("JDK_VER_TAG");
        String userName = (String)info.get("USER");
        String password = (String)info.get("PASSWD");
        this.hash(userName + password);
        this.serverInfo = new HashMap();
        this.userIDs = new ArrayList();
    }

    private void hash(String data) throws NoSuchAlgorithmException, InvalidKeyException {
        SunJCE sunJce = new SunJCE();
        Security.addProvider(sunJce);
        KeyGenerator kg = KeyGenerator.getInstance("HmacSHA1");
        kg.init(16);
        SecretKey sk = kg.generateKey();
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(sk);
        this.authenticationHash = mac.doFinal(data.getBytes());
    }

    public String getRemoteRuntimeID() {
        return this.remoteRuntimeID;
    }

    public long getPID() {
        return this.pid;
    }

    public byte[] getAuthenticationHash() {
        return this.authenticationHash;
    }

    public byte[] getAuthorizationHash() {
        return null;
    }

    public HashMap getServerInfo() {
        return this.serverInfo;
    }

    public synchronized int getNumUsers() {
        return this.numUsers;
    }

    public String getJDKVersion() {
        return this.JDKVersion;
    }

    public synchronized Long incNumUsers(ServerOutput sout) {
        Long userID = new Long(System.currentTimeMillis());
        ++this.numUsers;
        this.userIDs.add(new Pair(userID, sout));
        return userID;
    }

    public synchronized boolean decNumUsers(Long userID) {
        Pair pair = new Pair(userID, null);
        if (this.numUsers > 0 && this.userIDs.contains(pair)) {
            --this.numUsers;
            Pair p = (Pair)this.userIDs.get(this.userIDs.indexOf(pair));
            ServerOutput sout = (ServerOutput)p.getSecond();
            sout = null;
            this.userIDs.remove(pair);
            return true;
        }
        return false;
    }

    public synchronized void refresh() {
        Iterator itr = this.userIDs.iterator();
        while (itr.hasNext()) {
            ServerOutput sout;
            Pair pair = (Pair)itr.next();
            boolean clientAlive = true;
            try {
                sout = (ServerOutput)pair.getSecond();
                clientAlive = sout.isClientAlive();
            }
            catch (Exception e) {
                clientAlive = false;
            }
            if (clientAlive) continue;
            sout = (ServerOutput)pair.getSecond();
            sout = null;
            itr.remove();
            --this.numUsers;
        }
    }

    class Pair
    implements Serializable {
        private Object p1;
        private transient Object p2;

        public Pair(Object p1, Object p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        public Object getFirst() {
            return this.p1;
        }

        public Object getSecond() {
            return this.p2;
        }

        public boolean equals(Object pair) {
            return this.p1.equals(((Pair)pair).getFirst());
        }
    }
}

