/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.core;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.distributed.remotefs.core.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.core.SyncTablePanel;
import org.netbeans.modules.distributed.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class SynchronizeRecurseAction
extends NodeAction {
    static final long serialVersionUID = -7910677883192530621L;
    private RemoteFileSystem fs;

    protected boolean enable(Node[] nodes) {
        if (nodes == null) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            DataObject df = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? SynchronizeRecurseAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (df == null) continue;
            FileObject fo = df.getPrimaryFile();
            try {
                FileSystem fs = fo.getFileSystem();
                if (fs instanceof RemoteFileSystem) continue;
                return false;
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        return true;
    }

    private void refreshRecurse(Set parentFolders, String packageName, RemoteFileSystem fs) {
        String[] children = fs.children(packageName);
        if (children == null) {
            return;
        }
        try {
            for (int i = 0; i < children.length; ++i) {
                if (fs.getRemoteFile(packageName + (packageName.equals("") ? "" : "/") + children[i]) == null || !fs.getRemoteFile(packageName + (packageName.equals("") ? "" : "/") + children[i]).isDirectory()) continue;
                parentFolders.add(packageName + (packageName.equals("") ? "" : "/") + children[i]);
                this.refreshRecurse(parentFolders, packageName + (packageName.equals("") ? "" : "/") + children[i], fs);
            }
        }
        catch (IOException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        HashSet<String> parentFolder = new HashSet<String>();
        StatusDisplayer.getDefault().setStatusText("Performing Synchronize Recursively");
        boolean firstTime = true;
        String localRoot = null;
        RemoteFileSystem fs = null;
        try {
            Set fobjs = ((DataObject)nodes[0].getCookie(DataObject.class)).files();
            Iterator itr = fobjs.iterator();
            if (itr.hasNext()) {
                FileObject fobj = (FileObject)itr.next();
                fs = (RemoteFileSystem)fobj.getFileSystem();
            }
        }
        catch (FileStateInvalidException e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
        }
        Object object = fs.getSynchLock();
        synchronized (object) {
            for (int i = 0; i < nodes.length; ++i) {
                Set fobjs = ((DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? SynchronizeRecurseAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)).files();
                Iterator itr = fobjs.iterator();
                while (itr.hasNext()) {
                    try {
                        FileObject fobj = (FileObject)itr.next();
                        if (firstTime) {
                            localRoot = ((RemoteFileSystem)fobj.getFileSystem()).getLocalRoot();
                            Utils.createStatusLogger(localRoot, "sync");
                            fs = (RemoteFileSystem)fobj.getFileSystem();
                            ((RemoteFileSystem)fobj.getFileSystem()).setStopSyncAll(false);
                            ((RemoteFileSystem)fobj.getFileSystem()).setPrintSyncAllStop(true);
                            if (((RemoteFileSystem)fobj.getFileSystem()).getRemoteRuntimeType() != null) {
                                ((RemoteFileSystem)fobj.getFileSystem()).getRemoteRuntimeType().setRemoteServerError(false);
                            }
                            firstTime = false;
                        }
                        if (!fobj.isFolder()) continue;
                        parentFolder.add(fobj.getPackageName('/'));
                        this.refreshRecurse(parentFolder, fobj.getPackageName('/'), fs);
                    }
                    catch (FileStateInvalidException e) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                    }
                    catch (IOException e) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                    }
                }
            }
            Iterator itr = parentFolder.iterator();
            while (itr.hasNext()) {
                String packageName = (String)itr.next();
                if (fs.findResource(packageName) != null) {
                    fs.findResource(packageName).refresh();
                    continue;
                }
                Utils.getStatusLogger(localRoot, "sync").info("Sync:" + packageName + " not found");
            }
            if (localRoot != null) {
                Utils.getStatusLogger(localRoot, "sync").info("Done.");
            }
            SyncTablePanel.bringupTable(false);
            StatusDisplayer.getDefault().setStatusText("Finished Synchronize Recursively");
        }
    }

    protected void setFS(RemoteFileSystem fs) {
        this.fs = fs;
    }

    public String getName() {
        return "Synchronize Recursively";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

