/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.distributed.remotefs.core.DownloadAllAction;
import org.netbeans.modules.distributed.remotefs.core.RemoteFile;
import org.netbeans.modules.distributed.remotefs.core.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.core.Sync;
import org.netbeans.modules.distributed.remotefs.core.SynchronizeAction;
import org.netbeans.modules.distributed.remotefs.core.SynchronizeRecurseAction;
import org.netbeans.modules.distributed.remotefs.core.UploadAllAction;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class FTPActions
extends NodeAction
implements Presenter.Popup {
    static final long serialVersionUID = -7910677883191530622L;
    private RemoteFileSystem fs = null;
    public static final String SYNCHRONIZE = "Synchronize";
    public static final String SYNCHRONIZE_RECURSE = "Synchronize Recursively";
    public static final String GET_ALL = "Get All Files From Server";
    public static final String PUT_ALL = "Put All Files To Server";
    public static final String GET_ONE = "Get File From Server";
    public static final String PUT_ONE = "Put File To Server";
    public static final String FILE_MODE_TAG = "FTP Actions";
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public JMenuItem getPopupPresenter() {
        return new SpecialSubMenu((SystemAction)this, new ActSubMenuModel(this), true);
    }

    protected boolean enable(Node[] nodes) {
        if (nodes == null) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            DataObject df = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? FTPActions.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (df == null) continue;
            FileObject fo = df.getPrimaryFile();
            try {
                FileSystem fs = fo.getFileSystem();
                if (!(fs instanceof RemoteFileSystem)) {
                    return false;
                }
                if (((RemoteFileSystem)fs).isConnected()) continue;
                return false;
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        return true;
    }

    public void performAction(Node[] nodes) {
    }

    protected void setFS(RemoteFileSystem fs) {
        this.fs = fs;
    }

    public String getName() {
        return FILE_MODE_TAG;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private static final class ActSubMenuModel
    implements Actions.SubMenuModel {
        private List targets = null;
        private Node[] nodes = null;
        private DataObject dobj = null;
        private final NodeAction action;

        ActSubMenuModel(NodeAction action) {
            this.action = action;
            this.targets = new ArrayList();
        }

        public int getCount() {
            if (this.targets == null) {
                return 0;
            }
            return this.targets.size();
        }

        public String getLabel(int index) {
            return (String)this.targets.get(index);
        }

        public HelpCtx getHelpCtx(int index) {
            return new HelpCtx("org.apache.tools.ant.module.executing-target");
        }

        public void performActionAt(int index) {
            if (this.targets.get(index).equals(FTPActions.SYNCHRONIZE)) {
                SynchronizeAction saction = new SynchronizeAction();
                Thread thr = new Thread(this, "FTP-Synchronize", saction){
                    private final /* synthetic */ SynchronizeAction val$saction;
                    private final /* synthetic */ ActSubMenuModel this$0;
                    {
                        this.this$0 = this$0;
                        this.val$saction = val$saction;
                        super(x0);
                    }

                    public void run() {
                        this.val$saction.performAction(ActSubMenuModel.access$000(this.this$0));
                    }
                };
                thr.start();
            } else if (this.targets.get(index).equals(FTPActions.SYNCHRONIZE_RECURSE)) {
                SynchronizeRecurseAction saction = new SynchronizeRecurseAction();
                Thread thr = new Thread(this, "FTP-Synchronize", saction){
                    private final /* synthetic */ SynchronizeRecurseAction val$saction;
                    private final /* synthetic */ ActSubMenuModel this$0;
                    {
                        this.this$0 = this$0;
                        this.val$saction = val$saction;
                        super(x0);
                    }

                    public void run() {
                        this.val$saction.performAction(ActSubMenuModel.access$000(this.this$0));
                    }
                };
                thr.start();
            } else if (((String)this.targets.get(index)).startsWith("Get")) {
                DownloadAllAction daction = new DownloadAllAction();
                daction.performAction(this.nodes);
            } else if (((String)this.targets.get(index)).startsWith("Put")) {
                UploadAllAction uaction = new UploadAllAction();
                uaction.performAction(this.nodes);
            }
        }

        void addNotify() {
            this.nodes = this.action.getActivatedNodes();
            if (this.nodes != null && this.nodes.length > 0) {
                this.targets.add(FTPActions.SYNCHRONIZE);
                this.targets.add(FTPActions.SYNCHRONIZE_RECURSE);
                DataFolder df = (DataFolder)this.nodes[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = FTPActions.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                if (this.nodes.length == 1 && df == null) {
                    DataObject doj = (DataObject)this.nodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = FTPActions.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    FileObject fobj = doj.getPrimaryFile();
                    try {
                        RemoteFileSystem fs = (RemoteFileSystem)fobj.getFileSystem();
                        RemoteFile rf = fs.getRemoteFile(fobj.getPackageNameExt('/', '.'));
                        if (!rf.getClientStatus().equals(Sync.SyncState.Missing) && !rf.getClientStatus().equals(Sync.SyncState.NoSuchFile)) {
                            this.targets.add(FTPActions.PUT_ONE);
                        }
                        if (!rf.getServerStatus().equals(Sync.SyncState.Missing) && !rf.getServerStatus().equals(Sync.SyncState.NoSuchFile)) {
                            this.targets.add(FTPActions.GET_ONE);
                        }
                    }
                    catch (FileStateInvalidException e) {
                        this.targets.add(FTPActions.PUT_ONE);
                        this.targets.add(FTPActions.GET_ONE);
                    }
                    catch (IOException e) {
                        this.targets.add(FTPActions.PUT_ONE);
                        this.targets.add(FTPActions.GET_ONE);
                    }
                } else {
                    boolean clientCopyExist = false;
                    boolean serverCopyExist = false;
                    for (int i = 0; i < this.nodes.length; ++i) {
                        df = (DataFolder)this.nodes[i].getCookie(class$org$openide$loaders$DataFolder == null ? FTPActions.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
                        if (df != null) {
                            clientCopyExist = true;
                            serverCopyExist = true;
                            break;
                        }
                        DataObject doj = (DataObject)this.nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? FTPActions.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                        try {
                            FileObject fobj = doj.getPrimaryFile();
                            RemoteFileSystem fs = (RemoteFileSystem)fobj.getFileSystem();
                            RemoteFile rf = fs.getRemoteFile(fobj.getPackageNameExt('/', '.'));
                            if (!rf.getClientStatus().equals(Sync.SyncState.Missing) && !rf.getClientStatus().equals(Sync.SyncState.NoSuchFile)) {
                                clientCopyExist = true;
                            }
                            if (!rf.getServerStatus().equals(Sync.SyncState.Missing) && !rf.getServerStatus().equals(Sync.SyncState.NoSuchFile)) {
                                serverCopyExist = true;
                            }
                            if (!clientCopyExist || !serverCopyExist) continue;
                            break;
                        }
                        catch (FileStateInvalidException e) {
                            clientCopyExist = true;
                            serverCopyExist = true;
                            continue;
                        }
                        catch (IOException e) {
                            clientCopyExist = true;
                            serverCopyExist = true;
                        }
                    }
                    if (clientCopyExist) {
                        this.targets.add(FTPActions.PUT_ALL);
                    }
                    if (serverCopyExist) {
                        this.targets.add(FTPActions.GET_ALL);
                    }
                }
            }
        }

        public synchronized void addChangeListener(ChangeListener l) {
        }

        public synchronized void removeChangeListener(ChangeListener l) {
        }

        static /* synthetic */ Node[] access$000(ActSubMenuModel x0) {
            return x0.nodes;
        }
    }

    private static final class SpecialSubMenu
    extends Actions.SubMenu {
        private final ActSubMenuModel model;

        SpecialSubMenu(SystemAction action, ActSubMenuModel model, boolean popup) {
            super(action, (Actions.SubMenuModel)model, popup);
            this.model = model;
        }

        public void addNotify() {
            this.model.addNotify();
            super.addNotify();
        }
    }
}

