/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.distributed.propertyeditors.FileArrayEditor;

public abstract class RemoteRootJPanel
extends JPanel
implements PropertyChangeListener {
    private FileArrayEditor fileEditor;
    private JTextField jtextfield;
    private JCheckBox jcheckBox;
    boolean hideCheck = true;
    boolean alwaysHide = false;
    private FileSystemView fsv;

    public RemoteRootJPanel(String localTitle, String remoteTitle, String remoteDir) {
        this(localTitle, remoteTitle, remoteDir, true, true, null);
    }

    public RemoteRootJPanel(String localTitle, String remoteTitle, String remoteDir, FileSystemView fsv) {
        this(localTitle, remoteTitle, remoteDir, true, true, fsv);
    }

    public RemoteRootJPanel(String localTitle, String remoteTitle, String remoteDir, boolean hideCheck, boolean alwaysHide, FileSystemView fsv) {
        this.hideCheck = hideCheck;
        this.alwaysHide = alwaysHide;
        this.fsv = fsv;
        this.initComponents();
        this.setupComponents(localTitle, remoteTitle, remoteDir, fsv);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public boolean isHideChecked() {
        return this.jcheckBox.isSelected();
    }

    private void setupComponents(String localTitle, String remoteTitle, String remoteDirTitle, FileSystemView fsv) {
        this.fileEditor = new FileArrayEditor(fsv);
        this.jtextfield = new JTextField();
        this.jcheckBox = new JCheckBox();
        JComponent fileChooser = (JComponent)this.fileEditor.getCustomEditor();
        JPanel jPanel0 = new JPanel();
        jPanel0.setBorder(new TitledBorder(localTitle));
        jPanel0.setLayout(new BorderLayout());
        jPanel0.add((Component)fileChooser, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(remoteTitle));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(remoteDirTitle), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.jtextfield, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.createRemoteDirectory();
        fileChooser.setVisible(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(""));
        this.jcheckBox.setText("Hide the FileSystem upon mounting:");
        this.jcheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RemoteRootJPanel.this.hideCheck = ((JCheckBox)evt.getSource()).isSelected();
            }
        });
        this.jcheckBox.setSelected(true);
        if (this.hideCheck) {
            this.jcheckBox.setEnabled(false);
        }
        if (this.alwaysHide) {
            this.add((Component)jPanel0, "Center");
            this.add((Component)jPanel2, "South");
        } else {
            this.add((Component)jPanel0, "North");
            this.add((Component)jPanel2, "Center");
            this.add((Component)jPanel3, "South");
        }
    }

    public abstract void createRemoteDirectory();

    public JFileChooser getFileChooser() {
        return (JFileChooser)this.fileEditor.getCustomEditor();
    }

    protected JTextField getTextField() {
        return this.jtextfield;
    }

    public String getLocalDirectory() {
        if (this.fileEditor != null) {
            JFileChooser fileChooser = (JFileChooser)this.fileEditor.getCustomEditor();
            File selFile = fileChooser.getSelectedFile();
            if (selFile == null) {
                selFile = fileChooser.getCurrentDirectory();
            }
            return selFile.getAbsolutePath();
        }
        return "";
    }

    public String getRemoteDirectory() {
        return this.jtextfield.getText().trim();
    }
}

